/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.fs.gcs.FileSystemDescriptor;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFSInputStream;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopOutputStream;
import com.google.cloud.hadoop.fs.gcs.ListHelperGoogleHadoopFileSystem;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.DirectoryListCache;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.HadoopVersionInfo;
import com.google.cloud.hadoop.util.LogUtil;
import com.google.cloud.hadoop.util.PropertyUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.DirectoryNotEmptyException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobPattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

public abstract class GoogleHadoopFileSystemBase
extends FileSystem
implements FileSystemDescriptor {
    public static final LogUtil log = new LogUtil(GoogleHadoopFileSystemBase.class);
    public static final short REPLICATION_FACTOR_DEFAULT = 3;
    private static final FsPermission PERMISSIONS_TO_REPORT = FsPermission.valueOf((String)"-rwx------");
    private static final String USER_NAME = System.getProperty("user.name");
    private static final Splitter CONFIGURATION_SPLITTER = Splitter.on((char)',');
    public static final String BUFFERSIZE_KEY = "fs.gs.io.buffersize";
    public static final int BUFFERSIZE_DEFAULT = 0x800000;
    public static final String WRITE_BUFFERSIZE_KEY = "fs.gs.io.buffersize.write";
    public static final int WRITE_BUFFERSIZE_DEFAULT = 0x4000000;
    public static final String BLOCK_SIZE_KEY = "fs.gs.block.size";
    public static final int BLOCK_SIZE_DEFAULT = 0x4000000;
    public static final String AUTHENTICATION_PREFIX = "fs.gs";
    public static final String ENABLE_GCE_SERVICE_ACCOUNT_AUTH_KEY = "fs.gs.enable.service.account.auth";
    public static final String SERVICE_ACCOUNT_AUTH_EMAIL_KEY = "fs.gs.service.account.auth.email";
    public static final String SERVICE_ACCOUNT_AUTH_KEYFILE_KEY = "fs.gs.service.account.auth.keyfile";
    public static final String GCS_PROJECT_ID_KEY = "fs.gs.project.id";
    public static final String GCS_CLIENT_ID_KEY = "fs.gs.client.id";
    public static final String GCS_CLIENT_SECRET_KEY = "fs.gs.client.secret";
    public static final String GCS_SYSTEM_BUCKET_KEY = "fs.gs.system.bucket";
    public static final String GCS_CREATE_SYSTEM_BUCKET_KEY = "fs.gs.system.bucket.create";
    public static final boolean GCS_CREATE_SYSTEM_BUCKET_DEFAULT = true;
    public static final String GCS_WORKING_DIRECTORY_KEY = "fs.gs.working.dir";
    public static final String GCS_FILE_SIZE_LIMIT_250GB = "fs.gs.file.size.limit.250gb";
    public static final boolean GCS_FILE_SIZE_LIMIT_250GB_DEFAULT = true;
    public static final String GCS_ENABLE_METADATA_CACHE_KEY = "fs.gs.metadata.cache.enable";
    public static final boolean GCS_ENABLE_METADATA_CACHE_DEFAULT = true;
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_KEY = "fs.gs.parent.timestamp.update.enable";
    public static final boolean GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_DEFAULT = true;
    public static final String GCS_METADATA_CACHE_TYPE_KEY = "fs.gs.metadata.cache.type";
    public static final String GCS_METADATA_CACHE_TYPE_DEFAULT = "IN_MEMORY";
    public static final String GCS_METADATA_CACHE_DIRECTORY_KEY = "fs.gs.metadata.cache.directory";
    public static final String GCS_METADATA_CACHE_DIRECTORY_DEFAULT = "/tmp/gcs_connector_metadata_cache";
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_KEY = "fs.gs.parent.timestamp.update.substrings.excludes";
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT = "/";
    public static final String MR_JOB_HISTORY_INTERMEDIATE_DONE_DIR_KEY = "mapreduce.jobhistory.intermediate-done-dir";
    public static final String MR_JOB_HISTORY_DONE_DIR_KEY = "mapreduce.jobhistory.done-dir";
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_KEY = "fs.gs.parent.timestamp.update.substrings.includes";
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_DEFAULT = String.format("${%s},${%s}", "mapreduce.jobhistory.intermediate-done-dir", "mapreduce.jobhistory.done-dir");
    public static final String GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_KEY = "fs.gs.implicit.dir.repair.enable";
    public static final boolean GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_DEFAULT = true;
    private boolean enableAutoRepairImplicitDirectories = true;
    public static final String GCS_ENABLE_FLAT_GLOB_KEY = "fs.gs.glob.flatlist.enable";
    public static final boolean GCS_ENABLE_FLAT_GLOB_DEFAULT = true;
    public static final String GCS_ENABLE_MARKER_FILE_CREATION_KEY = "fs.gs.create.marker.files.enable";
    public static final boolean GCS_ENABLE_MARKER_FILE_CREATION_DEFAULT = false;
    public static final PathFilter DEFAULT_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            return true;
        }
    };
    public static final String PROPERTIES_FILE = "gcs.properties";
    public static final String VERSION_PROPERTY = "gcs.connector.version";
    public static final String UNKNOWN_VERSION = "0.0.0";
    public static final String VERSION = PropertyUtil.getPropertyOrDefault(GoogleHadoopFileSystemBase.class, (String)"gcs.properties", (String)"gcs.connector.version", (String)"0.0.0");
    public static final String GHFS_ID;
    private boolean enableFlatGlob = true;
    protected URI initUri;
    @Deprecated
    protected String systemBucket;
    protected GoogleCloudStorageFileSystem gcsfs;
    private Path workingDirectory;
    private int bufferSizeOverride = 0x800000;
    protected long defaultBlockSize = 0x4000000L;
    protected final ImmutableMap<Counter, AtomicLong> counters = this.createCounterMap();
    protected ListStatusFileNotFoundBehavior listStatusFileNotFoundBehavior = ListStatusFileNotFoundBehavior.get();

    protected ImmutableMap<Counter, AtomicLong> createCounterMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Counter counter : Counter.values()) {
            builder.put((Object)counter, (Object)new AtomicLong());
        }
        return builder.build();
    }

    @VisibleForTesting
    protected void setListStatusFileNotFoundBehavior(ListStatusFileNotFoundBehavior behavior) {
        this.listStatusFileNotFoundBehavior = behavior;
    }

    public GoogleHadoopFileSystemBase() {
    }

    public GoogleHadoopFileSystemBase(GoogleCloudStorageFileSystem gcsfs) {
        Preconditions.checkArgument((gcsfs != null ? 1 : 0) != 0, (Object)"gcsfs must not be null");
        this.gcsfs = gcsfs;
    }

    protected abstract String getHomeDirectorySubpath();

    public abstract Path getHadoopPath(URI var1);

    public abstract URI getGcsPath(Path var1);

    public abstract Path getDefaultWorkingDirectory();

    @Override
    public abstract Path getFileSystemRoot();

    @Override
    public abstract String getScheme();

    @Override
    @Deprecated
    public String getHadoopScheme() {
        return this.getScheme();
    }

    public Path makeQualified(Path path) {
        log.debug("GHFS.makeQualified: path: %s", new Object[]{path});
        Path qualifiedPath = super.makeQualified(path);
        URI uri = qualifiedPath.toUri();
        Preconditions.checkState(("".equals(uri.getPath()) || qualifiedPath.isAbsolute() ? 1 : 0) != 0, (String)"Path '%s' must be fully qualified.", (Object[])new Object[]{qualifiedPath});
        StringBuilder sb = new StringBuilder(uri.getPath());
        while (sb.indexOf("/../") == 0) {
            sb.delete(0, 3);
        }
        String strippedPath = sb.toString();
        if (strippedPath.equals("/..") || strippedPath.equals("")) {
            strippedPath = GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT;
        }
        Path result = new Path(uri.getScheme(), uri.getAuthority(), strippedPath);
        log.debug("GHFS.makeQualified:=> %s", new Object[]{result});
        return result;
    }

    protected void checkPath(Path path) {
        URI uri = path.toUri();
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equalsIgnoreCase(this.getScheme())) {
            return;
        }
        String msg = String.format("Wrong FS scheme: %s, in path: %s, expected scheme: %s", scheme, path, this.getScheme());
        throw new IllegalArgumentException(msg);
    }

    public void initialize(URI path, Configuration config) throws IOException {
        this.initialize(path, config, true);
    }

    public void initialize(URI path, Configuration config, boolean initSuperclass) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path must not be null");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config must not be null");
        Preconditions.checkArgument((path.getScheme() != null ? 1 : 0) != 0, (Object)"scheme of path must not be null");
        if (!path.getScheme().equals(this.getScheme())) {
            String string = String.valueOf(String.valueOf(path));
            throw new IllegalArgumentException(new StringBuilder(26 + string.length()).append("URI scheme not supported: ").append(string).toString());
        }
        this.initUri = path;
        log.debug("GHFS.initialize: %s", new Object[]{path});
        if (initSuperclass) {
            super.initialize(path, config);
        } else {
            log.debug("Initializing 'statistics' as an instance not attached to the static FileSystem map", new Object[0]);
            this.statistics = new FileSystem.Statistics(this.getScheme());
        }
        this.configure(config);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.INIT);
        this.increment(Counter.INIT_TIME, duration);
    }

    public URI getUri() {
        return this.getFileSystemRoot().toUri();
    }

    protected int getDefaultPort() {
        log.debug("GHFS.getDefaultPort:", new Object[0]);
        int result = -1;
        log.debug("GHFS.getDefaultPort:=> %d", new Object[]{result});
        return result;
    }

    public FSDataInputStream open(Path hadoopPath, int bufferSize) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (String)"bufferSize must be a positive integer: %s", (Object[])new Object[]{bufferSize});
        this.checkOpen();
        log.debug("GHFS.open: %s, bufferSize: %d (override: %d)", new Object[]{hadoopPath, bufferSize, this.bufferSizeOverride});
        bufferSize = this.bufferSizeOverride;
        URI gcsPath = this.getGcsPath(hadoopPath);
        GoogleHadoopFSInputStream in = new GoogleHadoopFSInputStream(this, gcsPath, bufferSize, this.statistics);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.OPEN);
        this.increment(Counter.OPEN_TIME, duration);
        return new FSDataInputStream((InputStream)((Object)in));
    }

    public FSDataOutputStream create(Path hadoopPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (String)"bufferSize must be a positive integer: %s", (Object[])new Object[]{bufferSize});
        Preconditions.checkArgument((replication > 0 ? 1 : 0) != 0, (String)"replication must be a positive integer: %s", (Object[])new Object[]{replication});
        Preconditions.checkArgument((blockSize > 0L ? 1 : 0) != 0, (String)"blockSize must be a positive integer: %s", (Object[])new Object[]{blockSize});
        this.checkOpen();
        log.debug("GHFS.create: %s, overwrite: %s, bufferSize: %d (override: %d)", new Object[]{hadoopPath, overwrite, bufferSize, this.bufferSizeOverride});
        bufferSize = this.bufferSizeOverride;
        URI gcsPath = this.getGcsPath(hadoopPath);
        GoogleHadoopOutputStream out = new GoogleHadoopOutputStream(this, gcsPath, bufferSize, this.statistics, new CreateFileOptions(overwrite));
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.CREATE);
        this.increment(Counter.CREATE_TIME, duration);
        return new FSDataOutputStream((OutputStream)out);
    }

    public FSDataOutputStream append(Path hadoopPath, int bufferSize, Progressable progress) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (String)"bufferSize must be a positive integer: %s", (Object[])new Object[]{bufferSize});
        log.debug("GHFS.append: %s, bufferSize: %d (override: %d)", new Object[]{hadoopPath, bufferSize, this.bufferSizeOverride});
        bufferSize = this.bufferSizeOverride;
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.APPEND);
        this.increment(Counter.APPEND_TIME, duration);
        throw new IOException("The append operation is not supported.");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        if (src.makeQualified((FileSystem)this).equals((Object)this.getFileSystemRoot())) {
            log.debug("GHFS.rename: src is root: '%s'", new Object[]{src});
            return false;
        }
        long startTime = System.nanoTime();
        Preconditions.checkArgument((src != null ? 1 : 0) != 0, (Object)"src must not be null");
        Preconditions.checkArgument((dst != null ? 1 : 0) != 0, (Object)"dst must not be null");
        this.checkOpen();
        try {
            log.debug("GHFS.rename: %s -> %s", new Object[]{src, dst});
            URI srcPath = this.getGcsPath(src);
            URI dstPath = this.getGcsPath(dst);
            this.gcsfs.rename(srcPath, dstPath);
        }
        catch (IOException e) {
            log.debug("GHFS.rename", (Throwable)e);
            return false;
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.RENAME);
        this.increment(Counter.RENAME_TIME, duration);
        return true;
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    public boolean delete(Path hadoopPath, boolean recursive) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        log.debug("GHFS.delete: %s, recursive: %s", new Object[]{hadoopPath, recursive});
        URI gcsPath = this.getGcsPath(hadoopPath);
        try {
            this.gcsfs.delete(gcsPath, recursive);
        }
        catch (DirectoryNotEmptyException e) {
            throw e;
        }
        catch (IOException e) {
            log.debug("GHFS.delete", (Throwable)e);
            return false;
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.DELETE);
        this.increment(Counter.DELETE_TIME, duration);
        return true;
    }

    public FileStatus[] listStatus(Path hadoopPath) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        log.debug("GHFS.listStatus: %s", new Object[]{hadoopPath});
        URI gcsPath = this.getGcsPath(hadoopPath);
        ArrayList<FileStatus> status = new ArrayList<FileStatus>();
        try {
            List<FileInfo> fileInfos = this.gcsfs.listFileInfo(gcsPath, this.enableAutoRepairImplicitDirectories);
            for (FileInfo fileInfo : fileInfos) {
                status.add(this.getFileStatus(fileInfo));
            }
        }
        catch (FileNotFoundException fnfe) {
            log.debug("Got fnfe: ", (Throwable)fnfe);
            return this.listStatusFileNotFoundBehavior.handle(gcsPath.toString());
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.LIST_STATUS);
        this.increment(Counter.LIST_STATUS_TIME, duration);
        return status.toArray(new FileStatus[0]);
    }

    public void setWorkingDirectory(Path hadoopPath) {
        Path newPath;
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        log.debug("GHFS.setWorkingDirectory: %s", new Object[]{hadoopPath});
        URI gcsPath = this.getGcsPath(hadoopPath);
        gcsPath = FileInfo.convertToDirectoryPath(gcsPath);
        this.workingDirectory = newPath = this.getHadoopPath(gcsPath);
        log.debug("GHFS.setWorkingDirectory: => %s", new Object[]{this.workingDirectory});
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.SET_WD);
        this.increment(Counter.SET_WD_TIME, duration);
    }

    public Path getWorkingDirectory() {
        log.debug("GHFS.getWorkingDirectory: %s", new Object[]{this.workingDirectory});
        return this.workingDirectory;
    }

    public boolean mkdirs(Path hadoopPath, FsPermission permission) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        log.debug("GHFS.mkdirs: %s, perm: %s", new Object[]{hadoopPath, permission});
        URI gcsPath = this.getGcsPath(hadoopPath);
        this.gcsfs.mkdirs(gcsPath);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.MKDIRS);
        this.increment(Counter.MKDIRS_TIME, duration);
        return true;
    }

    public short getDefaultReplication() {
        return 3;
    }

    public FileStatus getFileStatus(Path hadoopPath) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        log.debug("GHFS.getFileStatus: %s", new Object[]{hadoopPath});
        URI gcsPath = this.getGcsPath(hadoopPath);
        FileInfo fileInfo = this.gcsfs.getFileInfo(gcsPath);
        if (!fileInfo.exists()) {
            log.debug("GHFS.getFileStatus: not found: %s", new Object[]{gcsPath});
            String msg = fileInfo.isDirectory() ? "Directory not found : " : "File not found : ";
            String string = String.valueOf(msg);
            String string2 = String.valueOf(hadoopPath.toString());
            msg = string2.length() != 0 ? string.concat(string2) : new String(string);
            throw new FileNotFoundException(msg);
        }
        FileStatus status = this.getFileStatus(fileInfo);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.GET_FILE_STATUS);
        this.increment(Counter.GET_FILE_STATUS_TIME, duration);
        return status;
    }

    @VisibleForTesting
    boolean shouldUseFlatGlob(Path fixedPath) {
        if (!this.enableFlatGlob) {
            return false;
        }
        if (!this.getUri().getScheme().equals("gs")) {
            log.debug("Flat glob is on, but doesn't work for scheme '%s'; usig default behavior.", new Object[]{this.getUri().getScheme()});
            return false;
        }
        GlobPattern fullPattern = new GlobPattern(fixedPath.toString());
        if (!fullPattern.hasWildcard()) {
            log.debug("Flat glob is on, but Path '%s' has no wildcard; using default behavior.", new Object[]{fixedPath});
            return false;
        }
        if (Strings.isNullOrEmpty((String)fixedPath.toUri().getAuthority())) {
            log.info("Flat glob is on, but Path '%s' has a empty authority, using default behavior.", new Object[]{fixedPath});
            return false;
        }
        GlobPattern authorityPattern = new GlobPattern(fixedPath.toUri().getAuthority());
        if (authorityPattern.hasWildcard()) {
            log.info("Flat glob is on, but Path '%s' has a wildcard authority, using default behavior.", new Object[]{fixedPath});
            return false;
        }
        return true;
    }

    @VisibleForTesting
    String trimToPrefixWithoutGlob(String path) {
        char[] wildcardChars = "*?{[".toCharArray();
        int trimIndex = path.length();
        for (char wildcard : wildcardChars) {
            int wildcardIndex = path.indexOf(wildcard);
            if (wildcardIndex < 0 || wildcardIndex >= trimIndex) continue;
            trimIndex = wildcardIndex;
        }
        return path.substring(0, trimIndex);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.globStatus(pathPattern, DEFAULT_FILTER);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.checkOpen();
        log.debug("GHFS.globStatus: %s", new Object[]{pathPattern});
        Path fixedPath = this.getHadoopPath(this.getGcsPath(pathPattern));
        log.debug("GHFS.globStatus fixedPath: %s => %s", new Object[]{pathPattern, fixedPath});
        if (this.shouldUseFlatGlob(fixedPath)) {
            String pathString = fixedPath.toString();
            String prefixString = this.trimToPrefixWithoutGlob(pathString);
            Path prefixPath = new Path(prefixString);
            URI prefixUri = this.getGcsPath(prefixPath);
            if (prefixString.endsWith(GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT) && !prefixPath.toString().endsWith(GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT)) {
                prefixUri = FileInfo.convertToDirectoryPath(prefixUri);
            }
            log.debug("Listing everything with prefix '%s'", new Object[]{prefixUri});
            List<FileInfo> fileInfos = this.gcsfs.listAllFileInfoForPrefix(prefixUri);
            if (fileInfos.isEmpty()) {
                return super.globStatus(fixedPath, filter);
            }
            GoogleHadoopFileSystem helperFileSystem = ListHelperGoogleHadoopFileSystem.createInstance(fileInfos);
            FileStatus[] returnList = helperFileSystem.globStatus(pathPattern, filter);
            if (this.enableAutoRepairImplicitDirectories) {
                ArrayList<URI> toRepair = new ArrayList<URI>();
                for (FileStatus status : returnList) {
                    if (!status.isDir() || status.getModificationTime() != 0L) continue;
                    toRepair.add(this.getGcsPath(status.getPath()));
                }
                if (!toRepair.isEmpty()) {
                    log.warn("Discovered %d implicit directories to repair within return values.", new Object[]{toRepair.size()});
                    this.gcsfs.repairDirs(toRepair);
                }
            }
            return returnList;
        }
        FileStatus[] ret = super.globStatus(fixedPath, filter);
        if (ret == null && this.enableAutoRepairImplicitDirectories) {
            log.debug("GHFS.globStatus returned null for '%s', attempting possible repair.", new Object[]{pathPattern});
            if (this.gcsfs.repairPossibleImplicitDirectory(this.getGcsPath(fixedPath))) {
                log.warn("Success repairing '%s', re-globbing.", new Object[]{pathPattern});
                ret = super.globStatus(fixedPath, filter);
            }
        }
        return ret;
    }

    public Path getHomeDirectory() {
        Path result = new Path(this.getFileSystemRoot(), this.getHomeDirectorySubpath());
        log.debug("GHFS.getHomeDirectory:=> %s", new Object[]{result});
        return result;
    }

    private FileStatus getFileStatus(FileInfo fileInfo) {
        FileStatus status = new FileStatus(fileInfo.getSize(), fileInfo.isDirectory(), 3, this.defaultBlockSize, fileInfo.getModificationTime(), fileInfo.getModificationTime(), PERMISSIONS_TO_REPORT, USER_NAME, USER_NAME, this.getHadoopPath(fileInfo.getPath()));
        log.debug("GHFS.getFileStatus: %s => %s", new Object[]{fileInfo.getPath(), GoogleHadoopFileSystemBase.fileStatusToString(status)});
        return status;
    }

    private static String fileStatusToString(FileStatus stat) {
        assert (stat != null);
        return String.format("path: %s, isDir: %s, len: %d, owner: %s", stat.getPath().toString(), stat.isDir(), stat.getLen(), stat.getOwner());
    }

    @VisibleForTesting
    int getBufferSizeOverride() {
        return this.bufferSizeOverride;
    }

    @Deprecated
    @VisibleForTesting
    String getSystemBucketName() {
        return this.systemBucket;
    }

    public String getCanonicalServiceName() {
        log.debug("GHFS.getCanonicalServiceName:", new Object[0]);
        log.debug("GHFS.getCanonicalServiceName:=> null", new Object[0]);
        return null;
    }

    GoogleCloudStorageFileSystem getGcsFs() {
        return this.gcsfs;
    }

    void increment(Counter key) {
        this.increment(key, 1L);
    }

    void increment(Counter key, long value) {
        ((AtomicLong)this.counters.get((Object)key)).addAndGet(value);
    }

    @VisibleForTesting
    String countersToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        double numNanoSecPerSec = TimeUnit.SECONDS.toNanos(1L);
        String timeSuffix = "_TIME";
        for (Counter c : Counter.values()) {
            String name = c.toString();
            if (name.endsWith(timeSuffix)) continue;
            long count = ((AtomicLong)this.counters.get((Object)c)).get();
            sb.append(String.format("%20s = %d calls\n", name, count));
            String string = String.valueOf(name);
            String string2 = String.valueOf(timeSuffix);
            String timeCounterName = string2.length() != 0 ? string.concat(string2) : new String(string);
            double totalTime = (double)((AtomicLong)this.counters.get((Object)Enum.valueOf(Counter.class, timeCounterName))).get() / numNanoSecPerSec;
            sb.append(String.format("%20s = %.2f sec\n", timeCounterName, totalTime));
            String avgName = String.valueOf(name).concat(" avg.");
            double avg = totalTime / (double)count;
            sb.append(String.format("%20s = %.2f sec / call\n\n", avgName, avg));
        }
        return sb.toString();
    }

    private void logCounters() {
        log.debug(this.countersToString(), new Object[0]);
    }

    private static void copyIfNotPresent(Configuration config, String deprecatedKey, String newKey) {
        String deprecatedValue = config.get(deprecatedKey);
        if (config.get(newKey) == null && deprecatedValue != null) {
            log.warn("Key %s is deprecated. Copying the value of key %s to new key %s", new Object[]{deprecatedKey, deprecatedKey, newKey});
            config.set(newKey, deprecatedValue);
        }
    }

    private static void copyDeprecatedConfigurationOptions(Configuration config) {
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, ENABLE_GCE_SERVICE_ACCOUNT_AUTH_KEY, "fs.gs.auth.service.account.enable");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, SERVICE_ACCOUNT_AUTH_KEYFILE_KEY, "fs.gs.auth.service.account.keyfile");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, SERVICE_ACCOUNT_AUTH_EMAIL_KEY, "fs.gs.auth.service.account.email");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, GCS_CLIENT_ID_KEY, "fs.gs.auth.client.id");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, GCS_CLIENT_SECRET_KEY, "fs.gs.auth.client.secret");
        String oauthClientFileKey = "fs.gs.auth.client.file";
        if (config.get(oauthClientFileKey) == null) {
            config.set(oauthClientFileKey, String.valueOf(System.getProperty("user.home")).concat("/.credentials/storage.json"));
        }
    }

    private synchronized void configure(Configuration config) throws IOException {
        Path newWorkingDirectory;
        log.debug("GHFS.configure", new Object[0]);
        log.debug("GHFS_ID = %s", new Object[]{GHFS_ID});
        if (this.gcsfs == null) {
            Credential credential;
            GoogleHadoopFileSystemBase.copyDeprecatedConfigurationOptions(config);
            try {
                credential = ((HadoopCredentialConfiguration)((HadoopCredentialConfiguration.Builder)HadoopCredentialConfiguration.newBuilder().withConfiguration(config).withOverridePrefix(AUTHENTICATION_PREFIX)).build()).getCredential(CredentialFactory.GCS_SCOPES);
            }
            catch (GeneralSecurityException gse) {
                throw new IOException(gse);
            }
            GoogleCloudStorageFileSystemOptions.Builder optionsBuilder = GoogleCloudStorageFileSystemOptions.newBuilder();
            boolean enableMetadataCache = config.getBoolean(GCS_ENABLE_METADATA_CACHE_KEY, true);
            log.debug("%s = %s", new Object[]{GCS_ENABLE_METADATA_CACHE_KEY, enableMetadataCache});
            optionsBuilder.setIsMetadataCacheEnabled(enableMetadataCache);
            DirectoryListCache.Type cacheType = DirectoryListCache.Type.valueOf(config.get(GCS_METADATA_CACHE_TYPE_KEY, GCS_METADATA_CACHE_TYPE_DEFAULT));
            log.debug("%s = %s", new Object[]{GCS_METADATA_CACHE_TYPE_KEY, cacheType});
            optionsBuilder.setCacheType(cacheType);
            String cacheBasePath = config.get(GCS_METADATA_CACHE_DIRECTORY_KEY, GCS_METADATA_CACHE_DIRECTORY_DEFAULT);
            log.debug("%s = %s", new Object[]{GCS_METADATA_CACHE_DIRECTORY_KEY, cacheBasePath});
            optionsBuilder.setCacheBasePath(cacheBasePath);
            Predicate<String> shouldIncludeInTimestampUpdatesPredicate = ParentTimestampUpdateIncludePredicate.create(config);
            optionsBuilder.setShouldIncludeInTimestampUpdatesPredicate(shouldIncludeInTimestampUpdatesPredicate);
            this.enableAutoRepairImplicitDirectories = config.getBoolean(GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_KEY, true);
            log.debug("%s = %s", new Object[]{GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_KEY, this.enableAutoRepairImplicitDirectories});
            this.enableFlatGlob = config.getBoolean(GCS_ENABLE_FLAT_GLOB_KEY, true);
            log.debug("%s = %s", new Object[]{GCS_ENABLE_FLAT_GLOB_KEY, this.enableFlatGlob});
            optionsBuilder.getCloudStorageOptionsBuilder().setAutoRepairImplicitDirectoriesEnabled(this.enableAutoRepairImplicitDirectories);
            boolean enableMarkerFileCreation = config.getBoolean(GCS_ENABLE_MARKER_FILE_CREATION_KEY, false);
            log.debug("%s = %s", new Object[]{GCS_ENABLE_MARKER_FILE_CREATION_KEY, enableMarkerFileCreation});
            optionsBuilder.getCloudStorageOptionsBuilder().setCreateMarkerObjects(enableMarkerFileCreation);
            String projectId = ConfigurationUtil.getMandatoryConfig((Configuration)config, (String)GCS_PROJECT_ID_KEY);
            optionsBuilder.getCloudStorageOptionsBuilder().setProjectId(projectId);
            boolean limitFileSizeTo250Gb = config.getBoolean(GCS_FILE_SIZE_LIMIT_250GB, true);
            optionsBuilder.getCloudStorageOptionsBuilder().getWriteChannelOptionsBuilder().setFileSizeLimitedTo250Gb(limitFileSizeTo250Gb);
            int uploadBufferSize = config.getInt(WRITE_BUFFERSIZE_KEY, 0x4000000);
            log.debug("%s = %d", new Object[]{WRITE_BUFFERSIZE_KEY, uploadBufferSize});
            optionsBuilder.getCloudStorageOptionsBuilder().getWriteChannelOptionsBuilder().setUploadBufferSize(uploadBufferSize);
            optionsBuilder.getCloudStorageOptionsBuilder().setAppName(GHFS_ID);
            this.gcsfs = new GoogleCloudStorageFileSystem(credential, optionsBuilder.build());
        }
        this.bufferSizeOverride = config.getInt(BUFFERSIZE_KEY, 0x800000);
        log.debug("%s = %d", new Object[]{BUFFERSIZE_KEY, this.bufferSizeOverride});
        this.defaultBlockSize = config.getLong(BLOCK_SIZE_KEY, 0x4000000L);
        log.debug("%s = %d", new Object[]{BLOCK_SIZE_KEY, this.defaultBlockSize});
        String systemBucketName = config.get(GCS_SYSTEM_BUCKET_KEY, null);
        log.debug("%s = %s", new Object[]{GCS_SYSTEM_BUCKET_KEY, systemBucketName});
        boolean createSystemBucket = config.getBoolean(GCS_CREATE_SYSTEM_BUCKET_KEY, true);
        log.debug("%s = %s", new Object[]{GCS_CREATE_SYSTEM_BUCKET_KEY, createSystemBucket});
        this.configureBuckets(systemBucketName, createSystemBucket);
        this.workingDirectory = this.getFileSystemRoot();
        String configWorkingDirectory = config.get(GCS_WORKING_DIRECTORY_KEY);
        if (Strings.isNullOrEmpty((String)configWorkingDirectory)) {
            newWorkingDirectory = this.getDefaultWorkingDirectory();
            log.warn("No working directory configured, using default: '%s'", new Object[]{newWorkingDirectory});
        } else {
            newWorkingDirectory = new Path(configWorkingDirectory);
        }
        this.setWorkingDirectory(newWorkingDirectory);
        log.debug("%s = %s", new Object[]{GCS_WORKING_DIRECTORY_KEY, this.getWorkingDirectory()});
        this.setConf(config);
        log.debug("GHFS.configure: done", new Object[0]);
    }

    @VisibleForTesting
    public void configureBuckets(String systemBucketName, boolean createSystemBucket) throws IOException {
        log.debug("GHFS.configureBuckets: %s, %s", new Object[]{systemBucketName, createSystemBucket});
        this.systemBucket = systemBucketName;
        if (this.systemBucket != null) {
            log.debug("GHFS.configureBuckets: Warning fs.gs.system.bucket is deprecated.", new Object[0]);
            URI systemBucketPath = GoogleCloudStorageFileSystem.getPath(this.systemBucket);
            this.checkOpen();
            if (!this.gcsfs.exists(systemBucketPath)) {
                if (createSystemBucket) {
                    this.gcsfs.mkdirs(systemBucketPath);
                } else {
                    String msg = String.format("%s: system bucket not found: %s", GCS_SYSTEM_BUCKET_KEY, this.systemBucket);
                    throw new FileNotFoundException(msg);
                }
            }
        }
        log.debug("GHFS.configureBuckets:=>", new Object[0]);
    }

    private void checkOpen() throws IOException {
        if (this.gcsfs == null) {
            throw new IOException("GoogleHadoopFileSystem has been closed or not initialized.");
        }
    }

    public boolean deleteOnExit(Path f) throws IOException {
        this.checkOpen();
        log.debug("GHFS.deleteOnExit: %s", new Object[]{f});
        boolean result = super.deleteOnExit(f);
        log.debug("GHFS.deleteOnExit:=> %s", new Object[]{result});
        return result;
    }

    protected void processDeleteOnExit() {
        log.debug("GHFS.processDeleteOnExit:", new Object[0]);
        super.processDeleteOnExit();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        log.debug("GHFS.getContentSummary: %s", new Object[]{f});
        ContentSummary result = super.getContentSummary(f);
        log.debug("GHFS.getContentSummary:=> %s", new Object[]{result});
        return result;
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        log.debug("GHFS.getDelegationToken: renewer: %s", new Object[]{renewer});
        Token result = super.getDelegationToken(renewer);
        log.debug("GHFS.getDelegationToken:=> %s", new Object[]{result});
        return result;
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        log.debug("GHFS.copyFromLocalFile: delSrc: %s, overwrite: %s, #srcs: %d, dst: %s", new Object[]{delSrc, overwrite, srcs.length, dst});
        super.copyFromLocalFile(delSrc, overwrite, srcs, dst);
        log.debug("GHFS.copyFromLocalFile:=> ", new Object[0]);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        log.debug("GHFS.copyFromLocalFile: delSrc: %s, overwrite: %s, src: %s, dst: %s", new Object[]{delSrc, overwrite, src, dst});
        super.copyFromLocalFile(delSrc, overwrite, src, dst);
        log.debug("GHFS.copyFromLocalFile:=> ", new Object[0]);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        log.debug("GHFS.copyToLocalFile: delSrc: %s, src: %s, dst: %s", new Object[]{delSrc, src, dst});
        super.copyToLocalFile(delSrc, src, dst);
        log.debug("GHFS.copyToLocalFile:=> ", new Object[0]);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        log.debug("GHFS.startLocalOutput: out: %s, tmp: %s", new Object[]{fsOutputFile, tmpLocalFile});
        Path result = super.startLocalOutput(fsOutputFile, tmpLocalFile);
        log.debug("GHFS.startLocalOutput:=> %s", new Object[]{result});
        return result;
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        log.debug("GHFS.startLocalOutput: out: %s, tmp: %s", new Object[]{fsOutputFile, tmpLocalFile});
        super.completeLocalOutput(fsOutputFile, tmpLocalFile);
        log.debug("GHFS.completeLocalOutput:=> ", new Object[0]);
    }

    public void close() throws IOException {
        log.debug("GHFS.close:", new Object[0]);
        super.close();
        if (this.gcsfs != null) {
            this.gcsfs.close();
            this.gcsfs = null;
        }
        this.logCounters();
        log.debug("GHFS.close:=> ", new Object[0]);
    }

    public long getUsed() throws IOException {
        log.debug("GHFS.getUsed:", new Object[0]);
        long result = super.getUsed();
        log.debug("GHFS.getUsed:=> %d", new Object[]{result});
        return result;
    }

    public long getDefaultBlockSize() {
        log.debug("GHFS.getDefaultBlockSize:", new Object[0]);
        long result = this.defaultBlockSize;
        log.debug("GHFS.getDefaultBlockSize:=> %s", new Object[]{result});
        return result;
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        log.debug("GHFS.getFileChecksum:", new Object[0]);
        FileChecksum result = super.getFileChecksum(f);
        log.debug("GHFS.getFileChecksum:=> %s", new Object[]{result});
        return result;
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        log.debug("GHFS.setVerifyChecksum:", new Object[0]);
        super.setVerifyChecksum(verifyChecksum);
        log.debug("GHFS.setVerifyChecksum:=> ", new Object[0]);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        log.debug("GHFS.setPermission: path: %s, perm: %s", new Object[]{p, permission});
        super.setPermission(p, permission);
        log.debug("GHFS.setPermission:=> ", new Object[0]);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        log.debug("GHFS.setOwner: path: %s, user: %s, group: %s", new Object[]{p, username, groupname});
        super.setOwner(p, username, groupname);
        log.debug("GHFS.setOwner:=> ", new Object[0]);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        log.debug("GHFS.setTimes: path: %s, mtime: %d, atime: %d", new Object[]{p, mtime, atime});
        super.setTimes(p, mtime, atime);
        log.debug("GHFS.setTimes:=> ", new Object[0]);
    }

    static {
        log.info("GHFS version: %s", new Object[]{VERSION});
        GHFS_ID = String.format("GHFS/%s", VERSION);
    }

    public static class ParentTimestampUpdateIncludePredicate
    implements Predicate<String> {
        private final List<String> includeSubstrings;
        private final List<String> excludeSubstrings;
        private final boolean enableTimestampUpdates;

        public static Predicate<String> create(Configuration config) {
            boolean enableDirectoryTimestampUpdating = config.getBoolean(GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_KEY, true);
            log.debug("%s = %s", new Object[]{GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_KEY, enableDirectoryTimestampUpdating});
            String includedParentPaths = config.get(GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_KEY, GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_DEFAULT);
            log.debug("%s = %s", new Object[]{GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_KEY, includedParentPaths});
            List splitIncludedParentPaths = CONFIGURATION_SPLITTER.splitToList((CharSequence)includedParentPaths);
            String excludedParentPaths = config.get(GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_KEY, GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT);
            log.debug("%s = %s", new Object[]{GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_KEY, excludedParentPaths});
            List splitExcludedParentPaths = CONFIGURATION_SPLITTER.splitToList((CharSequence)excludedParentPaths);
            return new ParentTimestampUpdateIncludePredicate(enableDirectoryTimestampUpdating, splitIncludedParentPaths, splitExcludedParentPaths);
        }

        public ParentTimestampUpdateIncludePredicate(boolean enableTimestampUpdates, List<String> includeSubstrings, List<String> excludeSubstrings) {
            this.includeSubstrings = includeSubstrings;
            this.excludeSubstrings = excludeSubstrings;
            this.enableTimestampUpdates = enableTimestampUpdates;
        }

        public boolean apply(String path) {
            if (!this.enableTimestampUpdates) {
                log.debug("Timestamp updating disabled. Not updating path %s", new Object[]{path});
                return false;
            }
            for (String include : this.includeSubstrings) {
                if (!path.contains(include)) continue;
                log.debug("Path %s matched included path %s. Updating timestamps.", new Object[]{path, include});
                return true;
            }
            for (String exclude : this.excludeSubstrings) {
                if (!path.contains(exclude)) continue;
                log.debug("Path %s matched excluded path %s. Not updating timestamps.", new Object[]{path, exclude});
                return false;
            }
            return true;
        }
    }

    public static enum Counter {
        APPEND,
        APPEND_TIME,
        CREATE,
        CREATE_TIME,
        DELETE,
        DELETE_TIME,
        GET_FILE_STATUS,
        GET_FILE_STATUS_TIME,
        INIT,
        INIT_TIME,
        INPUT_STREAM,
        INPUT_STREAM_TIME,
        LIST_STATUS,
        LIST_STATUS_TIME,
        MKDIRS,
        MKDIRS_TIME,
        OPEN,
        OPEN_TIME,
        OUTPUT_STREAM,
        OUTPUT_STREAM_TIME,
        READ1,
        READ1_TIME,
        READ,
        READ_TIME,
        READ_FROM_CHANNEL,
        READ_FROM_CHANNEL_TIME,
        READ_CLOSE,
        READ_CLOSE_TIME,
        READ_POS,
        READ_POS_TIME,
        RENAME,
        RENAME_TIME,
        SEEK,
        SEEK_TIME,
        SET_WD,
        SET_WD_TIME,
        WRITE1,
        WRITE1_TIME,
        WRITE,
        WRITE_TIME,
        WRITE_CLOSE,
        WRITE_CLOSE_TIME;

    }

    protected static enum ListStatusFileNotFoundBehavior {
        Hadoop1{

            @Override
            public FileStatus[] handle(String path) throws IOException {
                return null;
            }
        }
        ,
        Hadoop2{

            @Override
            public FileStatus[] handle(String path) throws IOException {
                throw new FileNotFoundException(String.format("Path '%s' does not exist.", path));
            }
        };


        public abstract FileStatus[] handle(String var1) throws IOException;

        public static ListStatusFileNotFoundBehavior get() {
            return ListStatusFileNotFoundBehavior.get(HadoopVersionInfo.getInstance());
        }

        public static ListStatusFileNotFoundBehavior get(HadoopVersionInfo hadoopVersionInfo) {
            if (hadoopVersionInfo.isGreaterThan(2, 0) || hadoopVersionInfo.isEqualTo(0, 23)) {
                return Hadoop2;
            }
            return Hadoop1;
        }
    }
}

