/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@Deprecated
public class GoogleHadoopGlobalRootedFileSystem
extends GoogleHadoopFileSystemBase {
    public GoogleHadoopGlobalRootedFileSystem() {
    }

    public GoogleHadoopGlobalRootedFileSystem(GoogleCloudStorageFileSystem gcsfs) {
        super(gcsfs);
    }

    @Override
    protected String getHomeDirectorySubpath() {
        String string = String.valueOf(String.valueOf(this.systemBucket));
        String string2 = String.valueOf(String.valueOf(System.getProperty("user.name")));
        return new StringBuilder(6 + string.length() + string2.length()).append(string).append("/user/").append(string2).toString();
    }

    @Override
    public Path getHadoopPath(URI gcsPath) {
        log.debug("GHFS.getHadoopPath: %s", new Object[]{gcsPath});
        if (gcsPath.equals(this.getGcsPath(this.getFileSystemRoot()))) {
            return this.getFileSystemRoot();
        }
        StorageResourceId resourceId = GoogleCloudStorageFileSystem.validatePathAndGetId(gcsPath, true);
        Path hadoopPath = this.getHadoopPathFromResourceId(resourceId);
        log.debug("GHFS.getHadoopPath: %s -> %s", new Object[]{gcsPath, hadoopPath});
        return hadoopPath;
    }

    @VisibleForTesting
    Path getHadoopPathFromResourceId(StorageResourceId resourceId) {
        Preconditions.checkArgument((!resourceId.isRoot() ? 1 : 0) != 0, (Object)"resourceId must be a bucket or object.");
        String bucketName = resourceId.getBucketName();
        String objectName = resourceId.getObjectName();
        if (objectName == null) {
            objectName = "";
        }
        URI pathUri = null;
        String string = String.valueOf(String.valueOf(this.getScheme()));
        String string2 = String.valueOf(String.valueOf(bucketName));
        String string3 = String.valueOf(String.valueOf(objectName));
        String path = new StringBuilder(3 + string.length() + string2.length() + string3.length()).append(string).append(":/").append(string2).append("/").append(string3).toString();
        try {
            pathUri = new URI(path);
        }
        catch (URISyntaxException e) {
            String msg = String.format("Invalid path: %s / %s", bucketName, objectName);
            throw new IllegalArgumentException(msg, e);
        }
        Path hadoopPath = new Path(pathUri.toString());
        return hadoopPath;
    }

    @Override
    public URI getGcsPath(Path hadoopPath) {
        log.debug("GHFS.getGcsPath: %s", new Object[]{hadoopPath});
        Path resolvedPath = hadoopPath.makeQualified((FileSystem)this);
        if (resolvedPath.equals((Object)this.getFileSystemRoot())) {
            return GoogleCloudStorageFileSystem.GCS_ROOT;
        }
        String authorityString = null;
        if (!Strings.isNullOrEmpty((String)resolvedPath.toUri().getAuthority())) {
            String string = String.valueOf(resolvedPath.toUri().getAuthority());
            authorityString = string.length() != 0 ? "/".concat(string) : new String("/");
        } else {
            authorityString = "";
        }
        String string = String.valueOf(String.valueOf("gs:/"));
        String string2 = String.valueOf(String.valueOf(authorityString));
        String string3 = String.valueOf(String.valueOf(resolvedPath.toUri().getPath()));
        String path = new StringBuilder(0 + string.length() + string2.length() + string3.length()).append(string).append(string2).append(string3).toString();
        URI gcsPath = null;
        try {
            gcsPath = new URI(path);
        }
        catch (URISyntaxException e) {
            String msg = String.format("Invalid path: %s", hadoopPath);
            throw new IllegalArgumentException(msg, e);
        }
        log.debug("GHFS.getGcsPath: %s -> %s", new Object[]{hadoopPath, gcsPath});
        return gcsPath;
    }

    @Override
    public Path getFileSystemRoot() {
        return new Path(String.valueOf(this.getScheme()).concat(":/"));
    }

    @Override
    public String getScheme() {
        return "gsg";
    }

    @Override
    public Path getDefaultWorkingDirectory() {
        return new Path(this.getFileSystemRoot(), this.systemBucket);
    }
}

