/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.MetadataReadOnlyGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

class ListHelperGoogleHadoopFileSystem
extends GoogleHadoopFileSystem {
    public static GoogleHadoopFileSystem createInstance(Collection<FileInfo> fileInfos) throws IOException {
        Preconditions.checkState((!fileInfos.isEmpty() ? 1 : 0) != 0, (Object)"Cannot construct ListHelperGoogleHadoopFileSystem with empty fileInfos list!");
        ArrayList<GoogleCloudStorageItemInfo> infos = new ArrayList<GoogleCloudStorageItemInfo>();
        URI rootUri = null;
        HashSet<URI> providedPaths = new HashSet<URI>();
        for (FileInfo info : fileInfos) {
            infos.add(info.getItemInfo());
            providedPaths.add(info.getPath());
            if (rootUri != null) continue;
            rootUri = info.getPath();
        }
        HashSet missingParents = new HashSet();
        for (FileInfo info : fileInfos) {
            URI parentPath = GoogleCloudStorageFileSystem.getParentPath(info.getPath());
            while (parentPath != null && !parentPath.equals(GoogleCloudStorageFileSystem.GCS_ROOT)) {
                if (!providedPaths.contains(parentPath)) {
                    log.debug("Adding fake entry for missing parent path '%s'", new Object[]{parentPath});
                    GoogleCloudStorageItemInfo fakeInfo = new GoogleCloudStorageItemInfo(GoogleCloudStorageFileSystem.validatePathAndGetId(parentPath, true), 0L, 0L, null, null);
                    infos.add(fakeInfo);
                    providedPaths.add(parentPath);
                }
                parentPath = GoogleCloudStorageFileSystem.getParentPath(parentPath);
            }
        }
        String tempBucket = rootUri.getAuthority();
        infos.add(new GoogleCloudStorageItemInfo(new StorageResourceId(tempBucket), 0L, 0L, "", ""));
        MetadataReadOnlyGoogleCloudStorage tempGcs = new MetadataReadOnlyGoogleCloudStorage(infos);
        GoogleCloudStorageFileSystem tempGcsFs = new GoogleCloudStorageFileSystem(tempGcs);
        ListHelperGoogleHadoopFileSystem tempGhfs = new ListHelperGoogleHadoopFileSystem(tempGcsFs);
        Configuration tempConfig = new Configuration();
        tempConfig.set("fs.gs.system.bucket", tempBucket);
        tempConfig.setBoolean("fs.gs.system.bucket.create", false);
        tempConfig.set("fs.gs.working.dir", "/");
        tempGhfs.initialize(rootUri, tempConfig, false);
        return tempGhfs;
    }

    public ListHelperGoogleHadoopFileSystem(GoogleCloudStorageFileSystem gcsfs) {
        super(gcsfs);
    }

    @Override
    boolean shouldUseFlatGlob(Path fixedPath) {
        return false;
    }
}

