/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.StorageRequest;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class BatchHelper {
    private final List<QueueRequestCallback> pendingBatchEntries = new LinkedList<QueueRequestCallback>();
    private final BatchRequest batch;
    private final long maxRequestsPerBatch;
    private boolean flushing = false;

    private BatchHelper(HttpRequestInitializer requestInitializer, Storage gcs, long maxRequestsPerBatch) {
        this.batch = gcs.batch(requestInitializer);
        this.maxRequestsPerBatch = maxRequestsPerBatch;
    }

    @VisibleForTesting
    protected BatchHelper() {
        this.batch = null;
        this.maxRequestsPerBatch = -1L;
    }

    public <T> void queue(final StorageRequest<T> req, final JsonBatchCallback<T> callback) throws IOException {
        QueueRequestCallback queueCallback = new QueueRequestCallback(){

            @Override
            public void enqueue() throws IOException {
                req.queue(BatchHelper.this.batch, callback);
            }
        };
        this.pendingBatchEntries.add(queueCallback);
        this.flushIfPossibleAndRequired();
    }

    private void flushIfPossibleAndRequired() throws IOException {
        if ((long)this.pendingBatchEntries.size() > this.maxRequestsPerBatch) {
            this.flushIfPossible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIfPossible() throws IOException {
        if (!this.flushing && this.pendingBatchEntries.size() > 0) {
            this.flushing = true;
            try {
                while ((long)this.batch.size() < this.maxRequestsPerBatch && this.pendingBatchEntries.size() > 0) {
                    QueueRequestCallback head = this.pendingBatchEntries.remove(0);
                    head.enqueue();
                }
                this.batch.execute();
            }
            finally {
                this.flushing = false;
            }
        }
    }

    public void flush() throws IOException {
        this.flushIfPossible();
    }

    public boolean isEmpty() {
        return this.pendingBatchEntries.size() == 0;
    }

    protected static interface QueueRequestCallback {
        public void enqueue() throws IOException;
    }

    public static class Factory {
        public BatchHelper newBatchHelper(HttpRequestInitializer requestInitializer, Storage gcs, long maxRequestsPerBatch) {
            return new BatchHelper(requestInitializer, gcs, maxRequestsPerBatch);
        }
    }
}

