/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.DirectoryListCache;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

public class GoogleCloudStorageFileSystemOptions {
    private final GoogleCloudStorageOptions cloudStorageOptions;
    private final boolean metadataCacheEnabled;
    private final DirectoryListCache.Type cacheType;
    private final String cacheBasePath;
    private final Predicate<String> shouldIncludeInTimestampUpdatesPredicate;

    public static Builder newBuilder() {
        return new Builder();
    }

    public GoogleCloudStorageFileSystemOptions(GoogleCloudStorageOptions cloudStorageOptions, boolean metadataCacheEnabled, DirectoryListCache.Type cacheType, String cacheBasePath, Predicate<String> shouldIncludeInTimestampUpdatesPredicate) {
        this.cloudStorageOptions = cloudStorageOptions;
        this.metadataCacheEnabled = metadataCacheEnabled;
        this.cacheType = cacheType;
        this.cacheBasePath = cacheBasePath;
        this.shouldIncludeInTimestampUpdatesPredicate = shouldIncludeInTimestampUpdatesPredicate;
    }

    public GoogleCloudStorageOptions getCloudStorageOptions() {
        return this.cloudStorageOptions;
    }

    public boolean isMetadataCacheEnabled() {
        return this.metadataCacheEnabled;
    }

    public DirectoryListCache.Type getCacheType() {
        return this.cacheType;
    }

    public String getCacheBasePath() {
        return this.cacheBasePath;
    }

    public Predicate<String> getShouldIncludeInTimestampUpdatesPredicate() {
        return this.shouldIncludeInTimestampUpdatesPredicate;
    }

    public void throwIfNotValid() {
        Preconditions.checkArgument((this.shouldIncludeInTimestampUpdatesPredicate != null ? 1 : 0) != 0, (Object)"Predicate for ignored directory updates should not be null. Consider Predicates.alwasyTrue");
        this.cloudStorageOptions.throwIfNotValid();
    }

    public static class Builder {
        protected boolean metadataCacheEnabled = true;
        protected DirectoryListCache.Type cacheType = DirectoryListCache.Type.IN_MEMORY;
        protected String cacheBasePath = null;
        protected Predicate<String> shouldIncludeInTimestampUpdatesPredicate = Predicates.alwaysTrue();
        private GoogleCloudStorageOptions.Builder cloudStorageOptionsBuilder = new GoogleCloudStorageOptions.Builder();

        public GoogleCloudStorageOptions.Builder getCloudStorageOptionsBuilder() {
            return this.cloudStorageOptionsBuilder;
        }

        public Builder setIsMetadataCacheEnabled(boolean isMetadataCacheEnabled) {
            this.metadataCacheEnabled = isMetadataCacheEnabled;
            return this;
        }

        public Builder setCacheType(DirectoryListCache.Type cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder setCacheBasePath(String cacheBasePath) {
            this.cacheBasePath = cacheBasePath;
            return this;
        }

        public Builder setShouldIncludeInTimestampUpdatesPredicate(Predicate<String> shouldIncludeInTimestampUpdatesPredicate) {
            this.shouldIncludeInTimestampUpdatesPredicate = shouldIncludeInTimestampUpdatesPredicate;
            return this;
        }

        public GoogleCloudStorageFileSystemOptions build() {
            return new GoogleCloudStorageFileSystemOptions(this.cloudStorageOptionsBuilder.build(), this.metadataCacheEnabled, this.cacheType, this.cacheBasePath, this.shouldIncludeInTimestampUpdatesPredicate);
        }
    }
}

