/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Data;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.Buckets;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.BatchHelper;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageWriteChannel;
import com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.gcsio.OperationWithRetry;
import com.google.cloud.hadoop.gcsio.SeekableReadableByteChannel;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.util.LogUtil;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GoogleCloudStorageImpl
implements GoogleCloudStorage {
    public static final String PATH_DELIMITER = "/";
    public static final int BUCKET_EMPTY_MAX_RETRIES = 20;
    public static final int BUCKET_EMPTY_WAIT_TIME_MS = 500;
    private static final HttpTransport DEFAULT_HTTP_TRANSPORT = new NetHttpTransport();
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static final LogUtil log = new LogUtil(GoogleCloudStorage.class);
    private static final String OCTECT_STREAM_MEDIA_TYPE = "application/octet-stream";
    private static final int MAXIMUM_PRECONDITION_FAILURES_IN_DELETE = 4;
    private final Predicate<IOException> isRateLimitedException = new Predicate<IOException>(){

        public boolean apply(IOException e) {
            return GoogleCloudStorageImpl.this.errorExtractor.rateLimited(e);
        }
    };
    private static final Function<byte[], String> ENCODE_METADATA_VALUES = new Function<byte[], String>(){

        public String apply(byte[] bytes) {
            if (bytes == null) {
                return Data.NULL_STRING;
            }
            return BaseEncoding.base64().encode(bytes);
        }
    };
    private static final Function<String, byte[]> DECODE_METADATA_VALUES = new Function<String, byte[]>(){

        public byte[] apply(String value) {
            try {
                return BaseEncoding.base64().decode((CharSequence)value);
            }
            catch (IllegalArgumentException iae) {
                log.error("Failed to parse base64 encoded attribute value %s - %s", new Object[]{value, iae});
                return null;
            }
        }
    };
    private Storage gcs;
    private ExecutorService threadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcs-async-channel-pool-%d").setDaemon(true).build());
    private ExecutorService manualBatchingThreadPool = new ThreadPoolExecutor(10, 20, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("gcs-manual-batching-pool-%d").setDaemon(true).build());
    private ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
    private ClientRequestHelper<StorageObject> clientRequestHelper = new ClientRequestHelper();
    private BatchHelper.Factory batchFactory = new BatchHelper.Factory();
    private HttpRequestInitializer httpRequestInitializer;
    private final GoogleCloudStorageOptions storageOptions;
    private Sleeper sleeper = Sleeper.DEFAULT;
    private BackOffFactory backOffFactory = BackOffFactory.DEFAULT;

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Credential credential) throws IOException {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options must not be null");
        log.debug("GCS(%s)", new Object[]{options.getAppName()});
        options.throwIfNotValid();
        this.storageOptions = options;
        Preconditions.checkArgument((credential != null ? 1 : 0) != 0, (Object)"credential must not be null");
        this.httpRequestInitializer = new RetryHttpInitializer(credential, options.getAppName());
        this.gcs = new Storage.Builder(DEFAULT_HTTP_TRANSPORT, JSON_FACTORY, this.httpRequestInitializer).setApplicationName(options.getAppName()).build();
    }

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Storage gcs) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options must not be null");
        log.debug("GCS(%s)", new Object[]{options.getAppName()});
        options.throwIfNotValid();
        this.storageOptions = options;
        Preconditions.checkArgument((gcs != null ? 1 : 0) != 0, (Object)"gcs must not be null");
        this.gcs = gcs;
        this.httpRequestInitializer = null;
    }

    @VisibleForTesting
    protected GoogleCloudStorageImpl() {
        this.storageOptions = GoogleCloudStorageOptions.newBuilder().build();
    }

    @VisibleForTesting
    void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @VisibleForTesting
    void setManualBatchingThreadPool(ExecutorService manualBatchingThreadPool) {
        this.manualBatchingThreadPool = manualBatchingThreadPool;
    }

    @VisibleForTesting
    void setErrorExtractor(ApiErrorExtractor errorExtractor) {
        this.errorExtractor = errorExtractor;
    }

    @VisibleForTesting
    void setClientRequestHelper(ClientRequestHelper<StorageObject> clientRequestHelper) {
        this.clientRequestHelper = clientRequestHelper;
    }

    @VisibleForTesting
    void setBatchFactory(BatchHelper.Factory batchFactory) {
        this.batchFactory = batchFactory;
    }

    @VisibleForTesting
    GoogleCloudStorageOptions getStorageOptions() {
        return this.storageOptions;
    }

    @VisibleForTesting
    void setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    @VisibleForTesting
    void setBackOffFactory(BackOffFactory factory) {
        this.backOffFactory = factory;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        log.debug("create(%s)", new Object[]{resourceId});
        String string = String.valueOf(String.valueOf(resourceId));
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + string.length()).append("Expected full StorageObject id, got ").append(string).toString());
        Optional overwriteGeneration = Optional.absent();
        long backOffSleep = 0L;
        GoogleCloudStorageItemInfo info = this.getItemInfo(resourceId);
        if (this.storageOptions.isMarkerFileCreationEnabled()) {
            BackOff backOff = this.backOffFactory.newBackOff();
            do {
                if (backOffSleep != 0L) {
                    try {
                        this.sleeper.sleep(backOffSleep);
                    }
                    catch (InterruptedException ie) {
                        throw new IOException(String.format("Interrupted while sleeping for backoff in create of %s", resourceId));
                    }
                }
                backOffSleep = backOff.nextBackOffMillis();
                Storage.Objects.Insert insertObject = this.prepareEmptyInsert(resourceId, options);
                if (!info.exists()) {
                    insertObject.setIfGenerationMatch(Long.valueOf(0L));
                } else if (info.exists() && options.overwriteExisting()) {
                    long generation = info.getContentGeneration();
                    Preconditions.checkState((generation != 0L ? 1 : 0) != 0, (Object)"Generation should not be 0 for an existing item");
                    insertObject.setIfGenerationMatch(Long.valueOf(generation));
                } else {
                    throw new IOException(String.format("Object %s already exists", resourceId.toString()));
                }
                try {
                    StorageObject result = (StorageObject)insertObject.execute();
                    overwriteGeneration = Optional.of((Object)result.getGeneration());
                }
                catch (IOException ioe) {
                    if (this.errorExtractor.preconditionNotMet(ioe)) {
                        log.info("Retrying marker file creation. Retrying according to backoff policy, %s - %s", new Object[]{resourceId, ioe});
                        continue;
                    }
                    throw ioe;
                }
            } while (!overwriteGeneration.isPresent() && backOffSleep != -1L);
            if (backOffSleep == -1L) {
                throw new IOException(String.format("Retries exhausted while attempting to create marker file for %s", resourceId));
            }
        } else {
            if (!info.exists()) {
                overwriteGeneration = Optional.of((Object)0L);
            } else if (info.exists() && options.overwriteExisting()) {
                long generation = info.getContentGeneration();
                Preconditions.checkState((generation != 0L ? 1 : 0) != 0, (Object)"Generation should not be 0 for an existing item");
                overwriteGeneration = Optional.of((Object)generation);
            } else {
                throw new IOException(String.format("Object %s already exists.", resourceId.toString()));
            }
            Preconditions.checkState((boolean)overwriteGeneration.isPresent(), (Object)"Marker file creation is disabled, we should have a generation to overwrite.");
        }
        ObjectWriteConditions writeConditions = new ObjectWriteConditions((Optional<Long>)overwriteGeneration, (Optional<Long>)Optional.absent());
        Map rewrittenMetadata = Maps.transformValues(options.getMetadata(), ENCODE_METADATA_VALUES);
        GoogleCloudStorageWriteChannel channel = new GoogleCloudStorageWriteChannel(this.threadPool, this.gcs, this.clientRequestHelper, resourceId.getBucketName(), resourceId.getObjectName(), this.storageOptions.getWriteChannelOptions(), writeConditions, rewrittenMetadata);
        channel.initialize();
        return channel;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId) throws IOException {
        log.debug("create(%s)", new Object[]{resourceId});
        String string = String.valueOf(String.valueOf(resourceId));
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + string.length()).append("Expected full StorageObject id, got ").append(string).toString());
        return this.create(resourceId, CreateObjectOptions.DEFAULT);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        String string = String.valueOf(String.valueOf(resourceId));
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + string.length()).append("Expected full StorageObject id, got ").append(string).toString());
        Storage.Objects.Insert insertObject = this.prepareEmptyInsert(resourceId, options);
        insertObject.execute();
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        log.debug("createEmptyObject(%s)", new Object[]{resourceId});
        String string = String.valueOf(String.valueOf(resourceId));
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + string.length()).append("Expected full StorageObject id, got ").append(string).toString());
        this.createEmptyObject(resourceId, CreateObjectOptions.DEFAULT);
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        log.debug("createEmptyObjects(%s)", new Object[]{resourceIds});
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (String)"Expected full StorageObject names only, got: '%s'", (Object[])new Object[]{resourceId});
        }
        final List<IOException> innerExceptions = Collections.synchronizedList(new ArrayList());
        final CountDownLatch latch = new CountDownLatch(resourceIds.size());
        for (final StorageResourceId resourceId : resourceIds) {
            final Storage.Objects.Insert insertObject = this.prepareEmptyInsert(resourceId, options);
            this.manualBatchingThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        insertObject.execute();
                        log.debug("Successfully inserted %s", new Object[]{resourceId.toString()});
                    }
                    catch (IOException ioe) {
                        innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(ioe, "Error inserting", resourceId.getBucketName(), resourceId.getObjectName()));
                    }
                    catch (Throwable t) {
                        innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(t), "Error inserting", resourceId.getBucketName(), resourceId.getObjectName()));
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        this.createEmptyObjects(resourceIds, CreateObjectOptions.DEFAULT);
    }

    @Override
    public SeekableReadableByteChannel open(StorageResourceId resourceId) throws IOException {
        log.debug("open(%s)", new Object[]{resourceId});
        String string = String.valueOf(String.valueOf(resourceId));
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + string.length()).append("Expected full StorageObject id, got ").append(string).toString());
        if (!this.getItemInfo(resourceId).exists()) {
            throw GoogleCloudStorageExceptions.getFileNotFoundException(resourceId.getBucketName(), resourceId.getObjectName());
        }
        return new GoogleCloudStorageReadChannel(this.gcs, resourceId.getBucketName(), resourceId.getObjectName(), this.errorExtractor, this.clientRequestHelper);
    }

    @Override
    public void create(String bucketName) throws IOException {
        log.debug("create(%s)", new Object[]{bucketName});
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        Bucket bucket = new Bucket();
        bucket.setName(bucketName);
        Storage.Buckets.Insert insertBucket = this.gcs.buckets().insert(this.storageOptions.getProjectId(), bucket);
        OperationWithRetry operation = new OperationWithRetry(this.sleeper, this.backOffFactory.newBackOff(), insertBucket, this.isRateLimitedException);
        operation.execute();
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        log.debug("deleteBuckets(%s)", new Object[]{bucketNames.toString()});
        for (String bucketName : bucketNames) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        }
        ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        for (String bucketName : bucketNames) {
            Storage.Buckets.Delete deleteBucket = this.gcs.buckets().delete(bucketName);
            OperationWithRetry bucketDeleteOperation = new OperationWithRetry(this.sleeper, this.backOffFactory.newBackOff(), deleteBucket, this.isRateLimitedException);
            try {
                bucketDeleteOperation.execute();
            }
            catch (IOException ioe) {
                if (this.errorExtractor.itemNotFound(ioe)) {
                    log.debug("delete(%s) : not found", new Object[]{bucketName});
                    innerExceptions.add(GoogleCloudStorageExceptions.getFileNotFoundException(bucketName, null));
                    continue;
                }
                innerExceptions.add(this.wrapException(new IOException(ioe.toString()), "Error deleting", bucketName, null));
            }
        }
        if (innerExceptions.size() > 0) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        log.debug("deleteObjects(%s)", new Object[]{fullObjectNames.toString()});
        for (StorageResourceId fullObjectName : fullObjectNames) {
            String string = String.valueOf(fullObjectName.toString());
            Preconditions.checkArgument((boolean)fullObjectName.isStorageObject(), (Object)(string.length() != 0 ? "Expected full StorageObject names only, got: ".concat(string) : new String("Expected full StorageObject names only, got: ")));
        }
        ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getMaxRequestsPerBatch());
        for (StorageResourceId fullObjectName : fullObjectNames) {
            this.queueSingleObjectDelete(fullObjectName, innerExceptions, batchHelper, 1);
        }
        do {
            batchHelper.flush();
        } while (!batchHelper.isEmpty());
        if (innerExceptions.size() > 0) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void queueSingleObjectDelete(final StorageResourceId fullObjectName, final List<IOException> innerExceptions, final BatchHelper batchHelper, final int attempt) throws IOException {
        final String bucketName = fullObjectName.getBucketName();
        final String objectName = fullObjectName.getObjectName();
        Storage.Objects.Get getObject = this.gcs.objects().get(bucketName, objectName);
        batchHelper.queue(getObject, new JsonBatchCallback<StorageObject>(){

            public void onSuccess(StorageObject storageObject, HttpHeaders httpHeaders) throws IOException {
                final Long generation = storageObject.getGeneration();
                Storage.Objects.Delete deleteObject = GoogleCloudStorageImpl.this.gcs.objects().delete(bucketName, objectName).setIfGenerationMatch(generation);
                batchHelper.queue(deleteObject, new JsonBatchCallback<Void>(){

                    public void onSuccess(Void obj, HttpHeaders responseHeaders) {
                        log.debug("Successfully deleted %s at generation %s", new Object[]{fullObjectName.toString(), generation});
                    }

                    public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) throws IOException {
                        if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(e)) {
                            log.debug("deleteObjects(%s) : delete not found", new Object[]{fullObjectName.toString()});
                        } else if (GoogleCloudStorageImpl.this.errorExtractor.preconditionNotMet(e) && attempt <= 4) {
                            log.info("Precondition not met while deleting %s at generation %s. Attempt %s. Retrying.", new Object[]{fullObjectName.toString(), generation, attempt});
                            GoogleCloudStorageImpl.this.queueSingleObjectDelete(fullObjectName, innerExceptions, batchHelper, attempt + 1);
                        } else {
                            innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(e.toString()), String.format("Error deleting, stage 2 with generation %s", generation), bucketName, objectName));
                        }
                    }
                });
            }

            public void onFailure(GoogleJsonError googleJsonError, HttpHeaders httpHeaders) throws IOException {
                if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(googleJsonError)) {
                    log.debug("deleteObjects(%s) : get not found", new Object[]{fullObjectName.toString()});
                } else {
                    innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(googleJsonError.toString()), "Error deleting, stage 1", bucketName, objectName));
                }
            }
        });
    }

    static void validateCopyArguments(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames, GoogleCloudStorage gcsImpl) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)srcBucketName) ? 1 : 0) != 0, (Object)"srcBucketName must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dstBucketName) ? 1 : 0) != 0, (Object)"dstBucketName must not be null or empty");
        Preconditions.checkArgument((srcObjectNames != null ? 1 : 0) != 0, (Object)"srcObjectNames must not be null");
        Preconditions.checkArgument((dstObjectNames != null ? 1 : 0) != 0, (Object)"dstObjectNames must not be null");
        Preconditions.checkArgument((srcObjectNames.size() == dstObjectNames.size() ? 1 : 0) != 0, (Object)"Must supply same number of elements in srcObjectNames and dstObjectNames");
        if (!srcBucketName.equals(dstBucketName)) {
            GoogleCloudStorageItemInfo srcBucketInfo = gcsImpl.getItemInfo(new StorageResourceId(srcBucketName));
            if (!srcBucketInfo.exists()) {
                String string = String.valueOf(srcBucketName);
                throw new FileNotFoundException(string.length() != 0 ? "Bucket not found: ".concat(string) : new String("Bucket not found: "));
            }
            GoogleCloudStorageItemInfo dstBucketInfo = gcsImpl.getItemInfo(new StorageResourceId(dstBucketName));
            if (!dstBucketInfo.exists()) {
                String string = String.valueOf(dstBucketName);
                throw new FileNotFoundException(string.length() != 0 ? "Bucket not found: ".concat(string) : new String("Bucket not found: "));
            }
            if (!srcBucketInfo.getLocation().equals(dstBucketInfo.getLocation())) {
                throw new UnsupportedOperationException("This operation is not supported across two different storage locations.");
            }
            if (!srcBucketInfo.getStorageClass().equals(dstBucketInfo.getStorageClass())) {
                throw new UnsupportedOperationException("This operation is not supported across two different storage classes.");
            }
        }
        for (int i = 0; i < srcObjectNames.size(); ++i) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)srcObjectNames.get(i)) ? 1 : 0) != 0, (Object)"srcObjectName must not be null or empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dstObjectNames.get(i)) ? 1 : 0) != 0, (Object)"dstObjectName must not be null or empty");
            if (!srcBucketName.equals(dstBucketName) || !srcObjectNames.get(i).equals(dstObjectNames.get(i))) continue;
            throw new IllegalArgumentException(String.format("Copy destination must be different from source for %s.", StorageResourceId.createReadableString(srcBucketName, srcObjectNames.get(i))));
        }
    }

    @Override
    public void copy(final String srcBucketName, List<String> srcObjectNames, final String dstBucketName, List<String> dstObjectNames) throws IOException {
        GoogleCloudStorageImpl.validateCopyArguments(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames, this);
        final ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getMaxRequestsPerBatch());
        for (int i = 0; i < srcObjectNames.size(); ++i) {
            final String srcObjectName = srcObjectNames.get(i);
            final String dstObjectName = dstObjectNames.get(i);
            Storage.Objects.Copy copyObject = this.gcs.objects().copy(srcBucketName, srcObjectName, dstBucketName, dstObjectName, null);
            batchHelper.queue(copyObject, new JsonBatchCallback<StorageObject>(){

                public void onSuccess(StorageObject obj, HttpHeaders responseHeaders) {
                    log.debug("Successfully copied %s to %s", new Object[]{StorageResourceId.createReadableString(srcBucketName, srcObjectName), StorageResourceId.createReadableString(dstBucketName, dstObjectName)});
                }

                public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(e)) {
                        log.debug("copy(%s) : not found", new Object[]{StorageResourceId.createReadableString(srcBucketName, srcObjectName)});
                        innerExceptions.add(GoogleCloudStorageExceptions.getFileNotFoundException(srcBucketName, srcObjectName));
                    } else {
                        innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(e.toString()), "Error copying", srcBucketName, srcObjectName));
                    }
                }
            });
        }
        batchHelper.flush();
        if (innerExceptions.size() > 0) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private List<Bucket> listBucketsInternal() throws IOException {
        Buckets items;
        log.debug("listBucketsInternal()", new Object[0]);
        ArrayList<Bucket> allBuckets = new ArrayList<Bucket>();
        Storage.Buckets.List listBucket = this.gcs.buckets().list(this.storageOptions.getProjectId());
        listBucket.setMaxResults(Long.valueOf(this.storageOptions.getMaxListItemsPerCall()));
        String pageToken = null;
        do {
            List buckets;
            if (pageToken != null) {
                log.debug("listBucketsInternal: next page %s", new Object[]{pageToken});
                listBucket.setPageToken(pageToken);
            }
            if ((buckets = (items = (Buckets)listBucket.execute()).getItems()) == null) continue;
            log.debug("listed %d items", new Object[]{buckets.size()});
            allBuckets.addAll(buckets);
        } while ((pageToken = items.getNextPageToken()) != null);
        return allBuckets;
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        log.debug("listBucketNames()", new Object[0]);
        ArrayList<String> bucketNames = new ArrayList<String>();
        List<Bucket> allBuckets = this.listBucketsInternal();
        for (Bucket bucket : allBuckets) {
            bucketNames.add(bucket.getName());
        }
        return bucketNames;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        log.debug("listBucketInfo()", new Object[0]);
        ArrayList<GoogleCloudStorageItemInfo> bucketInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        List<Bucket> allBuckets = this.listBucketsInternal();
        for (Bucket bucket : allBuckets) {
            bucketInfos.add(new GoogleCloudStorageItemInfo(new StorageResourceId(bucket.getName()), bucket.getTimeCreated().getValue(), 0L, bucket.getLocation(), bucket.getStorageClass()));
        }
        return bucketInfos;
    }

    private Storage.Objects.Insert prepareEmptyInsert(StorageResourceId resourceId, CreateObjectOptions createObjectOptions) throws IOException {
        StorageObject object = new StorageObject();
        object.setName(resourceId.getObjectName());
        Map rewrittenMetadata = Maps.transformValues(createObjectOptions.getMetadata(), ENCODE_METADATA_VALUES);
        object.setMetadata(rewrittenMetadata);
        ByteArrayContent emptyContent = new ByteArrayContent(OCTECT_STREAM_MEDIA_TYPE, new byte[0]);
        Storage.Objects.Insert insertObject = this.gcs.objects().insert(resourceId.getBucketName(), object, (AbstractInputStreamContent)emptyContent);
        insertObject.setDisableGZipContent(true);
        this.clientRequestHelper.setDirectUploadEnabled((AbstractGoogleClientRequest)insertObject, true);
        if (!createObjectOptions.overwriteExisting()) {
            insertObject.setIfGenerationMatch(Long.valueOf(0L));
        }
        return insertObject;
    }

    private void listStorageObjectsAndPrefixes(String bucketName, String objectNamePrefix, String delimiter, List<StorageObject> listedObjects, List<String> listedPrefixes) throws IOException {
        Objects items;
        log.debug("listStorageObjectsAndPrefixes(%s, %s, %s)", new Object[]{bucketName, objectNamePrefix, delimiter});
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        Preconditions.checkArgument((listedObjects != null ? 1 : 0) != 0, (Object)"Must provide a non-null container for listedObjects.");
        Preconditions.checkArgument((listedPrefixes != null ? 1 : 0) != 0, (Object)"Must provide a non-null container for listedPrefixes.");
        Storage.Objects.List listObject = this.gcs.objects().list(bucketName);
        if (delimiter != null) {
            listObject.setDelimiter(delimiter);
        }
        listObject.setMaxResults(Long.valueOf(this.storageOptions.getMaxListItemsPerCall()));
        if (!Strings.isNullOrEmpty((String)objectNamePrefix)) {
            listObject.setPrefix(objectNamePrefix);
        }
        String pageToken = null;
        do {
            List objects;
            if (pageToken != null) {
                log.debug("listObjectNames: next page %s", new Object[]{pageToken});
                listObject.setPageToken(pageToken);
            }
            try {
                items = (Objects)listObject.execute();
            }
            catch (IOException e) {
                if (this.errorExtractor.itemNotFound(e)) {
                    log.debug("listObjectNames(%s, %s, %s): not found", new Object[]{bucketName, objectNamePrefix, delimiter});
                    break;
                }
                throw this.wrapException(e, "Error listing", bucketName, objectNamePrefix);
            }
            List prefixes = items.getPrefixes();
            if (prefixes != null) {
                log.debug("listed %d prefixes", new Object[]{prefixes.size()});
                listedPrefixes.addAll(prefixes);
            }
            if ((objects = items.getItems()) == null) continue;
            log.debug("listed %d objects", new Object[]{objects.size()});
            boolean objectPrefixEndsWithDelimiter = !Strings.isNullOrEmpty((String)objectNamePrefix) && objectNamePrefix.endsWith(PATH_DELIMITER);
            for (StorageObject object : objects) {
                String objectName = object.getName();
                if (objectPrefixEndsWithDelimiter && (!objectPrefixEndsWithDelimiter || objectName.equals(objectNamePrefix))) continue;
                listedObjects.add(object);
            }
        } while ((pageToken = items.getNextPageToken()) != null);
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        log.debug("listObjectNames(%s, %s, %s)", new Object[]{bucketName, objectNamePrefix, delimiter});
        ArrayList<StorageObject> listedObjects = new ArrayList<StorageObject>();
        ArrayList<String> listedPrefixes = new ArrayList<String>();
        this.listStorageObjectsAndPrefixes(bucketName, objectNamePrefix, delimiter, listedObjects, listedPrefixes);
        ArrayList<String> objectNames = listedPrefixes;
        for (StorageObject obj : listedObjects) {
            objectNames.add(obj.getName());
        }
        return objectNames;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        log.debug("listObjectInfo(%s, %s, %s)", new Object[]{bucketName, objectNamePrefix, delimiter});
        ArrayList<StorageObject> listedObjects = new ArrayList<StorageObject>();
        ArrayList<String> listedPrefixes = new ArrayList<String>();
        this.listStorageObjectsAndPrefixes(bucketName, objectNamePrefix, delimiter, listedObjects, listedPrefixes);
        ArrayList<GoogleCloudStorageItemInfo> objectInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (StorageObject obj : listedObjects) {
            objectInfos.add(GoogleCloudStorageImpl.createItemInfoForStorageObject(new StorageResourceId(bucketName, obj.getName()), obj));
        }
        if (listedPrefixes.size() > 0) {
            ArrayList<StorageResourceId> resourceIdsForPrefixes = new ArrayList<StorageResourceId>();
            for (String prefix : listedPrefixes) {
                resourceIdsForPrefixes.add(new StorageResourceId(bucketName, prefix));
            }
            List<GoogleCloudStorageItemInfo> prefixInfos = this.getItemInfos(resourceIdsForPrefixes);
            ArrayList<StorageResourceId> repairList = new ArrayList<StorageResourceId>();
            for (GoogleCloudStorageItemInfo prefixInfo : prefixInfos) {
                if (prefixInfo.exists()) {
                    objectInfos.add(prefixInfo);
                    continue;
                }
                String errorBase = String.format("Error retrieving object for a retrieved prefix with resourceId '%s'. ", prefixInfo.getResourceId());
                if (this.storageOptions.isAutoRepairImplicitDirectoriesEnabled()) {
                    log.debug(String.valueOf(errorBase).concat("Attempting to repair missing directory."), new Object[0]);
                    repairList.add(prefixInfo.getResourceId());
                    continue;
                }
                log.error(String.valueOf(errorBase).concat("Giving up on retrieving missing directory."), new Object[0]);
            }
            if (this.storageOptions.isAutoRepairImplicitDirectoriesEnabled() && !repairList.isEmpty()) {
                try {
                    log.warn("Repairing batch of %d missing directories.", new Object[]{repairList.size()});
                    if (repairList.size() == 1) {
                        this.createEmptyObject((StorageResourceId)repairList.get(0));
                    } else {
                        this.createEmptyObjects(repairList);
                    }
                    List<GoogleCloudStorageItemInfo> repairedInfos = this.getItemInfos(repairList);
                    int numRepaired = 0;
                    for (GoogleCloudStorageItemInfo repairedInfo : repairedInfos) {
                        if (repairedInfo.exists()) {
                            objectInfos.add(repairedInfo);
                            ++numRepaired;
                            continue;
                        }
                        log.warn("Somehow the repair for '%s' failed quietly", new Object[]{repairedInfo.getResourceId()});
                    }
                    log.warn("Successfully repaired %d/%d implicit directories.", new Object[]{numRepaired, repairList.size()});
                }
                catch (IOException ioe) {
                    log.error("Failed to repair some missing directories.", (Throwable)ioe);
                }
            }
        }
        return objectInfos;
    }

    @VisibleForTesting
    static GoogleCloudStorageItemInfo createItemInfoForBucket(StorageResourceId resourceId, Bucket bucket) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"resourceId must not be null");
        Preconditions.checkArgument((bucket != null ? 1 : 0) != 0, (Object)"bucket must not be null");
        Preconditions.checkArgument((boolean)resourceId.isBucket(), (Object)String.format("resourceId must be a Bucket. resourceId: %s", resourceId));
        Preconditions.checkArgument((boolean)resourceId.getBucketName().equals(bucket.getName()), (Object)String.format("resourceId.getBucketName() must equal bucket.getName(): '%s' vs '%s'", resourceId.getBucketName(), bucket.getName()));
        return new GoogleCloudStorageItemInfo(resourceId, bucket.getTimeCreated().getValue(), 0L, bucket.getLocation(), bucket.getStorageClass());
    }

    @VisibleForTesting
    static GoogleCloudStorageItemInfo createItemInfoForStorageObject(StorageResourceId resourceId, StorageObject object) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"resourceId must not be null");
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"object must not be null");
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)String.format("resourceId must be a StorageObject. resourceId: %s", resourceId));
        Preconditions.checkArgument((boolean)resourceId.getBucketName().equals(object.getBucket()), (Object)String.format("resourceId.getBucketName() must equal object.getBucket(): '%s' vs '%s'", resourceId.getBucketName(), object.getBucket()));
        Preconditions.checkArgument((boolean)resourceId.getObjectName().equals(object.getName()), (Object)String.format("resourceId.getObjectName() must equal object.getName(): '%s' vs '%s'", resourceId.getObjectName(), object.getName()));
        Map decodedMetadata = object.getMetadata() == null ? null : Maps.transformValues((Map)object.getMetadata(), DECODE_METADATA_VALUES);
        return new GoogleCloudStorageItemInfo(resourceId, object.getUpdated().getValue(), object.getSize().longValue(), null, null, decodedMetadata, object.getGeneration(), object.getMetageneration());
    }

    @VisibleForTesting
    static GoogleCloudStorageItemInfo createItemInfoForNotFound(StorageResourceId resourceId) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"resourceId must not be null");
        return new GoogleCloudStorageItemInfo(resourceId, 0L, -1L, null, null);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        log.debug("getItemInfos(%s)", new Object[]{resourceIds.toString()});
        final HashMap<StorageResourceId, GoogleCloudStorageItemInfo> itemInfos = new HashMap<StorageResourceId, GoogleCloudStorageItemInfo>();
        final ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getMaxRequestsPerBatch());
        for (final StorageResourceId resourceId : resourceIds) {
            if (resourceId.isRoot()) {
                itemInfos.put(resourceId, GoogleCloudStorageItemInfo.ROOT_INFO);
                continue;
            }
            if (resourceId.isBucket()) {
                batchHelper.queue(this.gcs.buckets().get(resourceId.getBucketName()), new JsonBatchCallback<Bucket>(){

                    public void onSuccess(Bucket bucket, HttpHeaders responseHeaders) {
                        log.debug("getItemInfos: Successfully fetched bucket: %s for resourceId: %s", new Object[]{bucket, resourceId});
                        itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForBucket(resourceId, bucket));
                    }

                    public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                        if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(e)) {
                            log.debug("getItemInfos: bucket not found: %s", new Object[]{resourceId.getBucketName()});
                            itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForNotFound(resourceId));
                        } else {
                            innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(e.toString()), "Error getting Bucket: ", resourceId.getBucketName(), null));
                        }
                    }
                });
                continue;
            }
            final String bucketName = resourceId.getBucketName();
            final String objectName = resourceId.getObjectName();
            batchHelper.queue(this.gcs.objects().get(bucketName, objectName), new JsonBatchCallback<StorageObject>(){

                public void onSuccess(StorageObject obj, HttpHeaders responseHeaders) {
                    log.debug("getItemInfos: Successfully fetched object '%s' for resourceId '%s'", new Object[]{obj, resourceId});
                    itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, obj));
                }

                public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(e)) {
                        log.debug("getItemInfos: object not found: %s", new Object[]{resourceId});
                        itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForNotFound(resourceId));
                    } else {
                        innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(e.toString()), "Error getting StorageObject: ", bucketName, objectName));
                    }
                }
            });
        }
        batchHelper.flush();
        if (innerExceptions.size() > 0) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkState((boolean)itemInfos.containsKey(resourceId), (Object)String.format("Somehow missing resourceId '%s' from map: %s", resourceId, itemInfos));
            sortedItemInfos.add((GoogleCloudStorageItemInfo)itemInfos.get(resourceId));
        }
        Preconditions.checkState((sortedItemInfos.size() == resourceIds.size() ? 1 : 0) != 0, (Object)String.format("sortedItemInfos.size() (%d) != resourceIds.size() (%d). infos: %s, ids: %s", sortedItemInfos.size(), resourceIds.size(), sortedItemInfos, resourceIds));
        return sortedItemInfos;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        log.debug("updateItems(%s)", new Object[]{itemInfoList.toString()});
        final HashMap resultItemInfos = new HashMap();
        final ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getMaxRequestsPerBatch());
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkArgument((!itemInfo.getStorageResourceId().isBucket() && !itemInfo.getStorageResourceId().isRoot() ? 1 : 0) != 0, (Object)"Buckets and GCS Root resources are not supported for updateItems");
        }
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            final StorageResourceId resourceId = itemInfo.getStorageResourceId();
            final String bucketName = resourceId.getBucketName();
            final String objectName = resourceId.getObjectName();
            Map<String, byte[]> originalMetadata = itemInfo.getMetadata();
            Map rewrittenMetadata = Maps.transformValues(originalMetadata, ENCODE_METADATA_VALUES);
            Storage.Objects.Patch patch = this.gcs.objects().patch(bucketName, objectName, new StorageObject().setMetadata(rewrittenMetadata));
            batchHelper.queue(patch, new JsonBatchCallback<StorageObject>(){

                public void onSuccess(StorageObject obj, HttpHeaders responseHeaders) {
                    log.debug("updateItems: Successfully updated object '%s' for resourceId '%s'", new Object[]{obj, resourceId});
                    resultItemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, obj));
                }

                public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(e)) {
                        log.debug("updateItems: object not found: %s", new Object[]{resourceId});
                        resultItemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForNotFound(resourceId));
                    } else {
                        innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(e.toString()), "Error getting StorageObject: ", bucketName, objectName));
                    }
                }
            });
        }
        batchHelper.flush();
        if (innerExceptions.size() > 0) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkState((boolean)resultItemInfos.containsKey(itemInfo.getStorageResourceId()), (Object)String.format("Missing resourceId '%s' from map: %s", itemInfo.getStorageResourceId(), resultItemInfos));
            sortedItemInfos.add((GoogleCloudStorageItemInfo)resultItemInfos.get(itemInfo.getStorageResourceId()));
        }
        Preconditions.checkState((sortedItemInfos.size() == itemInfoList.size() ? 1 : 0) != 0, (Object)String.format("sortedItemInfos.size() (%d) != resourceIds.size() (%d). infos: %s, updateItemInfos: %s", sortedItemInfos.size(), itemInfoList.size(), sortedItemInfos, itemInfoList));
        return sortedItemInfos;
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        log.debug("getItemInfo(%s)", new Object[]{resourceId});
        if (resourceId.isRoot()) {
            return GoogleCloudStorageItemInfo.ROOT_INFO;
        }
        GoogleCloudStorageItemInfo itemInfo = null;
        if (resourceId.isBucket()) {
            Bucket bucket = this.getBucket(resourceId.getBucketName());
            if (bucket != null) {
                itemInfo = GoogleCloudStorageImpl.createItemInfoForBucket(resourceId, bucket);
            }
        } else {
            StorageObject object = this.getObject(resourceId);
            if (object != null) {
                itemInfo = GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, object);
            }
        }
        if (itemInfo == null) {
            itemInfo = GoogleCloudStorageImpl.createItemInfoForNotFound(resourceId);
        }
        log.debug("getItemInfo: %s", new Object[]{itemInfo});
        return itemInfo;
    }

    @Override
    public void close() {
        log.debug("close()", new Object[0]);
        this.threadPool.shutdown();
        this.manualBatchingThreadPool.shutdown();
    }

    private Bucket getBucket(String bucketName) throws IOException {
        log.debug("getBucket(%s)", new Object[]{bucketName});
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        Bucket bucket = null;
        Storage.Buckets.Get getBucket = this.gcs.buckets().get(bucketName);
        try {
            bucket = (Bucket)getBucket.execute();
        }
        catch (IOException e) {
            if (this.errorExtractor.itemNotFound(e)) {
                log.debug("getBucket(%s) : not found", new Object[]{bucketName});
            }
            log.debug(String.format("getBucket(%s) threw exception: ", bucketName), (Throwable)e);
            throw this.wrapException(e, "Error accessing", bucketName, null);
        }
        return bucket;
    }

    @VisibleForTesting
    IOException wrapException(IOException e, String message, String bucketName, String objectName) {
        String name;
        String string = String.valueOf(bucketName);
        String string2 = name = string.length() != 0 ? "bucket: ".concat(string) : new String("bucket: ");
        if (!Strings.isNullOrEmpty((String)objectName)) {
            String string3 = String.valueOf(name);
            String string4 = String.valueOf(String.valueOf(objectName));
            name = new StringBuilder(10 + string3.length() + string4.length()).append(string3).append(", object: ").append(string4).toString();
        }
        String fullMessage = String.format("%s: %s", message, name);
        return new IOException(fullMessage, e);
    }

    private StorageObject getObject(StorageResourceId resourceId) throws IOException {
        log.debug("getObject(%s)", new Object[]{resourceId});
        String string = String.valueOf(String.valueOf(resourceId));
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + string.length()).append("Expected full StorageObject id, got ").append(string).toString());
        String bucketName = resourceId.getBucketName();
        String objectName = resourceId.getObjectName();
        StorageObject object = null;
        Storage.Objects.Get getObject = this.gcs.objects().get(bucketName, objectName);
        try {
            object = (StorageObject)getObject.execute();
        }
        catch (IOException e) {
            if (this.errorExtractor.itemNotFound(e)) {
                log.debug("getObject(%s) : not found", new Object[]{resourceId});
            }
            log.debug(String.format("getObject(%s) threw exception: ", resourceId), (Throwable)e);
            throw this.wrapException(e, "Error accessing", bucketName, objectName);
        }
        return object;
    }

    @Override
    public void waitForBucketEmpty(String bucketName) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        int maxRetries = 20;
        int waitTime = 500;
        for (int i = 0; i < maxRetries; ++i) {
            List<String> objectNames = this.listObjectNames(bucketName, null, PATH_DELIMITER);
            if (objectNames.size() == 0) {
                return;
            }
            try {
                this.sleeper.sleep((long)waitTime);
                continue;
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
        String string = String.valueOf(bucketName);
        throw new IOException(string.length() != 0 ? "Internal error: bucket not empty: ".concat(string) : new String("Internal error: bucket not empty: "));
    }

    public static interface BackOffFactory {
        public static final BackOffFactory DEFAULT = new BackOffFactory(){

            @Override
            public BackOff newBackOff() {
                return new ExponentialBackOff();
            }
        };

        public BackOff newBackOff();
    }
}

