/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class GoogleCloudStorageItemInfo {
    public static final GoogleCloudStorageItemInfo ROOT_INFO = new GoogleCloudStorageItemInfo(StorageResourceId.ROOT, 0L, 0L, null, null);
    private static final Map<String, byte[]> EMPTY_METADATA = ImmutableMap.of();
    private final StorageResourceId resourceId;
    private final long creationTime;
    private final long size;
    private final String location;
    private final String storageClass;
    private final Map<String, byte[]> metadata;
    private final long contentGeneration;
    private final long metaGeneration;

    public GoogleCloudStorageItemInfo(StorageResourceId resourceId, long creationTime, long size, String location, String storageClass) {
        this(resourceId, creationTime, size, location, storageClass, (Map<String, byte[]>)ImmutableMap.of(), 0L, 0L);
    }

    public GoogleCloudStorageItemInfo(StorageResourceId resourceId, long creationTime, long size, String location, String storageClass, Map<String, byte[]> metadata, long contentGeneration, long metaGeneration) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"resourceId must not be null! Use StorageResourceId.ROOT to represent GCS root.");
        this.resourceId = resourceId;
        this.creationTime = creationTime;
        this.size = size;
        this.location = location;
        this.storageClass = storageClass;
        this.metadata = metadata == null ? EMPTY_METADATA : metadata;
        this.contentGeneration = contentGeneration;
        this.metaGeneration = metaGeneration;
    }

    public String getBucketName() {
        return this.resourceId.getBucketName();
    }

    public String getObjectName() {
        return this.resourceId.getObjectName();
    }

    public StorageResourceId getResourceId() {
        return this.resourceId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getSize() {
        return this.size;
    }

    public String getLocation() {
        return this.location;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public Map<String, byte[]> getMetadata() {
        return this.metadata;
    }

    public boolean isBucket() {
        return this.resourceId.isBucket();
    }

    public boolean isRoot() {
        return this.resourceId.isRoot();
    }

    public boolean exists() {
        return this.size >= 0L;
    }

    public long getContentGeneration() {
        return this.contentGeneration;
    }

    public long getMetaGeneration() {
        return this.metaGeneration;
    }

    public String toString() {
        if (this.exists()) {
            return String.format("%s: created on: %s", this.resourceId, new Date(this.creationTime).toString());
        }
        return String.format("%s: exists: no", this.resourceId.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof GoogleCloudStorageItemInfo) {
            GoogleCloudStorageItemInfo other = (GoogleCloudStorageItemInfo)obj;
            return this.resourceId.equals(other.resourceId) && this.creationTime == other.creationTime && this.size == other.size && Objects.equals(this.location, other.location) && Objects.equals(this.storageClass, other.storageClass) && this.metaGeneration == other.metaGeneration && this.contentGeneration == other.contentGeneration;
        }
        return false;
    }
}

