/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class GoogleCloudStorageOptions {
    public static final long MAX_LIST_ITEMS_PER_CALL_DEFAULT = 1024L;
    public static final boolean AUTO_REPAIR_IMPLICIT_DIRECTORIES_DEFAULT = true;
    public static final long MAX_REQUESTS_PER_BATCH_DEFAULT = 1000L;
    public static final boolean CREATE_EMPTY_MARKER_OBJECT_DEFAULT = false;
    private final boolean autoRepairImplicitDirectoriesEnabled;
    private final String projectId;
    private final String appName;
    private final AsyncWriteChannelOptions writeChannelOptions;
    private final long maxListItemsPerCall;
    private final long maxRequestsPerBatch;
    private final boolean createMarkerFile;

    public static Builder newBuilder() {
        return new Builder();
    }

    public GoogleCloudStorageOptions(boolean autoRepairImplicitDirectoriesEnabled, String projectId, String appName, long maxListItemsPerCall, long maxRequestsPerBatch, boolean createMarkerFile, AsyncWriteChannelOptions writeChannelOptions) {
        this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
        this.projectId = projectId;
        this.appName = appName;
        this.writeChannelOptions = writeChannelOptions;
        this.maxListItemsPerCall = maxListItemsPerCall;
        this.maxRequestsPerBatch = maxRequestsPerBatch;
        this.createMarkerFile = createMarkerFile;
    }

    public boolean isAutoRepairImplicitDirectoriesEnabled() {
        return this.autoRepairImplicitDirectoriesEnabled;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getAppName() {
        return this.appName;
    }

    public long getMaxListItemsPerCall() {
        return this.maxListItemsPerCall;
    }

    public AsyncWriteChannelOptions getWriteChannelOptions() {
        return this.writeChannelOptions;
    }

    public long getMaxRequestsPerBatch() {
        return this.maxRequestsPerBatch;
    }

    public boolean isMarkerFileCreationEnabled() {
        return this.createMarkerFile;
    }

    public void throwIfNotValid() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.projectId) ? 1 : 0) != 0, (Object)"projectId must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.appName) ? 1 : 0) != 0, (Object)"appName must not be null or empty");
    }

    public static class Builder {
        private boolean autoRepairImplicitDirectoriesEnabled = true;
        private String projectId = null;
        private String appName = null;
        private long maxListItemsPerCall = 1024L;
        private boolean createMarkerObjects = false;
        private long maxRequestsPerBatch = 1000L;
        private AsyncWriteChannelOptions.Builder writeChannelOptionsBuilder = new AsyncWriteChannelOptions.Builder();

        public Builder setAutoRepairImplicitDirectoriesEnabled(boolean autoRepairImplicitDirectoriesEnabled) {
            this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder setMaxListItemsPerCall(long maxListItemsPerCall) {
            this.maxListItemsPerCall = maxListItemsPerCall;
            return this;
        }

        public Builder setMaxRequestsPerBatch(long maxRequestsPerBatch) {
            this.maxRequestsPerBatch = maxRequestsPerBatch;
            return this;
        }

        public Builder setCreateMarkerObjects(boolean createMarkerObjects) {
            this.createMarkerObjects = createMarkerObjects;
            return this;
        }

        public Builder setWriteChannelOptionsBuilder(AsyncWriteChannelOptions.Builder builder) {
            this.writeChannelOptionsBuilder = builder;
            return this;
        }

        public AsyncWriteChannelOptions.Builder getWriteChannelOptionsBuilder() {
            return this.writeChannelOptionsBuilder;
        }

        public GoogleCloudStorageOptions build() {
            return new GoogleCloudStorageOptions(this.autoRepairImplicitDirectoriesEnabled, this.projectId, this.appName, this.maxListItemsPerCall, this.maxRequestsPerBatch, this.createMarkerObjects, this.writeChannelOptionsBuilder.build());
        }
    }
}

