/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.InputStreamContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.util.AbstractGoogleAsyncWriteChannel;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.ClientRequestHelper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class GoogleCloudStorageWriteChannel
extends AbstractGoogleAsyncWriteChannel<Storage.Objects.Insert, StorageObject> {
    private final Storage gcs;
    private final String bucketName;
    private final String objectName;
    private final ObjectWriteConditions writeConditions;
    private final Map<String, String> metadata;

    public GoogleCloudStorageWriteChannel(ExecutorService threadPool, Storage gcs, ClientRequestHelper<StorageObject> requestHelper, String bucketName, String objectName, AsyncWriteChannelOptions options, ObjectWriteConditions writeConditions, Map<String, String> objectMetadata) {
        super(threadPool, options);
        this.setClientRequestHelper(requestHelper);
        this.gcs = gcs;
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.writeConditions = writeConditions;
        this.metadata = objectMetadata;
    }

    public Storage.Objects.Insert createRequest(InputStreamContent inputStream) throws IOException {
        StorageObject object = new StorageObject().setName(this.objectName).setMetadata(this.metadata);
        Storage.Objects.Insert insert = this.gcs.objects().insert(this.bucketName, object, (AbstractInputStreamContent)inputStream);
        this.writeConditions.apply(insert);
        return insert;
    }
}

