/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.storage.StorageRequest;
import com.google.cloud.hadoop.util.LogUtil;
import com.google.common.base.Predicate;
import java.io.IOException;

public class OperationWithRetry<T extends StorageRequest<S>, S> {
    private static final LogUtil log = new LogUtil(OperationWithRetry.class);
    private final Sleeper sleeper;
    private final BackOff backOff;
    private final T request;
    private final Predicate<IOException> shouldRetryPredicate;

    public OperationWithRetry(Sleeper sleeper, BackOff backOff, T request, Predicate<IOException> shouldRetryPredicate) {
        this.sleeper = sleeper;
        this.backOff = backOff;
        this.request = request;
        this.shouldRetryPredicate = shouldRetryPredicate;
    }

    public S execute() throws IOException {
        while (true) {
            try {
                return (S)this.request.execute();
            }
            catch (IOException ioe) {
                long nextRetryBackoff;
                IOException lastException;
                if (this.shouldRetryPredicate.apply((Object)ioe)) {
                    log.debug("Retrying after catching exception", (Throwable)ioe);
                    lastException = ioe;
                    nextRetryBackoff = this.backOff.nextBackOffMillis();
                    try {
                        this.sleeper.sleep(nextRetryBackoff);
                    }
                    catch (InterruptedException ie) {
                        throw new IOException(ie);
                    }
                } else {
                    log.debug("Not retrying after catching exception", (Throwable)ioe);
                    throw ioe;
                }
                if (nextRetryBackoff != -1L) continue;
                log.debug("Exhausted retries. lastException was: ", (Throwable)lastException);
                throw lastException;
            }
            break;
        }
    }
}

