/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.Path;

public class GoogleHadoopFileSystem
extends GoogleHadoopFileSystemBase {
    private String rootBucket;

    public GoogleHadoopFileSystem() {
    }

    public GoogleHadoopFileSystem(GoogleCloudStorageFileSystem gcsfs) {
        super(gcsfs);
    }

    @Override
    @VisibleForTesting
    public void configureBuckets(String systemBucketName, boolean createConfiguredBuckets) throws IOException {
        super.configureBuckets(systemBucketName, createConfiguredBuckets);
        this.rootBucket = this.initUri.getAuthority();
        if (this.rootBucket != null) {
            this.gcsfs.getPathCodec().getPath(this.rootBucket, null, true);
        } else if (this.systemBucket != null) {
            LOG.warn("GHFS.configureBuckets: Warning. No GCS bucket provided. Falling back on deprecated fs.gs.system.bucket.");
            this.rootBucket = this.systemBucket;
        } else {
            String msg = String.format("No bucket specified in GCS URI: %s", this.initUri);
            throw new IllegalArgumentException(msg);
        }
        LOG.debug("GHFS.configureBuckets: GoogleHadoopFileSystem root in bucket: ", (Object)this.rootBucket);
    }

    @Override
    protected void checkPath(Path path) {
        super.checkPath(path);
        URI uri = path.toUri();
        String bucket = uri.getAuthority();
        if (bucket == null || bucket.equals(this.rootBucket)) {
            return;
        }
        String msg = String.format("Wrong bucket: %s, in path: %s, expected bucket: %s", bucket, path, this.rootBucket);
        throw new IllegalArgumentException(msg);
    }

    @VisibleForTesting
    String getRootBucketName() {
        return this.rootBucket;
    }

    @Override
    protected String getHomeDirectorySubpath() {
        return "user/" + System.getProperty("user.name");
    }

    @Override
    public Path getHadoopPath(URI gcsPath) {
        LOG.debug("GHFS.getHadoopPath: {}", (Object)gcsPath);
        if (gcsPath.equals(this.getGcsPath(this.getFileSystemRoot()))) {
            return this.getFileSystemRoot();
        }
        StorageResourceId resourceId = this.gcsfs.getPathCodec().validatePathAndGetId(gcsPath, true);
        if (resourceId.isRoot()) {
            throw new IllegalArgumentException(String.format("Missing authority in gcsPath '%s'", gcsPath.toString()));
        }
        if (!resourceId.getBucketName().equals(this.rootBucket)) {
            throw new IllegalArgumentException(String.format("Authority of URI '%s' doesn't match root bucket '%s'", resourceId.getBucketName(), this.rootBucket));
        }
        Path hadoopPath = new Path(this.getScheme() + "://" + this.rootBucket + '/' + resourceId.getObjectName());
        LOG.debug("GHFS.getHadoopPath: {} -> {}", (Object)gcsPath, (Object)hadoopPath);
        return hadoopPath;
    }

    @Override
    public URI getGcsPath(Path hadoopPath) {
        LOG.debug("GHFS.getGcsPath: {}", (Object)hadoopPath);
        Path resolvedPath = this.makeQualified(hadoopPath);
        String objectName = resolvedPath.toUri().getPath();
        if (objectName != null && resolvedPath.isAbsolute()) {
            objectName = objectName.substring(1);
        }
        URI gcsPath = this.gcsfs.getPathCodec().getPath(this.rootBucket, objectName, true);
        LOG.debug("GHFS.getGcsPath: {} -> {}", (Object)hadoopPath, (Object)gcsPath);
        return gcsPath;
    }

    @Override
    public String getScheme() {
        return "gs";
    }

    @Override
    public Path getFileSystemRoot() {
        return new Path(this.getScheme() + "://" + this.rootBucket + '/');
    }

    @Override
    public Path getDefaultWorkingDirectory() {
        return this.getFileSystemRoot();
    }
}

