/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.fs.gcs.FileSystemDescriptor;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFSInputStream;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopOutputStream;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopSyncableOutputStream;
import com.google.cloud.hadoop.fs.gcs.ListHelperGoogleHadoopFileSystem;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.DirectoryListCache;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.PathCodec;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.util.EntriesCredentialConfiguration;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.HadoopVersionInfo;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.PropertyUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.DirectoryNotEmptyException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobPattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GoogleHadoopFileSystemBase
extends FileSystem
implements FileSystemDescriptor {
    public static final Logger LOG = LoggerFactory.getLogger(GoogleHadoopFileSystemBase.class);
    public static final short REPLICATION_FACTOR_DEFAULT = 3;
    private static final String USER_NAME = System.getProperty("user.name");
    private static final Splitter CONFIGURATION_SPLITTER = Splitter.on((char)',');
    public static final String PERMISSIONS_TO_REPORT_KEY = "fs.gs.reported.permissions";
    public static final String PERMISSIONS_TO_REPORT_DEFAULT = "700";
    public static final String BUFFERSIZE_KEY = "fs.gs.io.buffersize";
    public static final int BUFFERSIZE_DEFAULT = 0x800000;
    public static final String WRITE_BUFFERSIZE_KEY = "fs.gs.io.buffersize.write";
    public static final int WRITE_BUFFERSIZE_DEFAULT = 0x4000000;
    public static final String BLOCK_SIZE_KEY = "fs.gs.block.size";
    public static final int BLOCK_SIZE_DEFAULT = 0x4000000;
    public static final String AUTHENTICATION_PREFIX = "fs.gs";
    public static final String ENABLE_GCE_SERVICE_ACCOUNT_AUTH_KEY = "fs.gs.enable.service.account.auth";
    public static final String SERVICE_ACCOUNT_AUTH_EMAIL_KEY = "fs.gs.service.account.auth.email";
    public static final String SERVICE_ACCOUNT_AUTH_KEYFILE_KEY = "fs.gs.service.account.auth.keyfile";
    public static final String GCS_PROJECT_ID_KEY = "fs.gs.project.id";
    public static final String GCS_CLIENT_ID_KEY = "fs.gs.client.id";
    public static final String GCS_CLIENT_SECRET_KEY = "fs.gs.client.secret";
    public static final String GCS_SYSTEM_BUCKET_KEY = "fs.gs.system.bucket";
    public static final String GCS_CREATE_SYSTEM_BUCKET_KEY = "fs.gs.system.bucket.create";
    public static final boolean GCS_CREATE_SYSTEM_BUCKET_DEFAULT = true;
    public static final String GCS_WORKING_DIRECTORY_KEY = "fs.gs.working.dir";
    public static final String GCS_FILE_SIZE_LIMIT_250GB = "fs.gs.file.size.limit.250gb";
    public static final boolean GCS_FILE_SIZE_LIMIT_250GB_DEFAULT = false;
    public static final String GCS_ENABLE_METADATA_CACHE_KEY = "fs.gs.metadata.cache.enable";
    public static final boolean GCS_ENABLE_METADATA_CACHE_DEFAULT = true;
    public static final String GCS_ENABLE_PERFORMANCE_CACHE_KEY = "fs.gs.performance.cache.enable";
    public static final boolean GCS_ENABLE_PERFORMANCE_CACHE_DEFAULT = false;
    public static final String GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS_KEY = "fs.gs.performance.cache.max.entry.age.ms";
    public static final long GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS_DEFAULT = 3000L;
    public static final String GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE_KEY = "fs.gs.performance.cache.list.caching.enable";
    public static final boolean GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE_DEFAULT = true;
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_KEY = "fs.gs.parent.timestamp.update.enable";
    public static final boolean GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_DEFAULT = true;
    public static final String GCS_METADATA_CACHE_TYPE_KEY = "fs.gs.metadata.cache.type";
    public static final String GCS_METADATA_CACHE_TYPE_DEFAULT = "IN_MEMORY";
    public static final String GCS_METADATA_CACHE_DIRECTORY_KEY = "fs.gs.metadata.cache.directory";
    public static final String GCS_METADATA_CACHE_DIRECTORY_DEFAULT = "/tmp/gcs_connector_metadata_cache";
    public static final String GCS_METADATA_CACHE_MAX_ENTRY_AGE_KEY = "fs.gs.metadata.cache.max.age.entry.ms";
    public static final long GCS_METADATA_CACHE_MAX_ENTRY_AGE_DEFAULT = 14400000L;
    public static final String GCS_METADATA_CACHE_MAX_INFO_AGE_KEY = "fs.gs.metadata.cache.max.age.info.ms";
    public static final long GCS_METADATA_CACHE_MAX_INFO_AGE_DEFAULT = 10000L;
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_KEY = "fs.gs.parent.timestamp.update.substrings.excludes";
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT = "/";
    public static final String MR_JOB_HISTORY_INTERMEDIATE_DONE_DIR_KEY = "mapreduce.jobhistory.intermediate-done-dir";
    public static final String MR_JOB_HISTORY_DONE_DIR_KEY = "mapreduce.jobhistory.done-dir";
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_KEY = "fs.gs.parent.timestamp.update.substrings.includes";
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_DEFAULT = String.format("${%s},${%s}", "mapreduce.jobhistory.intermediate-done-dir", "mapreduce.jobhistory.done-dir");
    public static final String GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_KEY = "fs.gs.implicit.dir.repair.enable";
    public static final boolean GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_DEFAULT = true;
    public static final String PATH_CODEC_KEY = "fs.gs.path.encoding";
    public static final String PATH_CODEC_USE_URI_ENCODING = "uri-path";
    public static final String PATH_CODEC_USE_LEGACY_ENCODING = "legacy";
    public static final String PATH_CODEC_DEFAULT = "legacy";
    private boolean enableAutoRepairImplicitDirectories = true;
    public static final String GCS_ENABLE_INFER_IMPLICIT_DIRECTORIES_KEY = "fs.gs.implicit.dir.infer.enable";
    public static final boolean GCS_ENABLE_INFER_IMPLICIT_DIRECTORIES_DEFAULT = true;
    private boolean enableInferImplicitDirectories = true;
    public static final String GCS_ENABLE_FLAT_GLOB_KEY = "fs.gs.glob.flatlist.enable";
    public static final boolean GCS_ENABLE_FLAT_GLOB_DEFAULT = true;
    public static final String GCS_ENABLE_MARKER_FILE_CREATION_KEY = "fs.gs.create.marker.files.enable";
    public static final boolean GCS_ENABLE_MARKER_FILE_CREATION_DEFAULT = false;
    public static final String GCS_MAX_LIST_ITEMS_PER_CALL = "fs.gs.list.max.items.per.call";
    public static final long GCS_MAX_LIST_ITEMS_PER_CALL_DEFAULT = 1024L;
    public static final String GCS_PROXY_ADDRESS_KEY = "fs.gs.proxy.address";
    public static final String GCS_PROXY_ADDRESS_DEFAULT = EntriesCredentialConfiguration.PROXY_ADDRESS_DEFAULT;
    public static final String GCS_HTTP_TRANSPORT_KEY = "fs.gs.http.transport.type";
    public static final String GCS_HTTP_TRANSPORT_DEFAULT = EntriesCredentialConfiguration.PROXY_ADDRESS_DEFAULT;
    public static final String GCS_APPLICATION_NAME_SUFFIX_KEY = "fs.gs.application.name.suffix";
    public static final String GCS_APPLICATION_NAME_SUFFIX_DEFAULT = "";
    public static final String GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE_KEY = "fs.gs.max.wait.for.empty.object.creation.ms";
    public static final int GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE_DEFAULT = 3000;
    public static final String GCS_OUTPUTSTREAM_TYPE_KEY = "fs.gs.outputstream.type";
    public static final String GCS_OUTPUTSTREAM_TYPE_DEFAULT = "BASIC";
    public static final String GCS_INPUTSTREAM_INTERNALBUFFER_ENABLE_KEY = "fs.gs.inputstream.internalbuffer.enable";
    public static final boolean GCS_INPUTSTREAM_INTERNALBUFFER_ENABLE_DEFAULT = false;
    public static final String GCS_INPUTSTREAM_SUPPORT_CONTENT_ENCODING_ENABLE_KEY = "fs.gs.inputstream.support.content.encoding.enable";
    public static final boolean GCS_INPUTSTREAM_SUPPORT_CONTENT_ENCODING_ENABLE_DEFAULT = true;
    public static final String GCS_INPUTSTREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE_KEY = "fs.gs.inputstream.fast.fail.on.not.found.enable";
    public static final boolean GCS_INPUTSTREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE_DEFAULT = true;
    public static final String GCS_INPUTSTREAM_INPLACE_SEEK_LIMIT_KEY = "fs.gs.inputstream.inplace.seek.limit";
    public static final long GCS_INPUTSTREAM_INPLACE_SEEK_LIMIT_DEFAULT = 0x800000L;
    public static final String GCE_BUCKET_DELETE_ENABLE_KEY = "fs.gs.bucket.delete.enable";
    public static final boolean GCE_BUCKET_DELETE_ENABLE_DEFAULT = false;
    public static final PathFilter DEFAULT_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            return true;
        }
    };
    public static final String PROPERTIES_FILE = "gcs.properties";
    public static final String VERSION_PROPERTY = "gcs.connector.version";
    public static final String UNKNOWN_VERSION = "0.0.0";
    public static final String VERSION = PropertyUtil.getPropertyOrDefault(GoogleHadoopFileSystemBase.class, (String)"gcs.properties", (String)"gcs.connector.version", (String)"0.0.0");
    public static final String GHFS_ID;
    private boolean enableFlatGlob = true;
    protected URI initUri;
    @Deprecated
    protected String systemBucket;
    protected GoogleCloudStorageFileSystem gcsfs;
    private Path workingDirectory;
    private int bufferSizeOverride = 0x800000;
    protected long defaultBlockSize = 0x4000000L;
    private FsPermission reportedPermissions;
    protected final ImmutableMap<Counter, AtomicLong> counters = this.createCounterMap();
    protected ListStatusFileNotFoundBehavior listStatusFileNotFoundBehavior = ListStatusFileNotFoundBehavior.get();

    protected ImmutableMap<Counter, AtomicLong> createCounterMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Counter counter : Counter.values()) {
            builder.put((Object)counter, (Object)new AtomicLong());
        }
        return builder.build();
    }

    @VisibleForTesting
    protected void setListStatusFileNotFoundBehavior(ListStatusFileNotFoundBehavior behavior) {
        this.listStatusFileNotFoundBehavior = behavior;
    }

    public GoogleHadoopFileSystemBase() {
    }

    public GoogleHadoopFileSystemBase(GoogleCloudStorageFileSystem gcsfs) {
        Preconditions.checkArgument((gcsfs != null ? 1 : 0) != 0, (Object)"gcsfs must not be null");
        this.gcsfs = gcsfs;
    }

    protected abstract String getHomeDirectorySubpath();

    public abstract Path getHadoopPath(URI var1);

    public abstract URI getGcsPath(Path var1);

    public abstract Path getDefaultWorkingDirectory();

    @Override
    public abstract Path getFileSystemRoot();

    @Override
    public abstract String getScheme();

    @Override
    @Deprecated
    public String getHadoopScheme() {
        return this.getScheme();
    }

    public Path makeQualified(Path path) {
        LOG.debug("GHFS.makeQualified: path: {}", (Object)path);
        Path qualifiedPath = super.makeQualified(path);
        URI uri = qualifiedPath.toUri();
        Preconditions.checkState((GCS_APPLICATION_NAME_SUFFIX_DEFAULT.equals(uri.getPath()) || qualifiedPath.isAbsolute() ? 1 : 0) != 0, (String)"Path '%s' must be fully qualified.", (Object[])new Object[]{qualifiedPath});
        StringBuilder sb = new StringBuilder(uri.getPath());
        while (sb.indexOf("/../") == 0) {
            sb.delete(0, 3);
        }
        String strippedPath = sb.toString();
        if (strippedPath.equals("/..") || strippedPath.equals(GCS_APPLICATION_NAME_SUFFIX_DEFAULT)) {
            strippedPath = GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT;
        }
        Path result = new Path(uri.getScheme(), uri.getAuthority(), strippedPath);
        LOG.debug("GHFS.makeQualified:=> {}", (Object)result);
        return result;
    }

    protected void checkPath(Path path) {
        URI uri = path.toUri();
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equalsIgnoreCase(this.getScheme())) {
            return;
        }
        String msg = String.format("Wrong FS scheme: %s, in path: %s, expected scheme: %s", scheme, path, this.getScheme());
        throw new IllegalArgumentException(msg);
    }

    public void initialize(URI path, Configuration config) throws IOException {
        this.initialize(path, config, true);
    }

    public void initialize(URI path, Configuration config, boolean initSuperclass) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path must not be null");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config must not be null");
        Preconditions.checkArgument((path.getScheme() != null ? 1 : 0) != 0, (Object)"scheme of path must not be null");
        if (!path.getScheme().equals(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme not supported: " + path);
        }
        this.initUri = path;
        LOG.debug("GHFS.initialize: {}", (Object)path);
        if (initSuperclass) {
            super.initialize(path, config);
        } else {
            LOG.debug("Initializing 'statistics' as an instance not attached to the static FileSystem map");
            this.statistics = new FileSystem.Statistics(this.getScheme());
        }
        this.configure(config);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.INIT);
        this.increment(Counter.INIT_TIME, duration);
    }

    public URI getUri() {
        return this.getFileSystemRoot().toUri();
    }

    protected int getDefaultPort() {
        LOG.debug("GHFS.getDefaultPort:");
        int result = -1;
        LOG.debug("GHFS.getDefaultPort:=> {}", (Object)result);
        return result;
    }

    public FSDataInputStream open(Path hadoopPath, int bufferSize) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (String)"bufferSize must be a positive integer: %s", (Object[])new Object[]{bufferSize});
        this.checkOpen();
        LOG.debug("GHFS.open: {}, bufferSize: {} (override: {})", new Object[]{hadoopPath, bufferSize, this.bufferSizeOverride});
        bufferSize = this.bufferSizeOverride;
        URI gcsPath = this.getGcsPath(hadoopPath);
        GoogleHadoopFSInputStream in = new GoogleHadoopFSInputStream(this, gcsPath, bufferSize, this.statistics);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.OPEN);
        this.increment(Counter.OPEN_TIME, duration);
        return new FSDataInputStream((InputStream)((Object)in));
    }

    public FSDataOutputStream create(Path hadoopPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        OutputStream out;
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (String)"bufferSize must be a positive integer: %s", (Object[])new Object[]{bufferSize});
        Preconditions.checkArgument((replication > 0 ? 1 : 0) != 0, (String)"replication must be a positive integer: %s", (Object[])new Object[]{replication});
        Preconditions.checkArgument((blockSize > 0L ? 1 : 0) != 0, (String)"blockSize must be a positive integer: %s", (Object[])new Object[]{blockSize});
        this.checkOpen();
        LOG.debug("GHFS.create: {}, overwrite: {}, bufferSize: {} (override: {})", new Object[]{hadoopPath, overwrite, bufferSize, this.bufferSizeOverride});
        bufferSize = this.bufferSizeOverride;
        URI gcsPath = this.getGcsPath(hadoopPath);
        OutputStreamType type = OutputStreamType.valueOf(this.getConf().get(GCS_OUTPUTSTREAM_TYPE_KEY, GCS_OUTPUTSTREAM_TYPE_DEFAULT));
        switch (type) {
            case BASIC: {
                out = new GoogleHadoopOutputStream(this, gcsPath, bufferSize, this.statistics, new CreateFileOptions(overwrite));
                break;
            }
            case SYNCABLE_COMPOSITE: {
                out = new GoogleHadoopSyncableOutputStream(this, gcsPath, bufferSize, this.statistics, new CreateFileOptions(overwrite));
                break;
            }
            default: {
                throw new IOException(String.format("Unsupported output stream type given for key '%s': '%s'", new Object[]{GCS_OUTPUTSTREAM_TYPE_KEY, type}));
            }
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.CREATE);
        this.increment(Counter.CREATE_TIME, duration);
        return new FSDataOutputStream(out);
    }

    public FSDataOutputStream append(Path hadoopPath, int bufferSize, Progressable progress) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (String)"bufferSize must be a positive integer: %s", (Object[])new Object[]{bufferSize});
        LOG.debug("GHFS.append: {}, bufferSize: {} (override: {})", new Object[]{hadoopPath, bufferSize, this.bufferSizeOverride});
        bufferSize = this.bufferSizeOverride;
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.APPEND);
        this.increment(Counter.APPEND_TIME, duration);
        throw new IOException("The append operation is not supported.");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        if (src.makeQualified((FileSystem)this).equals((Object)this.getFileSystemRoot())) {
            LOG.debug("GHFS.rename: src is root: '{}'", (Object)src);
            return false;
        }
        long startTime = System.nanoTime();
        Preconditions.checkArgument((src != null ? 1 : 0) != 0, (Object)"src must not be null");
        Preconditions.checkArgument((dst != null ? 1 : 0) != 0, (Object)"dst must not be null");
        this.checkOpen();
        try {
            LOG.debug("GHFS.rename: {} -> {}", (Object)src, (Object)dst);
            URI srcPath = this.getGcsPath(src);
            URI dstPath = this.getGcsPath(dst);
            this.gcsfs.rename(srcPath, dstPath);
        }
        catch (IOException e) {
            LOG.debug("GHFS.rename", (Throwable)e);
            return false;
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.RENAME);
        this.increment(Counter.RENAME_TIME, duration);
        return true;
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    public boolean delete(Path hadoopPath, boolean recursive) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        LOG.debug("GHFS.delete: {}, recursive: {}", (Object)hadoopPath, (Object)recursive);
        URI gcsPath = this.getGcsPath(hadoopPath);
        try {
            this.gcsfs.delete(gcsPath, recursive);
        }
        catch (DirectoryNotEmptyException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.debug("GHFS.delete", (Throwable)e);
            return false;
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.DELETE);
        this.increment(Counter.DELETE_TIME, duration);
        return true;
    }

    public FileStatus[] listStatus(Path hadoopPath) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        LOG.debug("GHFS.listStatus: {}", (Object)hadoopPath);
        URI gcsPath = this.getGcsPath(hadoopPath);
        ArrayList<FileStatus> status = new ArrayList<FileStatus>();
        try {
            List fileInfos = this.gcsfs.listFileInfo(gcsPath, this.enableAutoRepairImplicitDirectories);
            for (FileInfo fileInfo : fileInfos) {
                status.add(this.getFileStatus(fileInfo));
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug("Got fnfe: ", (Throwable)fnfe);
            return this.listStatusFileNotFoundBehavior.handle(gcsPath.toString());
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.LIST_STATUS);
        this.increment(Counter.LIST_STATUS_TIME, duration);
        return status.toArray(new FileStatus[0]);
    }

    public void setWorkingDirectory(Path hadoopPath) {
        Path newPath;
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        LOG.debug("GHFS.setWorkingDirectory: {}", (Object)hadoopPath);
        URI gcsPath = this.getGcsPath(hadoopPath);
        gcsPath = FileInfo.convertToDirectoryPath((PathCodec)this.gcsfs.getPathCodec(), (URI)gcsPath);
        this.workingDirectory = newPath = this.getHadoopPath(gcsPath);
        LOG.debug("GHFS.setWorkingDirectory: => {}", (Object)this.workingDirectory);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.SET_WD);
        this.increment(Counter.SET_WD_TIME, duration);
    }

    public Path getWorkingDirectory() {
        LOG.debug("GHFS.getWorkingDirectory: {}", (Object)this.workingDirectory);
        return this.workingDirectory;
    }

    public boolean mkdirs(Path hadoopPath, FsPermission permission) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        LOG.debug("GHFS.mkdirs: {}, perm: {}", (Object)hadoopPath, (Object)permission);
        URI gcsPath = this.getGcsPath(hadoopPath);
        try {
            this.gcsfs.mkdirs(gcsPath);
        }
        catch (java.nio.file.FileAlreadyExistsException faee) {
            throw (FileAlreadyExistsException)new FileAlreadyExistsException(faee.getMessage()).initCause((Throwable)faee);
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.MKDIRS);
        this.increment(Counter.MKDIRS_TIME, duration);
        return true;
    }

    public short getDefaultReplication() {
        return 3;
    }

    public FileStatus getFileStatus(Path hadoopPath) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        LOG.debug("GHFS.getFileStatus: {}", (Object)hadoopPath);
        URI gcsPath = this.getGcsPath(hadoopPath);
        FileInfo fileInfo = this.gcsfs.getFileInfo(gcsPath);
        if (!fileInfo.exists()) {
            LOG.debug("GHFS.getFileStatus: not found: {}", (Object)gcsPath);
            String msg = fileInfo.isDirectory() ? "Directory not found : " : "File not found : ";
            msg = msg + hadoopPath.toString();
            throw new FileNotFoundException(msg);
        }
        FileStatus status = this.getFileStatus(fileInfo);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.GET_FILE_STATUS);
        this.increment(Counter.GET_FILE_STATUS_TIME, duration);
        return status;
    }

    @VisibleForTesting
    boolean shouldUseFlatGlob(Path fixedPath) {
        if (!this.enableFlatGlob) {
            return false;
        }
        if (!this.getUri().getScheme().equals("gs")) {
            LOG.debug("Flat glob is on, but doesn't work for scheme '{}'; usig default behavior.", (Object)this.getUri().getScheme());
            return false;
        }
        GlobPattern fullPattern = new GlobPattern(fixedPath.toString());
        if (!fullPattern.hasWildcard()) {
            LOG.debug("Flat glob is on, but Path '{}' has no wildcard; using default behavior.", (Object)fixedPath);
            return false;
        }
        if (Strings.isNullOrEmpty((String)fixedPath.toUri().getAuthority())) {
            LOG.info("Flat glob is on, but Path '{}' has a empty authority, using default behavior.", (Object)fixedPath);
            return false;
        }
        GlobPattern authorityPattern = new GlobPattern(fixedPath.toUri().getAuthority());
        if (authorityPattern.hasWildcard()) {
            LOG.info("Flat glob is on, but Path '{}' has a wildcard authority, using default behavior.", (Object)fixedPath);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    String trimToPrefixWithoutGlob(String path) {
        char[] wildcardChars = "*?{[".toCharArray();
        int trimIndex = path.length();
        for (char wildcard : wildcardChars) {
            int wildcardIndex = path.indexOf(wildcard);
            if (wildcardIndex < 0 || wildcardIndex >= trimIndex) continue;
            trimIndex = wildcardIndex;
        }
        return path.substring(0, trimIndex);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.globStatus(pathPattern, DEFAULT_FILTER);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.checkOpen();
        LOG.debug("GHFS.globStatus: {}", (Object)pathPattern);
        Path encodedPath = new Path(pathPattern.toUri().toString());
        Path fixedPath = this.getHadoopPath(this.getGcsPath(encodedPath));
        fixedPath = new Path(URI.create(fixedPath.toString()));
        LOG.debug("GHFS.globStatus fixedPath: {} => {}", (Object)pathPattern, (Object)fixedPath);
        if (this.shouldUseFlatGlob(fixedPath)) {
            String pathString = fixedPath.toString();
            String prefixString = this.trimToPrefixWithoutGlob(pathString);
            Path prefixPath = new Path(prefixString);
            URI prefixUri = this.getGcsPath(prefixPath);
            if (prefixString.endsWith(GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT) && !prefixPath.toString().endsWith(GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT)) {
                prefixUri = FileInfo.convertToDirectoryPath((PathCodec)this.gcsfs.getPathCodec(), (URI)prefixUri);
            }
            LOG.debug("Listing everything with prefix '{}'", (Object)prefixUri);
            List fileInfos = this.gcsfs.listAllFileInfoForPrefix(prefixUri);
            if (fileInfos.isEmpty()) {
                return super.globStatus(fixedPath, filter);
            }
            GoogleHadoopFileSystem helperFileSystem = ListHelperGoogleHadoopFileSystem.createInstance(this.gcsfs, fileInfos);
            FileStatus[] returnList = helperFileSystem.globStatus(pathPattern, filter);
            if (this.enableAutoRepairImplicitDirectories) {
                ArrayList<URI> toRepair = new ArrayList<URI>();
                for (FileStatus status : returnList) {
                    if (!status.isDir() || status.getModificationTime() != 0L) continue;
                    toRepair.add(this.getGcsPath(status.getPath()));
                }
                if (!toRepair.isEmpty()) {
                    LOG.warn("Discovered {} implicit directories to repair within return values.", (Object)toRepair.size());
                    this.gcsfs.repairDirs(toRepair);
                }
            }
            return returnList;
        }
        FileStatus[] ret = super.globStatus(fixedPath, filter);
        if (ret == null && this.enableAutoRepairImplicitDirectories) {
            LOG.debug("GHFS.globStatus returned null for '{}', attempting possible repair.", (Object)pathPattern);
            if (this.gcsfs.repairPossibleImplicitDirectory(this.getGcsPath(fixedPath))) {
                LOG.warn("Success repairing '{}', re-globbing.", (Object)pathPattern);
                ret = super.globStatus(fixedPath, filter);
            }
        }
        return ret;
    }

    public Path getHomeDirectory() {
        Path result = new Path(this.getFileSystemRoot(), this.getHomeDirectorySubpath());
        LOG.debug("GHFS.getHomeDirectory:=> {}", (Object)result);
        return result;
    }

    private FileStatus getFileStatus(FileInfo fileInfo) {
        FileStatus status = new FileStatus(fileInfo.getSize(), fileInfo.isDirectory(), 3, this.defaultBlockSize, fileInfo.getModificationTime(), fileInfo.getModificationTime(), this.reportedPermissions, USER_NAME, USER_NAME, this.getHadoopPath(fileInfo.getPath()));
        LOG.debug("GHFS.getFileStatus: {} => {}", (Object)fileInfo.getPath(), (Object)GoogleHadoopFileSystemBase.fileStatusToString(status));
        return status;
    }

    private static String fileStatusToString(FileStatus stat) {
        assert (stat != null);
        return String.format("path: %s, isDir: %s, len: %d, owner: %s", stat.getPath().toString(), stat.isDir(), stat.getLen(), stat.getOwner());
    }

    @VisibleForTesting
    int getBufferSizeOverride() {
        return this.bufferSizeOverride;
    }

    @Deprecated
    @VisibleForTesting
    String getSystemBucketName() {
        return this.systemBucket;
    }

    public String getCanonicalServiceName() {
        LOG.debug("GHFS.getCanonicalServiceName:");
        LOG.debug("GHFS.getCanonicalServiceName:=> null");
        return null;
    }

    public GoogleCloudStorageFileSystem getGcsFs() {
        return this.gcsfs;
    }

    void increment(Counter key) {
        this.increment(key, 1L);
    }

    void increment(Counter key, long value) {
        ((AtomicLong)this.counters.get((Object)key)).addAndGet(value);
    }

    @VisibleForTesting
    String countersToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        double numNanoSecPerSec = TimeUnit.SECONDS.toNanos(1L);
        String timeSuffix = "_TIME";
        for (Counter c : Counter.values()) {
            String name = c.toString();
            if (name.endsWith(timeSuffix)) continue;
            long count = ((AtomicLong)this.counters.get((Object)c)).get();
            sb.append(String.format("%20s = %d calls\n", name, count));
            String timeCounterName = name + timeSuffix;
            double totalTime = (double)((AtomicLong)this.counters.get((Object)Enum.valueOf(Counter.class, timeCounterName))).get() / numNanoSecPerSec;
            sb.append(String.format("%20s = %.2f sec\n", timeCounterName, totalTime));
            String avgName = name + " avg.";
            double avg = totalTime / (double)count;
            sb.append(String.format("%20s = %.2f sec / call\n\n", avgName, avg));
        }
        return sb.toString();
    }

    private void logCounters() {
        LOG.debug(this.countersToString());
    }

    private static void copyIfNotPresent(Configuration config, String deprecatedKey, String newKey) {
        String deprecatedValue = config.get(deprecatedKey);
        if (config.get(newKey) == null && deprecatedValue != null) {
            LOG.warn("Key {} is deprecated. Copying the value of key {} to new key {}", new Object[]{deprecatedKey, deprecatedKey, newKey});
            config.set(newKey, deprecatedValue);
        }
    }

    private static void copyDeprecatedConfigurationOptions(Configuration config) {
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, ENABLE_GCE_SERVICE_ACCOUNT_AUTH_KEY, "fs.gs.auth.service.account.enable");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, SERVICE_ACCOUNT_AUTH_KEYFILE_KEY, "fs.gs.auth.service.account.keyfile");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, SERVICE_ACCOUNT_AUTH_EMAIL_KEY, "fs.gs.auth.service.account.email");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, GCS_CLIENT_ID_KEY, "fs.gs.auth.client.id");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, GCS_CLIENT_SECRET_KEY, "fs.gs.auth.client.secret");
        String oauthClientFileKey = "fs.gs.auth.client.file";
        if (config.get(oauthClientFileKey) == null) {
            config.set(oauthClientFileKey, System.getProperty("user.home") + "/.credentials/storage.json");
        }
    }

    private synchronized void configure(Configuration config) throws IOException {
        Path newWorkingDirectory;
        LOG.debug("GHFS.configure");
        LOG.debug("GHFS_ID = {}", (Object)GHFS_ID);
        if (this.gcsfs == null) {
            PathCodec pathCodec;
            Credential credential;
            GoogleHadoopFileSystemBase.copyDeprecatedConfigurationOptions(config);
            try {
                credential = ((HadoopCredentialConfiguration)((HadoopCredentialConfiguration.Builder)HadoopCredentialConfiguration.newBuilder().withConfiguration(config).withOverridePrefix(AUTHENTICATION_PREFIX)).build()).getCredential((List)CredentialFactory.GCS_SCOPES);
            }
            catch (GeneralSecurityException gse) {
                throw new IOException(gse);
            }
            GoogleCloudStorageFileSystemOptions.Builder optionsBuilder = this.createOptionsBuilderFromConfig(config);
            String specifiedPathCodec = config.get(PATH_CODEC_KEY, "legacy").toLowerCase();
            LOG.debug("{} = {}", (Object)PATH_CODEC_KEY, (Object)specifiedPathCodec);
            if (specifiedPathCodec.equals("legacy")) {
                pathCodec = GoogleCloudStorageFileSystem.LEGACY_PATH_CODEC;
            } else if (specifiedPathCodec.equals(PATH_CODEC_USE_URI_ENCODING)) {
                pathCodec = GoogleCloudStorageFileSystem.URI_ENCODED_PATH_CODEC;
            } else {
                pathCodec = GoogleCloudStorageFileSystem.LEGACY_PATH_CODEC;
                LOG.warn("Unknwon path codec specified {}. Using default / legacy.", (Object)specifiedPathCodec);
            }
            optionsBuilder.setPathCodec(pathCodec);
            this.gcsfs = new GoogleCloudStorageFileSystem(credential, optionsBuilder.build());
        }
        this.bufferSizeOverride = config.getInt(BUFFERSIZE_KEY, 0x800000);
        LOG.debug("{} = {}", (Object)BUFFERSIZE_KEY, (Object)this.bufferSizeOverride);
        this.defaultBlockSize = config.getLong(BLOCK_SIZE_KEY, 0x4000000L);
        LOG.debug("{} = {}", (Object)BLOCK_SIZE_KEY, (Object)this.defaultBlockSize);
        String systemBucketName = config.get(GCS_SYSTEM_BUCKET_KEY, null);
        LOG.debug("{} = {}", (Object)GCS_SYSTEM_BUCKET_KEY, (Object)systemBucketName);
        boolean createSystemBucket = config.getBoolean(GCS_CREATE_SYSTEM_BUCKET_KEY, true);
        LOG.debug("{} = {}", (Object)GCS_CREATE_SYSTEM_BUCKET_KEY, (Object)createSystemBucket);
        this.reportedPermissions = new FsPermission(config.get(PERMISSIONS_TO_REPORT_KEY, PERMISSIONS_TO_REPORT_DEFAULT));
        LOG.debug("{} = {}", (Object)PERMISSIONS_TO_REPORT_KEY, (Object)this.reportedPermissions);
        this.configureBuckets(systemBucketName, createSystemBucket);
        this.workingDirectory = this.getFileSystemRoot();
        String configWorkingDirectory = config.get(GCS_WORKING_DIRECTORY_KEY);
        if (Strings.isNullOrEmpty((String)configWorkingDirectory)) {
            newWorkingDirectory = this.getDefaultWorkingDirectory();
            LOG.warn("No working directory configured, using default: '{}'", (Object)newWorkingDirectory);
        } else {
            newWorkingDirectory = new Path(configWorkingDirectory);
        }
        this.setWorkingDirectory(newWorkingDirectory);
        LOG.debug("{} = {}", (Object)GCS_WORKING_DIRECTORY_KEY, (Object)this.getWorkingDirectory());
        this.setConf(config);
        LOG.debug("GHFS.configure: done");
    }

    @VisibleForTesting
    public void configureBuckets(String systemBucketName, boolean createSystemBucket) throws IOException {
        LOG.debug("GHFS.configureBuckets: {}, {}", (Object)systemBucketName, (Object)createSystemBucket);
        this.systemBucket = systemBucketName;
        if (this.systemBucket != null) {
            LOG.debug("GHFS.configureBuckets: Warning fs.gs.system.bucket is deprecated.");
            URI systemBucketPath = this.gcsfs.getPathCodec().getPath(this.systemBucket, null, true);
            this.checkOpen();
            if (!this.gcsfs.exists(systemBucketPath)) {
                if (createSystemBucket) {
                    this.gcsfs.mkdirs(systemBucketPath);
                } else {
                    String msg = String.format("%s: system bucket not found: %s", GCS_SYSTEM_BUCKET_KEY, this.systemBucket);
                    throw new FileNotFoundException(msg);
                }
            }
        }
        LOG.debug("GHFS.configureBuckets:=>");
    }

    private void checkOpen() throws IOException {
        if (this.gcsfs == null) {
            throw new IOException("GoogleHadoopFileSystem has been closed or not initialized.");
        }
    }

    public boolean deleteOnExit(Path f) throws IOException {
        this.checkOpen();
        LOG.debug("GHFS.deleteOnExit: {}", (Object)f);
        boolean result = super.deleteOnExit(f);
        LOG.debug("GHFS.deleteOnExit:=> {}", (Object)result);
        return result;
    }

    protected void processDeleteOnExit() {
        LOG.debug("GHFS.processDeleteOnExit:");
        super.processDeleteOnExit();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        LOG.debug("GHFS.getContentSummary: {}", (Object)f);
        ContentSummary result = super.getContentSummary(f);
        LOG.debug("GHFS.getContentSummary:=> {}", (Object)result);
        return result;
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        LOG.debug("GHFS.getDelegationToken: renewer: {}", (Object)renewer);
        Token result = super.getDelegationToken(renewer);
        LOG.debug("GHFS.getDelegationToken:=> {}", (Object)result);
        return result;
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        LOG.debug("GHFS.copyFromLocalFile: delSrc: {}, overwrite: {}, #srcs: {}, dst: {}", new Object[]{delSrc, overwrite, srcs.length, dst});
        super.copyFromLocalFile(delSrc, overwrite, srcs, dst);
        LOG.debug("GHFS.copyFromLocalFile:=> ");
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        LOG.debug("GHFS.copyFromLocalFile: delSrc: {}, overwrite: {}, src: {}, dst: {}", new Object[]{delSrc, overwrite, src, dst});
        super.copyFromLocalFile(delSrc, overwrite, src, dst);
        LOG.debug("GHFS.copyFromLocalFile:=> ");
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        LOG.debug("GHFS.copyToLocalFile: delSrc: {}, src: {}, dst: {}", new Object[]{delSrc, src, dst});
        super.copyToLocalFile(delSrc, src, dst);
        LOG.debug("GHFS.copyToLocalFile:=> ");
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        LOG.debug("GHFS.startLocalOutput: out: {}, tmp: {}", (Object)fsOutputFile, (Object)tmpLocalFile);
        Path result = super.startLocalOutput(fsOutputFile, tmpLocalFile);
        LOG.debug("GHFS.startLocalOutput:=> {}", (Object)result);
        return result;
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        LOG.debug("GHFS.startLocalOutput: out: {}, tmp: {}", (Object)fsOutputFile, (Object)tmpLocalFile);
        super.completeLocalOutput(fsOutputFile, tmpLocalFile);
        LOG.debug("GHFS.completeLocalOutput:=> ");
    }

    public void close() throws IOException {
        LOG.debug("GHFS.close:");
        super.close();
        if (this.gcsfs != null) {
            this.gcsfs.close();
            this.gcsfs = null;
        }
        this.logCounters();
        LOG.debug("GHFS.close:=> ");
    }

    public long getUsed() throws IOException {
        LOG.debug("GHFS.getUsed:");
        long result = super.getUsed();
        LOG.debug("GHFS.getUsed:=> {}", (Object)result);
        return result;
    }

    public long getDefaultBlockSize() {
        LOG.debug("GHFS.getDefaultBlockSize:");
        long result = this.defaultBlockSize;
        LOG.debug("GHFS.getDefaultBlockSize:=> {}", (Object)result);
        return result;
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        LOG.debug("GHFS.getFileChecksum:");
        FileChecksum result = super.getFileChecksum(f);
        LOG.debug("GHFS.getFileChecksum:=> {}", (Object)result);
        return result;
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        LOG.debug("GHFS.setVerifyChecksum:");
        super.setVerifyChecksum(verifyChecksum);
        LOG.debug("GHFS.setVerifyChecksum:=> ");
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        LOG.debug("GHFS.setPermission: path: {}, perm: {}", (Object)p, (Object)permission);
        super.setPermission(p, permission);
        LOG.debug("GHFS.setPermission:=> ");
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        LOG.debug("GHFS.setOwner: path: {}, user: {}, group: {}", new Object[]{p, username, groupname});
        super.setOwner(p, username, groupname);
        LOG.debug("GHFS.setOwner:=> ");
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        LOG.debug("GHFS.setTimes: path: {}, mtime: {}, atime: {}", new Object[]{p, mtime, atime});
        super.setTimes(p, mtime, atime);
        LOG.debug("GHFS.setTimes:=> ");
    }

    @VisibleForTesting
    GoogleCloudStorageFileSystemOptions.Builder createOptionsBuilderFromConfig(Configuration config) throws IOException {
        GoogleCloudStorageFileSystemOptions.Builder optionsBuilder = GoogleCloudStorageFileSystemOptions.newBuilder();
        boolean enableMetadataCache = config.getBoolean(GCS_ENABLE_METADATA_CACHE_KEY, true);
        LOG.debug("{} = {}", (Object)GCS_ENABLE_METADATA_CACHE_KEY, (Object)enableMetadataCache);
        optionsBuilder.setIsMetadataCacheEnabled(enableMetadataCache);
        boolean enableBucketDelete = config.getBoolean(GCE_BUCKET_DELETE_ENABLE_KEY, false);
        LOG.debug("{} = {}", (Object)GCE_BUCKET_DELETE_ENABLE_KEY, (Object)enableBucketDelete);
        optionsBuilder.setEnableBucketDelete(enableBucketDelete);
        DirectoryListCache.Type cacheType = DirectoryListCache.Type.valueOf((String)config.get(GCS_METADATA_CACHE_TYPE_KEY, GCS_METADATA_CACHE_TYPE_DEFAULT));
        LOG.debug("{} = {}", (Object)GCS_METADATA_CACHE_TYPE_KEY, (Object)cacheType);
        optionsBuilder.setCacheType(cacheType);
        String cacheBasePath = config.get(GCS_METADATA_CACHE_DIRECTORY_KEY, GCS_METADATA_CACHE_DIRECTORY_DEFAULT);
        LOG.debug("{} = {}", (Object)GCS_METADATA_CACHE_DIRECTORY_KEY, (Object)cacheBasePath);
        optionsBuilder.setCacheBasePath(cacheBasePath);
        long cacheMaxEntryAgeMillis = config.getLong(GCS_METADATA_CACHE_MAX_ENTRY_AGE_KEY, 14400000L);
        LOG.debug("{} = {}", (Object)GCS_METADATA_CACHE_MAX_ENTRY_AGE_KEY, (Object)cacheMaxEntryAgeMillis);
        optionsBuilder.setCacheMaxEntryAgeMillis(cacheMaxEntryAgeMillis);
        long cacheMaxInfoAgeMillis = config.getLong(GCS_METADATA_CACHE_MAX_INFO_AGE_KEY, 10000L);
        LOG.debug("{} = {}", (Object)GCS_METADATA_CACHE_MAX_INFO_AGE_KEY, (Object)cacheMaxInfoAgeMillis);
        optionsBuilder.setCacheMaxInfoAgeMillis(cacheMaxInfoAgeMillis);
        ParentTimestampUpdateIncludePredicate updatePredicate = ParentTimestampUpdateIncludePredicate.create(config);
        optionsBuilder.setShouldIncludeInTimestampUpdatesPredicate((GoogleCloudStorageFileSystemOptions.TimestampUpdatePredicate)updatePredicate);
        this.enableAutoRepairImplicitDirectories = config.getBoolean(GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_KEY, true);
        LOG.debug("{} = {}", (Object)GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_KEY, (Object)this.enableAutoRepairImplicitDirectories);
        this.enableInferImplicitDirectories = config.getBoolean(GCS_ENABLE_INFER_IMPLICIT_DIRECTORIES_KEY, true);
        LOG.debug("{} = {}", (Object)GCS_ENABLE_INFER_IMPLICIT_DIRECTORIES_KEY, (Object)this.enableInferImplicitDirectories);
        this.enableFlatGlob = config.getBoolean(GCS_ENABLE_FLAT_GLOB_KEY, true);
        LOG.debug("{} = {}", (Object)GCS_ENABLE_FLAT_GLOB_KEY, (Object)this.enableFlatGlob);
        optionsBuilder.getCloudStorageOptionsBuilder().setAutoRepairImplicitDirectoriesEnabled(this.enableAutoRepairImplicitDirectories).setInferImplicitDirectoriesEnabled(this.enableInferImplicitDirectories);
        boolean enableMarkerFileCreation = config.getBoolean(GCS_ENABLE_MARKER_FILE_CREATION_KEY, false);
        LOG.debug("{} = {}", (Object)GCS_ENABLE_MARKER_FILE_CREATION_KEY, (Object)enableMarkerFileCreation);
        optionsBuilder.getCloudStorageOptionsBuilder().setCreateMarkerObjects(enableMarkerFileCreation);
        String transportTypeString = config.get(GCS_HTTP_TRANSPORT_KEY, GCS_HTTP_TRANSPORT_DEFAULT);
        String proxyAddress = config.get(GCS_PROXY_ADDRESS_KEY, GCS_PROXY_ADDRESS_DEFAULT);
        HttpTransportFactory.HttpTransportType transportType = HttpTransportFactory.getTransportTypeOf((String)transportTypeString);
        optionsBuilder.getCloudStorageOptionsBuilder().setTransportType(transportType).setProxyAddress(proxyAddress);
        String projectId = ConfigurationUtil.getMandatoryConfig((Configuration)config, (String)GCS_PROJECT_ID_KEY);
        optionsBuilder.getCloudStorageOptionsBuilder().setProjectId(projectId);
        long maxListItemsPerCall = config.getLong(GCS_MAX_LIST_ITEMS_PER_CALL, 1024L);
        optionsBuilder.getCloudStorageOptionsBuilder().setMaxListItemsPerCall(maxListItemsPerCall);
        boolean limitFileSizeTo250Gb = config.getBoolean(GCS_FILE_SIZE_LIMIT_250GB, false);
        optionsBuilder.getCloudStorageOptionsBuilder().getWriteChannelOptionsBuilder().setFileSizeLimitedTo250Gb(limitFileSizeTo250Gb);
        int uploadBufferSize = config.getInt(WRITE_BUFFERSIZE_KEY, 0x4000000);
        LOG.debug("{} = {}", (Object)WRITE_BUFFERSIZE_KEY, (Object)uploadBufferSize);
        optionsBuilder.getCloudStorageOptionsBuilder().getWriteChannelOptionsBuilder().setUploadBufferSize(uploadBufferSize);
        String applicationNameSuffix = config.get(GCS_APPLICATION_NAME_SUFFIX_KEY, GCS_APPLICATION_NAME_SUFFIX_DEFAULT);
        LOG.debug("{} = {}", (Object)GCS_APPLICATION_NAME_SUFFIX_KEY, (Object)applicationNameSuffix);
        String applicationName = GHFS_ID;
        if (!Strings.isNullOrEmpty((String)applicationNameSuffix)) {
            applicationName = applicationName + applicationNameSuffix;
        }
        LOG.debug("Setting GCS application name to {}", (Object)applicationName);
        optionsBuilder.getCloudStorageOptionsBuilder().setAppName(applicationName);
        int maxWaitMillisForEmptyObjectCreation = config.getInt(GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE_KEY, 3000);
        LOG.debug("{} = {}", (Object)GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE_KEY, (Object)maxWaitMillisForEmptyObjectCreation);
        optionsBuilder.getCloudStorageOptionsBuilder().setMaxWaitMillisForEmptyObjectCreation(maxWaitMillisForEmptyObjectCreation);
        boolean enablePerformanceCache = config.getBoolean(GCS_ENABLE_PERFORMANCE_CACHE_KEY, false);
        LOG.debug("{} = {}", (Object)GCS_ENABLE_PERFORMANCE_CACHE_KEY, (Object)enablePerformanceCache);
        optionsBuilder.setIsPerformanceCacheEnabled(enablePerformanceCache);
        long performanceCacheMaxEntryAgeMillis = config.getLong(GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS_KEY, 3000L);
        LOG.debug("{} = {}", (Object)GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS_KEY, (Object)performanceCacheMaxEntryAgeMillis);
        boolean listCachingEnabled = config.getBoolean(GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE_KEY, true);
        LOG.debug("{} = {}", (Object)GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE_KEY, (Object)listCachingEnabled);
        optionsBuilder.getPerformanceCachingOptionsBuilder().setMaxEntryAgeMillis(performanceCacheMaxEntryAgeMillis).setInferImplicitDirectoriesEnabled(this.enableInferImplicitDirectories).setListCachingEnabled(listCachingEnabled);
        return optionsBuilder;
    }

    static {
        LOG.info("GHFS version: {}", (Object)VERSION);
        GHFS_ID = String.format("GHFS/%s", VERSION);
    }

    public static class ParentTimestampUpdateIncludePredicate
    implements GoogleCloudStorageFileSystemOptions.TimestampUpdatePredicate {
        private final List<String> includeSubstrings;
        private final List<String> excludeSubstrings;
        private final boolean enableTimestampUpdates;

        public static ParentTimestampUpdateIncludePredicate create(Configuration config) {
            boolean enableDirectoryTimestampUpdating = config.getBoolean(GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_KEY, true);
            LOG.debug("{} = {}", (Object)GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_KEY, (Object)enableDirectoryTimestampUpdating);
            String includedParentPaths = config.get(GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_KEY, GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_DEFAULT);
            LOG.debug("{} = {}", (Object)GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_KEY, (Object)includedParentPaths);
            List splitIncludedParentPaths = CONFIGURATION_SPLITTER.splitToList((CharSequence)includedParentPaths);
            String excludedParentPaths = config.get(GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_KEY, GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT);
            LOG.debug("{} = {}", (Object)GoogleHadoopFileSystemBase.GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_KEY, (Object)excludedParentPaths);
            List splitExcludedParentPaths = CONFIGURATION_SPLITTER.splitToList((CharSequence)excludedParentPaths);
            return new ParentTimestampUpdateIncludePredicate(enableDirectoryTimestampUpdating, splitIncludedParentPaths, splitExcludedParentPaths);
        }

        public ParentTimestampUpdateIncludePredicate(boolean enableTimestampUpdates, List<String> includeSubstrings, List<String> excludeSubstrings) {
            this.includeSubstrings = includeSubstrings;
            this.excludeSubstrings = excludeSubstrings;
            this.enableTimestampUpdates = enableTimestampUpdates;
        }

        public boolean shouldUpdateTimestamp(URI uri) {
            if (!this.enableTimestampUpdates) {
                LOG.debug("Timestamp updating disabled. Not updating uri {}", (Object)uri);
                return false;
            }
            for (String include : this.includeSubstrings) {
                if (!uri.toString().contains(include)) continue;
                LOG.debug("Path %s matched included path %s. Updating timestamps.", (Object)uri, (Object)include);
                return true;
            }
            for (String exclude : this.excludeSubstrings) {
                if (!uri.toString().contains(exclude)) continue;
                LOG.debug("Path %s matched excluded path %s. Not updating timestamps.", (Object)uri, (Object)exclude);
                return false;
            }
            return true;
        }
    }

    public static enum Counter {
        APPEND,
        APPEND_TIME,
        CREATE,
        CREATE_TIME,
        DELETE,
        DELETE_TIME,
        GET_FILE_STATUS,
        GET_FILE_STATUS_TIME,
        INIT,
        INIT_TIME,
        INPUT_STREAM,
        INPUT_STREAM_TIME,
        LIST_STATUS,
        LIST_STATUS_TIME,
        MKDIRS,
        MKDIRS_TIME,
        OPEN,
        OPEN_TIME,
        OUTPUT_STREAM,
        OUTPUT_STREAM_TIME,
        READ1,
        READ1_TIME,
        READ,
        READ_TIME,
        READ_FROM_CHANNEL,
        READ_FROM_CHANNEL_TIME,
        READ_CLOSE,
        READ_CLOSE_TIME,
        READ_POS,
        READ_POS_TIME,
        RENAME,
        RENAME_TIME,
        SEEK,
        SEEK_TIME,
        SET_WD,
        SET_WD_TIME,
        WRITE1,
        WRITE1_TIME,
        WRITE,
        WRITE_TIME,
        WRITE_CLOSE,
        WRITE_CLOSE_TIME;

    }

    protected static enum ListStatusFileNotFoundBehavior {
        Hadoop1{

            @Override
            public FileStatus[] handle(String path) throws IOException {
                return null;
            }
        }
        ,
        Hadoop2{

            @Override
            public FileStatus[] handle(String path) throws IOException {
                throw new FileNotFoundException(String.format("Path '%s' does not exist.", path));
            }
        };


        public abstract FileStatus[] handle(String var1) throws IOException;

        public static ListStatusFileNotFoundBehavior get() {
            return ListStatusFileNotFoundBehavior.get(HadoopVersionInfo.getInstance());
        }

        public static ListStatusFileNotFoundBehavior get(HadoopVersionInfo hadoopVersionInfo) {
            if (hadoopVersionInfo.isGreaterThan(2, 0) || hadoopVersionInfo.isEqualTo(0, 23)) {
                return Hadoop2;
            }
            return Hadoop1;
        }
    }

    public static enum OutputStreamType {
        BASIC,
        SYNCABLE_COMPOSITE;

    }
}

