/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.gcsio.CacheEntry;
import com.google.cloud.hadoop.gcsio.DirectoryListCache;
import com.google.cloud.hadoop.gcsio.FileSystemBackedDirectoryListCache;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericOptionsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleHadoopFileSystemCacheCleaner {
    public static final Logger LOG = LoggerFactory.getLogger(GoogleHadoopFileSystemCacheCleaner.class);

    public static void cleanCache(DirectoryListCache cache) throws IOException {
        for (CacheEntry bucket : cache.getRawBucketList()) {
            String bucketName = bucket.getResourceId().getBucketName();
            LOG.info("Performing GC on cache bucket {}", (Object)bucketName);
            cache.getObjectList(bucketName, "", null, null);
        }
        cache.getBucketList();
    }

    public static void main(String[] args) throws IOException {
        GenericOptionsParser parser = new GenericOptionsParser(args);
        args = parser.getRemainingArgs();
        Configuration configuration = parser.getConfiguration();
        if ("FILESYSTEM_BACKED".equals(configuration.get("fs.gs.metadata.cache.type", "IN_MEMORY"))) {
            String fsStringPath = configuration.get("fs.gs.metadata.cache.directory", "");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)fsStringPath) ? 1 : 0) != 0);
            LOG.info("Performing GC on cache directory {}", (Object)fsStringPath);
            Path path = Paths.get(fsStringPath, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                FileSystemBackedDirectoryListCache cache = new FileSystemBackedDirectoryListCache(fsStringPath);
                GoogleHadoopFileSystemCacheCleaner.cleanCache((DirectoryListCache)cache);
            }
        }
        LOG.info("Done with GC.");
    }
}

