/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@Deprecated
public class GoogleHadoopGlobalRootedFileSystem
extends GoogleHadoopFileSystemBase {
    public GoogleHadoopGlobalRootedFileSystem() {
    }

    public GoogleHadoopGlobalRootedFileSystem(GoogleCloudStorageFileSystem gcsfs) {
        super(gcsfs);
    }

    @Override
    protected String getHomeDirectorySubpath() {
        return this.systemBucket + "/user/" + System.getProperty("user.name");
    }

    @Override
    public Path getHadoopPath(URI gcsPath) {
        LOG.debug("GHFS.getHadoopPath: {}", (Object)gcsPath);
        if (gcsPath.equals(this.getGcsPath(this.getFileSystemRoot()))) {
            return this.getFileSystemRoot();
        }
        StorageResourceId resourceId = this.gcsfs.getPathCodec().validatePathAndGetId(gcsPath, true);
        Path hadoopPath = this.getHadoopPathFromResourceId(resourceId);
        LOG.debug("GHFS.getHadoopPath: {} -> {}", (Object)gcsPath, (Object)hadoopPath);
        return hadoopPath;
    }

    @VisibleForTesting
    Path getHadoopPathFromResourceId(StorageResourceId resourceId) {
        Preconditions.checkArgument((!resourceId.isRoot() ? 1 : 0) != 0, (Object)"resourceId must be a bucket or object.");
        String bucketName = resourceId.getBucketName();
        String objectName = resourceId.getObjectName();
        if (objectName == null) {
            objectName = "";
        }
        URI pathUri = null;
        String path = this.getScheme() + ":/" + bucketName + "/" + objectName;
        try {
            pathUri = new URI(path);
        }
        catch (URISyntaxException e) {
            String msg = String.format("Invalid path: %s / %s", bucketName, objectName);
            throw new IllegalArgumentException(msg, e);
        }
        Path hadoopPath = new Path(pathUri.toString());
        return hadoopPath;
    }

    @Override
    public URI getGcsPath(Path hadoopPath) {
        LOG.debug("GHFS.getGcsPath: {}", (Object)hadoopPath);
        Path resolvedPath = hadoopPath.makeQualified((FileSystem)this);
        if (resolvedPath.equals((Object)this.getFileSystemRoot())) {
            return GoogleCloudStorageFileSystem.GCS_ROOT;
        }
        String authorityString = null;
        authorityString = !Strings.isNullOrEmpty((String)resolvedPath.toUri().getAuthority()) ? "/" + resolvedPath.toUri().getAuthority() : "";
        String path = "gs:/" + authorityString + resolvedPath.toUri().getPath();
        URI gcsPath = null;
        try {
            gcsPath = new URI(path);
        }
        catch (URISyntaxException e) {
            String msg = String.format("Invalid path: %s", hadoopPath);
            throw new IllegalArgumentException(msg, e);
        }
        LOG.debug("GHFS.getGcsPath: {} -> {}", (Object)hadoopPath, (Object)gcsPath);
        return gcsPath;
    }

    @Override
    public Path getFileSystemRoot() {
        return new Path(this.getScheme() + ":/");
    }

    @Override
    public String getScheme() {
        return "gsg";
    }

    @Override
    public Path getDefaultWorkingDirectory() {
        return new Path(this.getFileSystemRoot(), this.systemBucket);
    }
}

