/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GoogleHadoopOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleHadoopOutputStream.class);
    private GoogleHadoopFileSystemBase ghfs;
    private WritableByteChannel channel;
    private OutputStream out;
    private URI gcsPath;
    private final FileSystem.Statistics statistics;
    private long initTime;

    GoogleHadoopOutputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, int bufferSize, FileSystem.Statistics statistics, CreateFileOptions createFileOptions) throws IOException {
        LOG.debug("GoogleHadoopOutputStream({}, {})", (Object)gcsPath, (Object)bufferSize);
        this.ghfs = ghfs;
        this.gcsPath = gcsPath;
        this.statistics = statistics;
        this.initTime = System.nanoTime();
        try {
            this.channel = ghfs.getGcsFs().create(gcsPath, createFileOptions);
        }
        catch (java.nio.file.FileAlreadyExistsException faee) {
            throw (FileAlreadyExistsException)new FileAlreadyExistsException(faee.getMessage()).initCause((Throwable)faee);
        }
        OutputStream rawStream = Channels.newOutputStream(this.channel);
        this.out = new BufferedOutputStream(rawStream, bufferSize);
    }

    @Override
    public void write(int b) throws IOException {
        long startTime = System.nanoTime();
        this.out.write(b);
        this.statistics.incrementBytesWritten(1L);
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE1);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE1_TIME, duration);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        long startTime = System.nanoTime();
        this.out.write(b, offset, len);
        this.statistics.incrementBytesWritten((long)len);
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE_TIME, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.out != null) {
            try {
                long startTime = System.nanoTime();
                this.out.close();
                long duration = System.nanoTime() - startTime;
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE_CLOSE);
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE_CLOSE_TIME, duration);
                long streamDuration = System.nanoTime() - this.initTime;
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.OUTPUT_STREAM);
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.OUTPUT_STREAM_TIME, streamDuration);
                LOG.debug("close({})", (Object)this.gcsPath);
            }
            finally {
                this.out = null;
                this.channel = null;
            }
        }
    }

    WritableByteChannel getInternalChannel() {
        return this.channel;
    }
}

