/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.CompositeLimitExceededException;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopOutputStream;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleHadoopSyncableOutputStream
extends OutputStream
implements Syncable {
    public static final String TEMPFILE_PREFIX = "_GCS_SYNCABLE_TEMPFILE_";
    public static final int MAX_COMPOSITE_COMPONENTS = 1024;
    private static final Logger LOG = LoggerFactory.getLogger(GoogleHadoopSyncableOutputStream.class);
    private static final CreateFileOptions TEMPFILE_CREATE_OPTIONS = new CreateFileOptions(false, "application/octet-stream", (Map)CreateFileOptions.EMPTY_ATTRIBUTES, false, false, 0L);
    private static final ExecutorService TEMPFILE_CLEANUP_THREADPOOL = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcs-syncable-output-stream-cleanup-pool-%d").setDaemon(true).build());
    private final GoogleHadoopFileSystemBase ghfs;
    private final URI finalGcsPath;
    private final int bufferSize;
    private final FileSystem.Statistics statistics;
    private final CreateFileOptions fileOptions;
    private final List<Future<Void>> deletionFutures;
    private final ExecutorService cleanupThreadpool;
    private URI curGcsPath;
    private GoogleHadoopOutputStream curDelegate;
    private int curComponentIndex;
    private long curDestGenerationId;

    public GoogleHadoopSyncableOutputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, int bufferSize, FileSystem.Statistics statistics, CreateFileOptions createFileOptions) throws IOException {
        this(ghfs, gcsPath, bufferSize, statistics, createFileOptions, TEMPFILE_CLEANUP_THREADPOOL);
    }

    GoogleHadoopSyncableOutputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, int bufferSize, FileSystem.Statistics statistics, CreateFileOptions createFileOptions, ExecutorService cleanupThreadpool) throws IOException {
        LOG.debug("GoogleHadoopSyncableOutputStream({}, {})", (Object)gcsPath, (Object)bufferSize);
        this.ghfs = ghfs;
        this.finalGcsPath = gcsPath;
        this.bufferSize = bufferSize;
        this.statistics = statistics;
        this.fileOptions = createFileOptions;
        this.deletionFutures = new ArrayList<Future<Void>>();
        this.cleanupThreadpool = cleanupThreadpool;
        this.curGcsPath = gcsPath;
        this.curDelegate = new GoogleHadoopOutputStream(ghfs, this.curGcsPath, bufferSize, statistics, this.fileOptions);
        this.curComponentIndex = 0;
        this.curDestGenerationId = -1L;
    }

    @Override
    public void write(int b) throws IOException {
        this.throwIfNotOpen();
        this.curDelegate.write(b);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this.throwIfNotOpen();
        this.curDelegate.write(b, offset, len);
    }

    @Override
    public void close() throws IOException {
        LOG.debug("close(): Current tail file: {} final destination: {}", (Object)this.curGcsPath, (Object)this.finalGcsPath);
        if (!this.isOpen()) {
            LOG.debug("close(): Ignoring; stream already closed.");
            return;
        }
        this.commitCurrentFile();
        this.curGcsPath = null;
        this.curDelegate = null;
        LOG.debug("close(): Awaiting {} deletionFutures", (Object)this.deletionFutures.size());
        for (Future<Void> deletion : this.deletionFutures) {
            try {
                deletion.get();
            }
            catch (InterruptedException | ExecutionException ee) {
                if (ee.getCause() instanceof IOException) {
                    throw (IOException)ee.getCause();
                }
                throw new IOException(ee);
            }
        }
        LOG.debug("close(): done");
    }

    public void sync() throws IOException {
        this.hsync();
    }

    public void hflush() throws IOException {
        LOG.warn("hflush() is a no-op; readers will *not* yet see flushed data for {}", (Object)this.finalGcsPath);
        this.throwIfNotOpen();
    }

    public void hsync() throws IOException {
        LOG.debug("hsync(): Committing tail file {} to final destination {}", (Object)this.curGcsPath, (Object)this.finalGcsPath);
        this.throwIfNotOpen();
        long startTime = System.nanoTime();
        int curNumComponents = this.curComponentIndex + 1;
        if (curNumComponents >= 1024) {
            throw new CompositeLimitExceededException(String.format("Cannot hsync() '%s' because subsequent component count would exceed limit of %d", this.finalGcsPath, 1024));
        }
        this.commitCurrentFile();
        ++this.curComponentIndex;
        this.curGcsPath = this.getNextTemporaryPath();
        LOG.debug("hsync(): Opening next temporary tail file {} as component number {}", (Object)this.curGcsPath, (Object)this.curComponentIndex);
        this.curDelegate = new GoogleHadoopOutputStream(this.ghfs, this.curGcsPath, this.bufferSize, this.statistics, TEMPFILE_CREATE_OPTIONS);
        long endTime = System.nanoTime();
        LOG.debug("Took {} ns to hsync()", (Object)(endTime - startTime));
    }

    private void commitCurrentFile() throws IOException {
        WritableByteChannel innerChannel = this.curDelegate.getInternalChannel();
        this.curDelegate.close();
        long generationId = -1L;
        if (innerChannel instanceof GoogleCloudStorageItemInfo.Provider) {
            generationId = ((GoogleCloudStorageItemInfo.Provider)innerChannel).getItemInfo().getContentGeneration();
            LOG.debug("innerChannel is GoogleCloudStorageItemInfo.Provider; closed generationId {}.", (Object)generationId);
        } else {
            LOG.debug("innerChannel NOT instanceof provider: {}", innerChannel.getClass());
        }
        if (!this.finalGcsPath.equals(this.curGcsPath)) {
            StorageResourceId destResourceId = StorageResourceId.fromObjectName((String)this.finalGcsPath.toString(), (long)this.curDestGenerationId);
            final StorageResourceId tempResourceId = StorageResourceId.fromObjectName((String)this.curGcsPath.toString(), (long)generationId);
            if (!destResourceId.getBucketName().equals(tempResourceId.getBucketName())) {
                throw new IllegalStateException(String.format("Destination bucket in path '%s' doesn't match temp file bucket in path '%s'", this.finalGcsPath, this.curGcsPath));
            }
            GoogleCloudStorageItemInfo composedObject = this.ghfs.getGcsFs().getGcs().composeObjects((List)ImmutableList.of((Object)destResourceId, (Object)tempResourceId), destResourceId, GoogleCloudStorageFileSystem.objectOptionsFromFileOptions((CreateFileOptions)this.fileOptions));
            this.curDestGenerationId = composedObject.getContentGeneration();
            this.deletionFutures.add(this.cleanupThreadpool.submit(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    GoogleHadoopSyncableOutputStream.this.ghfs.getGcsFs().getGcs().deleteObjects((List)ImmutableList.of((Object)tempResourceId));
                    return null;
                }
            }));
        } else {
            this.curDestGenerationId = generationId;
        }
    }

    private URI getNextTemporaryPath() {
        Path basePath = this.ghfs.getHadoopPath(this.finalGcsPath);
        Path baseDir = basePath.getParent();
        Path tempPath = new Path(baseDir, String.format("%s%s.%d.%s", TEMPFILE_PREFIX, basePath.getName(), this.curComponentIndex, UUID.randomUUID().toString()));
        return this.ghfs.getGcsPath(tempPath);
    }

    private boolean isOpen() {
        return this.curDelegate != null;
    }

    private void throwIfNotOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

