/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.MetadataReadOnlyGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

class ListHelperGoogleHadoopFileSystem
extends GoogleHadoopFileSystem {
    public static GoogleHadoopFileSystem createInstance(GoogleCloudStorageFileSystem gcsfs, Collection<FileInfo> fileInfos) throws IOException {
        Preconditions.checkState((!fileInfos.isEmpty() ? 1 : 0) != 0, (Object)"Cannot construct ListHelperGoogleHadoopFileSystem with empty fileInfos list!");
        ArrayList<GoogleCloudStorageItemInfo> infos = new ArrayList<GoogleCloudStorageItemInfo>();
        URI rootUri = null;
        HashSet<URI> providedPaths = new HashSet<URI>();
        for (FileInfo info : fileInfos) {
            infos.add(info.getItemInfo());
            providedPaths.add(info.getPath());
            if (rootUri != null) continue;
            rootUri = info.getPath();
        }
        for (FileInfo info : fileInfos) {
            URI parentPath = gcsfs.getParentPath(info.getPath());
            while (parentPath != null && !parentPath.equals(GoogleCloudStorageFileSystem.GCS_ROOT)) {
                if (!providedPaths.contains(parentPath)) {
                    LOG.debug("Adding fake entry for missing parent path '{}'", (Object)parentPath);
                    GoogleCloudStorageItemInfo fakeInfo = new GoogleCloudStorageItemInfo(gcsfs.getPathCodec().validatePathAndGetId(parentPath, true), 0L, 0L, null, null);
                    infos.add(fakeInfo);
                    providedPaths.add(parentPath);
                }
                parentPath = gcsfs.getParentPath(parentPath);
            }
        }
        String tempBucket = rootUri.getAuthority();
        infos.add(new GoogleCloudStorageItemInfo(new StorageResourceId(tempBucket), 0L, 0L, "", ""));
        MetadataReadOnlyGoogleCloudStorage tempGcs = new MetadataReadOnlyGoogleCloudStorage(infos);
        GoogleCloudStorageFileSystem tempGcsFs = new GoogleCloudStorageFileSystem((GoogleCloudStorage)tempGcs, gcsfs.getOptions());
        ListHelperGoogleHadoopFileSystem tempGhfs = new ListHelperGoogleHadoopFileSystem(tempGcsFs);
        Configuration tempConfig = new Configuration();
        tempConfig.set("fs.gs.system.bucket", tempBucket);
        tempConfig.setBoolean("fs.gs.system.bucket.create", false);
        tempConfig.set("fs.gs.working.dir", "/");
        tempGhfs.initialize(rootUri, tempConfig, false);
        return tempGhfs;
    }

    public ListHelperGoogleHadoopFileSystem(GoogleCloudStorageFileSystem gcsfs) {
        super(gcsfs);
    }

    @Override
    boolean shouldUseFlatGlob(Path fixedPath) {
        return false;
    }
}

