/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.AbstractGhfsStatisticsSource;
import com.google.cloud.hadoop.fs.gcs.DelegationTokenStatistics;
import com.google.cloud.hadoop.fs.gcs.GhfsInputStreamStatistics;
import com.google.cloud.hadoop.fs.gcs.GhfsOutputStreamStatistics;
import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import com.google.cloud.hadoop.fs.gcs.GhfsStatisticTypeEnum;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.Closeable;
import java.net.URI;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStoreBuilder;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableMetric;

public class GhfsInstrumentation
implements Closeable,
MetricsSource,
IOStatisticsSource,
DurationTrackerFactory {
    private static final String METRICS_SOURCE_BASENAME = "GCSMetrics";
    private static final String CONTEXT = "GoogleHadoopFilesystem";
    private static final String METRICS_SYSTEM_NAME = "google-hadoop-file-system";
    private static final String METRIC_TAG_FILESYSTEM_ID = "gcsFilesystemId";
    private static final String METRIC_TAG_BUCKET = "bucket";
    private static final Object METRICS_SYSTEM_LOCK = new Object();
    private static MetricsSystem metricsSystem = null;
    private static int metricsSourceNameCounter = 0;
    private static int metricsSourceActiveCounter = 0;
    private final MetricsRegistry registry = new MetricsRegistry("googleHadoopFilesystem").setContext("GoogleHadoopFilesystem");
    private final IOStatisticsStore instanceIOStatistics;
    private final DurationTrackerFactory durationTrackerFactory;
    private String metricsSourceName;
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    public GhfsInstrumentation(URI name) {
        UUID fileSystemInstanceID = UUID.randomUUID();
        this.registry.tag(METRIC_TAG_FILESYSTEM_ID, "A unique identifier for the instance", fileSystemInstanceID.toString());
        this.registry.tag(METRIC_TAG_BUCKET, "Hostname from the FS URL", name.getHost());
        IOStatisticsStoreBuilder storeBuilder = this.createStoreBuilder();
        this.registerAsMetricsSource(name);
        this.instanceIOStatistics = storeBuilder.build();
        this.durationTrackerFactory = IOStatisticsBinding.pairedTrackerFactory((DurationTrackerFactory)new MetricDurationTrackerFactory(), (DurationTrackerFactory)this.instanceIOStatistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAsMetricsSource(URI name) {
        int number;
        Object object = METRICS_SYSTEM_LOCK;
        synchronized (object) {
            this.getMetricsSystem();
            ++metricsSourceActiveCounter;
            number = ++metricsSourceNameCounter;
        }
        this.metricsSourceName = METRICS_SOURCE_BASENAME + number + "-" + name.getHost();
        metricsSystem.register(this.metricsSourceName, "", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = METRICS_SYSTEM_LOCK;
        synchronized (object) {
            metricsSystem.unregisterSource(this.metricsSourceName);
            int activeSources = --metricsSourceActiveCounter;
            if (activeSources == 0) {
                ((GoogleLogger.Api)logger.atInfo()).log("Shutting down metrics publisher");
                metricsSystem.publishMetricsNow();
                metricsSystem.shutdown();
                metricsSystem = null;
            }
        }
    }

    public IOStatisticsStore getIOStatistics() {
        return this.instanceIOStatistics;
    }

    public void incrementCounter(GhfsStatistic op, long count) {
        if (count == 0L) {
            return;
        }
        String name = op.getSymbol();
        this.incrementMutableCounter(name, count);
        this.instanceIOStatistics.incrementCounter(name, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsSystem getMetricsSystem() {
        Object object = METRICS_SYSTEM_LOCK;
        synchronized (object) {
            if (metricsSystem == null) {
                metricsSystem = new MetricsSystemImpl();
                metricsSystem.init(METRICS_SYSTEM_NAME);
            }
        }
        return metricsSystem;
    }

    protected final MutableCounterLong counter(String name, String desc) {
        return this.registry.newCounter(name, desc, 0L);
    }

    protected final MutableCounterLong counter(GhfsStatistic op) {
        return this.counter(op.getSymbol(), op.getDescription());
    }

    protected final void duration(GhfsStatistic op) {
        this.counter(op.getSymbol(), op.getDescription());
        this.counter(op.getSymbol() + ".failures", op.getDescription());
    }

    protected final MutableGaugeLong gauge(String name, String desc) {
        return this.registry.newGauge(name, desc, 0L);
    }

    protected final MutableGaugeLong gauge(GhfsStatistic op) {
        return this.gauge(op.getSymbol(), op.getDescription());
    }

    public MetricsRegistry getRegistry() {
        return this.registry;
    }

    public MutableMetric lookupMetric(String name) {
        return this.getRegistry().get(name);
    }

    private MutableCounterLong lookupCounter(String name) {
        MutableMetric metric = this.lookupMetric(name);
        if (metric == null) {
            return null;
        }
        if (!(metric instanceof MutableCounterLong)) {
            throw new IllegalStateException(String.format("Metric %s is not a MutableCounterLong: %s (type: %s)", name, metric, metric.getClass()));
        }
        return (MutableCounterLong)metric;
    }

    private void incrementMutableCounter(String name, long count) {
        MutableCounterLong counter;
        if (count > 0L && (counter = this.lookupCounter(name)) != null) {
            counter.incr(count);
        }
    }

    public DurationTrackerFactory getDurationTrackerFactory() {
        return this.durationTrackerFactory;
    }

    public DurationTracker trackDuration(String key, long count) {
        return this.durationTrackerFactory.trackDuration(key, count);
    }

    public void getMetrics(MetricsCollector metricsCollector, boolean b) {
    }

    public void fileCreated() {
        this.incrementCounter(GhfsStatistic.FILES_CREATED, 1L);
    }

    public void directoryCreated() {
        this.incrementCounter(GhfsStatistic.DIRECTORIES_CREATED, 1L);
    }

    public void directoryDeleted() {
        this.incrementCounter(GhfsStatistic.DIRECTORIES_DELETED, 1L);
    }

    public void fileDeleted(int count) {
        this.incrementCounter(GhfsStatistic.FILES_DELETED, count);
    }

    public GhfsInputStreamStatistics newInputStreamStatistics(@Nullable FileSystem.Statistics filesystemStatistics) {
        return new InputStreamStatistics(filesystemStatistics);
    }

    public GhfsOutputStreamStatistics newOutputStreamStatistics(FileSystem.Statistics filesystemStatistics) {
        return new OutputStreamStatistics(filesystemStatistics);
    }

    private void mergeOutputStreamStatistics(OutputStreamStatistics source) {
        this.incrementCounter(GhfsStatistic.STREAM_WRITE_EXCEPTIONS, source.lookupCounterValue("stream_write_exceptions"));
        this.getIOStatistics().aggregate((IOStatistics)source.getIOStatistics());
    }

    public DelegationTokenStatistics newDelegationTokenStatistics() {
        return new DelegationTokenStatisticsImpl();
    }

    private IOStatisticsStoreBuilder createStoreBuilder() {
        IOStatisticsStoreBuilder storeBuilder = IOStatisticsBinding.iostatisticsStore();
        EnumSet.allOf(GhfsStatistic.class).forEach(stat -> {
            if (stat.getType() == GhfsStatisticTypeEnum.TYPE_COUNTER) {
                this.counter((GhfsStatistic)((Object)stat));
                storeBuilder.withCounters(new String[]{stat.getSymbol()});
            } else if (stat.getType() == GhfsStatisticTypeEnum.TYPE_GAUGE) {
                this.gauge((GhfsStatistic)((Object)stat));
                storeBuilder.withGauges(new String[]{stat.getSymbol()});
            } else if (stat.getType() == GhfsStatisticTypeEnum.TYPE_DURATION) {
                this.duration((GhfsStatistic)((Object)stat));
                storeBuilder.withDurationTracking(new String[]{stat.getSymbol()});
            }
        });
        return storeBuilder;
    }

    private final class DelegationTokenStatisticsImpl
    extends AbstractGhfsStatisticsSource
    implements DelegationTokenStatistics {
        private DelegationTokenStatisticsImpl() {
            IOStatisticsStore st = IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{GhfsStatistic.DELEGATION_TOKENS_ISSUED.getSymbol()}).build();
        }

        private IOStatisticsStore localIOStatistics() {
            return super.getIOStatistics();
        }

        private void mergeDelegationTokenStatistics(DelegationTokenStatistics source) {
            this.getIOStatistics().aggregate(source.getIOStatistics());
        }

        @Override
        public void tokenIssued() {
        }

        @Override
        public DurationTracker trackDuration(String key, long count) {
            return GhfsInstrumentation.this.getDurationTrackerFactory().trackDuration(key, count);
        }
    }

    private final class OutputStreamStatistics
    extends AbstractGhfsStatisticsSource
    implements GhfsOutputStreamStatistics {
        private final AtomicLong bytesWritten;
        private final AtomicLong writeExceptions;
        private final FileSystem.Statistics filesystemStatistics;

        private OutputStreamStatistics(FileSystem.Statistics filesystemStatistics) {
            this.filesystemStatistics = filesystemStatistics;
            IOStatisticsStore st = IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{GhfsStatistic.STREAM_WRITE_BYTES.getSymbol(), GhfsStatistic.STREAM_WRITE_EXCEPTIONS.getSymbol()}).withDurationTracking(new String[]{GhfsStatistic.STREAM_WRITE_CLOSE_OPERATIONS.getSymbol(), GhfsStatistic.STREAM_WRITE_OPERATIONS.getSymbol(), GhfsStatistic.INVOCATION_HFLUSH.getSymbol(), GhfsStatistic.INVOCATION_HSYNC.getSymbol()}).build();
            this.setIOStatistics(st);
            this.bytesWritten = st.getCounterReference("stream_write_bytes");
            this.writeExceptions = st.getCounterReference("stream_write_exceptions");
        }

        private IOStatisticsStore localIOStatistics() {
            return super.getIOStatistics();
        }

        @Override
        public void close() {
            GhfsInstrumentation.this.mergeOutputStreamStatistics(this);
        }

        @Override
        public void writeBytes(long count) {
            this.bytesWritten.addAndGet(count);
        }

        @Override
        public void writeException() {
            this.writeExceptions.incrementAndGet();
        }

        @Override
        public void hflushInvoked() {
            this.incrementCounter(GhfsStatistic.INVOCATION_HFLUSH.getSymbol(), 1L);
        }

        @Override
        public void hsyncInvoked() {
            this.incrementCounter(GhfsStatistic.INVOCATION_HSYNC.getSymbol(), 1L);
        }

        @Override
        public long getBytesWritten() {
            return this.bytesWritten.get();
        }

        @Override
        public long getWriteExceptions() {
            return this.lookupCounterValue("stream_write_exceptions");
        }
    }

    private final class InputStreamStatistics
    extends AbstractGhfsStatisticsSource
    implements GhfsInputStreamStatistics {
        private static final int DISTANCE = 5;
        private final FileSystem.Statistics filesystemStatistics;
        private IOStatisticsSnapshot mergedStats;
        private final AtomicLong backwardSeekOperations;
        private final AtomicLong bytesBackwardsOnSeek;
        private final AtomicLong bytesRead;
        private final AtomicLong bytesSkippedOnSeek;
        private final AtomicLong forwardSeekOperations;
        private final AtomicLong readExceptions;
        private final AtomicLong readsIncomplete;
        private final AtomicLong readOperations;
        private final AtomicLong seekOperations;
        private final AtomicLong totalBytesRead;

        private InputStreamStatistics(FileSystem.Statistics filesystemStatistics) {
            this.filesystemStatistics = filesystemStatistics;
            IOStatisticsStore st = IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{"stream_read_bytes", "stream_read_exceptions", "stream_read_operations_incomplete", "stream_read_seek_backward_operations", "stream_read_seek_forward_operations", "stream_read_bytes_backwards_on_seek", "stream_read_seek_bytes_skipped", "stream_read_total_bytes"}).withDurationTracking(new String[]{GhfsStatistic.STREAM_READ_SEEK_OPERATIONS.getSymbol(), GhfsStatistic.STREAM_READ_CLOSE_OPERATIONS.getSymbol(), GhfsStatistic.STREAM_READ_OPERATIONS.getSymbol()}).build();
            this.setIOStatistics(st);
            this.backwardSeekOperations = st.getCounterReference("stream_read_seek_backward_operations");
            this.bytesBackwardsOnSeek = st.getCounterReference("stream_read_bytes_backwards_on_seek");
            this.bytesRead = st.getCounterReference("stream_read_bytes");
            this.bytesSkippedOnSeek = st.getCounterReference("stream_read_seek_bytes_skipped");
            this.forwardSeekOperations = st.getCounterReference("stream_read_seek_forward_operations");
            this.readExceptions = st.getCounterReference("stream_read_exceptions");
            this.readsIncomplete = st.getCounterReference("stream_read_operations_incomplete");
            this.readOperations = st.getCounterReference("stream_read_operations");
            this.seekOperations = st.getCounterReference("stream_read_seek_operations");
            this.totalBytesRead = st.getCounterReference("stream_read_total_bytes");
            this.setIOStatistics(st);
            this.mergedStats = IOStatisticsSupport.snapshotIOStatistics((IOStatistics)st);
        }

        private long increment(String name) {
            return this.increment(name, 1L);
        }

        private long increment(String name, long value) {
            return this.incrementCounter(name, value);
        }

        private IOStatisticsStore localIOStatistics() {
            return super.getIOStatistics();
        }

        @Override
        public void seekBackwards(long negativeOffset) {
            this.backwardSeekOperations.incrementAndGet();
            this.bytesBackwardsOnSeek.addAndGet(-negativeOffset);
        }

        @Override
        public void seekForwards(long skipped) {
            if (skipped > 0L) {
                this.bytesSkippedOnSeek.addAndGet(skipped);
            }
            this.forwardSeekOperations.incrementAndGet();
        }

        @Override
        public void readException() {
            this.readExceptions.incrementAndGet();
        }

        @Override
        public void bytesRead(long bytes) {
            if (bytes > 0L) {
                this.bytesRead.addAndGet(bytes);
                this.totalBytesRead.addAndGet(bytes);
            }
        }

        @Override
        public void readOperationStarted(long pos, long len) {
            this.readOperations.incrementAndGet();
        }

        @Override
        public void readOperationCompleted(int requested, int actual) {
            if (requested > actual) {
                this.readsIncomplete.incrementAndGet();
            }
        }

        @Override
        public void close() {
            IOStatisticsStore ioStatistics = this.localIOStatistics();
            this.promoteInputStreamCountersToMetrics();
            this.mergedStats = IOStatisticsSupport.snapshotIOStatistics((IOStatistics)this.localIOStatistics());
            GhfsInstrumentation.this.getIOStatistics().aggregate((IOStatistics)ioStatistics);
        }

        @Override
        public long getCloseOperations() {
            return this.lookupCounterValue("stream_read_close_operations");
        }

        @Override
        public long getForwardSeekOperations() {
            return this.lookupCounterValue("stream_read_seek_forward_operations");
        }

        @Override
        public long getBackwardSeekOperations() {
            return this.lookupCounterValue("stream_read_seek_backward_operations");
        }

        @Override
        public long getBytesRead() {
            return this.lookupCounterValue("stream_read_bytes");
        }

        @Override
        public long getTotalBytesRead() {
            return this.lookupCounterValue("stream_read_total_bytes");
        }

        @Override
        public long getBytesSkippedOnSeek() {
            return this.lookupCounterValue("stream_read_seek_bytes_skipped");
        }

        @Override
        public long getBytesBackwardsOnSeek() {
            return this.lookupCounterValue("stream_read_bytes_backwards_on_seek");
        }

        @Override
        public long getSeekOperations() {
            return this.lookupCounterValue("stream_read_seek_operations");
        }

        @Override
        public long getReadExceptions() {
            return this.lookupCounterValue("stream_read_exceptions");
        }

        @Override
        public long getReadOperations() {
            return this.lookupCounterValue("stream_read_operations");
        }

        @Override
        public long getReadsIncomplete() {
            return this.lookupCounterValue("stream_read_operations_incomplete");
        }

        private void promoteInputStreamCountersToMetrics() {
            this.localIOStatistics().counters().keySet().forEach(this::promoteIOCounter);
        }

        void promoteIOCounter(String name) {
            GhfsInstrumentation.this.incrementMutableCounter(name, this.lookupCounterValue(name) - (Long)this.mergedStats.counters().get(name));
        }
    }

    private final class MetricDurationTrackerFactory
    implements DurationTrackerFactory {
        private MetricDurationTrackerFactory() {
        }

        public DurationTracker trackDuration(String key, long count) {
            return new MetricUpdatingDurationTracker(key, count);
        }
    }

    private final class MetricUpdatingDurationTracker
    implements DurationTracker {
        private final String symbol;
        private boolean failed;

        private MetricUpdatingDurationTracker(String symbol, long count) {
            this.symbol = symbol;
            GhfsInstrumentation.this.incrementMutableCounter(symbol, count);
        }

        public void failed() {
            this.failed = true;
        }

        public void close() {
            if (this.failed) {
                GhfsInstrumentation.this.incrementMutableCounter(this.symbol + ".failures", 1L);
            }
        }
    }
}

