/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GhfsInputStreamStatistics;
import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;

class GoogleHadoopFSInputStream
extends FSInputStream
implements IOStatisticsSource {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final byte[] singleReadBuf = new byte[1];
    private final URI gcsPath;
    private final SeekableByteChannel channel;
    private long totalBytesRead = 0L;
    private volatile boolean closed;
    private final FileSystem.Statistics statistics;
    private final GhfsInputStreamStatistics streamStatistics;

    static GoogleHadoopFSInputStream create(GoogleHadoopFileSystem ghfs, URI gcsPath, FileSystem.Statistics statistics) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("create(gcsPath: %s)", gcsPath);
        GoogleCloudStorageFileSystem gcsFs = ghfs.getGcsFs();
        SeekableByteChannel channel = gcsFs.open(gcsPath, gcsFs.getOptions().getCloudStorageOptions().getReadChannelOptions());
        return new GoogleHadoopFSInputStream(ghfs, gcsPath, channel, statistics);
    }

    static GoogleHadoopFSInputStream create(GoogleHadoopFileSystem ghfs, FileInfo fileInfo, FileSystem.Statistics statistics) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("create(fileInfo: %s)", fileInfo);
        GoogleCloudStorageFileSystem gcsFs = ghfs.getGcsFs();
        SeekableByteChannel channel = gcsFs.open(fileInfo, gcsFs.getOptions().getCloudStorageOptions().getReadChannelOptions());
        return new GoogleHadoopFSInputStream(ghfs, fileInfo.getPath(), channel, statistics);
    }

    private GoogleHadoopFSInputStream(GoogleHadoopFileSystem ghfs, URI gcsPath, SeekableByteChannel channel, FileSystem.Statistics statistics) {
        ((GoogleLogger.Api)logger.atFiner()).log("GoogleHadoopFSInputStream(gcsPath: %s)", gcsPath);
        this.gcsPath = gcsPath;
        this.channel = channel;
        this.statistics = statistics;
        this.streamStatistics = ghfs.getInstrumentation().newInputStreamStatistics(statistics);
    }

    public synchronized int read() throws IOException {
        this.checkNotClosed();
        int numRead = this.read(this.singleReadBuf, 0, 1);
        Preconditions.checkState(numRead == -1 || numRead == 1, "Read %s bytes using single-byte buffer for path %s ending in position %s", (Object)numRead, (Object)this.gcsPath, (Object)this.channel.position());
        return numRead > 0 ? this.singleReadBuf[0] & 0xFF : numRead;
    }

    public synchronized int read(@Nonnull byte[] buf, int offset, int length) throws IOException {
        return (Integer)IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.streamStatistics, (String)GhfsStatistic.STREAM_READ_OPERATIONS.getSymbol(), () -> {
            this.checkNotClosed();
            Preconditions.checkNotNull(buf, "buf must not be null");
            if (offset < 0 || length < 0 || length > buf.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            int response = 0;
            try {
                int numRead = this.channel.read(ByteBuffer.wrap(buf, offset, length));
                if (numRead > 0) {
                    this.totalBytesRead += (long)numRead;
                    this.statistics.incrementBytesRead((long)numRead);
                    this.statistics.incrementReadOps(1);
                }
                response = numRead;
            }
            catch (IOException e) {
                this.streamStatistics.readException();
            }
            this.streamStatistics.bytesRead(Math.max(response, 0));
            this.streamStatistics.readOperationCompleted(length, Math.max(response, 0));
            return response;
        });
    }

    public synchronized void seek(long pos) throws IOException {
        IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.streamStatistics, (String)GhfsStatistic.STREAM_READ_SEEK_OPERATIONS.getSymbol(), () -> {
            this.checkNotClosed();
            ((GoogleLogger.Api)logger.atFiner()).log("seek(%d)", pos);
            long curPos = this.getPos();
            long diff = pos - curPos;
            if (diff > 0L) {
                this.streamStatistics.seekForwards(diff);
            } else {
                this.streamStatistics.seekBackwards(diff);
            }
            try {
                this.channel.position(pos);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            return null;
        });
    }

    public synchronized void close() throws IOException {
        boolean isClosed = this.closed;
        IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.streamStatistics, (String)GhfsStatistic.STREAM_READ_CLOSE_OPERATIONS.getSymbol(), () -> {
            if (!this.closed) {
                this.closed = true;
                ((GoogleLogger.Api)logger.atFiner()).log("close(): %s", this.gcsPath);
                if (this.channel != null) {
                    ((GoogleLogger.Api)logger.atFiner()).log("Closing '%s' file with %d total bytes read", (Object)this.gcsPath, this.totalBytesRead);
                    this.channel.close();
                }
            }
            return null;
        });
        if (!isClosed) {
            this.streamStatistics.close();
        }
    }

    public synchronized long getPos() throws IOException {
        this.checkNotClosed();
        long pos = this.channel.position();
        ((GoogleLogger.Api)logger.atFiner()).log("getPos(): %d", pos);
        return pos;
    }

    public boolean seekToNewSource(long targetPos) {
        ((GoogleLogger.Api)logger.atFiner()).log("seekToNewSource(%d): false", targetPos);
        return false;
    }

    public int available() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("available()");
        this.checkNotClosed();
        return 0;
    }

    public IOStatistics getIOStatistics() {
        return this.streamStatistics.getIOStatistics();
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException(this.gcsPath + ": Stream is closed!");
        }
    }
}

