/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.NoCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.AutoBuilder_GoogleCloudStorageClientImpl_Builder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcTracingInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientReadChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GrpcErrorTypeExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSessionConfigs;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.util.AccessBoundary;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@VisibleForTesting
public class GoogleCloudStorageClientImpl
extends ForwardingGoogleCloudStorage {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final GoogleCloudStorageOptions storageOptions;
    private final Storage storage;
    private static final ErrorTypeExtractor errorExtractor = GrpcErrorTypeExtractor.INSTANCE;
    private ExecutorService backgroundTasksThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcsio-storage-client-write-channel-pool-%d").setDaemon(true).build());

    GoogleCloudStorageClientImpl(GoogleCloudStorageOptions options, @Nullable Storage clientLibraryStorage, @Nullable Credentials credentials, @Nullable HttpTransport httpTransport, @Nullable HttpRequestInitializer httpRequestInitializer, @Nullable ImmutableList<ClientInterceptor> gRPCInterceptors, @Nullable Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        super(GoogleCloudStorageImpl.builder().setOptions(options).setCredentials(credentials).setHttpTransport(httpTransport).setHttpRequestInitializer(httpRequestInitializer).setDownscopedAccessTokenFn(downscopedAccessTokenFn).build());
        this.storageOptions = options;
        this.storage = clientLibraryStorage == null ? GoogleCloudStorageClientImpl.createStorage(credentials, options, gRPCInterceptors) : clientLibraryStorage;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("create(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        StorageResourceId resourceIdWithGeneration = resourceId;
        if (!resourceId.hasGenerationId()) {
            resourceIdWithGeneration = new StorageResourceId(resourceId.getBucketName(), resourceId.getObjectName(), this.getWriteGeneration(resourceId, options.isOverwriteExisting()));
        }
        GoogleCloudStorageClientWriteChannel channel = new GoogleCloudStorageClientWriteChannel(this.storage, this.storageOptions, resourceIdWithGeneration, options, this.backgroundTasksThreadPool);
        channel.initialize();
        return channel;
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)resourceId, (Object)readOptions);
        return this.open(resourceId, null, readOptions);
    }

    @Override
    public SeekableByteChannel open(GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)itemInfo, (Object)readOptions);
        Preconditions.checkNotNull(itemInfo, "itemInfo should not be null");
        StorageResourceId resourceId = itemInfo.getResourceId();
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        return this.open(resourceId, itemInfo, readOptions);
    }

    private SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        return new GoogleCloudStorageClientReadChannel(this.storage, itemInfo == null ? this.getItemInfo(resourceId) : itemInfo, readOptions, errorExtractor, this.storageOptions);
    }

    @Override
    public void close() {
        try {
            try {
                this.storage.close();
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Error occurred while closing the storage client");
            }
            try {
                super.close();
            }
            finally {
                this.backgroundTasksThreadPool.shutdown();
            }
        }
        finally {
            this.backgroundTasksThreadPool = null;
        }
    }

    private long getWriteGeneration(StorageResourceId resourceId, boolean overwrite) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getWriteGeneration(%s, %s)", (Object)resourceId, overwrite);
        GoogleCloudStorageItemInfo info = this.getItemInfo(resourceId);
        if (!info.exists()) {
            return 0L;
        }
        if (info.exists() && overwrite) {
            long generation = info.getContentGeneration();
            Preconditions.checkState(generation != 0L, "Generation should not be 0 for an existing item");
            return generation;
        }
        throw new FileAlreadyExistsException(String.format("Object %s already exists.", resourceId));
    }

    private static Storage createStorage(Credentials credentials, GoogleCloudStorageOptions storageOptions, List<ClientInterceptor> interceptors) {
        return (Storage)StorageOptions.grpc().setAttemptDirectPath(storageOptions.isDirectPathPreferred()).setHeaderProvider(() -> storageOptions.getHttpRequestHeaders()).setGrpcInterceptorProvider(() -> {
            ArrayList<GoogleCloudStorageClientGrpcTracingInterceptor> list = new ArrayList<GoogleCloudStorageClientGrpcTracingInterceptor>();
            if (interceptors != null && !interceptors.isEmpty()) {
                list.addAll(interceptors.stream().filter(x -> x != null).collect(Collectors.toList()));
            }
            if (storageOptions.isTraceLogEnabled()) {
                list.add(new GoogleCloudStorageClientGrpcTracingInterceptor());
            }
            return ImmutableList.copyOf(list);
        }).setCredentials(credentials != null ? credentials : NoCredentials.getInstance()).setBlobWriteSessionConfig(BlobWriteSessionConfigs.getDefault().withChunkSize(storageOptions.getWriteChannelOptions().getUploadChunkSize())).build().getService();
    }

    public static Builder builder() {
        return new AutoBuilder_GoogleCloudStorageClientImpl_Builder();
    }

    @AutoBuilder(ofClass=GoogleCloudStorageClientImpl.class)
    public static abstract class Builder {
        public abstract Builder setOptions(GoogleCloudStorageOptions var1);

        public abstract Builder setHttpTransport(@Nullable HttpTransport var1);

        public abstract Builder setCredentials(@Nullable Credentials var1);

        @VisibleForTesting
        public abstract Builder setHttpRequestInitializer(@Nullable HttpRequestInitializer var1);

        public abstract Builder setDownscopedAccessTokenFn(@Nullable Function<List<AccessBoundary>, String> var1);

        public abstract Builder setGRPCInterceptors(@Nullable ImmutableList<ClientInterceptor> var1);

        @VisibleForTesting
        public abstract Builder setClientLibraryStorage(@Nullable Storage var1);

        public abstract GoogleCloudStorageClientImpl build() throws IOException;
    }
}

