/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.annotation.Nullable;

final class AutoValue_RequesterPaysOptions
extends RequesterPaysOptions {
    private final RequesterPaysOptions.RequesterPaysMode mode;
    private final String projectId;
    private final ImmutableSet<String> buckets;

    private AutoValue_RequesterPaysOptions(RequesterPaysOptions.RequesterPaysMode mode, @Nullable String projectId, ImmutableSet<String> buckets) {
        this.mode = mode;
        this.projectId = projectId;
        this.buckets = buckets;
    }

    @Override
    public RequesterPaysOptions.RequesterPaysMode getMode() {
        return this.mode;
    }

    @Override
    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public ImmutableSet<String> getBuckets() {
        return this.buckets;
    }

    public String toString() {
        return "RequesterPaysOptions{mode=" + this.mode + ", projectId=" + this.projectId + ", buckets=" + this.buckets + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RequesterPaysOptions) {
            RequesterPaysOptions that = (RequesterPaysOptions)o;
            return this.mode.equals((Object)that.getMode()) && (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId())) && this.buckets.equals(that.getBuckets());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.mode.hashCode();
        h$ *= 1000003;
        h$ ^= this.projectId == null ? 0 : this.projectId.hashCode();
        h$ *= 1000003;
        return h$ ^= this.buckets.hashCode();
    }

    @Override
    public RequesterPaysOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends RequesterPaysOptions.Builder {
        private RequesterPaysOptions.RequesterPaysMode mode;
        private String projectId;
        private ImmutableSet<String> buckets;

        Builder() {
        }

        private Builder(RequesterPaysOptions source) {
            this.mode = source.getMode();
            this.projectId = source.getProjectId();
            this.buckets = source.getBuckets();
        }

        @Override
        public RequesterPaysOptions.Builder setMode(RequesterPaysOptions.RequesterPaysMode mode) {
            if (mode == null) {
                throw new NullPointerException("Null mode");
            }
            this.mode = mode;
            return this;
        }

        @Override
        public RequesterPaysOptions.Builder setProjectId(@Nullable String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public RequesterPaysOptions.Builder setBuckets(Collection<String> buckets) {
            this.buckets = ImmutableSet.copyOf(buckets);
            return this;
        }

        @Override
        public RequesterPaysOptions.Builder setBuckets(String ... buckets) {
            this.buckets = ImmutableSet.copyOf(buckets);
            return this;
        }

        @Override
        public RequesterPaysOptions build() {
            if (this.mode == null || this.buckets == null) {
                StringBuilder missing = new StringBuilder();
                if (this.mode == null) {
                    missing.append(" mode");
                }
                if (this.buckets == null) {
                    missing.append(" buckets");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RequesterPaysOptions(this.mode, this.projectId, this.buckets);
        }
    }
}

