/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpHeaders;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpIOExceptionHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpStatusCodes;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.ExponentialBackOff;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.interceptors.InvocationIdInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.LogContext;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class RetryHttpInitializer
implements HttpRequestInitializer {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final ExponentialBackOff.Builder BACKOFF_BUILDER = new ExponentialBackOff.Builder().setInitialIntervalMillis(1250).setMultiplier(1.6).setRandomizationFactor(0.2).setMaxIntervalMillis(20000).setMaxElapsedTimeMillis(1800000);
    private final HttpCredentialsAdapter credentials;
    private final RetryHttpInitializerOptions options;

    public RetryHttpInitializer(Credentials credentials, RetryHttpInitializerOptions options) {
        this.credentials = credentials == null ? null : new HttpCredentialsAdapter(credentials);
        this.options = options;
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        if (this.credentials != null) {
            this.credentials.initialize(request);
        }
        request.setNumberOfRetries(this.options.getMaxRequestRetries()).setConnectTimeout(Math.toIntExact(this.options.getConnectTimeout().toMillis())).setReadTimeout(Math.toIntExact(this.options.getReadTimeout().toMillis())).setUnsuccessfulResponseHandler(new UnsuccessfulResponseHandler(this.credentials)).setIOExceptionHandler(new IoExceptionHandler());
        HttpHeaders headers = request.getHeaders();
        if (Strings.isNullOrEmpty(headers.getUserAgent()) && !Strings.isNullOrEmpty(this.options.getDefaultUserAgent())) {
            ((GoogleLogger.Api)logger.atFiner()).log("Request is missing a user-agent header, adding default value of '%s'", this.options.getDefaultUserAgent());
            headers.setUserAgent(this.options.getDefaultUserAgent());
        }
        headers.putAll((Map<? extends String, ?>)this.options.getHttpHeaders());
        request.setInterceptor(new InvocationIdInterceptor(request.getInterceptor()));
    }

    public Credentials getCredentials() {
        return this.credentials == null ? null : this.credentials.getCredentials();
    }

    private static class IoExceptionHandler
    implements HttpIOExceptionHandler {
        private final HttpIOExceptionHandler delegate = new HttpBackOffIOExceptionHandler(BACKOFF_BUILDER.build());

        @Override
        public boolean handleIOException(HttpRequest httpRequest, boolean supportsRetry) throws IOException {
            ((GoogleLogger.Api)logger.atFine()).log("Encountered an IOException when accessing URL %s", httpRequest.getUrl());
            return this.delegate.handleIOException(httpRequest, supportsRetry);
        }
    }

    private static class UnsuccessfulResponseHandler
    implements HttpUnsuccessfulResponseHandler {
        private static final int HTTP_SC_GONE = 410;
        private static final int HTTP_SC_TOO_MANY_REQUESTS = 429;
        private static final int HTTP_REQUEST_TIMEOUT = 408;
        private static final Set<Integer> RETRYABLE_CODES = ImmutableSet.of(Integer.valueOf(429), Integer.valueOf(408));
        private static final ImmutableSet<Integer> RESPONSE_CODES_TO_LOG_WITH_RATE_LIMIT = ImmutableSet.of(Integer.valueOf(429));
        private static final ImmutableSet<Integer> RESPONSE_CODES_TO_LOG = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(RESPONSE_CODES_TO_LOG_WITH_RATE_LIMIT)).add(new Integer[]{410, 503})).build();
        private static final HttpBackOffUnsuccessfulResponseHandler.BackOffRequired BACK_OFF_REQUIRED = response -> RETRYABLE_CODES.contains(response.getStatusCode()) || HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ON_SERVER_ERROR.isRequired(response);
        private final HttpCredentialsAdapter credentials;
        private final HttpBackOffUnsuccessfulResponseHandler delegate;

        public UnsuccessfulResponseHandler(HttpCredentialsAdapter credentials) {
            this.credentials = credentials;
            this.delegate = new HttpBackOffUnsuccessfulResponseHandler(BACKOFF_BUILDER.build()).setBackOffRequired(BACK_OFF_REQUIRED);
        }

        @Override
        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
            this.logResponseCode(request, response);
            if (this.credentials != null && this.credentials.handleResponse(request, response, supportsRetry)) {
                return true;
            }
            if (this.delegate.handleResponse(request, response, supportsRetry)) {
                return true;
            }
            this.escapeRedirectPath(request, response);
            return false;
        }

        private void logResponseCode(HttpRequest request, HttpResponse response) {
            if (RESPONSE_CODES_TO_LOG.contains(response.getStatusCode())) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).with(LogContext.Key.LOG_SITE_GROUPING_KEY, response.getStatusCode())).atMostEvery(RESPONSE_CODES_TO_LOG_WITH_RATE_LIMIT.contains(response.getStatusCode()) ? 10 : 0, TimeUnit.SECONDS)).log("Encountered status code %d when sending %s request to URL '%s'. Delegating to response handler for possible retry.", response.getStatusCode(), request.getRequestMethod(), request.getUrl());
            }
        }

        private void escapeRedirectPath(HttpRequest request, HttpResponse response) {
            String redirectLocation;
            if (HttpStatusCodes.isRedirect(response.getStatusCode()) && request.getFollowRedirects() && response.getHeaders() != null && response.getHeaders().getLocation() != null && (redirectLocation = response.getHeaders().getLocation()).contains("+")) {
                String escapedLocation = redirectLocation.replace("+", "%2B");
                ((GoogleLogger.Api)logger.atFine()).log("Redirect path '%s' contains unescaped '+', replacing with '%%2B': '%s'", (Object)redirectLocation, (Object)escapedLocation);
                response.getHeaders().setLocation(escapedLocation);
            }
        }
    }
}

