/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CanonicalExtensionHeadersSerializer {
    private static final char HEADER_SEPARATOR = ':';
    private static final char HEADER_NAME_SEPARATOR = ';';
    private final Storage.SignUrlOption.SignatureVersion signatureVersion;

    public CanonicalExtensionHeadersSerializer(Storage.SignUrlOption.SignatureVersion signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    public CanonicalExtensionHeadersSerializer() {
        this.signatureVersion = Storage.SignUrlOption.SignatureVersion.V2;
    }

    public StringBuilder serialize(Map<String, String> canonicalizedExtensionHeaders) {
        StringBuilder serializedHeaders = new StringBuilder();
        if (canonicalizedExtensionHeaders == null || canonicalizedExtensionHeaders.isEmpty()) {
            return serializedHeaders;
        }
        Map<String, String> lowercaseHeaders = this.getLowercaseHeaders(canonicalizedExtensionHeaders);
        ArrayList<String> sortedHeaderNames = new ArrayList<String>(lowercaseHeaders.keySet());
        Collections.sort(sortedHeaderNames);
        for (String headerName : sortedHeaderNames) {
            serializedHeaders.append(headerName).append(':').append(lowercaseHeaders.get(headerName).trim().replaceAll("\\s+", " ")).append('\n');
        }
        return serializedHeaders;
    }

    public StringBuilder serializeHeaderNames(Map<String, String> canonicalizedExtensionHeaders) {
        StringBuilder serializedHeaders = new StringBuilder();
        if (canonicalizedExtensionHeaders == null || canonicalizedExtensionHeaders.isEmpty()) {
            return serializedHeaders;
        }
        Map<String, String> lowercaseHeaders = this.getLowercaseHeaders(canonicalizedExtensionHeaders);
        ArrayList<String> sortedHeaderNames = new ArrayList<String>(lowercaseHeaders.keySet());
        Collections.sort(sortedHeaderNames);
        for (String headerName : sortedHeaderNames) {
            serializedHeaders.append(headerName).append(';');
        }
        serializedHeaders.setLength(serializedHeaders.length() - 1);
        return serializedHeaders;
    }

    private Map<String, String> getLowercaseHeaders(Map<String, String> canonicalizedExtensionHeaders) {
        HashMap<String, String> lowercaseHeaders = new HashMap<String, String>();
        for (String headerName : new ArrayList<String>(canonicalizedExtensionHeaders.keySet())) {
            String lowercaseHeaderName = headerName.toLowerCase();
            if (Storage.SignUrlOption.SignatureVersion.V2.equals((Object)this.signatureVersion) && ("x-goog-encryption-key".equals(lowercaseHeaderName) || "x-goog-encryption-key-sha256".equals(lowercaseHeaderName))) continue;
            lowercaseHeaders.put(lowercaseHeaderName, canonicalizedExtensionHeaders.get(headerName));
        }
        return lowercaseHeaders;
    }
}

