/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ThroughputSink;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;

final class RecoveryFile
implements AutoCloseable {
    private static final Set<OpenOption> writeOps = ImmutableSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    private static final Set<OpenOption> readOps = ImmutableSet.of(StandardOpenOption.READ);
    private final Path path;
    private final ThroughputSink throughputSink;
    private final Runnable onCloseCallback;

    RecoveryFile(Path path, ThroughputSink throughputSink, Runnable onCloseCallback) {
        this.path = path;
        this.throughputSink = throughputSink;
        this.onCloseCallback = onCloseCallback;
    }

    public Path getPath() {
        return this.path;
    }

    public Path touch() throws IOException {
        return Files.createFile(this.path, new FileAttribute[0]);
    }

    public SeekableByteChannel reader() throws IOException {
        return Files.newByteChannel(this.path, readOps, new FileAttribute[0]);
    }

    public WritableByteChannel writer() throws IOException {
        return this.throughputSink.decorate(Files.newByteChannel(this.path, writeOps, new FileAttribute[0]));
    }

    @Override
    public void close() throws IOException {
        Files.delete(this.path);
        this.onCloseCallback.run();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("path", this.path).add("throughputSink", this.throughputSink).add("onCloseCallback", this.onCloseCallback).toString();
    }

    Unsafe unsafe() {
        return new Unsafe();
    }

    final class Unsafe {
        Unsafe() {
        }

        public Path touch() throws UnsafeIOException {
            try {
                return RecoveryFile.this.touch();
            }
            catch (IOException e) {
                throw new UnsafeIOException(e);
            }
        }
    }

    static final class UnsafeIOException
    extends RuntimeException {
        private UnsafeIOException(IOException cause) {
            super(cause);
        }
    }
}

