/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.RecoveryFile;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ThroughputSink;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class RecoveryFileManager {
    private final ImmutableList<RecoveryVolume> volumes;
    private final Map<BlobInfo, RecoveryFile> files;
    private int nextVolumeIndex;

    private RecoveryFileManager(List<RecoveryVolume> volumes) {
        this.volumes = ImmutableList.copyOf(volumes);
        this.files = Collections.synchronizedMap(new HashMap());
        this.nextVolumeIndex = 0;
    }

    public RecoveryFile newRecoveryFile(BlobInfo info) {
        int i = this.getNextVolumeIndex();
        RecoveryVolume v = (RecoveryVolume)this.volumes.get(i);
        int hashCode = info.hashCode();
        String fileName = Base64.getUrlEncoder().encodeToString(Ints.toByteArray(hashCode));
        Path path = v.basePath.resolve(fileName);
        RecoveryFile recoveryFile = new RecoveryFile(path, v.sink, () -> this.files.remove(info));
        this.files.put(info, recoveryFile);
        return recoveryFile;
    }

    private synchronized int getNextVolumeIndex() {
        this.nextVolumeIndex = (this.nextVolumeIndex + 1) % this.volumes.size();
        return this.nextVolumeIndex;
    }

    static RecoveryFileManager of(List<Path> volumes) throws IOException {
        return RecoveryFileManager.of(volumes, p -> ThroughputSink.nullSink());
    }

    static RecoveryFileManager of(List<Path> volumes, RecoverVolumeSinkFactory factory) throws IOException {
        Preconditions.checkArgument(!volumes.isEmpty(), "At least one volume must be specified");
        Preconditions.checkArgument(volumes.stream().allMatch(p -> !Files.exists(p, new LinkOption[0]) || Files.isDirectory(p, new LinkOption[0])), "All provided volumes must either:\n1. Not yet exists\n2. Be directories");
        for (Path v : volumes) {
            if (Files.exists(v, new LinkOption[0])) continue;
            Files.createDirectories(v, new FileAttribute[0]);
        }
        ImmutableList<RecoveryVolume> recoveryVolumes = volumes.stream().map(p -> RecoveryVolume.of(p, factory.apply((Path)p))).collect(ImmutableList.toImmutableList());
        return new RecoveryFileManager(recoveryVolumes);
    }

    static final class RecoveryVolume {
        private final Path basePath;
        private final ThroughputSink sink;

        private RecoveryVolume(Path basePath, ThroughputSink sink) {
            this.basePath = basePath;
            this.sink = sink;
        }

        public static RecoveryVolume of(Path basePath, ThroughputSink sink) {
            return new RecoveryVolume(basePath, sink);
        }
    }

    @FunctionalInterface
    static interface RecoverVolumeSinkFactory {
        public ThroughputSink apply(Path var1);
    }
}

