/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.orca;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientStreamTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ExperimentalApi;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ForwardingClientStreamTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.protobuf.ProtoUtils;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.services.InternalCallMetricRecorder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.services.MetricReport;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.shaded.com.github.xds.data.orca.v3.OrcaLoadReport;
import java.util.ArrayList;
import java.util.List;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9128")
public abstract class OrcaPerRequestUtil {
    private static final ClientStreamTracer NOOP_CLIENT_STREAM_TRACER = new ClientStreamTracer(){};
    private static final ClientStreamTracer.Factory NOOP_CLIENT_STREAM_TRACER_FACTORY = new ClientStreamTracer.Factory(){

        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            return NOOP_CLIENT_STREAM_TRACER;
        }
    };
    private static final OrcaPerRequestUtil DEFAULT_INSTANCE = new OrcaPerRequestUtil(){

        @Override
        public ClientStreamTracer.Factory newOrcaClientStreamTracerFactory(OrcaPerRequestReportListener listener) {
            return this.newOrcaClientStreamTracerFactory(NOOP_CLIENT_STREAM_TRACER_FACTORY, listener);
        }

        @Override
        public ClientStreamTracer.Factory newOrcaClientStreamTracerFactory(ClientStreamTracer.Factory delegate, OrcaPerRequestReportListener listener) {
            return new OrcaReportingTracerFactory(delegate, listener);
        }
    };

    public static OrcaPerRequestUtil getInstance() {
        return DEFAULT_INSTANCE;
    }

    public abstract ClientStreamTracer.Factory newOrcaClientStreamTracerFactory(OrcaPerRequestReportListener var1);

    public abstract ClientStreamTracer.Factory newOrcaClientStreamTracerFactory(ClientStreamTracer.Factory var1, OrcaPerRequestReportListener var2);

    static MetricReport fromOrcaLoadReport(OrcaLoadReport loadReport) {
        return InternalCallMetricRecorder.createMetricReport(loadReport.getCpuUtilization(), loadReport.getApplicationUtilization(), loadReport.getMemUtilization(), loadReport.getRpsFractional(), loadReport.getEps(), loadReport.getRequestCostMap(), loadReport.getUtilizationMap());
    }

    private static final class OrcaReportBroker {
        private final List<OrcaPerRequestReportListener> listeners = new ArrayList<OrcaPerRequestReportListener>();

        private OrcaReportBroker() {
        }

        void addListener(OrcaPerRequestReportListener listener) {
            this.listeners.add(listener);
        }

        void onReport(OrcaLoadReport report) {
            MetricReport metricReport = OrcaPerRequestUtil.fromOrcaLoadReport(report);
            for (OrcaPerRequestReportListener listener : this.listeners) {
                listener.onLoadReport(metricReport);
            }
        }
    }

    @VisibleForTesting
    static final class OrcaReportingTracerFactory
    extends ClientStreamTracer.Factory {
        @VisibleForTesting
        static final Metadata.Key<OrcaLoadReport> ORCA_ENDPOINT_LOAD_METRICS_KEY = Metadata.Key.of("endpoint-load-metrics-bin", ProtoUtils.metadataMarshaller(OrcaLoadReport.getDefaultInstance()));
        private static final CallOptions.Key<OrcaReportBroker> ORCA_REPORT_BROKER_KEY = CallOptions.Key.create("internal-orca-report-broker");
        private final ClientStreamTracer.Factory delegate;
        private final OrcaPerRequestReportListener listener;

        OrcaReportingTracerFactory(ClientStreamTracer.Factory delegate, OrcaPerRequestReportListener listener) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.listener = Preconditions.checkNotNull(listener, "listener");
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            OrcaReportBroker broker = info.getCallOptions().getOption(ORCA_REPORT_BROKER_KEY);
            boolean augmented = false;
            if (broker == null) {
                broker = new OrcaReportBroker();
                info = info.toBuilder().setCallOptions(info.getCallOptions().withOption(ORCA_REPORT_BROKER_KEY, broker)).build();
                augmented = true;
            }
            broker.addListener(this.listener);
            ClientStreamTracer tracer = this.delegate.newClientStreamTracer(info, headers);
            if (augmented) {
                final ClientStreamTracer currTracer = tracer;
                final OrcaReportBroker currBroker = broker;
                tracer = new ForwardingClientStreamTracer(){

                    @Override
                    protected ClientStreamTracer delegate() {
                        return currTracer;
                    }

                    @Override
                    public void inboundTrailers(Metadata trailers) {
                        OrcaLoadReport report = trailers.get(ORCA_ENDPOINT_LOAD_METRICS_KEY);
                        if (report != null) {
                            currBroker.onReport(report);
                        }
                        this.delegate().inboundTrailers(trailers);
                    }
                };
            }
            return tracer;
        }
    }

    public static interface OrcaPerRequestReportListener {
        public void onLoadReport(MetricReport var1);
    }
}

