/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.HadoopConfigurationProperty;
import com.google.cloud.hadoop.fs.gcs.VectoredReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HadoopCredentialsConfiguration;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class GoogleHadoopFileSystemConfiguration {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String GCS_CONFIG_PREFIX = "fs.gs";
    public static final List<String> CONFIG_KEY_PREFIXES = ImmutableList.copyOf(HadoopCredentialsConfiguration.getConfigKeyPrefixes("fs.gs"));
    public static final HadoopConfigurationProperty<String> GCS_ROOT_URL = new HadoopConfigurationProperty<String>("fs.gs.storage.root.url", GoogleCloudStorageOptions.DEFAULT.getStorageRootUrl(), new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_SERVICE_PATH = new HadoopConfigurationProperty<String>("fs.gs.storage.service.path", GoogleCloudStorageOptions.DEFAULT.getStorageServicePath(), new String[0]);
    public static final HadoopConfigurationProperty<String> PERMISSIONS_TO_REPORT = new HadoopConfigurationProperty<String>("fs.gs.reported.permissions", "700", new String[0]);
    public static final HadoopConfigurationProperty<Long> BLOCK_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.block.size", 0x4000000L, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_HIERARCHICAL_NAMESPACE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.hierarchical.namespace.folders.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<String> DELEGATION_TOKEN_BINDING_CLASS = new HadoopConfigurationProperty("fs.gs.delegation.token.binding");
    public static final HadoopConfigurationProperty<String> GCS_PROJECT_ID = new HadoopConfigurationProperty("fs.gs.project.id");
    public static final HadoopConfigurationProperty<String> GCS_WORKING_DIRECTORY = new HadoopConfigurationProperty<String>("fs.gs.working.dir", "/", new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCE_BUCKET_DELETE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.bucket.delete.enable", GoogleCloudStorageFileSystemOptions.DEFAULT.isBucketDeleteEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<RequesterPaysOptions.RequesterPaysMode> GCS_REQUESTER_PAYS_MODE = new HadoopConfigurationProperty<RequesterPaysOptions.RequesterPaysMode>("fs.gs.requester.pays.mode", RequesterPaysOptions.DEFAULT.getMode(), new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_REQUESTER_PAYS_PROJECT_ID = new HadoopConfigurationProperty("fs.gs.requester.pays.project.id");
    public static final HadoopConfigurationProperty<Collection<String>> GCS_REQUESTER_PAYS_BUCKETS = new HadoopConfigurationProperty("fs.gs.requester.pays.buckets", ImmutableList.of(), new String[0]);
    public static final HadoopConfigurationProperty<GoogleHadoopFileSystem.GcsFileChecksumType> GCS_FILE_CHECKSUM_TYPE = new HadoopConfigurationProperty<GoogleHadoopFileSystem.GcsFileChecksumType>("fs.gs.checksum.type", GoogleHadoopFileSystem.GcsFileChecksumType.NONE, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_PERFORMANCE_CACHE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.performance.cache.enable", GoogleCloudStorageFileSystemOptions.DEFAULT.isPerformanceCacheEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE = new HadoopConfigurationProperty<Long>("fs.gs.performance.cache.max.entry.age", PerformanceCachingGoogleCloudStorageOptions.DEFAULT.getMaxEntryAge().toMillis(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_STATUS_PARALLEL_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.status.parallel.enable", GoogleCloudStorageFileSystemOptions.DEFAULT.isStatusParallelEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_LAZY_INITIALIZATION_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.lazy.init.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.implicit.dir.repair.enable", GoogleCloudStorageOptions.DEFAULT.isAutoRepairImplicitDirectoriesEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_CREATE_ITEMS_CONFLICT_CHECK_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.create.items.conflict.check.enable", GoogleCloudStorageFileSystemOptions.DEFAULT.isEnsureNoConflictingItems(), new String[0]);
    public static final HadoopConfigurationProperty<GoogleHadoopFileSystem.GlobAlgorithm> GCS_GLOB_ALGORITHM = new HadoopConfigurationProperty<GoogleHadoopFileSystem.GlobAlgorithm>("fs.gs.glob.algorithm", GoogleHadoopFileSystem.GlobAlgorithm.CONCURRENT, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_MARKER_FILE_PATTERN = new HadoopConfigurationProperty("fs.gs.marker.file.pattern");
    public static final HadoopConfigurationProperty<Integer> GCS_MAX_REQUESTS_PER_BATCH = new HadoopConfigurationProperty<Integer>("fs.gs.max.requests.per.batch", GoogleCloudStorageOptions.DEFAULT.getMaxRequestsPerBatch(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_BATCH_THREADS = new HadoopConfigurationProperty<Integer>("fs.gs.batch.threads", GoogleCloudStorageOptions.DEFAULT.getBatchThreads(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_FADVISE_REQUEST_TRACK_COUNT = new HadoopConfigurationProperty<Integer>("fs.gs.fadvise.request.track.count", 3, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_COPY_WITH_REWRITE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.copy.with.rewrite.enable", GoogleCloudStorageOptions.DEFAULT.isCopyWithRewriteEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_REWRITE_MAX_CHUNK_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.rewrite.max.chunk.size", GoogleCloudStorageOptions.DEFAULT.getMaxRewriteChunkSize(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_MAX_LIST_ITEMS_PER_CALL = new HadoopConfigurationProperty<Integer>("fs.gs.list.max.items.per.call", GoogleCloudStorageOptions.DEFAULT.getMaxListItemsPerCall(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_HTTP_MAX_RETRY = new HadoopConfigurationProperty<Integer>("fs.gs.http.max.retry", GoogleCloudStorageOptions.DEFAULT.getMaxHttpRequestRetries(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_HTTP_CONNECT_TIMEOUT = new HadoopConfigurationProperty<Long>("fs.gs.http.connect-timeout", GoogleCloudStorageOptions.DEFAULT.getHttpRequestConnectTimeout().toMillis(), new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_APPLICATION_NAME_SUFFIX = new HadoopConfigurationProperty<String>("fs.gs.application.name.suffix", "", new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_MAX_WAIT_TIME_EMPTY_OBJECT_CREATE = new HadoopConfigurationProperty<Long>("fs.gs.max.wait.for.empty.object.creation", GoogleCloudStorageOptions.DEFAULT.getMaxWaitTimeForEmptyObjectCreation().toMillis(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_OUTPUT_STREAM_BUFFER_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.outputstream.buffer.size", Long.valueOf(AsyncWriteChannelOptions.DEFAULT.getBufferSize()), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_OUTPUT_STREAM_PIPE_BUFFER_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.outputstream.pipe.buffer.size", Long.valueOf(AsyncWriteChannelOptions.DEFAULT.getPipeBufferSize()), new String[0]);
    public static final HadoopConfigurationProperty<AsyncWriteChannelOptions.PipeType> GCS_OUTPUT_STREAM_PIPE_TYPE = new HadoopConfigurationProperty<AsyncWriteChannelOptions.PipeType>("fs.gs.outputstream.pipe.type", AsyncWriteChannelOptions.DEFAULT.getPipeType(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.outputstream.upload.chunk.size", Long.valueOf(AsyncWriteChannelOptions.DEFAULT.getUploadChunkSize()), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_OUTPUT_STREAM_UPLOAD_CACHE_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.outputstream.upload.cache.size", Long.valueOf(AsyncWriteChannelOptions.DEFAULT.getUploadCacheSize()), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_OUTPUT_STREAM_DIRECT_UPLOAD_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.outputstream.direct.upload.enable", AsyncWriteChannelOptions.DEFAULT.isDirectUploadEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_OUTPUT_STREAM_SYNC_MIN_INTERVAL = new HadoopConfigurationProperty<Long>("fs.gs.outputstream.sync.min.interval", CreateFileOptions.DEFAULT.getMinSyncInterval().toMillis(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.inputstream.fast.fail.on.not.found.enable", GoogleCloudStorageReadOptions.DEFAULT.isFastFailOnNotFoundEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_INPUT_STREAM_SUPPORT_GZIP_ENCODING_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.inputstream.support.gzip.encoding.enable", GoogleCloudStorageReadOptions.DEFAULT.isGzipEncodingSupportEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT = new HadoopConfigurationProperty<Long>("fs.gs.inputstream.inplace.seek.limit", GoogleCloudStorageReadOptions.DEFAULT.getInplaceSeekLimit(), new String[0]);
    public static final HadoopConfigurationProperty<GoogleCloudStorageReadOptions.Fadvise> GCS_INPUT_STREAM_FADVISE = new HadoopConfigurationProperty<GoogleCloudStorageReadOptions.Fadvise>("fs.gs.inputstream.fadvise", GoogleCloudStorageReadOptions.DEFAULT.getFadvise(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.inputstream.min.range.request.size", GoogleCloudStorageReadOptions.DEFAULT.getMinRangeRequestSize(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_VECTORED_READ_RANGE_MIN_SEEK = new HadoopConfigurationProperty<Integer>("fs.gs.vectored.read.min.range.seek.size", VectoredReadOptions.DEFAULT.getMinSeekVectoredReadSize(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_VECTORED_READ_MERGED_RANGE_MAX_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.vectored.read.merged.range.max.size", VectoredReadOptions.DEFAULT.getMergeRangeMaxSize(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_VECTORED_READ_THREADS = new HadoopConfigurationProperty<Integer>("fs.gs.vectored.read.threads", VectoredReadOptions.DEFAULT.getReadThreads(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.enable", GoogleCloudStorageOptions.DEFAULT.isGrpcEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_CHECKSUMS_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.checksums.enable", GoogleCloudStorageReadOptions.DEFAULT.isGrpcChecksumsEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_CHECK_INTERVAL_TIMEOUT = new HadoopConfigurationProperty<Long>("fs.gs.grpc.checkinterval.timeout", GoogleCloudStorageOptions.DEFAULT.getGrpcMessageTimeoutCheckInterval().toMillis(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_READ_TIMEOUT = new HadoopConfigurationProperty<Long>("fs.gs.grpc.read.timeout", GoogleCloudStorageReadOptions.DEFAULT.getGrpcReadTimeout().toMillis(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_READ_MESSAGE_TIMEOUT = new HadoopConfigurationProperty<Long>("fs.gs.grpc.read.message.timeout", GoogleCloudStorageReadOptions.DEFAULT.getGrpcReadMessageTimeout().toMillis(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_READ_ZEROCOPY_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.read.zerocopy.enable", GoogleCloudStorageReadOptions.DEFAULT.isGrpcReadZeroCopyEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_GRPC_UPLOAD_BUFFERED_REQUESTS = new HadoopConfigurationProperty<Integer>("fs.gs.grpc.write.buffered.requests", AsyncWriteChannelOptions.DEFAULT.getNumberOfBufferedRequests(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_WRITE_TIMEOUT = new HadoopConfigurationProperty<Long>("fs.gs.grpc.write.timeout", AsyncWriteChannelOptions.DEFAULT.getGrpcWriteTimeout().toMillis(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_WRITE_MESSAGE_TIMEOUT = new HadoopConfigurationProperty<Long>("fs.gs.grpc.write.message.timeout", AsyncWriteChannelOptions.DEFAULT.getGrpcWriteMessageTimeout().toMillis(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_DIRECTPATH_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.directpath.enable", GoogleCloudStorageOptions.DEFAULT.isDirectPathPreferred(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_TRAFFICDIRECTOR_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.trafficdirector.enable", GoogleCloudStorageOptions.DEFAULT.isTrafficDirectorEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Map<String, String>> GCS_HTTP_HEADERS = new HadoopConfigurationProperty<ImmutableMap<String, String>>("fs.gs.storage.http.headers.", GoogleCloudStorageOptions.DEFAULT.getHttpRequestHeaders(), new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_ENCRYPTION_ALGORITHM = new HadoopConfigurationProperty("fs.gs.encryption.algorithm");
    public static final HadoopConfigurationProperty<RedactedString> GCS_ENCRYPTION_KEY = new HadoopConfigurationProperty("fs.gs.encryption.key");
    public static final HadoopConfigurationProperty<RedactedString> GCS_ENCRYPTION_KEY_HASH = new HadoopConfigurationProperty("fs.gs.encryption.key.hash");
    public static final HadoopConfigurationProperty<GoogleCloudStorageOptions.MetricsSink> GCS_METRICS_SINK = new HadoopConfigurationProperty<GoogleCloudStorageOptions.MetricsSink>("fs.gs.metrics.sink", GoogleCloudStorageOptions.DEFAULT.getMetricsSink(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_TRACE_LOG_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.tracelog.enable", GoogleCloudStorageOptions.DEFAULT.isTraceLogEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_OPERATION_TRACE_LOG_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.operation.tracelog.enable", GoogleCloudStorageOptions.DEFAULT.isTraceLogEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_CLOUD_LOGGING_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.cloud.logging.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<GoogleCloudStorageFileSystemOptions.ClientType> GCS_CLIENT_TYPE = new HadoopConfigurationProperty<GoogleCloudStorageFileSystemOptions.ClientType>("fs.gs.client.type", GoogleCloudStorageFileSystemOptions.DEFAULT.getClientType(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_WRITE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.write.enable", GoogleCloudStorageOptions.DEFAULT.isGrpcWriteEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<AsyncWriteChannelOptions.UploadType> GCS_CLIENT_UPLOAD_TYPE = new HadoopConfigurationProperty<AsyncWriteChannelOptions.UploadType>("fs.gs.client.upload.type", AsyncWriteChannelOptions.UploadType.CHUNK_UPLOAD, new String[0]);
    public static final HadoopConfigurationProperty<Collection<String>> GCS_WRITE_TEMPORARY_FILES_PATH = new HadoopConfigurationProperty("fs.gs.write.temporary.dirs", ImmutableSet.of(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_PCU_BUFFER_COUNT = new HadoopConfigurationProperty<Integer>("fs.gs.write.parallel.composite.upload.buffer.count", AsyncWriteChannelOptions.DEFAULT.getPCUBufferCount(), new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_PCU_BUFFER_CAPACITY = new HadoopConfigurationProperty<Long>("fs.gs.write.parallel.composite.upload.buffer.capacity", Long.valueOf(AsyncWriteChannelOptions.DEFAULT.getPCUBufferCapacity()), new String[0]);
    public static final HadoopConfigurationProperty<AsyncWriteChannelOptions.PartFileCleanupType> GCS_PCU_PART_FILE_CLEANUP_TYPE = new HadoopConfigurationProperty<AsyncWriteChannelOptions.PartFileCleanupType>("fs.gs.write.parallel.composite.upload.part.file.cleanup.type", AsyncWriteChannelOptions.DEFAULT.getPartFileCleanupType(), new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_PCU_PART_FILE_NAME_PREFIX = new HadoopConfigurationProperty<String>("fs.gs.write.parallel.composite.upload.part.file.name.prefix", AsyncWriteChannelOptions.DEFAULT.getPartFileNamePrefix(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_WRITE_ROLLING_CHECKSUM_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.write.rolling.checksum.enable", AsyncWriteChannelOptions.DEFAULT.isRollingChecksumEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_HNS_OPTIMIZATION_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.hierarchical.namespace.folders.optimization.enable", GoogleCloudStorageOptions.DEFAULT.isHnOptimizationEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_OPERATION_MOVE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.operation.move.enable", GoogleCloudStorageOptions.DEFAULT.isMoveOperationEnabled(), new String[0]);

    static GoogleCloudStorageFileSystemOptions.Builder getGcsFsOptionsBuilder(Configuration config) {
        return GoogleCloudStorageFileSystemOptions.builder().setBucketDeleteEnabled(GCE_BUCKET_DELETE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setClientType(GCS_CLIENT_TYPE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setCloudStorageOptions(GoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder(config).build()).setEnsureNoConflictingItems(GCS_CREATE_ITEMS_CONFLICT_CHECK_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setMarkerFilePattern(GCS_MARKER_FILE_PATTERN.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setPerformanceCacheEnabled(GCS_PERFORMANCE_CACHE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setPerformanceCacheOptions(GoogleHadoopFileSystemConfiguration.getPerformanceCachingOptions(config)).setStatusParallelEnabled(GCS_STATUS_PARALLEL_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)));
    }

    static VectoredReadOptions.Builder getVectoredReadOptionBuilder(Configuration config) {
        return VectoredReadOptions.builder().setMinSeekVectoredReadSize(GCS_VECTORED_READ_RANGE_MIN_SEEK.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setMergeRangeMaxSize(GCS_VECTORED_READ_MERGED_RANGE_MAX_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setReadThreads(GCS_VECTORED_READ_THREADS.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)));
    }

    @VisibleForTesting
    static GoogleCloudStorageOptions.Builder getGcsOptionsBuilder(Configuration config) {
        String projectId = GCS_PROJECT_ID.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        return GoogleCloudStorageOptions.builder().setAppName(GoogleHadoopFileSystemConfiguration.getApplicationName(config)).setGrpcWriteEnabled(GCS_GRPC_WRITE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setAutoRepairImplicitDirectoriesEnabled(GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setBatchThreads(GCS_BATCH_THREADS.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setCopyWithRewriteEnabled(GCS_COPY_WITH_REWRITE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setDirectPathPreferred(GCS_GRPC_DIRECTPATH_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setEncryptionAlgorithm(GCS_ENCRYPTION_ALGORITHM.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setEncryptionKey(GCS_ENCRYPTION_KEY.getPassword(config)).setEncryptionKeyHash(GCS_ENCRYPTION_KEY_HASH.getPassword(config)).setGrpcEnabled(GCS_GRPC_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setHnBucketRenameEnabled(GCS_HIERARCHICAL_NAMESPACE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setGrpcMessageTimeoutCheckInterval(GCS_GRPC_CHECK_INTERVAL_TIMEOUT.getTimeDuration(config)).setHttpRequestConnectTimeout(GCS_HTTP_CONNECT_TIMEOUT.getTimeDuration(config)).setHttpRequestHeaders(GCS_HTTP_HEADERS.getPropsWithPrefix(config)).setHttpRequestReadTimeout(HadoopCredentialsConfiguration.READ_TIMEOUT_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).getTimeDuration(config)).setMaxHttpRequestRetries(GCS_HTTP_MAX_RETRY.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setMaxListItemsPerCall(GCS_MAX_LIST_ITEMS_PER_CALL.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setMaxRequestsPerBatch(GCS_MAX_REQUESTS_PER_BATCH.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setMaxRewriteChunkSize(GCS_REWRITE_MAX_CHUNK_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getLongBytes(arg_0, arg_1))).setMaxWaitTimeForEmptyObjectCreation(GCS_MAX_WAIT_TIME_EMPTY_OBJECT_CREATE.getTimeDuration(config)).setMetricsSink(GCS_METRICS_SINK.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setProjectId(projectId).setProxyAddress(HadoopCredentialsConfiguration.PROXY_ADDRESS_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setProxyPassword(HadoopCredentialsConfiguration.PROXY_PASSWORD_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).getPassword(config)).setProxyUsername(HadoopCredentialsConfiguration.PROXY_USERNAME_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).getPassword(config)).setReadChannelOptions(GoogleHadoopFileSystemConfiguration.getReadChannelOptions(config)).setRequesterPaysOptions(GoogleHadoopFileSystemConfiguration.getRequesterPaysOptions(config, projectId)).setStorageRootUrl(GCS_ROOT_URL.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setStorageServicePath(GCS_SERVICE_PATH.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setTraceLogEnabled(GCS_TRACE_LOG_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setOperationTraceLogEnabled(GCS_OPERATION_TRACE_LOG_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setTrafficDirectorEnabled(GCS_GRPC_TRAFFICDIRECTOR_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setWriteChannelOptions(GoogleHadoopFileSystemConfiguration.getWriteChannelOptions(config)).setMoveOperationEnabled(GCS_OPERATION_MOVE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setHnOptimizationEnabled(GCS_HNS_OPTIMIZATION_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)));
    }

    @VisibleForTesting
    static PerformanceCachingGoogleCloudStorageOptions getPerformanceCachingOptions(Configuration config) {
        return PerformanceCachingGoogleCloudStorageOptions.builder().setMaxEntryAge(GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE.getTimeDuration(config)).build();
    }

    private static String getApplicationName(Configuration config) {
        String appNameSuffix = Strings.nullToEmpty(GCS_APPLICATION_NAME_SUFFIX.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1)));
        String applicationName = GoogleHadoopFileSystem.GHFS_ID + appNameSuffix;
        ((GoogleLogger.Api)logger.atFiner()).log("getApplicationName(config: %s): %s", (Object)config, (Object)applicationName);
        return applicationName;
    }

    private static GoogleCloudStorageReadOptions getReadChannelOptions(Configuration config) {
        return GoogleCloudStorageReadOptions.builder().setFadvise(GCS_INPUT_STREAM_FADVISE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setFastFailOnNotFoundEnabled(GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setGrpcChecksumsEnabled(GCS_GRPC_CHECKSUMS_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setGrpcReadMessageTimeout(GCS_GRPC_READ_MESSAGE_TIMEOUT.getTimeDuration(config)).setGrpcReadTimeout(GCS_GRPC_READ_TIMEOUT.getTimeDuration(config)).setGrpcReadZeroCopyEnabled(GCS_GRPC_READ_ZEROCOPY_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setGzipEncodingSupportEnabled(GCS_INPUT_STREAM_SUPPORT_GZIP_ENCODING_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setInplaceSeekLimit(GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT.get(config, (arg_0, arg_1) -> ((Configuration)config).getLongBytes(arg_0, arg_1))).setMinRangeRequestSize(GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getLongBytes(arg_0, arg_1))).setBlockSize(BLOCK_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).setFadviseRequestTrackCount(GCS_FADVISE_REQUEST_TRACK_COUNT.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setBlockSize(BLOCK_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).setFadviseRequestTrackCount(GCS_FADVISE_REQUEST_TRACK_COUNT.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).build();
    }

    private static AsyncWriteChannelOptions getWriteChannelOptions(Configuration config) {
        return AsyncWriteChannelOptions.builder().setBufferSize(Math.toIntExact(GCS_OUTPUT_STREAM_BUFFER_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getLongBytes(arg_0, arg_1)))).setDirectUploadEnabled(GCS_OUTPUT_STREAM_DIRECT_UPLOAD_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setGrpcChecksumsEnabled(GCS_GRPC_CHECKSUMS_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setGrpcWriteMessageTimeout(GCS_GRPC_WRITE_MESSAGE_TIMEOUT.getTimeDuration(config)).setGrpcWriteTimeout(GCS_GRPC_WRITE_TIMEOUT.getTimeDuration(config)).setNumberOfBufferedRequests(GCS_GRPC_UPLOAD_BUFFERED_REQUESTS.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setPipeBufferSize(Math.toIntExact(GCS_OUTPUT_STREAM_PIPE_BUFFER_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getLongBytes(arg_0, arg_1)))).setPipeType(GCS_OUTPUT_STREAM_PIPE_TYPE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setUploadCacheSize(Math.toIntExact(GCS_OUTPUT_STREAM_UPLOAD_CACHE_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getLongBytes(arg_0, arg_1)))).setUploadChunkSize(Math.toIntExact(GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getLongBytes(arg_0, arg_1)))).setUploadType(GCS_CLIENT_UPLOAD_TYPE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setTemporaryPaths(ImmutableSet.copyOf(GCS_WRITE_TEMPORARY_FILES_PATH.getStringCollection(config))).setPCUBufferCount(GCS_PCU_BUFFER_COUNT.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setPCUBufferCapacity(Math.toIntExact(GCS_PCU_BUFFER_CAPACITY.get(config, (arg_0, arg_1) -> ((Configuration)config).getLongBytes(arg_0, arg_1)))).setPartFileCleanupType(GCS_PCU_PART_FILE_CLEANUP_TYPE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setPartFileNamePrefix(GCS_PCU_PART_FILE_NAME_PREFIX.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setRollingChecksumEnabled(GCS_WRITE_ROLLING_CHECKSUM_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).build();
    }

    private static RequesterPaysOptions getRequesterPaysOptions(Configuration config, String projectId) {
        String requesterPaysProjectId = GCS_REQUESTER_PAYS_PROJECT_ID.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        return RequesterPaysOptions.builder().setBuckets(GCS_REQUESTER_PAYS_BUCKETS.getStringCollection(config)).setMode(GCS_REQUESTER_PAYS_MODE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setProjectId(requesterPaysProjectId == null ? projectId : requesterPaysProjectId).build();
    }
}

