/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GhfsGlobalStorageStatistics;
import com.google.cloud.hadoop.fs.gcs.GhfsInstrumentation;
import com.google.cloud.hadoop.fs.gcs.GhfsOutputStreamStatistics;
import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import com.google.cloud.hadoop.fs.gcs.GhfsStreamStats;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ITraceFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Ascii;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.RateLimiter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.util.functional.CallableRaisingIOE;

class GoogleHadoopOutputStream
extends OutputStream
implements IOStatisticsSource,
StreamCapabilities,
Syncable {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final GhfsGlobalStorageStatistics storageStatistics;
    private final ITraceFactory traceFactory;
    public static final String TMP_FILE_PREFIX = "_GHFS_SYNC_TMP_FILE_";
    private static final CreateFileOptions TMP_FILE_CREATE_OPTIONS = CreateFileOptions.builder().setEnsureNoDirectoryConflict(false).build();
    private static final ExecutorService TMP_FILE_CLEANUP_THREADPOOL = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("ghfs-output-stream-sync-cleanup-%d").setDaemon(true).build());
    private final GoogleHadoopFileSystem ghfs;
    private final CreateObjectOptions composeObjectOptions;
    private final URI dstGcsPath;
    private long dstGenerationId;
    private URI tmpGcsPath;
    private int tmpIndex;
    private OutputStream tmpOut;
    private final RateLimiter syncRateLimiter;
    private final List<Future<Void>> tmpDeletionFutures = new ArrayList<Future<Void>>();
    private final FileSystem.Statistics statistics;
    private final GhfsOutputStreamStatistics streamStatistics;
    private final GhfsInstrumentation instrumentation;
    private final GhfsStreamStats streamStats;

    public GoogleHadoopOutputStream(GoogleHadoopFileSystem ghfs, URI dstGcsPath, CreateFileOptions createFileOptions, FileSystem.Statistics statistics) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("GoogleHadoopOutputStream(gcsPath: %s, createFileOptions: %s)", (Object)dstGcsPath, (Object)createFileOptions);
        this.ghfs = ghfs;
        this.dstGcsPath = dstGcsPath;
        this.statistics = statistics;
        this.storageStatistics = ghfs.getGlobalGcsStorageStatistics();
        this.streamStatistics = ghfs.getInstrumentation().newOutputStreamStatistics(statistics);
        this.streamStats = new GhfsStreamStats(this.storageStatistics, GhfsStatistic.STREAM_WRITE_OPERATIONS, dstGcsPath);
        Duration minSyncInterval = createFileOptions.getMinSyncInterval();
        this.instrumentation = ghfs.getInstrumentation();
        this.syncRateLimiter = minSyncInterval.isNegative() || minSyncInterval.isZero() ? null : RateLimiter.create(1000.0 / (double)minSyncInterval.toMillis());
        this.composeObjectOptions = GoogleCloudStorageFileSystemImpl.objectOptionsFromFileOptions(createFileOptions.toBuilder().setWriteMode(CreateFileOptions.WriteMode.OVERWRITE).build());
        if (createFileOptions.getWriteMode() == CreateFileOptions.WriteMode.APPEND) {
            this.tmpGcsPath = this.getNextTmpPath();
            this.tmpIndex = 1;
        } else {
            this.tmpGcsPath = dstGcsPath;
            this.tmpIndex = 0;
        }
        this.tmpOut = GoogleHadoopOutputStream.createOutputStream(ghfs.getGcsFs(), this.tmpGcsPath, this.tmpIndex == 0 ? createFileOptions : TMP_FILE_CREATE_OPTIONS);
        this.dstGenerationId = -1L;
        this.traceFactory = ghfs.getTraceFactory();
    }

    private static OutputStream createOutputStream(GoogleCloudStorageFileSystem gcsfs, URI gcsPath, CreateFileOptions options) throws IOException {
        WritableByteChannel channel;
        try {
            channel = gcsfs.create(gcsPath, options);
        }
        catch (java.nio.file.FileAlreadyExistsException e) {
            GoogleCloudStorageEventBus.postOnException();
            throw (FileAlreadyExistsException)new FileAlreadyExistsException(String.format("'%s' already exists", gcsPath)).initCause((Throwable)e);
        }
        OutputStream outputStream = Channels.newOutputStream(channel);
        int bufferSize = gcsfs.getOptions().getCloudStorageOptions().getWriteChannelOptions().getBufferSize();
        return bufferSize > 0 ? new BufferedOutputStream(outputStream, bufferSize) : outputStream;
    }

    @Override
    public void write(int b) throws IOException {
        IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.streamStatistics, (String)GhfsStatistic.STREAM_WRITE_OPERATIONS.getSymbol(), () -> {
            long start = System.nanoTime();
            this.throwIfNotOpen();
            this.tmpOut.write(b);
            this.streamStatistics.writeBytes(1L);
            this.statistics.incrementBytesWritten(1L);
            this.statistics.incrementWriteOps(1);
            this.streamStats.updateWriteStreamStats(1, start);
            return null;
        });
    }

    private <B> B trackDurationWithTracing(DurationTrackerFactory factory, @Nonnull GhfsGlobalStorageStatistics stats, GhfsStatistic statistic, Object context, ITraceFactory traceFactory, CallableRaisingIOE<B> operation) throws IOException {
        return GhfsGlobalStorageStatistics.trackDuration(factory, stats, statistic, context, traceFactory, operation);
    }

    @Override
    public void write(@Nonnull byte[] b, int offset, int len) throws IOException {
        IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.streamStatistics, (String)GhfsStatistic.STREAM_WRITE_OPERATIONS.getSymbol(), () -> {
            long start = System.nanoTime();
            this.throwIfNotOpen();
            this.tmpOut.write(b, offset, len);
            this.statistics.incrementBytesWritten((long)len);
            this.statistics.incrementWriteOps(1);
            this.streamStats.updateWriteStreamStats(len, start);
            this.streamStatistics.writeBytes(len);
            return null;
        });
    }

    public void hflush() throws IOException {
        this.trackDurationWithTracing(this.streamStatistics, this.storageStatistics, GhfsStatistic.INVOCATION_HFLUSH, this.dstGcsPath, this.traceFactory, () -> {
            ((GoogleLogger.Api)logger.atFiner()).log("hflush(): %s", this.dstGcsPath);
            long startMs = System.currentTimeMillis();
            this.throwIfNotOpen();
            if (this.syncRateLimiter == null || this.syncRateLimiter.tryAcquire()) {
                ((GoogleLogger.Api)logger.atFine()).log("hflush() uses hsyncInternal() for %s", this.dstGcsPath);
                this.hsyncInternal(startMs);
                return null;
            }
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).atMostEvery(1, TimeUnit.MINUTES)).log("hflush(): No-op due to rate limit (%s): readers will *not* yet see flushed data for %s", (Object)this.syncRateLimiter, (Object)this.dstGcsPath);
            return null;
        });
    }

    public void hsync() throws IOException {
        this.trackDurationWithTracing(this.streamStatistics, this.storageStatistics, GhfsStatistic.INVOCATION_HSYNC, this.dstGcsPath, this.traceFactory, () -> {
            ((GoogleLogger.Api)logger.atFiner()).log("hsync(): %s", this.dstGcsPath);
            long startMs = System.currentTimeMillis();
            this.throwIfNotOpen();
            if (this.syncRateLimiter != null) {
                ((GoogleLogger.Api)logger.atFiner()).log("hsync(): Rate limited (%s) with blocking permit acquisition for %s", (Object)this.syncRateLimiter, (Object)this.dstGcsPath);
                this.syncRateLimiter.acquire();
            }
            this.hsyncInternal(startMs);
            return null;
        });
    }

    private void hsyncInternal(long startMs) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("hsyncInternal(): Committing tail file %s to final destination %s", (Object)this.tmpGcsPath, (Object)this.dstGcsPath);
        this.commitTempFile();
        ++this.tmpIndex;
        this.tmpGcsPath = this.getNextTmpPath();
        ((GoogleLogger.Api)logger.atFiner()).log("hsync(): Opening next temporary tail file %s at %d index", (Object)this.tmpGcsPath, this.tmpIndex);
        this.tmpOut = GoogleHadoopOutputStream.createOutputStream(this.ghfs.getGcsFs(), this.tmpGcsPath, TMP_FILE_CREATE_OPTIONS);
        long finishMs = System.currentTimeMillis();
        ((GoogleLogger.Api)logger.atFiner()).log("Took %dms to sync() for %s", finishMs - startMs, (Object)this.dstGcsPath);
    }

    private void commitTempFile() throws IOException {
        this.tmpOut.close();
        long tmpGenerationId = this.tmpOut instanceof GoogleCloudStorageItemInfo.Provider ? ((GoogleCloudStorageItemInfo.Provider)((Object)this.tmpOut)).getItemInfo().getContentGeneration() : -1L;
        ((GoogleLogger.Api)logger.atFiner()).log("tmpOut is an instance of %s; expected generationId %d.", (Object)this.tmpOut.getClass(), tmpGenerationId);
        if (this.dstGcsPath.equals(this.tmpGcsPath)) {
            this.dstGenerationId = tmpGenerationId;
        } else {
            StorageResourceId dstId = StorageResourceId.fromUriPath(this.dstGcsPath, false, this.dstGenerationId);
            StorageResourceId tmpId = StorageResourceId.fromUriPath(this.tmpGcsPath, false, tmpGenerationId);
            Preconditions.checkState(dstId.getBucketName().equals(tmpId.getBucketName()), "Destination bucket in path '%s' doesn't match temp file bucket in path '%s'", (Object)this.dstGcsPath, (Object)this.tmpGcsPath);
            GoogleCloudStorage gcs = this.ghfs.getGcsFs().getGcs();
            GoogleCloudStorageItemInfo composedObject = gcs.composeObjects(ImmutableList.of(dstId, tmpId), dstId, this.composeObjectOptions);
            this.dstGenerationId = composedObject.getContentGeneration();
            this.tmpDeletionFutures.add(TMP_FILE_CLEANUP_THREADPOOL.submit(() -> {
                gcs.deleteObjects(ImmutableList.of(tmpId));
                return null;
            }));
        }
    }

    private URI getNextTmpPath() {
        Path basePath = this.ghfs.getHadoopPath(this.dstGcsPath);
        Path tempPath = new Path(basePath.getParent(), String.format("%s%s.%d.%s", TMP_FILE_PREFIX, basePath.getName(), this.tmpIndex, UUID.randomUUID()));
        return this.ghfs.getGcsPath(tempPath);
    }

    @Override
    public void close() throws IOException {
        boolean isClosed = this.tmpOut == null;
        this.trackDurationWithTracing(this.streamStatistics, this.storageStatistics, GhfsStatistic.STREAM_WRITE_CLOSE_OPERATIONS, this.dstGcsPath, this.traceFactory, () -> {
            ((GoogleLogger.Api)logger.atFiner()).log("close(): temp tail file: %s final destination: %s", (Object)this.tmpGcsPath, (Object)this.dstGcsPath);
            if (this.tmpOut == null) {
                ((GoogleLogger.Api)logger.atFiner()).log("close(): Ignoring; stream already closed.");
                return null;
            }
            this.commitTempFile();
            try {
                this.tmpOut.close();
            }
            finally {
                this.tmpOut = null;
            }
            this.tmpGcsPath = null;
            this.tmpIndex = -1;
            ((GoogleLogger.Api)logger.atFiner()).log("close(): Awaiting %s deletionFutures", this.tmpDeletionFutures.size());
            for (Future<Void> deletion : this.tmpDeletionFutures) {
                try {
                    deletion.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    GoogleCloudStorageEventBus.postOnException();
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new IOException(String.format("Failed to delete temporary files while closing stream: '%s'", this.dstGcsPath), e);
                }
            }
            return null;
        });
        if (!isClosed) {
            this.streamStats.close();
            this.streamStatistics.close();
        }
    }

    private void throwIfNotOpen() throws IOException {
        if (this.tmpOut == null) {
            throw new ClosedChannelException();
        }
    }

    public IOStatistics getIOStatistics() {
        return this.streamStatistics.getIOStatistics();
    }

    public boolean hasCapability(String capability) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(capability), "capability must not be null or empty string");
        switch (Ascii.toLowerCase(capability)) {
            case "hflush": 
            case "hsync": {
                return this.syncRateLimiter != null;
            }
            case "iostatistics": {
                return true;
            }
        }
        return false;
    }
}

