/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_CreateFileOptions
extends CreateFileOptions {
    private final ImmutableMap<String, byte[]> attributes;
    @Nullable
    private final String contentType;
    private final Duration minSyncInterval;
    private final boolean ensureNoDirectoryConflict;
    private final CreateFileOptions.WriteMode writeMode;
    private final long overwriteGenerationId;

    private AutoValue_CreateFileOptions(ImmutableMap<String, byte[]> attributes, @Nullable String contentType, Duration minSyncInterval, boolean ensureNoDirectoryConflict, CreateFileOptions.WriteMode writeMode, long overwriteGenerationId) {
        this.attributes = attributes;
        this.contentType = contentType;
        this.minSyncInterval = minSyncInterval;
        this.ensureNoDirectoryConflict = ensureNoDirectoryConflict;
        this.writeMode = writeMode;
        this.overwriteGenerationId = overwriteGenerationId;
    }

    @Override
    public ImmutableMap<String, byte[]> getAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Duration getMinSyncInterval() {
        return this.minSyncInterval;
    }

    @Override
    public boolean isEnsureNoDirectoryConflict() {
        return this.ensureNoDirectoryConflict;
    }

    @Override
    public CreateFileOptions.WriteMode getWriteMode() {
        return this.writeMode;
    }

    @Override
    public long getOverwriteGenerationId() {
        return this.overwriteGenerationId;
    }

    public String toString() {
        return "CreateFileOptions{attributes=" + String.valueOf(this.attributes) + ", contentType=" + this.contentType + ", minSyncInterval=" + String.valueOf(this.minSyncInterval) + ", ensureNoDirectoryConflict=" + this.ensureNoDirectoryConflict + ", writeMode=" + String.valueOf((Object)this.writeMode) + ", overwriteGenerationId=" + this.overwriteGenerationId + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CreateFileOptions) {
            CreateFileOptions that = (CreateFileOptions)o;
            return this.attributes.equals(that.getAttributes()) && (this.contentType == null ? that.getContentType() == null : this.contentType.equals(that.getContentType())) && this.minSyncInterval.equals(that.getMinSyncInterval()) && this.ensureNoDirectoryConflict == that.isEnsureNoDirectoryConflict() && this.writeMode.equals((Object)that.getWriteMode()) && this.overwriteGenerationId == that.getOverwriteGenerationId();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.attributes.hashCode();
        h$ *= 1000003;
        h$ ^= this.contentType == null ? 0 : this.contentType.hashCode();
        h$ *= 1000003;
        h$ ^= this.minSyncInterval.hashCode();
        h$ *= 1000003;
        h$ ^= this.ensureNoDirectoryConflict ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.writeMode.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(this.overwriteGenerationId >>> 32 ^ this.overwriteGenerationId);
    }

    @Override
    public CreateFileOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends CreateFileOptions.Builder {
        private ImmutableMap<String, byte[]> attributes;
        private String contentType;
        private Duration minSyncInterval;
        private boolean ensureNoDirectoryConflict;
        private CreateFileOptions.WriteMode writeMode;
        private long overwriteGenerationId;
        private byte set$0;

        Builder() {
        }

        private Builder(CreateFileOptions source) {
            this.attributes = source.getAttributes();
            this.contentType = source.getContentType();
            this.minSyncInterval = source.getMinSyncInterval();
            this.ensureNoDirectoryConflict = source.isEnsureNoDirectoryConflict();
            this.writeMode = source.getWriteMode();
            this.overwriteGenerationId = source.getOverwriteGenerationId();
            this.set$0 = (byte)3;
        }

        @Override
        public CreateFileOptions.Builder setAttributes(Map<String, byte[]> attributes) {
            this.attributes = ImmutableMap.copyOf(attributes);
            return this;
        }

        @Override
        public CreateFileOptions.Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public CreateFileOptions.Builder setMinSyncInterval(Duration minSyncInterval) {
            if (minSyncInterval == null) {
                throw new NullPointerException("Null minSyncInterval");
            }
            this.minSyncInterval = minSyncInterval;
            return this;
        }

        @Override
        public CreateFileOptions.Builder setEnsureNoDirectoryConflict(boolean ensureNoDirectoryConflict) {
            this.ensureNoDirectoryConflict = ensureNoDirectoryConflict;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public CreateFileOptions.Builder setWriteMode(CreateFileOptions.WriteMode writeMode) {
            if (writeMode == null) {
                throw new NullPointerException("Null writeMode");
            }
            this.writeMode = writeMode;
            return this;
        }

        @Override
        public CreateFileOptions.Builder setOverwriteGenerationId(long overwriteGenerationId) {
            this.overwriteGenerationId = overwriteGenerationId;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        CreateFileOptions autoBuild() {
            if (this.set$0 != 3 || this.attributes == null || this.minSyncInterval == null || this.writeMode == null) {
                StringBuilder missing = new StringBuilder();
                if (this.attributes == null) {
                    missing.append(" attributes");
                }
                if (this.minSyncInterval == null) {
                    missing.append(" minSyncInterval");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" ensureNoDirectoryConflict");
                }
                if (this.writeMode == null) {
                    missing.append(" writeMode");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" overwriteGenerationId");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_CreateFileOptions(this.attributes, this.contentType, this.minSyncInterval, this.ensureNoDirectoryConflict, this.writeMode, this.overwriteGenerationId);
        }
    }
}

