/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_GoogleCloudStorageOptions
extends GoogleCloudStorageOptions {
    private final boolean grpcEnabled;
    private final boolean hnBucketRenameEnabled;
    private final boolean trafficDirectorEnabled;
    private final boolean directPathPreferred;
    private final String storageRootUrl;
    private final String storageServicePath;
    private final boolean grpcWriteEnabled;
    @Nullable
    private final String projectId;
    @Nullable
    private final String appName;
    private final boolean autoRepairImplicitDirectoriesEnabled;
    private final Duration maxWaitTimeForEmptyObjectCreation;
    private final int maxListItemsPerCall;
    private final int maxRequestsPerBatch;
    private final int batchThreads;
    private final int maxHttpRequestRetries;
    private final Duration httpRequestConnectTimeout;
    private final Duration httpRequestReadTimeout;
    @Nullable
    private final String proxyAddress;
    @Nullable
    private final RedactedString proxyUsername;
    @Nullable
    private final RedactedString proxyPassword;
    private final boolean copyWithRewriteEnabled;
    private final long maxRewriteChunkSize;
    private final GoogleCloudStorageReadOptions readChannelOptions;
    private final AsyncWriteChannelOptions writeChannelOptions;
    private final RequesterPaysOptions requesterPaysOptions;
    private final ImmutableMap<String, String> httpRequestHeaders;
    @Nullable
    private final String encryptionAlgorithm;
    @Nullable
    private final RedactedString encryptionKey;
    @Nullable
    private final RedactedString encryptionKeyHash;
    private final Duration grpcMessageTimeoutCheckInterval;
    private final GoogleCloudStorageOptions.MetricsSink metricsSink;
    private final boolean traceLogEnabled;
    private final boolean operationTraceLogEnabled;
    private final boolean moveOperationEnabled;
    private final boolean hnOptimizationEnabled;

    private AutoValue_GoogleCloudStorageOptions(boolean grpcEnabled, boolean hnBucketRenameEnabled, boolean trafficDirectorEnabled, boolean directPathPreferred, String storageRootUrl, String storageServicePath, boolean grpcWriteEnabled, @Nullable String projectId, @Nullable String appName, boolean autoRepairImplicitDirectoriesEnabled, Duration maxWaitTimeForEmptyObjectCreation, int maxListItemsPerCall, int maxRequestsPerBatch, int batchThreads, int maxHttpRequestRetries, Duration httpRequestConnectTimeout, Duration httpRequestReadTimeout, @Nullable String proxyAddress, @Nullable RedactedString proxyUsername, @Nullable RedactedString proxyPassword, boolean copyWithRewriteEnabled, long maxRewriteChunkSize, GoogleCloudStorageReadOptions readChannelOptions, AsyncWriteChannelOptions writeChannelOptions, RequesterPaysOptions requesterPaysOptions, ImmutableMap<String, String> httpRequestHeaders, @Nullable String encryptionAlgorithm, @Nullable RedactedString encryptionKey, @Nullable RedactedString encryptionKeyHash, Duration grpcMessageTimeoutCheckInterval, GoogleCloudStorageOptions.MetricsSink metricsSink, boolean traceLogEnabled, boolean operationTraceLogEnabled, boolean moveOperationEnabled, boolean hnOptimizationEnabled) {
        this.grpcEnabled = grpcEnabled;
        this.hnBucketRenameEnabled = hnBucketRenameEnabled;
        this.trafficDirectorEnabled = trafficDirectorEnabled;
        this.directPathPreferred = directPathPreferred;
        this.storageRootUrl = storageRootUrl;
        this.storageServicePath = storageServicePath;
        this.grpcWriteEnabled = grpcWriteEnabled;
        this.projectId = projectId;
        this.appName = appName;
        this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
        this.maxWaitTimeForEmptyObjectCreation = maxWaitTimeForEmptyObjectCreation;
        this.maxListItemsPerCall = maxListItemsPerCall;
        this.maxRequestsPerBatch = maxRequestsPerBatch;
        this.batchThreads = batchThreads;
        this.maxHttpRequestRetries = maxHttpRequestRetries;
        this.httpRequestConnectTimeout = httpRequestConnectTimeout;
        this.httpRequestReadTimeout = httpRequestReadTimeout;
        this.proxyAddress = proxyAddress;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.copyWithRewriteEnabled = copyWithRewriteEnabled;
        this.maxRewriteChunkSize = maxRewriteChunkSize;
        this.readChannelOptions = readChannelOptions;
        this.writeChannelOptions = writeChannelOptions;
        this.requesterPaysOptions = requesterPaysOptions;
        this.httpRequestHeaders = httpRequestHeaders;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.encryptionKey = encryptionKey;
        this.encryptionKeyHash = encryptionKeyHash;
        this.grpcMessageTimeoutCheckInterval = grpcMessageTimeoutCheckInterval;
        this.metricsSink = metricsSink;
        this.traceLogEnabled = traceLogEnabled;
        this.operationTraceLogEnabled = operationTraceLogEnabled;
        this.moveOperationEnabled = moveOperationEnabled;
        this.hnOptimizationEnabled = hnOptimizationEnabled;
    }

    @Override
    public boolean isGrpcEnabled() {
        return this.grpcEnabled;
    }

    @Override
    public boolean isHnBucketRenameEnabled() {
        return this.hnBucketRenameEnabled;
    }

    @Override
    public boolean isTrafficDirectorEnabled() {
        return this.trafficDirectorEnabled;
    }

    @Override
    public boolean isDirectPathPreferred() {
        return this.directPathPreferred;
    }

    @Override
    public String getStorageRootUrl() {
        return this.storageRootUrl;
    }

    @Override
    public String getStorageServicePath() {
        return this.storageServicePath;
    }

    @Override
    public boolean isGrpcWriteEnabled() {
        return this.grpcWriteEnabled;
    }

    @Override
    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @Nullable
    public String getAppName() {
        return this.appName;
    }

    @Override
    public boolean isAutoRepairImplicitDirectoriesEnabled() {
        return this.autoRepairImplicitDirectoriesEnabled;
    }

    @Override
    public Duration getMaxWaitTimeForEmptyObjectCreation() {
        return this.maxWaitTimeForEmptyObjectCreation;
    }

    @Override
    public int getMaxListItemsPerCall() {
        return this.maxListItemsPerCall;
    }

    @Override
    public int getMaxRequestsPerBatch() {
        return this.maxRequestsPerBatch;
    }

    @Override
    public int getBatchThreads() {
        return this.batchThreads;
    }

    @Override
    public int getMaxHttpRequestRetries() {
        return this.maxHttpRequestRetries;
    }

    @Override
    public Duration getHttpRequestConnectTimeout() {
        return this.httpRequestConnectTimeout;
    }

    @Override
    public Duration getHttpRequestReadTimeout() {
        return this.httpRequestReadTimeout;
    }

    @Override
    @Nullable
    public String getProxyAddress() {
        return this.proxyAddress;
    }

    @Override
    @Nullable
    public RedactedString getProxyUsername() {
        return this.proxyUsername;
    }

    @Override
    @Nullable
    public RedactedString getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public boolean isCopyWithRewriteEnabled() {
        return this.copyWithRewriteEnabled;
    }

    @Override
    public long getMaxRewriteChunkSize() {
        return this.maxRewriteChunkSize;
    }

    @Override
    public GoogleCloudStorageReadOptions getReadChannelOptions() {
        return this.readChannelOptions;
    }

    @Override
    public AsyncWriteChannelOptions getWriteChannelOptions() {
        return this.writeChannelOptions;
    }

    @Override
    public RequesterPaysOptions getRequesterPaysOptions() {
        return this.requesterPaysOptions;
    }

    @Override
    public ImmutableMap<String, String> getHttpRequestHeaders() {
        return this.httpRequestHeaders;
    }

    @Override
    @Nullable
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    @Nullable
    public RedactedString getEncryptionKey() {
        return this.encryptionKey;
    }

    @Override
    @Nullable
    public RedactedString getEncryptionKeyHash() {
        return this.encryptionKeyHash;
    }

    @Override
    public Duration getGrpcMessageTimeoutCheckInterval() {
        return this.grpcMessageTimeoutCheckInterval;
    }

    @Override
    public GoogleCloudStorageOptions.MetricsSink getMetricsSink() {
        return this.metricsSink;
    }

    @Override
    public boolean isTraceLogEnabled() {
        return this.traceLogEnabled;
    }

    @Override
    public boolean isOperationTraceLogEnabled() {
        return this.operationTraceLogEnabled;
    }

    @Override
    public boolean isMoveOperationEnabled() {
        return this.moveOperationEnabled;
    }

    @Override
    public boolean isHnOptimizationEnabled() {
        return this.hnOptimizationEnabled;
    }

    public String toString() {
        return "GoogleCloudStorageOptions{grpcEnabled=" + this.grpcEnabled + ", hnBucketRenameEnabled=" + this.hnBucketRenameEnabled + ", trafficDirectorEnabled=" + this.trafficDirectorEnabled + ", directPathPreferred=" + this.directPathPreferred + ", storageRootUrl=" + this.storageRootUrl + ", storageServicePath=" + this.storageServicePath + ", grpcWriteEnabled=" + this.grpcWriteEnabled + ", projectId=" + this.projectId + ", appName=" + this.appName + ", autoRepairImplicitDirectoriesEnabled=" + this.autoRepairImplicitDirectoriesEnabled + ", maxWaitTimeForEmptyObjectCreation=" + String.valueOf(this.maxWaitTimeForEmptyObjectCreation) + ", maxListItemsPerCall=" + this.maxListItemsPerCall + ", maxRequestsPerBatch=" + this.maxRequestsPerBatch + ", batchThreads=" + this.batchThreads + ", maxHttpRequestRetries=" + this.maxHttpRequestRetries + ", httpRequestConnectTimeout=" + String.valueOf(this.httpRequestConnectTimeout) + ", httpRequestReadTimeout=" + String.valueOf(this.httpRequestReadTimeout) + ", proxyAddress=" + this.proxyAddress + ", proxyUsername=" + String.valueOf(this.proxyUsername) + ", proxyPassword=" + String.valueOf(this.proxyPassword) + ", copyWithRewriteEnabled=" + this.copyWithRewriteEnabled + ", maxRewriteChunkSize=" + this.maxRewriteChunkSize + ", readChannelOptions=" + String.valueOf(this.readChannelOptions) + ", writeChannelOptions=" + String.valueOf(this.writeChannelOptions) + ", requesterPaysOptions=" + String.valueOf(this.requesterPaysOptions) + ", httpRequestHeaders=" + String.valueOf(this.httpRequestHeaders) + ", encryptionAlgorithm=" + this.encryptionAlgorithm + ", encryptionKey=" + String.valueOf(this.encryptionKey) + ", encryptionKeyHash=" + String.valueOf(this.encryptionKeyHash) + ", grpcMessageTimeoutCheckInterval=" + String.valueOf(this.grpcMessageTimeoutCheckInterval) + ", metricsSink=" + String.valueOf((Object)this.metricsSink) + ", traceLogEnabled=" + this.traceLogEnabled + ", operationTraceLogEnabled=" + this.operationTraceLogEnabled + ", moveOperationEnabled=" + this.moveOperationEnabled + ", hnOptimizationEnabled=" + this.hnOptimizationEnabled + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GoogleCloudStorageOptions) {
            GoogleCloudStorageOptions that = (GoogleCloudStorageOptions)o;
            return this.grpcEnabled == that.isGrpcEnabled() && this.hnBucketRenameEnabled == that.isHnBucketRenameEnabled() && this.trafficDirectorEnabled == that.isTrafficDirectorEnabled() && this.directPathPreferred == that.isDirectPathPreferred() && this.storageRootUrl.equals(that.getStorageRootUrl()) && this.storageServicePath.equals(that.getStorageServicePath()) && this.grpcWriteEnabled == that.isGrpcWriteEnabled() && (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId())) && (this.appName == null ? that.getAppName() == null : this.appName.equals(that.getAppName())) && this.autoRepairImplicitDirectoriesEnabled == that.isAutoRepairImplicitDirectoriesEnabled() && this.maxWaitTimeForEmptyObjectCreation.equals(that.getMaxWaitTimeForEmptyObjectCreation()) && this.maxListItemsPerCall == that.getMaxListItemsPerCall() && this.maxRequestsPerBatch == that.getMaxRequestsPerBatch() && this.batchThreads == that.getBatchThreads() && this.maxHttpRequestRetries == that.getMaxHttpRequestRetries() && this.httpRequestConnectTimeout.equals(that.getHttpRequestConnectTimeout()) && this.httpRequestReadTimeout.equals(that.getHttpRequestReadTimeout()) && (this.proxyAddress == null ? that.getProxyAddress() == null : this.proxyAddress.equals(that.getProxyAddress())) && (this.proxyUsername == null ? that.getProxyUsername() == null : this.proxyUsername.equals(that.getProxyUsername())) && (this.proxyPassword == null ? that.getProxyPassword() == null : this.proxyPassword.equals(that.getProxyPassword())) && this.copyWithRewriteEnabled == that.isCopyWithRewriteEnabled() && this.maxRewriteChunkSize == that.getMaxRewriteChunkSize() && this.readChannelOptions.equals(that.getReadChannelOptions()) && this.writeChannelOptions.equals(that.getWriteChannelOptions()) && this.requesterPaysOptions.equals(that.getRequesterPaysOptions()) && this.httpRequestHeaders.equals(that.getHttpRequestHeaders()) && (this.encryptionAlgorithm == null ? that.getEncryptionAlgorithm() == null : this.encryptionAlgorithm.equals(that.getEncryptionAlgorithm())) && (this.encryptionKey == null ? that.getEncryptionKey() == null : this.encryptionKey.equals(that.getEncryptionKey())) && (this.encryptionKeyHash == null ? that.getEncryptionKeyHash() == null : this.encryptionKeyHash.equals(that.getEncryptionKeyHash())) && this.grpcMessageTimeoutCheckInterval.equals(that.getGrpcMessageTimeoutCheckInterval()) && this.metricsSink.equals((Object)that.getMetricsSink()) && this.traceLogEnabled == that.isTraceLogEnabled() && this.operationTraceLogEnabled == that.isOperationTraceLogEnabled() && this.moveOperationEnabled == that.isMoveOperationEnabled() && this.hnOptimizationEnabled == that.isHnOptimizationEnabled();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.grpcEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.hnBucketRenameEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.trafficDirectorEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.directPathPreferred ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.storageRootUrl.hashCode();
        h$ *= 1000003;
        h$ ^= this.storageServicePath.hashCode();
        h$ *= 1000003;
        h$ ^= this.grpcWriteEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.projectId == null ? 0 : this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.appName == null ? 0 : this.appName.hashCode();
        h$ *= 1000003;
        h$ ^= this.autoRepairImplicitDirectoriesEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.maxWaitTimeForEmptyObjectCreation.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxListItemsPerCall;
        h$ *= 1000003;
        h$ ^= this.maxRequestsPerBatch;
        h$ *= 1000003;
        h$ ^= this.batchThreads;
        h$ *= 1000003;
        h$ ^= this.maxHttpRequestRetries;
        h$ *= 1000003;
        h$ ^= this.httpRequestConnectTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.httpRequestReadTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.proxyAddress == null ? 0 : this.proxyAddress.hashCode();
        h$ *= 1000003;
        h$ ^= this.proxyUsername == null ? 0 : this.proxyUsername.hashCode();
        h$ *= 1000003;
        h$ ^= this.proxyPassword == null ? 0 : this.proxyPassword.hashCode();
        h$ *= 1000003;
        h$ ^= this.copyWithRewriteEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.maxRewriteChunkSize >>> 32 ^ this.maxRewriteChunkSize);
        h$ *= 1000003;
        h$ ^= this.readChannelOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.writeChannelOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.requesterPaysOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.httpRequestHeaders.hashCode();
        h$ *= 1000003;
        h$ ^= this.encryptionAlgorithm == null ? 0 : this.encryptionAlgorithm.hashCode();
        h$ *= 1000003;
        h$ ^= this.encryptionKey == null ? 0 : this.encryptionKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.encryptionKeyHash == null ? 0 : this.encryptionKeyHash.hashCode();
        h$ *= 1000003;
        h$ ^= this.grpcMessageTimeoutCheckInterval.hashCode();
        h$ *= 1000003;
        h$ ^= this.metricsSink.hashCode();
        h$ *= 1000003;
        h$ ^= this.traceLogEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.operationTraceLogEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.moveOperationEnabled ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.hnOptimizationEnabled ? 1231 : 1237;
    }

    @Override
    public GoogleCloudStorageOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends GoogleCloudStorageOptions.Builder {
        private boolean grpcEnabled;
        private boolean hnBucketRenameEnabled;
        private boolean trafficDirectorEnabled;
        private boolean directPathPreferred;
        private String storageRootUrl;
        private String storageServicePath;
        private boolean grpcWriteEnabled;
        private String projectId;
        private String appName;
        private boolean autoRepairImplicitDirectoriesEnabled;
        private Duration maxWaitTimeForEmptyObjectCreation;
        private int maxListItemsPerCall;
        private int maxRequestsPerBatch;
        private int batchThreads;
        private int maxHttpRequestRetries;
        private Duration httpRequestConnectTimeout;
        private Duration httpRequestReadTimeout;
        private String proxyAddress;
        private RedactedString proxyUsername;
        private RedactedString proxyPassword;
        private boolean copyWithRewriteEnabled;
        private long maxRewriteChunkSize;
        private GoogleCloudStorageReadOptions readChannelOptions;
        private AsyncWriteChannelOptions writeChannelOptions;
        private RequesterPaysOptions requesterPaysOptions;
        private ImmutableMap<String, String> httpRequestHeaders;
        private String encryptionAlgorithm;
        private RedactedString encryptionKey;
        private RedactedString encryptionKeyHash;
        private Duration grpcMessageTimeoutCheckInterval;
        private GoogleCloudStorageOptions.MetricsSink metricsSink;
        private boolean traceLogEnabled;
        private boolean operationTraceLogEnabled;
        private boolean moveOperationEnabled;
        private boolean hnOptimizationEnabled;
        private short set$0;

        Builder() {
        }

        private Builder(GoogleCloudStorageOptions source) {
            this.grpcEnabled = source.isGrpcEnabled();
            this.hnBucketRenameEnabled = source.isHnBucketRenameEnabled();
            this.trafficDirectorEnabled = source.isTrafficDirectorEnabled();
            this.directPathPreferred = source.isDirectPathPreferred();
            this.storageRootUrl = source.getStorageRootUrl();
            this.storageServicePath = source.getStorageServicePath();
            this.grpcWriteEnabled = source.isGrpcWriteEnabled();
            this.projectId = source.getProjectId();
            this.appName = source.getAppName();
            this.autoRepairImplicitDirectoriesEnabled = source.isAutoRepairImplicitDirectoriesEnabled();
            this.maxWaitTimeForEmptyObjectCreation = source.getMaxWaitTimeForEmptyObjectCreation();
            this.maxListItemsPerCall = source.getMaxListItemsPerCall();
            this.maxRequestsPerBatch = source.getMaxRequestsPerBatch();
            this.batchThreads = source.getBatchThreads();
            this.maxHttpRequestRetries = source.getMaxHttpRequestRetries();
            this.httpRequestConnectTimeout = source.getHttpRequestConnectTimeout();
            this.httpRequestReadTimeout = source.getHttpRequestReadTimeout();
            this.proxyAddress = source.getProxyAddress();
            this.proxyUsername = source.getProxyUsername();
            this.proxyPassword = source.getProxyPassword();
            this.copyWithRewriteEnabled = source.isCopyWithRewriteEnabled();
            this.maxRewriteChunkSize = source.getMaxRewriteChunkSize();
            this.readChannelOptions = source.getReadChannelOptions();
            this.writeChannelOptions = source.getWriteChannelOptions();
            this.requesterPaysOptions = source.getRequesterPaysOptions();
            this.httpRequestHeaders = source.getHttpRequestHeaders();
            this.encryptionAlgorithm = source.getEncryptionAlgorithm();
            this.encryptionKey = source.getEncryptionKey();
            this.encryptionKeyHash = source.getEncryptionKeyHash();
            this.grpcMessageTimeoutCheckInterval = source.getGrpcMessageTimeoutCheckInterval();
            this.metricsSink = source.getMetricsSink();
            this.traceLogEnabled = source.isTraceLogEnabled();
            this.operationTraceLogEnabled = source.isOperationTraceLogEnabled();
            this.moveOperationEnabled = source.isMoveOperationEnabled();
            this.hnOptimizationEnabled = source.isHnOptimizationEnabled();
            this.set$0 = (short)-1;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setGrpcEnabled(boolean grpcEnabled) {
            this.grpcEnabled = grpcEnabled;
            this.set$0 = (short)(this.set$0 | 1);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setHnBucketRenameEnabled(boolean hnBucketRenameEnabled) {
            this.hnBucketRenameEnabled = hnBucketRenameEnabled;
            this.set$0 = (short)(this.set$0 | 2);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setTrafficDirectorEnabled(boolean trafficDirectorEnabled) {
            this.trafficDirectorEnabled = trafficDirectorEnabled;
            this.set$0 = (short)(this.set$0 | 4);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setDirectPathPreferred(boolean directPathPreferred) {
            this.directPathPreferred = directPathPreferred;
            this.set$0 = (short)(this.set$0 | 8);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setStorageRootUrl(String storageRootUrl) {
            if (storageRootUrl == null) {
                throw new NullPointerException("Null storageRootUrl");
            }
            this.storageRootUrl = storageRootUrl;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setStorageServicePath(String storageServicePath) {
            if (storageServicePath == null) {
                throw new NullPointerException("Null storageServicePath");
            }
            this.storageServicePath = storageServicePath;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setGrpcWriteEnabled(boolean grpcWriteEnabled) {
            this.grpcWriteEnabled = grpcWriteEnabled;
            this.set$0 = (short)(this.set$0 | 0x10);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setAutoRepairImplicitDirectoriesEnabled(boolean autoRepairImplicitDirectoriesEnabled) {
            this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
            this.set$0 = (short)(this.set$0 | 0x20);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxWaitTimeForEmptyObjectCreation(Duration maxWaitTimeForEmptyObjectCreation) {
            if (maxWaitTimeForEmptyObjectCreation == null) {
                throw new NullPointerException("Null maxWaitTimeForEmptyObjectCreation");
            }
            this.maxWaitTimeForEmptyObjectCreation = maxWaitTimeForEmptyObjectCreation;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxListItemsPerCall(int maxListItemsPerCall) {
            this.maxListItemsPerCall = maxListItemsPerCall;
            this.set$0 = (short)(this.set$0 | 0x40);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxRequestsPerBatch(int maxRequestsPerBatch) {
            this.maxRequestsPerBatch = maxRequestsPerBatch;
            this.set$0 = (short)(this.set$0 | 0x80);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setBatchThreads(int batchThreads) {
            this.batchThreads = batchThreads;
            this.set$0 = (short)(this.set$0 | 0x100);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxHttpRequestRetries(int maxHttpRequestRetries) {
            this.maxHttpRequestRetries = maxHttpRequestRetries;
            this.set$0 = (short)(this.set$0 | 0x200);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setHttpRequestConnectTimeout(Duration httpRequestConnectTimeout) {
            if (httpRequestConnectTimeout == null) {
                throw new NullPointerException("Null httpRequestConnectTimeout");
            }
            this.httpRequestConnectTimeout = httpRequestConnectTimeout;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setHttpRequestReadTimeout(Duration httpRequestReadTimeout) {
            if (httpRequestReadTimeout == null) {
                throw new NullPointerException("Null httpRequestReadTimeout");
            }
            this.httpRequestReadTimeout = httpRequestReadTimeout;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setProxyAddress(String proxyAddress) {
            this.proxyAddress = proxyAddress;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setProxyUsername(RedactedString proxyUsername) {
            this.proxyUsername = proxyUsername;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setProxyPassword(RedactedString proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setCopyWithRewriteEnabled(boolean copyWithRewriteEnabled) {
            this.copyWithRewriteEnabled = copyWithRewriteEnabled;
            this.set$0 = (short)(this.set$0 | 0x400);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxRewriteChunkSize(long maxRewriteChunkSize) {
            this.maxRewriteChunkSize = maxRewriteChunkSize;
            this.set$0 = (short)(this.set$0 | 0x800);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setReadChannelOptions(GoogleCloudStorageReadOptions readChannelOptions) {
            if (readChannelOptions == null) {
                throw new NullPointerException("Null readChannelOptions");
            }
            this.readChannelOptions = readChannelOptions;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setWriteChannelOptions(AsyncWriteChannelOptions writeChannelOptions) {
            if (writeChannelOptions == null) {
                throw new NullPointerException("Null writeChannelOptions");
            }
            this.writeChannelOptions = writeChannelOptions;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setRequesterPaysOptions(RequesterPaysOptions requesterPaysOptions) {
            if (requesterPaysOptions == null) {
                throw new NullPointerException("Null requesterPaysOptions");
            }
            this.requesterPaysOptions = requesterPaysOptions;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setHttpRequestHeaders(Map<String, String> httpRequestHeaders) {
            this.httpRequestHeaders = ImmutableMap.copyOf(httpRequestHeaders);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setEncryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setEncryptionKey(RedactedString encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setEncryptionKeyHash(RedactedString encryptionKeyHash) {
            this.encryptionKeyHash = encryptionKeyHash;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setGrpcMessageTimeoutCheckInterval(Duration grpcMessageTimeoutCheckInterval) {
            if (grpcMessageTimeoutCheckInterval == null) {
                throw new NullPointerException("Null grpcMessageTimeoutCheckInterval");
            }
            this.grpcMessageTimeoutCheckInterval = grpcMessageTimeoutCheckInterval;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMetricsSink(GoogleCloudStorageOptions.MetricsSink metricsSink) {
            if (metricsSink == null) {
                throw new NullPointerException("Null metricsSink");
            }
            this.metricsSink = metricsSink;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setTraceLogEnabled(Boolean traceLogEnabled) {
            if (traceLogEnabled == null) {
                throw new NullPointerException("Null traceLogEnabled");
            }
            this.traceLogEnabled = traceLogEnabled;
            this.set$0 = (short)(this.set$0 | 0x1000);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setOperationTraceLogEnabled(Boolean operationTraceLogEnabled) {
            if (operationTraceLogEnabled == null) {
                throw new NullPointerException("Null operationTraceLogEnabled");
            }
            this.operationTraceLogEnabled = operationTraceLogEnabled;
            this.set$0 = (short)(this.set$0 | 0x2000);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMoveOperationEnabled(boolean moveOperationEnabled) {
            this.moveOperationEnabled = moveOperationEnabled;
            this.set$0 = (short)(this.set$0 | 0x4000);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setHnOptimizationEnabled(boolean hnOptimizationEnabled) {
            this.hnOptimizationEnabled = hnOptimizationEnabled;
            this.set$0 = (short)(this.set$0 | Short.MIN_VALUE);
            return this;
        }

        @Override
        GoogleCloudStorageOptions autoBuild() {
            if (this.set$0 != -1 || this.storageRootUrl == null || this.storageServicePath == null || this.maxWaitTimeForEmptyObjectCreation == null || this.httpRequestConnectTimeout == null || this.httpRequestReadTimeout == null || this.readChannelOptions == null || this.writeChannelOptions == null || this.requesterPaysOptions == null || this.httpRequestHeaders == null || this.grpcMessageTimeoutCheckInterval == null || this.metricsSink == null) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" grpcEnabled");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" hnBucketRenameEnabled");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" trafficDirectorEnabled");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" directPathPreferred");
                }
                if (this.storageRootUrl == null) {
                    missing.append(" storageRootUrl");
                }
                if (this.storageServicePath == null) {
                    missing.append(" storageServicePath");
                }
                if ((this.set$0 & 0x10) == 0) {
                    missing.append(" grpcWriteEnabled");
                }
                if ((this.set$0 & 0x20) == 0) {
                    missing.append(" autoRepairImplicitDirectoriesEnabled");
                }
                if (this.maxWaitTimeForEmptyObjectCreation == null) {
                    missing.append(" maxWaitTimeForEmptyObjectCreation");
                }
                if ((this.set$0 & 0x40) == 0) {
                    missing.append(" maxListItemsPerCall");
                }
                if ((this.set$0 & 0x80) == 0) {
                    missing.append(" maxRequestsPerBatch");
                }
                if ((this.set$0 & 0x100) == 0) {
                    missing.append(" batchThreads");
                }
                if ((this.set$0 & 0x200) == 0) {
                    missing.append(" maxHttpRequestRetries");
                }
                if (this.httpRequestConnectTimeout == null) {
                    missing.append(" httpRequestConnectTimeout");
                }
                if (this.httpRequestReadTimeout == null) {
                    missing.append(" httpRequestReadTimeout");
                }
                if ((this.set$0 & 0x400) == 0) {
                    missing.append(" copyWithRewriteEnabled");
                }
                if ((this.set$0 & 0x800) == 0) {
                    missing.append(" maxRewriteChunkSize");
                }
                if (this.readChannelOptions == null) {
                    missing.append(" readChannelOptions");
                }
                if (this.writeChannelOptions == null) {
                    missing.append(" writeChannelOptions");
                }
                if (this.requesterPaysOptions == null) {
                    missing.append(" requesterPaysOptions");
                }
                if (this.httpRequestHeaders == null) {
                    missing.append(" httpRequestHeaders");
                }
                if (this.grpcMessageTimeoutCheckInterval == null) {
                    missing.append(" grpcMessageTimeoutCheckInterval");
                }
                if (this.metricsSink == null) {
                    missing.append(" metricsSink");
                }
                if ((this.set$0 & 0x1000) == 0) {
                    missing.append(" traceLogEnabled");
                }
                if ((this.set$0 & 0x2000) == 0) {
                    missing.append(" operationTraceLogEnabled");
                }
                if ((this.set$0 & 0x4000) == 0) {
                    missing.append(" moveOperationEnabled");
                }
                if ((this.set$0 & 0x8000) == 0) {
                    missing.append(" hnOptimizationEnabled");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_GoogleCloudStorageOptions(this.grpcEnabled, this.hnBucketRenameEnabled, this.trafficDirectorEnabled, this.directPathPreferred, this.storageRootUrl, this.storageServicePath, this.grpcWriteEnabled, this.projectId, this.appName, this.autoRepairImplicitDirectoriesEnabled, this.maxWaitTimeForEmptyObjectCreation, this.maxListItemsPerCall, this.maxRequestsPerBatch, this.batchThreads, this.maxHttpRequestRetries, this.httpRequestConnectTimeout, this.httpRequestReadTimeout, this.proxyAddress, this.proxyUsername, this.proxyPassword, this.copyWithRewriteEnabled, this.maxRewriteChunkSize, this.readChannelOptions, this.writeChannelOptions, this.requesterPaysOptions, this.httpRequestHeaders, this.encryptionAlgorithm, this.encryptionKey, this.encryptionKeyHash, this.grpcMessageTimeoutCheckInterval, this.metricsSink, this.traceLogEnabled, this.operationTraceLogEnabled, this.moveOperationEnabled, this.hnOptimizationEnabled);
        }
    }
}

