/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.AccessToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.AutoBuilder_GoogleCloudStorageClientImpl_Builder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.BatchExecutor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcDownscopingInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcStatisticsInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcTracingInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientReadChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GrpcErrorTypeExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Blob;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSessionConfigs;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ParallelCompositeUploadBlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.FutureCallback;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.util.AccessBoundary;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@VisibleForTesting
public class GoogleCloudStorageClientImpl
extends ForwardingGoogleCloudStorage {
    private static final String USER_AGENT = "user-agent";
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final GoogleCloudStorageOptions storageOptions;
    private final Storage storage;
    private static final ErrorTypeExtractor errorExtractor = GrpcErrorTypeExtractor.INSTANCE;
    private ExecutorService backgroundTasksThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcsio-storage-client-write-channel-pool-%d").setDaemon(true).build());

    GoogleCloudStorageClientImpl(GoogleCloudStorageOptions options, @Nullable Storage clientLibraryStorage, @Nullable Credentials credentials, @Nullable HttpTransport httpTransport, @Nullable HttpRequestInitializer httpRequestInitializer, @Nullable ImmutableList<ClientInterceptor> gRPCInterceptors, @Nullable Function<List<AccessBoundary>, String> downscopedAccessTokenFn, @Nullable ExecutorService pCUExecutorService) throws IOException {
        super(GoogleCloudStorageImpl.builder().setOptions(options).setCredentials(credentials).setHttpTransport(httpTransport).setHttpRequestInitializer(httpRequestInitializer).setDownscopedAccessTokenFn(downscopedAccessTokenFn).build());
        this.storageOptions = options;
        this.storage = clientLibraryStorage == null ? GoogleCloudStorageClientImpl.createStorage(credentials, options, gRPCInterceptors, downscopedAccessTokenFn, pCUExecutorService) : clientLibraryStorage;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        if (!this.storageOptions.isGrpcWriteEnabled()) {
            return super.create(resourceId, options);
        }
        ((GoogleLogger.Api)logger.atFiner()).log("create(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        StorageResourceId resourceIdWithGeneration = resourceId;
        if (!resourceId.hasGenerationId()) {
            resourceIdWithGeneration = new StorageResourceId(resourceId.getBucketName(), resourceId.getObjectName(), this.getWriteGeneration(resourceId, options.isOverwriteExisting()));
        }
        return new GoogleCloudStorageClientWriteChannel(this.storage, this.storageOptions, resourceIdWithGeneration, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Map<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap) throws IOException {
        GoogleCloudStorageImpl.validateMoveArguments(sourceToDestinationObjectsMap);
        if (sourceToDestinationObjectsMap.isEmpty()) {
            return;
        }
        ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions = ConcurrentHashMap.newKeySet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (Map.Entry<StorageResourceId, StorageResourceId> entry : sourceToDestinationObjectsMap.entrySet()) {
                StorageResourceId srcObject = entry.getKey();
                StorageResourceId dstObject = entry.getValue();
                this.moveInternal(executor, innerExceptions, srcObject.getBucketName(), srcObject.getGenerationId(), srcObject.getObjectName(), dstObject.getGenerationId(), dstObject.getObjectName());
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void moveInternal(BatchExecutor executor, ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final String srcBucketName, long srcContentGeneration, final String srcObjectName, long dstContentGeneration, String dstObjectName) {
        Storage.MoveBlobRequest.Builder moveRequestBuilder = this.createMoveRequestBuilder(srcBucketName, srcObjectName, dstObjectName, srcContentGeneration, dstContentGeneration);
        executor.queue(() -> {
            try {
                String srcString = StringPaths.fromComponents(srcBucketName, srcObjectName);
                String dstString = StringPaths.fromComponents(srcBucketName, dstObjectName);
                Blob movedBlob = this.storage.moveBlob(moveRequestBuilder.build());
                if (movedBlob != null) {
                    ((GoogleLogger.Api)logger.atFiner()).log("Successfully moved %s to %s", (Object)srcString, (Object)dstString);
                }
            }
            catch (StorageException e) {
                GoogleCloudStorageEventBus.postOnException();
                if (errorExtractor.getErrorType(e) == ErrorTypeExtractor.ErrorType.NOT_FOUND) {
                    innerExceptions.add(GoogleCloudStorageExceptions.createFileNotFoundException(srcBucketName, srcObjectName, new IOException(e)));
                }
                innerExceptions.add(new IOException(String.format("Error moving '%s'", StringPaths.fromComponents(srcBucketName, srcObjectName)), e));
            }
            return null;
        }, new FutureCallback<Blob>(){

            @Override
            public void onSuccess(@Nullable Blob result) {
                ((GoogleLogger.Api)logger.atFiner()).log("Move operation succeeded via callback for %s.", StringPaths.fromComponents(srcBucketName, srcObjectName));
            }

            @Override
            public void onFailure(Throwable t) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(t)).log("Move operation failed via callback for %s.", StringPaths.fromComponents(srcBucketName, srcObjectName));
            }
        });
    }

    private Storage.MoveBlobRequest.Builder createMoveRequestBuilder(String srcBucketName, String srcObjectName, String dstObjectName, long srcContentGeneration, long dstContentGeneration) {
        Storage.MoveBlobRequest.Builder moveRequestBuilder = Storage.MoveBlobRequest.newBuilder().setSource(BlobId.of(srcBucketName, srcObjectName));
        moveRequestBuilder.setTarget(BlobId.of(srcBucketName, dstObjectName));
        ArrayList<Storage.BlobTargetOption> blobTargetOptions = new ArrayList<Storage.BlobTargetOption>();
        ArrayList<Storage.BlobSourceOption> blobSourceOptions = new ArrayList<Storage.BlobSourceOption>();
        if (srcContentGeneration != -1L) {
            blobSourceOptions.add(Storage.BlobSourceOption.generationMatch(srcContentGeneration));
        }
        if (dstContentGeneration != -1L) {
            blobTargetOptions.add(Storage.BlobTargetOption.generationMatch(dstContentGeneration));
        }
        if (this.storageOptions.getEncryptionKey() != null) {
            blobSourceOptions.add(Storage.BlobSourceOption.decryptionKey(this.storageOptions.getEncryptionKey().value()));
            blobTargetOptions.add(Storage.BlobTargetOption.encryptionKey(this.storageOptions.getEncryptionKey().value()));
        }
        moveRequestBuilder.setSourceOptions(blobSourceOptions);
        moveRequestBuilder.setTargetOptions(blobTargetOptions);
        return moveRequestBuilder;
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)resourceId, (Object)readOptions);
        return this.open(resourceId, null, readOptions);
    }

    @Override
    public SeekableByteChannel open(GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)itemInfo, (Object)readOptions);
        Preconditions.checkNotNull(itemInfo, "itemInfo should not be null");
        StorageResourceId resourceId = itemInfo.getResourceId();
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        return this.open(resourceId, itemInfo, readOptions);
    }

    private SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        return new GoogleCloudStorageClientReadChannel(this.storage, itemInfo == null ? this.getItemInfo(resourceId) : itemInfo, readOptions, errorExtractor, this.storageOptions);
    }

    @Override
    public void close() {
        try {
            try {
                this.storage.close();
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Error occurred while closing the storage client");
            }
            try {
                super.close();
            }
            finally {
                this.backgroundTasksThreadPool.shutdown();
            }
        }
        finally {
            this.backgroundTasksThreadPool = null;
        }
    }

    @Override
    public void renameHnFolder(URI src, URI dst) throws IOException {
        super.renameHnFolder(src, dst);
    }

    private long getWriteGeneration(StorageResourceId resourceId, boolean overwrite) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getWriteGeneration(%s, %s)", (Object)resourceId, overwrite);
        GoogleCloudStorageItemInfo info = this.getItemInfo(resourceId);
        if (!info.exists()) {
            return 0L;
        }
        if (info.exists() && overwrite) {
            long generation = info.getContentGeneration();
            Preconditions.checkState(generation != 0L, "Generation should not be 0 for an existing item");
            return generation;
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new FileAlreadyExistsException(String.format("Object %s already exists.", resourceId));
    }

    private static Storage createStorage(Credentials credentials, GoogleCloudStorageOptions storageOptions, List<ClientInterceptor> interceptors, Function<List<AccessBoundary>, String> downscopedAccessTokenFn, ExecutorService pCUExecutorService) throws IOException {
        ImmutableMap<String, String> headers = GoogleCloudStorageClientImpl.getUpdatedHeadersWithUserAgent(storageOptions);
        return (Storage)StorageOptions.grpc().setAttemptDirectPath(storageOptions.isDirectPathPreferred()).setHeaderProvider(() -> headers).setGrpcInterceptorProvider(() -> {
            ArrayList<ClientInterceptor> list = new ArrayList<ClientInterceptor>();
            if (interceptors != null && !interceptors.isEmpty()) {
                list.addAll(interceptors.stream().filter(x -> x != null).collect(Collectors.toList()));
            }
            if (storageOptions.isTraceLogEnabled()) {
                list.add(new GoogleCloudStorageClientGrpcTracingInterceptor());
            }
            if (downscopedAccessTokenFn != null) {
                list.add(new GoogleCloudStorageClientGrpcDownscopingInterceptor(downscopedAccessTokenFn));
            }
            list.add(new GoogleCloudStorageClientGrpcStatisticsInterceptor());
            return ImmutableList.copyOf(list);
        }).setCredentials(credentials != null ? credentials : GoogleCloudStorageClientImpl.getNoCredentials(downscopedAccessTokenFn)).setBlobWriteSessionConfig(GoogleCloudStorageClientImpl.getSessionConfig(storageOptions.getWriteChannelOptions(), pCUExecutorService)).build().getService();
    }

    private static Credentials getNoCredentials(Function<List<AccessBoundary>, String> downscopedAccessTokenFn) {
        if (downscopedAccessTokenFn == null) {
            return null;
        }
        return GoogleCredentials.create(new AccessToken("", null));
    }

    private static ImmutableMap<String, String> getUpdatedHeadersWithUserAgent(GoogleCloudStorageOptions storageOptions) {
        ImmutableMap<String, String> httpRequestHeaders = MoreObjects.firstNonNull(storageOptions.getHttpRequestHeaders(), ImmutableMap.of());
        String appName = storageOptions.getAppName();
        if (!httpRequestHeaders.containsKey(USER_AGENT) && !Strings.isNullOrEmpty(appName)) {
            ((GoogleLogger.Api)logger.atFiner()).log("Setting useragent %s", appName);
            return ImmutableMap.builder().putAll(httpRequestHeaders).put(USER_AGENT, appName).build();
        }
        return httpRequestHeaders;
    }

    private static BlobWriteSessionConfig getSessionConfig(AsyncWriteChannelOptions writeOptions, ExecutorService pCUExecutorService) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("Upload strategy in use: %s", (Object)writeOptions.getUploadType());
        switch (writeOptions.getUploadType()) {
            case CHUNK_UPLOAD: {
                return BlobWriteSessionConfigs.getDefault().withChunkSize(writeOptions.getUploadChunkSize());
            }
            case WRITE_TO_DISK_THEN_UPLOAD: {
                if (writeOptions.getTemporaryPaths() == null || writeOptions.getTemporaryPaths().isEmpty()) {
                    return BlobWriteSessionConfigs.bufferToTempDirThenUpload();
                }
                return BlobWriteSessionConfigs.bufferToDiskThenUpload(writeOptions.getTemporaryPaths().stream().map(x -> Paths.get(x, new String[0])).collect(ImmutableSet.toImmutableSet()));
            }
            case JOURNALING: {
                if (writeOptions.getTemporaryPaths() == null || writeOptions.getTemporaryPaths().isEmpty()) {
                    throw new IllegalArgumentException("Upload using `Journaling` requires the property:fs.gs.write.temporary.dirs to be set.");
                }
                return BlobWriteSessionConfigs.journaling(writeOptions.getTemporaryPaths().stream().map(x -> Paths.get(x, new String[0])).collect(ImmutableSet.toImmutableSet()));
            }
            case PARALLEL_COMPOSITE_UPLOAD: {
                return BlobWriteSessionConfigs.parallelCompositeUpload().withBufferAllocationStrategy(ParallelCompositeUploadBlobWriteSessionConfig.BufferAllocationStrategy.fixedPool(writeOptions.getPCUBufferCount(), writeOptions.getPCUBufferCapacity())).withPartCleanupStrategy(GoogleCloudStorageClientImpl.getPartCleanupStrategy(writeOptions.getPartFileCleanupType())).withExecutorSupplier(GoogleCloudStorageClientImpl.getPCUExecutorSupplier(pCUExecutorService)).withPartNamingStrategy(GoogleCloudStorageClientImpl.getPartNamingStrategy(writeOptions.getPartFileNamePrefix()));
            }
        }
        throw new IllegalArgumentException(String.format("Upload type:%s is not supported.", new Object[]{writeOptions.getUploadType()}));
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy getPartCleanupStrategy(AsyncWriteChannelOptions.PartFileCleanupType cleanupType) {
        switch (cleanupType) {
            case NEVER: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.never();
            }
            case ON_SUCCESS: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.onlyOnSuccess();
            }
            case ALWAYS: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.always();
            }
        }
        throw new IllegalArgumentException(String.format("Cleanup type:%s is not handled.", new Object[]{cleanupType}));
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy getPartNamingStrategy(String partFilePrefix) {
        if (Strings.isNullOrEmpty(partFilePrefix)) {
            return ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy.useObjectNameAsPrefix();
        }
        return ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy.prefix(partFilePrefix);
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier getPCUExecutorSupplier(ExecutorService pCUExecutorService) {
        return pCUExecutorService == null ? ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier.cachedPool() : ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier.useExecutor(pCUExecutorService);
    }

    public static Builder builder() {
        return new AutoBuilder_GoogleCloudStorageClientImpl_Builder();
    }

    @AutoBuilder(ofClass=GoogleCloudStorageClientImpl.class)
    public static abstract class Builder {
        public abstract Builder setOptions(GoogleCloudStorageOptions var1);

        public abstract Builder setHttpTransport(@Nullable HttpTransport var1);

        public abstract Builder setCredentials(@Nullable Credentials var1);

        @VisibleForTesting
        public abstract Builder setHttpRequestInitializer(@Nullable HttpRequestInitializer var1);

        public abstract Builder setDownscopedAccessTokenFn(@Nullable Function<List<AccessBoundary>, String> var1);

        public abstract Builder setGRPCInterceptors(@Nullable ImmutableList<ClientInterceptor> var1);

        @VisibleForTesting
        public abstract Builder setClientLibraryStorage(@Nullable Storage var1);

        @VisibleForTesting
        public abstract Builder setPCUExecutorService(@Nullable ExecutorService var1);

        public abstract GoogleCloudStorageClientImpl build() throws IOException;
    }
}

