/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpResponseException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.IoExceptionHelper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public class ApiErrorExtractor {
    public static final ApiErrorExtractor INSTANCE = new ApiErrorExtractor();
    public static final int STATUS_CODE_RANGE_NOT_SATISFIABLE = 416;
    public static final String GLOBAL_DOMAIN = "global";
    public static final String USAGE_LIMITS_DOMAIN = "usageLimits";
    public static final String RATE_LIMITED_REASON = "rateLimitExceeded";
    public static final String USER_RATE_LIMITED_REASON = "userRateLimitExceeded";
    public static final String QUOTA_EXCEEDED_REASON = "quotaExceeded";
    public static final String ACCOUNT_DISABLED_REASON = "accountDisabled";
    public static final String ACCESS_NOT_CONFIGURED_REASON = "accessNotConfigured";
    public static final String RESOURCE_NOT_READY_REASON = "resourceNotReady";
    public static final String FIELD_SIZE_TOO_LARGE_REASON = "fieldSizeTooLarge";
    public static final String USER_PROJECT_MISSING_MESSAGE = "Bucket is a requester pays bucket but no user project provided.";
    private static final String DEBUG_INFO_FIELD = "debugInfo";

    public boolean requestFailure(IOException e) {
        HttpResponseException httpException = ApiErrorExtractor.getHttpResponseException(e);
        return httpException != null && (this.accessDenied(httpException) || this.badRequest(httpException) || this.internalServerError(httpException) || this.rateLimited(httpException) || IoExceptionHelper.isSocketError(httpException) || this.unauthorized(httpException));
    }

    public boolean accessDenied(IOException e) {
        return this.recursiveCheckForCode(e, 403);
    }

    public boolean badRequest(IOException e) {
        return this.recursiveCheckForCode(e, 400);
    }

    public boolean unauthorized(IOException e) {
        return this.recursiveCheckForCode(e, 401);
    }

    public boolean accessDeniedNonRecoverable(IOException e) {
        GoogleJsonError.ErrorInfo errorInfo = this.getErrorInfo(e);
        String reason = errorInfo != null ? errorInfo.getReason() : null;
        return ACCOUNT_DISABLED_REASON.equals(reason) || ACCESS_NOT_CONFIGURED_REASON.equals(reason);
    }

    public boolean clientError(IOException e) {
        HttpResponseException httpException = ApiErrorExtractor.getHttpResponseException(e);
        return httpException != null && this.getHttpStatusCode(httpException) / 100 == 4;
    }

    public boolean internalServerError(IOException e) {
        HttpResponseException httpException = ApiErrorExtractor.getHttpResponseException(e);
        return httpException != null && this.getHttpStatusCode(httpException) / 100 == 5;
    }

    public boolean itemAlreadyExists(IOException e) {
        return this.recursiveCheckForCode(e, 409);
    }

    public boolean itemNotFound(IOException e) {
        return this.recursiveCheckForCode(e, 404);
    }

    public boolean fieldSizeTooLarge(IOException e) {
        GoogleJsonError.ErrorInfo errorInfo = this.getErrorInfo(e);
        return errorInfo != null && FIELD_SIZE_TOO_LARGE_REASON.equals(errorInfo.getReason());
    }

    public boolean resourceNotReady(IOException e) {
        GoogleJsonError.ErrorInfo errorInfo = this.getErrorInfo(e);
        return errorInfo != null && RESOURCE_NOT_READY_REASON.equals(errorInfo.getReason());
    }

    public boolean preconditionNotMet(IOException e) {
        return this.recursiveCheckForCode(e, 412);
    }

    public boolean rangeNotSatisfiable(IOException e) {
        return this.recursiveCheckForCode(e, 416);
    }

    public boolean rateLimited(IOException e) {
        GoogleJsonError.ErrorInfo errorInfo = this.getErrorInfo(e);
        if (errorInfo != null) {
            String domain = errorInfo.getDomain();
            boolean isRateLimitedOrGlobalDomain = USAGE_LIMITS_DOMAIN.equals(domain) || GLOBAL_DOMAIN.equals(domain);
            String reason = errorInfo.getReason();
            boolean isRateLimitedReason = RATE_LIMITED_REASON.equals(reason) || USER_RATE_LIMITED_REASON.equals(reason);
            return isRateLimitedOrGlobalDomain && isRateLimitedReason;
        }
        return false;
    }

    public boolean quotaExceeded(IOException e) {
        GoogleJsonError.ErrorInfo errorInfo = this.getErrorInfo(e);
        return errorInfo != null && QUOTA_EXCEEDED_REASON.equals(errorInfo.getReason());
    }

    public boolean userProjectMissing(IOException e) {
        GoogleJsonError jsonError = this.getJsonError(e);
        return jsonError != null && jsonError.getCode() == 400 && USER_PROJECT_MISSING_MESSAGE.equals(jsonError.getMessage());
    }

    public String getErrorMessage(IOException e) {
        GoogleJsonError jsonError = this.getJsonError(e);
        return jsonError == null ? e.getMessage() : jsonError.getMessage();
    }

    public IOException toUserPresentableException(IOException e, String action) throws IOException {
        throw new IOException(this.toUserPresentableMessage(e, action), e);
    }

    public String toUserPresentableMessage(IOException e, @Nullable String action) {
        String message = "Internal server error";
        if (this.clientError(e)) {
            message = this.getErrorMessage(e);
        }
        return action == null ? message : String.format("Encountered an error while %s: %s", action, message);
    }

    public String toUserPresentableMessage(IOException e) {
        return this.toUserPresentableMessage(e, null);
    }

    @Nullable
    public String getDebugInfo(IOException e) {
        GoogleJsonError.ErrorInfo errorInfo = this.getErrorInfo(e);
        return errorInfo != null ? (String)errorInfo.getUnknownKeys().get(DEBUG_INFO_FIELD) : null;
    }

    protected int getHttpStatusCode(HttpResponseException e) {
        return e.getStatusCode();
    }

    @Nullable
    protected GoogleJsonError.ErrorInfo getErrorInfo(IOException e) {
        GoogleJsonError jsonError = this.getJsonError(e);
        List<Object> errors = jsonError != null ? jsonError.getErrors() : ImmutableList.of();
        return errors != null ? (GoogleJsonError.ErrorInfo)Iterables.getFirst(errors, null) : null;
    }

    @Nullable
    protected GoogleJsonError getJsonError(IOException e) {
        GoogleJsonResponseException jsonException = ApiErrorExtractor.getJsonResponseException(e);
        return jsonException == null ? null : jsonException.getDetails();
    }

    protected boolean recursiveCheckForCode(IOException e, int code) {
        HttpResponseException httpException = ApiErrorExtractor.getHttpResponseException(e);
        return httpException != null && this.getHttpStatusCode(httpException) == code;
    }

    @Nullable
    public static GoogleJsonResponseException getJsonResponseException(Throwable throwable) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof GoogleJsonResponseException)) continue;
            return (GoogleJsonResponseException)cause;
        }
        return null;
    }

    @Nullable
    public static HttpResponseException getHttpResponseException(Throwable throwable) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof HttpResponseException)) continue;
            return (HttpResponseException)cause;
        }
        return null;
    }
}

