/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.Gson;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThreadTrace {
    static final int MAX_EVENTS_SIZE = 20;
    private static Gson gson = new Gson();
    private final String trackingId;
    private final List<ThreadTraceEvent> events;
    private final Map<Long, List<ThreadTraceEvent>> subEvents = new HashMap<Long, List<ThreadTraceEvent>>();

    public ThreadTrace(String trackingId) {
        this(trackingId, new ArrayList<ThreadTraceEvent>());
    }

    private ThreadTrace(String trackingId, List<ThreadTraceEvent> events) {
        Preconditions.checkNotNull(trackingId, "trackingId cannot be null");
        Preconditions.checkNotNull(events, "events cannot be null. trackingId=%s", (Object)trackingId);
        this.trackingId = trackingId;
        this.events = events;
    }

    public String toString() {
        return gson.toJson(this);
    }

    ThreadTraceEvent starOperationEvent(String name) {
        if (this.isFull()) {
            return null;
        }
        ThreadTraceEvent theEvent = ThreadTraceEvent.startEvent(name);
        this.events.add(theEvent);
        return theEvent;
    }

    void endOperationEvent(ThreadTraceEvent startEvent) {
        ThreadTraceEvent lastEvent;
        if (this.isFull() || startEvent == null) {
            return;
        }
        int eventsSize = this.events.size();
        if (eventsSize != 0 && (lastEvent = this.events.get(eventsSize - 1)) == startEvent) {
            startEvent.markEnd();
            return;
        }
        this.events.add(startEvent.endEvent());
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    synchronized ThreadTrace getSubTrace() {
        long threadId = Thread.currentThread().getId();
        this.subEvents.putIfAbsent(threadId, new ArrayList());
        int size = this.subEvents.get(threadId).size();
        if (size >= 20) {
            return null;
        }
        return new ThreadTrace(this.trackingId, this.subEvents.get(threadId).subList(size, size));
    }

    public void annotate(String key, Object value) {
        if (this.events.size() == 0) {
            return;
        }
        this.events.get(this.events.size() - 1).annotate(key, value);
    }

    private boolean isFull() {
        return this.events.size() >= 20;
    }

    static class ThreadTraceEvent
    extends HashMap<String, Object> {
        static final int MAX_PROPERTY_SIZE = 10;
        @Expose(serialize=false)
        private final long timeStamp;
        @Expose(serialize=false)
        private final String name;

        static ThreadTraceEvent startEvent(String name) {
            return new ThreadTraceEvent(EventType.START, name);
        }

        private ThreadTraceEvent(EventType type, String name) {
            super(5);
            this.setEventType(type);
            this.put("name", name);
            this.timeStamp = System.currentTimeMillis();
            this.name = name;
            if (type == EventType.START) {
                this.put("starttime", this.timeStamp);
            } else if (type == EventType.END) {
                this.put("endtime", this.timeStamp);
            } else {
                throw new IllegalStateException("Not expected to create event of type: " + String.valueOf((Object)type));
            }
        }

        public void markEnd() {
            this.setEventType(EventType.MERGED);
            this.setTimeTaken(System.currentTimeMillis() - this.timeStamp);
        }

        ThreadTraceEvent endEvent() {
            ThreadTraceEvent result = new ThreadTraceEvent(EventType.END, this.name);
            result.setTimeTaken(result.timeStamp - this.timeStamp);
            return result;
        }

        void annotate(String key, Object value) {
            if (this.size() >= 10) {
                return;
            }
            this.put(key, value);
        }

        private void setTimeTaken(long timeTaken) {
            this.put("timetaken", timeTaken);
        }

        private void setEventType(EventType eventType) {
            this.put("type", eventType);
        }

        private static enum EventType {
            START,
            END,
            MERGED;

        }
    }
}

