/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.ValidationException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LogName
implements ResourceName {
    private static final PathTemplate PROJECT_LOG = PathTemplate.createWithoutUrlEncoding("projects/{project}/logs/{log}");
    private static final PathTemplate ORGANIZATION_LOG = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/logs/{log}");
    private static final PathTemplate FOLDER_LOG = PathTemplate.createWithoutUrlEncoding("folders/{folder}/logs/{log}");
    private static final PathTemplate BILLING_ACCOUNT_LOG = PathTemplate.createWithoutUrlEncoding("billingAccounts/{billing_account}/logs/{log}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String log;
    private final String organization;
    private final String folder;
    private final String billingAccount;

    @Deprecated
    protected LogName() {
        this.project = null;
        this.log = null;
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
    }

    private LogName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.log = Preconditions.checkNotNull(builder.getLog());
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = PROJECT_LOG;
    }

    private LogName(OrganizationLogBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.log = Preconditions.checkNotNull(builder.getLog());
        this.project = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = ORGANIZATION_LOG;
    }

    private LogName(FolderLogBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.log = Preconditions.checkNotNull(builder.getLog());
        this.project = null;
        this.organization = null;
        this.billingAccount = null;
        this.pathTemplate = FOLDER_LOG;
    }

    private LogName(BillingAccountLogBuilder builder) {
        this.billingAccount = Preconditions.checkNotNull(builder.getBillingAccount());
        this.log = Preconditions.checkNotNull(builder.getLog());
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.pathTemplate = BILLING_ACCOUNT_LOG;
    }

    public String getProject() {
        return this.project;
    }

    public String getLog() {
        return this.log;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLogBuilder() {
        return new Builder();
    }

    public static OrganizationLogBuilder newOrganizationLogBuilder() {
        return new OrganizationLogBuilder();
    }

    public static FolderLogBuilder newFolderLogBuilder() {
        return new FolderLogBuilder();
    }

    public static BillingAccountLogBuilder newBillingAccountLogBuilder() {
        return new BillingAccountLogBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LogName of(String project, String log) {
        return LogName.newBuilder().setProject(project).setLog(log).build();
    }

    public static LogName ofProjectLogName(String project, String log) {
        return LogName.newBuilder().setProject(project).setLog(log).build();
    }

    public static LogName ofOrganizationLogName(String organization, String log) {
        return LogName.newOrganizationLogBuilder().setOrganization(organization).setLog(log).build();
    }

    public static LogName ofFolderLogName(String folder, String log) {
        return LogName.newFolderLogBuilder().setFolder(folder).setLog(log).build();
    }

    public static LogName ofBillingAccountLogName(String billingAccount, String log) {
        return LogName.newBillingAccountLogBuilder().setBillingAccount(billingAccount).setLog(log).build();
    }

    public static String format(String project, String log) {
        return LogName.newBuilder().setProject(project).setLog(log).build().toString();
    }

    public static String formatProjectLogName(String project, String log) {
        return LogName.newBuilder().setProject(project).setLog(log).build().toString();
    }

    public static String formatOrganizationLogName(String organization, String log) {
        return LogName.newOrganizationLogBuilder().setOrganization(organization).setLog(log).build().toString();
    }

    public static String formatFolderLogName(String folder, String log) {
        return LogName.newFolderLogBuilder().setFolder(folder).setLog(log).build().toString();
    }

    public static String formatBillingAccountLogName(String billingAccount, String log) {
        return LogName.newBillingAccountLogBuilder().setBillingAccount(billingAccount).setLog(log).build().toString();
    }

    public static LogName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOG.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_LOG.match(formattedString);
            return LogName.ofProjectLogName(matchMap.get("project"), matchMap.get("log"));
        }
        if (ORGANIZATION_LOG.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_LOG.match(formattedString);
            return LogName.ofOrganizationLogName(matchMap.get("organization"), matchMap.get("log"));
        }
        if (FOLDER_LOG.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_LOG.match(formattedString);
            return LogName.ofFolderLogName(matchMap.get("folder"), matchMap.get("log"));
        }
        if (BILLING_ACCOUNT_LOG.matches(formattedString)) {
            Map<String, String> matchMap = BILLING_ACCOUNT_LOG.match(formattedString);
            return LogName.ofBillingAccountLogName(matchMap.get("billing_account"), matchMap.get("log"));
        }
        throw new ValidationException("LogName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<LogName> parseList(List<String> formattedStrings) {
        ArrayList<LogName> list = new ArrayList<LogName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LogName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LogName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LogName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOG.matches(formattedString) || ORGANIZATION_LOG.matches(formattedString) || FOLDER_LOG.matches(formattedString) || BILLING_ACCOUNT_LOG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LogName logName = this;
            synchronized (logName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.log != null) {
                        fieldMapBuilder.put("log", this.log);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put("billing_account", this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LogName that = (LogName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.log, that.log) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.log);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    public static class BillingAccountLogBuilder {
        private String billingAccount;
        private String log;

        protected BillingAccountLogBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLog() {
            return this.log;
        }

        public BillingAccountLogBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountLogBuilder setLog(String log) {
            this.log = log;
            return this;
        }

        public LogName build() {
            return new LogName(this);
        }
    }

    public static class FolderLogBuilder {
        private String folder;
        private String log;

        protected FolderLogBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLog() {
            return this.log;
        }

        public FolderLogBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLogBuilder setLog(String log) {
            this.log = log;
            return this;
        }

        public LogName build() {
            return new LogName(this);
        }
    }

    public static class OrganizationLogBuilder {
        private String organization;
        private String log;

        protected OrganizationLogBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLog() {
            return this.log;
        }

        public OrganizationLogBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLogBuilder setLog(String log) {
            this.log = log;
            return this;
        }

        public LogName build() {
            return new LogName(this);
        }
    }

    public static class Builder {
        private String project;
        private String log;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLog() {
            return this.log;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLog(String log) {
            this.log = log;
            return this;
        }

        private Builder(LogName logName) {
            Preconditions.checkArgument(Objects.equals(logName.pathTemplate, PROJECT_LOG), "toBuilder is only supported when LogName has the pattern of projects/{project}/logs/{log}");
            this.project = logName.project;
            this.log = logName.log;
        }

        public LogName build() {
            return new LogName(this);
        }
    }
}

