/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.ValidationException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LogSinkName
implements ResourceName {
    private static final PathTemplate PROJECT_SINK = PathTemplate.createWithoutUrlEncoding("projects/{project}/sinks/{sink}");
    private static final PathTemplate ORGANIZATION_SINK = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/sinks/{sink}");
    private static final PathTemplate FOLDER_SINK = PathTemplate.createWithoutUrlEncoding("folders/{folder}/sinks/{sink}");
    private static final PathTemplate BILLING_ACCOUNT_SINK = PathTemplate.createWithoutUrlEncoding("billingAccounts/{billing_account}/sinks/{sink}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String sink;
    private final String organization;
    private final String folder;
    private final String billingAccount;

    @Deprecated
    protected LogSinkName() {
        this.project = null;
        this.sink = null;
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
    }

    private LogSinkName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.sink = Preconditions.checkNotNull(builder.getSink());
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = PROJECT_SINK;
    }

    private LogSinkName(OrganizationSinkBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.sink = Preconditions.checkNotNull(builder.getSink());
        this.project = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = ORGANIZATION_SINK;
    }

    private LogSinkName(FolderSinkBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.sink = Preconditions.checkNotNull(builder.getSink());
        this.project = null;
        this.organization = null;
        this.billingAccount = null;
        this.pathTemplate = FOLDER_SINK;
    }

    private LogSinkName(BillingAccountSinkBuilder builder) {
        this.billingAccount = Preconditions.checkNotNull(builder.getBillingAccount());
        this.sink = Preconditions.checkNotNull(builder.getSink());
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.pathTemplate = BILLING_ACCOUNT_SINK;
    }

    public String getProject() {
        return this.project;
    }

    public String getSink() {
        return this.sink;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectSinkBuilder() {
        return new Builder();
    }

    public static OrganizationSinkBuilder newOrganizationSinkBuilder() {
        return new OrganizationSinkBuilder();
    }

    public static FolderSinkBuilder newFolderSinkBuilder() {
        return new FolderSinkBuilder();
    }

    public static BillingAccountSinkBuilder newBillingAccountSinkBuilder() {
        return new BillingAccountSinkBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LogSinkName of(String project, String sink) {
        return LogSinkName.newBuilder().setProject(project).setSink(sink).build();
    }

    public static LogSinkName ofProjectSinkName(String project, String sink) {
        return LogSinkName.newBuilder().setProject(project).setSink(sink).build();
    }

    public static LogSinkName ofOrganizationSinkName(String organization, String sink) {
        return LogSinkName.newOrganizationSinkBuilder().setOrganization(organization).setSink(sink).build();
    }

    public static LogSinkName ofFolderSinkName(String folder, String sink) {
        return LogSinkName.newFolderSinkBuilder().setFolder(folder).setSink(sink).build();
    }

    public static LogSinkName ofBillingAccountSinkName(String billingAccount, String sink) {
        return LogSinkName.newBillingAccountSinkBuilder().setBillingAccount(billingAccount).setSink(sink).build();
    }

    public static String format(String project, String sink) {
        return LogSinkName.newBuilder().setProject(project).setSink(sink).build().toString();
    }

    public static String formatProjectSinkName(String project, String sink) {
        return LogSinkName.newBuilder().setProject(project).setSink(sink).build().toString();
    }

    public static String formatOrganizationSinkName(String organization, String sink) {
        return LogSinkName.newOrganizationSinkBuilder().setOrganization(organization).setSink(sink).build().toString();
    }

    public static String formatFolderSinkName(String folder, String sink) {
        return LogSinkName.newFolderSinkBuilder().setFolder(folder).setSink(sink).build().toString();
    }

    public static String formatBillingAccountSinkName(String billingAccount, String sink) {
        return LogSinkName.newBillingAccountSinkBuilder().setBillingAccount(billingAccount).setSink(sink).build().toString();
    }

    public static LogSinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SINK.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_SINK.match(formattedString);
            return LogSinkName.ofProjectSinkName(matchMap.get("project"), matchMap.get("sink"));
        }
        if (ORGANIZATION_SINK.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_SINK.match(formattedString);
            return LogSinkName.ofOrganizationSinkName(matchMap.get("organization"), matchMap.get("sink"));
        }
        if (FOLDER_SINK.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_SINK.match(formattedString);
            return LogSinkName.ofFolderSinkName(matchMap.get("folder"), matchMap.get("sink"));
        }
        if (BILLING_ACCOUNT_SINK.matches(formattedString)) {
            Map<String, String> matchMap = BILLING_ACCOUNT_SINK.match(formattedString);
            return LogSinkName.ofBillingAccountSinkName(matchMap.get("billing_account"), matchMap.get("sink"));
        }
        throw new ValidationException("LogSinkName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<LogSinkName> parseList(List<String> formattedStrings) {
        ArrayList<LogSinkName> list = new ArrayList<LogSinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LogSinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LogSinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LogSinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SINK.matches(formattedString) || ORGANIZATION_SINK.matches(formattedString) || FOLDER_SINK.matches(formattedString) || BILLING_ACCOUNT_SINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LogSinkName logSinkName = this;
            synchronized (logSinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.sink != null) {
                        fieldMapBuilder.put("sink", this.sink);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put("billing_account", this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LogSinkName that = (LogSinkName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.sink, that.sink) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.sink);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    public static class BillingAccountSinkBuilder {
        private String billingAccount;
        private String sink;

        protected BillingAccountSinkBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getSink() {
            return this.sink;
        }

        public BillingAccountSinkBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountSinkBuilder setSink(String sink) {
            this.sink = sink;
            return this;
        }

        public LogSinkName build() {
            return new LogSinkName(this);
        }
    }

    public static class FolderSinkBuilder {
        private String folder;
        private String sink;

        protected FolderSinkBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getSink() {
            return this.sink;
        }

        public FolderSinkBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderSinkBuilder setSink(String sink) {
            this.sink = sink;
            return this;
        }

        public LogSinkName build() {
            return new LogSinkName(this);
        }
    }

    public static class OrganizationSinkBuilder {
        private String organization;
        private String sink;

        protected OrganizationSinkBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSink() {
            return this.sink;
        }

        public OrganizationSinkBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationSinkBuilder setSink(String sink) {
            this.sink = sink;
            return this;
        }

        public LogSinkName build() {
            return new LogSinkName(this);
        }
    }

    public static class Builder {
        private String project;
        private String sink;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSink() {
            return this.sink;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSink(String sink) {
            this.sink = sink;
            return this;
        }

        private Builder(LogSinkName logSinkName) {
            Preconditions.checkArgument(Objects.equals(logSinkName.pathTemplate, PROJECT_SINK), "toBuilder is only supported when LogSinkName has the pattern of projects/{project}/sinks/{sink}");
            this.project = logSinkName.project;
            this.sink = logSinkName.sink;
        }

        public LogSinkName build() {
            return new LogSinkName(this);
        }
    }
}

