/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.BackOff;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.ExponentialBackOff;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.paging.Page;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.AccessToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.AutoBuilder_GoogleCloudStorageClientImpl_Builder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.BatchExecutor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcDownscopingInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcStatisticsInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcTracingInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientReadChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GrpcErrorTypeExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Blob;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSessionConfigs;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Bucket;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BucketInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.CopyWriter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ParallelCompositeUploadBlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageClass;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Iterables;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Maps;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Sets;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.BaseEncoding;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.FutureCallback;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.util.AccessBoundary;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@VisibleForTesting
public class GoogleCloudStorageClientImpl
extends ForwardingGoogleCloudStorage {
    private static final String USER_AGENT = "user-agent";
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final int MAXIMUM_PRECONDITION_FAILURES_IN_DELETE = 4;
    private final GoogleCloudStorageOptions storageOptions;
    private final Storage storage;
    private static final ErrorTypeExtractor errorExtractor = GrpcErrorTypeExtractor.INSTANCE;
    static final List<Storage.BlobField> BLOB_FIELDS = ImmutableList.of(Storage.BlobField.BUCKET, Storage.BlobField.CONTENT_ENCODING, Storage.BlobField.CONTENT_TYPE, Storage.BlobField.CRC32C, Storage.BlobField.GENERATION, Storage.BlobField.METADATA, Storage.BlobField.MD5HASH, Storage.BlobField.METAGENERATION, Storage.BlobField.NAME, Storage.BlobField.SIZE, Storage.BlobField.TIME_CREATED, Storage.BlobField.UPDATED, new Storage.BlobField[0]);
    private ExecutorService backgroundTasksThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcsio-storage-client-write-channel-pool-%d").setDaemon(true).build());

    private static String encodeMetadataValues(byte[] bytes) {
        return bytes == null ? null : BaseEncoding.base64().encode(bytes);
    }

    GoogleCloudStorageClientImpl(GoogleCloudStorageOptions options, @Nullable Storage clientLibraryStorage, @Nullable Credentials credentials, @Nullable HttpTransport httpTransport, @Nullable HttpRequestInitializer httpRequestInitializer, @Nullable ImmutableList<ClientInterceptor> gRPCInterceptors, @Nullable Function<List<AccessBoundary>, String> downscopedAccessTokenFn, @Nullable ExecutorService pCUExecutorService) throws IOException {
        super(GoogleCloudStorageImpl.builder().setOptions(options).setCredentials(credentials).setHttpTransport(httpTransport).setHttpRequestInitializer(httpRequestInitializer).setDownscopedAccessTokenFn(downscopedAccessTokenFn).build());
        this.storageOptions = options;
        this.storage = clientLibraryStorage == null ? GoogleCloudStorageClientImpl.createStorage(credentials, options, gRPCInterceptors, pCUExecutorService, downscopedAccessTokenFn) : clientLibraryStorage;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        if (!this.storageOptions.isGrpcWriteEnabled()) {
            return super.create(resourceId, options);
        }
        ((GoogleLogger.Api)logger.atFiner()).log("create(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        StorageResourceId resourceIdWithGeneration = resourceId;
        if (!resourceId.hasGenerationId()) {
            resourceIdWithGeneration = new StorageResourceId(resourceId.getBucketName(), resourceId.getObjectName(), this.getWriteGeneration(resourceId, options.isOverwriteExisting()));
        }
        return new GoogleCloudStorageClientWriteChannel(this.storage, this.storageOptions, resourceIdWithGeneration, options);
    }

    @Override
    public void createBucket(String bucketName, CreateBucketOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createBucket(%s)", bucketName);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        Preconditions.checkNotNull(options, "options must not be null");
        Preconditions.checkNotNull(this.storageOptions.getProjectId(), "projectId must not be null");
        BucketInfo.Builder bucketInfoBuilder = BucketInfo.newBuilder(bucketName).setLocation(options.getLocation());
        if (options.getStorageClass() != null) {
            bucketInfoBuilder.setStorageClass(StorageClass.valueOfStrict(options.getStorageClass().toUpperCase()));
        }
        if (options.getTtl() != null) {
            bucketInfoBuilder.setLifecycleRules(Collections.singletonList(new BucketInfo.LifecycleRule(BucketInfo.LifecycleRule.LifecycleAction.newDeleteAction(), BucketInfo.LifecycleRule.LifecycleCondition.newBuilder().setAge(Math.toIntExact(options.getTtl().toDays())).build())));
        }
        try {
            this.storage.create(bucketInfoBuilder.build(), new Storage.BucketTargetOption[0]);
        }
        catch (StorageException e) {
            GoogleCloudStorageEventBus.postOnException();
            if (errorExtractor.bucketAlreadyExists(e)) {
                throw (FileAlreadyExistsException)new FileAlreadyExistsException(String.format("Bucket '%s' already exists.", bucketName)).initCause(e);
            }
            throw new IOException(e);
        }
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createEmptyObject(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        this.createEmptyObject(resourceId, GoogleCloudStorageImpl.EMPTY_OBJECT_CREATE_OPTIONS);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        try {
            this.createEmptyObjectInternal(resourceId, options);
        }
        catch (StorageException e) {
            if (this.canIgnoreExceptionForEmptyObject(e, resourceId, options)) {
                ((GoogleLogger.Api)logger.atInfo()).log("Ignoring exception of type %s; verified object already exists with desired state.", e.getClass().getSimpleName());
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(e)).log("Ignored exception while creating empty object");
            }
            if (errorExtractor.getErrorType(e) == ErrorTypeExtractor.ErrorType.ALREADY_EXISTS) {
                GoogleCloudStorageEventBus.postOnException();
                throw (FileAlreadyExistsException)new FileAlreadyExistsException(String.format("Object '%s' already exists.", resourceId)).initCause(e);
            }
            throw new IOException(e);
        }
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        this.createEmptyObjects(resourceIds, GoogleCloudStorageImpl.EMPTY_OBJECT_CREATE_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createEmptyObjects(%s)", resourceIds);
        if (resourceIds.isEmpty()) {
            return;
        }
        if (resourceIds.size() == 1) {
            this.createEmptyObject(Iterables.getOnlyElement(resourceIds), options);
            return;
        }
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject names only, got: '%s'", (Object)resourceId);
        }
        Set<IOException> innerExceptions = Sets.newConcurrentHashSet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (StorageResourceId resourceId : resourceIds) {
                executor.queue(() -> {
                    try {
                        this.createEmptyObjectInternal(resourceId, options);
                        ((GoogleLogger.Api)logger.atFiner()).log("Successfully inserted %s", resourceId);
                    }
                    catch (StorageException se) {
                        boolean canIgnoreException = false;
                        try {
                            canIgnoreException = this.canIgnoreExceptionForEmptyObject(se, resourceId, options);
                        }
                        catch (Exception e) {
                            innerExceptions.add(new IOException("Error re-fetching after rate-limit error: " + resourceId, e));
                        }
                        if (canIgnoreException) {
                            ((GoogleLogger.Api)logger.atInfo()).log("Ignoring exception of type %s; verified object already exists with desired state.", se.getClass().getSimpleName());
                            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(se)).log("Ignored exception while creating empty object");
                        } else {
                            innerExceptions.add(new IOException("Error inserting " + resourceId, se));
                        }
                    }
                    catch (Exception e) {
                        innerExceptions.add(new IOException("Error inserting " + resourceId, e));
                    }
                    return null;
                }, null);
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void createEmptyObjectInternal(StorageResourceId resourceId, CreateObjectOptions createObjectOptions) {
        Map<String, String> rewrittenMetadata = GoogleCloudStorageClientImpl.encodeMetadata(createObjectOptions.getMetadata());
        ArrayList<Storage.BlobTargetOption> blobTargetOptions = new ArrayList<Storage.BlobTargetOption>();
        blobTargetOptions.add(Storage.BlobTargetOption.disableGzipContent());
        if (resourceId.hasGenerationId()) {
            blobTargetOptions.add(Storage.BlobTargetOption.generationMatch(resourceId.getGenerationId()));
        } else if (resourceId.isDirectory() || !createObjectOptions.isOverwriteExisting()) {
            blobTargetOptions.add(Storage.BlobTargetOption.doesNotExist());
        }
        if (this.storageOptions.getEncryptionKey() != null) {
            blobTargetOptions.add(Storage.BlobTargetOption.encryptionKey(this.storageOptions.getEncryptionKey().value()));
        }
        this.storage.create(BlobInfo.newBuilder(BlobId.of(resourceId.getBucketName(), resourceId.getObjectName())).setMetadata(rewrittenMetadata).setContentEncoding(createObjectOptions.getContentEncoding()).setContentType(createObjectOptions.getContentType()).build(), (Storage.BlobTargetOption[])blobTargetOptions.toArray(Storage.BlobTargetOption[]::new));
    }

    private boolean canIgnoreExceptionForEmptyObject(StorageException exceptionOnCreate, StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        ErrorTypeExtractor.ErrorType errorType = errorExtractor.getErrorType(exceptionOnCreate);
        if (errorType == ErrorTypeExtractor.ErrorType.RESOURCE_EXHAUSTED || errorType == ErrorTypeExtractor.ErrorType.INTERNAL || resourceId.isDirectory() && errorType == ErrorTypeExtractor.ErrorType.FAILED_PRECONDITION) {
            GoogleCloudStorageItemInfo existingInfo;
            Duration maxWaitTime = this.storageOptions.getMaxWaitTimeForEmptyObjectCreation();
            BackOff backOff = !maxWaitTime.isZero() && !maxWaitTime.isNegative() ? new ExponentialBackOff.Builder().setMaxElapsedTimeMillis(Math.toIntExact(maxWaitTime.toMillis())).setMaxIntervalMillis(500).setInitialIntervalMillis(100).setMultiplier(1.5).setRandomizationFactor(0.15).build() : BackOff.STOP_BACKOFF;
            long nextSleep = 0L;
            do {
                if (nextSleep > 0L) {
                    try {
                        GoogleCloudStorageImpl.sleeper.sleep(nextSleep);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        nextSleep = -1L;
                    }
                }
                existingInfo = this.getItemInfo(resourceId);
                long l = nextSleep = nextSleep == -1L ? -1L : backOff.nextBackOffMillis();
            } while (!existingInfo.exists() && nextSleep != -1L);
            if (existingInfo.exists() && existingInfo.getSize() == 0L) {
                if (options.isEnsureEmptyObjectsMetadataMatch()) {
                    return existingInfo.metadataEquals(options.getMetadata());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void copy(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames) throws IOException {
        Preconditions.checkArgument(srcObjectNames != null, "srcObjectNames must not be null");
        Preconditions.checkArgument(dstObjectNames != null, "dstObjectNames must not be null");
        Preconditions.checkArgument(srcObjectNames.size() == dstObjectNames.size(), "Must supply same number of elements in srcObjects and dstObjects");
        HashMap<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap = new HashMap<StorageResourceId, StorageResourceId>(srcObjectNames.size());
        for (int i = 0; i < srcObjectNames.size(); ++i) {
            sourceToDestinationObjectsMap.put(new StorageResourceId(srcBucketName, srcObjectNames.get(i)), new StorageResourceId(dstBucketName, dstObjectNames.get(i)));
        }
        this.copy(sourceToDestinationObjectsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(Map<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap) throws IOException {
        GoogleCloudStorageImpl.validateCopyArguments(sourceToDestinationObjectsMap, this);
        if (sourceToDestinationObjectsMap.isEmpty()) {
            return;
        }
        ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions = ConcurrentHashMap.newKeySet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (Map.Entry<StorageResourceId, StorageResourceId> entry : sourceToDestinationObjectsMap.entrySet()) {
                StorageResourceId srcObject = entry.getKey();
                StorageResourceId dstObject = entry.getValue();
                this.copyInternal(executor, innerExceptions, srcObject.getBucketName(), srcObject.getObjectName(), dstObject.getGenerationId(), dstObject.getBucketName(), dstObject.getObjectName());
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void copyInternal(BatchExecutor executor, ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, String srcBucketName, String srcObjectName, long dstContentGeneration, String dstBucketName, String dstObjectName) {
        Storage.CopyRequest.Builder copyRequestBuilder = Storage.CopyRequest.newBuilder().setSource(BlobId.of(srcBucketName, srcObjectName));
        if (dstContentGeneration != -1L) {
            copyRequestBuilder.setTarget(BlobId.of(dstBucketName, dstObjectName), Storage.BlobTargetOption.generationMatch(dstContentGeneration));
        } else {
            copyRequestBuilder.setTarget(BlobId.of(dstBucketName, dstObjectName));
        }
        if (this.storageOptions.getEncryptionKey() != null) {
            copyRequestBuilder.setSourceOptions(Storage.BlobSourceOption.decryptionKey(this.storageOptions.getEncryptionKey().value()));
            copyRequestBuilder.setTarget(copyRequestBuilder.build().getTarget().getBlobId(), Storage.BlobTargetOption.encryptionKey(this.storageOptions.getEncryptionKey().value()));
        }
        if (this.storageOptions.getMaxRewriteChunkSize() > 0L) {
            copyRequestBuilder.setMegabytesCopiedPerChunk(this.storageOptions.getMaxRewriteChunkSize() / 0x100000L);
        }
        executor.queue(() -> {
            try {
                String srcString = StringPaths.fromComponents(srcBucketName, srcObjectName);
                String dstString = StringPaths.fromComponents(dstBucketName, dstObjectName);
                CopyWriter copyWriter = this.storage.copy(copyRequestBuilder.build());
                while (!copyWriter.isDone()) {
                    copyWriter.copyChunk();
                    ((GoogleLogger.Api)logger.atFinest()).log("Copy (%s to %s) did not complete. Resuming...", (Object)srcString, (Object)dstString);
                }
                ((GoogleLogger.Api)logger.atFiner()).log("Successfully copied %s to %s", (Object)srcString, (Object)dstString);
            }
            catch (StorageException e) {
                GoogleCloudStorageEventBus.postOnException();
                if (errorExtractor.getErrorType(e) == ErrorTypeExtractor.ErrorType.NOT_FOUND) {
                    innerExceptions.add(GoogleCloudStorageExceptions.createFileNotFoundException(srcBucketName, srcObjectName, new IOException(e)));
                }
                innerExceptions.add(new IOException(String.format("Error copying '%s'", StringPaths.fromComponents(srcBucketName, srcObjectName)), e));
            }
            return null;
        }, null);
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listBucketNames()");
        List<Bucket> allBuckets = this.listBucketsInternal();
        ArrayList<String> bucketNames = new ArrayList<String>(allBuckets.size());
        for (Bucket bucket : allBuckets) {
            bucketNames.add(bucket.getName());
        }
        return bucketNames;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listBucketInfo()");
        List<Bucket> allBuckets = this.listBucketsInternal();
        ArrayList<GoogleCloudStorageItemInfo> bucketInfos = new ArrayList<GoogleCloudStorageItemInfo>(allBuckets.size());
        for (Bucket bucket : allBuckets) {
            bucketInfos.add(GoogleCloudStorageClientImpl.createItemInfoForBucket(new StorageResourceId(bucket.getName()), bucket));
        }
        return bucketInfos;
    }

    private List<Bucket> listBucketsInternal() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listBucketsInternal()");
        Preconditions.checkNotNull(this.storageOptions.getProjectId(), "projectId must not be null");
        ArrayList<Bucket> allBuckets = new ArrayList<Bucket>();
        try {
            Page<Bucket> buckets = this.storage.list(Storage.BucketListOption.pageSize(this.storageOptions.getMaxListItemsPerCall()), Storage.BucketListOption.fields(Storage.BucketField.LOCATION, Storage.BucketField.STORAGE_CLASS, Storage.BucketField.TIME_CREATED, Storage.BucketField.UPDATED));
            for (Bucket bucket : buckets.iterateAll()) {
                allBuckets.add(bucket);
            }
        }
        catch (StorageException e) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(e);
        }
        return allBuckets;
    }

    private static GoogleCloudStorageItemInfo createItemInfoForBucket(StorageResourceId resourceId, Bucket bucket) {
        Preconditions.checkArgument(resourceId != null, "resourceId must not be null");
        Preconditions.checkArgument(bucket != null, "bucket must not be null");
        Preconditions.checkArgument(resourceId.isBucket(), "resourceId must be a Bucket. resourceId: %s", (Object)resourceId);
        Preconditions.checkArgument(resourceId.getBucketName().equals(bucket.getName()), "resourceId.getBucketName() must equal bucket.getName(): '%s' vs '%s'", (Object)resourceId.getBucketName(), (Object)bucket.getName());
        return GoogleCloudStorageItemInfo.createBucket(resourceId, bucket.asBucketInfo().getCreateTimeOffsetDateTime().toInstant().toEpochMilli(), bucket.asBucketInfo().getUpdateTimeOffsetDateTime().toInstant().toEpochMilli(), bucket.getLocation(), bucket.getStorageClass() == null ? null : bucket.getStorageClass().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("deleteObjects(%s)", fullObjectNames);
        if (fullObjectNames.isEmpty()) {
            return;
        }
        for (StorageResourceId fullObjectName : fullObjectNames) {
            Preconditions.checkArgument(fullObjectName.isStorageObject(), "Expected full StorageObject names only, got: %s", (Object)fullObjectName);
        }
        ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions = ConcurrentHashMap.newKeySet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (StorageResourceId object : fullObjectNames) {
                this.queueSingleObjectDelete(object, innerExceptions, executor, 0);
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void queueSingleObjectDelete(final StorageResourceId resourceId, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final BatchExecutor batchExecutor, final int attempt) {
        final String bucketName = resourceId.getBucketName();
        final String objectName = resourceId.getObjectName();
        if (resourceId.hasGenerationId()) {
            batchExecutor.queue(() -> this.storage.delete(BlobId.of(bucketName, objectName), Storage.BlobSourceOption.generationMatch(resourceId.getGenerationId())), this.getObjectDeletionCallback(resourceId, innerExceptions, batchExecutor, attempt, resourceId.getGenerationId()));
        } else {
            batchExecutor.queue(() -> this.storage.get(BlobId.of(bucketName, objectName), Storage.BlobGetOption.fields(Storage.BlobField.GENERATION)), new FutureCallback<Blob>(){

                @Override
                public void onSuccess(Blob blob) {
                    if (blob == null) {
                        ((GoogleLogger.Api)logger.atFiner()).log("deleteObjects(%s): get not found.", resourceId);
                        return;
                    }
                    long generation = Preconditions.checkNotNull(blob.getGeneration(), "generation can not be null");
                    batchExecutor.queue(() -> GoogleCloudStorageClientImpl.this.storage.delete(BlobId.of(bucketName, objectName), Storage.BlobSourceOption.generationMatch(generation)), GoogleCloudStorageClientImpl.this.getObjectDeletionCallback(resourceId, innerExceptions, batchExecutor, attempt, generation));
                }

                @Override
                public void onFailure(Throwable throwable) {
                    GoogleCloudStorageEventBus.postOnException();
                    innerExceptions.add(new IOException(String.format("Error deleting %s, stage 1", resourceId), throwable));
                }
            });
        }
    }

    private FutureCallback<Boolean> getObjectDeletionCallback(final StorageResourceId resourceId, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final BatchExecutor batchExecutor, final int attempt, final long generation) {
        return new FutureCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean result) {
                if (!result.booleanValue()) {
                    ((GoogleLogger.Api)logger.atFiner()).log("Delete object %s not found.", resourceId);
                } else {
                    ((GoogleLogger.Api)logger.atFiner()).log("Successfully deleted %s at generation %s", (Object)resourceId, generation);
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                if (throwable instanceof Exception && errorExtractor.getErrorType((Exception)throwable) == ErrorTypeExtractor.ErrorType.FAILED_PRECONDITION && attempt <= 4) {
                    ((GoogleLogger.Api)logger.atInfo()).log("Precondition not met while deleting '%s' at generation %s. Attempt %s. Retrying:%s", resourceId, generation, attempt, throwable);
                    GoogleCloudStorageClientImpl.this.queueSingleObjectDelete(resourceId, innerExceptions, batchExecutor, attempt + 1);
                } else {
                    GoogleCloudStorageEventBus.postOnException();
                    innerExceptions.add(new IOException(String.format("Error deleting '%s', stage 2 with generation %s", resourceId, generation), throwable));
                }
            }
        };
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("deleteBuckets(%s)", bucketNames);
        for (String bucketName : bucketNames) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        }
        ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        for (String bucketName : bucketNames) {
            try {
                boolean isDeleted = this.storage.delete(bucketName, new Storage.BucketSourceOption[0]);
                if (isDeleted) continue;
                innerExceptions.add(GoogleCloudStorageExceptions.createFileNotFoundException(bucketName, null, null));
            }
            catch (StorageException e) {
                GoogleCloudStorageEventBus.postOnException();
                innerExceptions.add(new IOException(String.format("Error deleting '%s' bucket", bucketName), e));
            }
        }
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos(%s)", resourceIds);
        if (resourceIds.isEmpty()) {
            return new ArrayList<GoogleCloudStorageItemInfo>();
        }
        ConcurrentHashMap<StorageResourceId, GoogleCloudStorageItemInfo> itemInfos = new ConcurrentHashMap<StorageResourceId, GoogleCloudStorageItemInfo>(resourceIds.size());
        Set<IOException> innerExceptions = Sets.newConcurrentHashSet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (StorageResourceId resourceId : resourceIds) {
                if (resourceId.isRoot()) {
                    itemInfos.put(resourceId, GoogleCloudStorageItemInfo.ROOT_INFO);
                    continue;
                }
                if (resourceId.isBucket()) {
                    executor.queue(() -> this.getBucket(resourceId.getBucketName()), this.getBucketCallback(resourceId, innerExceptions, itemInfos));
                    continue;
                }
                if (!resourceId.isStorageObject()) continue;
                executor.queue(() -> this.getBlob(resourceId), this.getBlobCallback(resourceId, innerExceptions, itemInfos));
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkState(itemInfos.containsKey(resourceId), "Somehow missing resourceId '%s' from map: %s", (Object)resourceId, itemInfos);
            sortedItemInfos.add((GoogleCloudStorageItemInfo)itemInfos.get(resourceId));
        }
        Preconditions.checkState(sortedItemInfos.size() == resourceIds.size(), "sortedItemInfos.size() (%s) != resourceIds.size() (%s). infos: %s, ids: %s", (Object)sortedItemInfos.size(), (Object)resourceIds.size(), sortedItemInfos, resourceIds);
        return sortedItemInfos;
    }

    private FutureCallback<Bucket> getBucketCallback(final StorageResourceId resourceId, final Set<IOException> innerExceptions, final Map<StorageResourceId, GoogleCloudStorageItemInfo> itemInfos) {
        return new FutureCallback<Bucket>(){

            @Override
            public void onSuccess(@Nullable Bucket bucket) {
                if (bucket != null) {
                    ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: Successfully fetched bucket: %s for resourceId: %s", (Object)bucket, (Object)resourceId);
                    itemInfos.put(resourceId, GoogleCloudStorageClientImpl.createItemInfoForBucket(resourceId, bucket));
                } else {
                    ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: bucket '%s' not found", resourceId.getBucketName());
                    itemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                GoogleCloudStorageEventBus.postOnException();
                innerExceptions.add(new IOException(String.format("Error getting %s bucket", resourceId.getBucketName()), throwable));
            }
        };
    }

    private FutureCallback<Blob> getBlobCallback(final StorageResourceId resourceId, final Set<IOException> innerExceptions, final Map<StorageResourceId, GoogleCloudStorageItemInfo> itemInfos) {
        return new FutureCallback<Blob>(){

            @Override
            public void onSuccess(@Nullable Blob blob) {
                if (blob != null) {
                    ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: Successfully fetched object '%s' for resourceId '%s'", (Object)blob, (Object)resourceId);
                    itemInfos.put(resourceId, GoogleCloudStorageClientImpl.createItemInfoForBlob(resourceId, blob));
                } else {
                    ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: object '%s' not found", resourceId);
                    itemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                GoogleCloudStorageEventBus.postOnException();
                innerExceptions.add(new IOException(String.format("Error getting %s object", resourceId), throwable));
            }
        };
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getItemInfo(%s)", resourceId);
        if (resourceId.isRoot()) {
            return GoogleCloudStorageItemInfo.ROOT_INFO;
        }
        GoogleCloudStorageItemInfo itemInfo = null;
        if (resourceId.isBucket()) {
            Bucket bucket = this.getBucket(resourceId.getBucketName());
            if (bucket != null) {
                itemInfo = GoogleCloudStorageClientImpl.createItemInfoForBucket(resourceId, bucket);
            } else {
                ((GoogleLogger.Api)logger.atFiner()).log("getBucket(%s): not found", resourceId.getBucketName());
            }
        } else {
            Blob blob = this.getBlob(resourceId);
            if (blob != null) {
                itemInfo = GoogleCloudStorageClientImpl.createItemInfoForBlob(resourceId, blob);
            } else {
                ((GoogleLogger.Api)logger.atFiner()).log("getObject(%s): not found", resourceId);
            }
        }
        if (itemInfo == null) {
            itemInfo = GoogleCloudStorageItemInfo.createNotFound(resourceId);
        }
        ((GoogleLogger.Api)logger.atFiner()).log("getItemInfo: %s", itemInfo);
        return itemInfo;
    }

    @Nullable
    private Bucket getBucket(String bucketName) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getBucket(%s)", bucketName);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        try {
            return this.storage.get(bucketName, new Storage.BucketGetOption[0]);
        }
        catch (StorageException e) {
            GoogleCloudStorageEventBus.postOnException();
            if (errorExtractor.getErrorType(e) == ErrorTypeExtractor.ErrorType.NOT_FOUND) {
                return null;
            }
            throw new IOException("Error accessing Bucket " + bucketName, e);
        }
    }

    @Nullable
    Blob getBlob(StorageResourceId resourceId) throws IOException {
        Blob blob;
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        String bucketName = resourceId.getBucketName();
        String objectName = resourceId.getObjectName();
        try {
            blob = this.storage.get(BlobId.of(bucketName, objectName), Storage.BlobGetOption.fields(BLOB_FIELDS.toArray(new Storage.BlobField[0])));
        }
        catch (StorageException e) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException("Error accessing " + resourceId, e);
        }
        return blob;
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)resourceId, (Object)readOptions);
        return this.open(resourceId, null, readOptions);
    }

    @Override
    public SeekableByteChannel open(GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)itemInfo, (Object)readOptions);
        Preconditions.checkNotNull(itemInfo, "itemInfo should not be null");
        StorageResourceId resourceId = itemInfo.getResourceId();
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        return this.open(resourceId, itemInfo, readOptions);
    }

    private SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        return new GoogleCloudStorageClientReadChannel(this.storage, itemInfo == null ? this.getItemInfo(resourceId) : itemInfo, readOptions, errorExtractor, this.storageOptions);
    }

    @Override
    public void close() {
        try {
            try {
                this.storage.close();
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Error occurred while closing the storage client");
            }
            try {
                super.close();
            }
            finally {
                this.backgroundTasksThreadPool.shutdown();
            }
        }
        finally {
            this.backgroundTasksThreadPool = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("updateItems(%s)", itemInfoList);
        if (itemInfoList.isEmpty()) {
            return new ArrayList<GoogleCloudStorageItemInfo>();
        }
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkArgument(!itemInfo.getStorageResourceId().isBucket() && !itemInfo.getStorageResourceId().isRoot(), "Buckets and GCS Root resources are not supported for updateItems");
        }
        final ConcurrentHashMap resultItemInfos = new ConcurrentHashMap();
        final Set<IOException> innerExceptions = Sets.newConcurrentHashSet();
        BatchExecutor executor = new BatchExecutor(this.storageOptions.getBatchThreads());
        try {
            for (UpdatableItemInfo itemInfo : itemInfoList) {
                final StorageResourceId resourceId = itemInfo.getStorageResourceId();
                String bucketName = resourceId.getBucketName();
                String blobName = resourceId.getObjectName();
                Map<String, byte[]> originalMetadata = itemInfo.getMetadata();
                Map<String, String> rewrittenMetadata = GoogleCloudStorageClientImpl.encodeMetadata(originalMetadata);
                BlobInfo blobUpdate = BlobInfo.newBuilder(bucketName, blobName).setMetadata(rewrittenMetadata).build();
                executor.queue(() -> this.storage.update(blobUpdate), new FutureCallback<Blob>(){

                    @Override
                    public void onSuccess(Blob blob) {
                        if (blob == null) {
                            ((GoogleLogger.Api)logger.atFiner()).log("updateItems: object not found %s", resourceId);
                            resultItemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                        } else {
                            ((GoogleLogger.Api)logger.atFiner()).log("updateItems: Successfully updated object '%s' for resourceId '%s'", (Object)blob, (Object)resourceId);
                            resultItemInfos.put(resourceId, GoogleCloudStorageClientImpl.createItemInfoForBlob(resourceId, blob));
                        }
                    }

                    @Override
                    public void onFailure(Throwable throwable) {
                        GoogleCloudStorageEventBus.postOnException();
                        innerExceptions.add(new IOException(String.format("Error updating '%s' object", resourceId), throwable));
                    }
                });
            }
        }
        finally {
            executor.shutdown();
        }
        if (!innerExceptions.isEmpty()) {
            GoogleCloudStorageEventBus.postOnException();
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkState(resultItemInfos.containsKey(itemInfo.getStorageResourceId()), "Missing resourceId '%s' from map: %s", (Object)itemInfo.getStorageResourceId(), resultItemInfos);
            sortedItemInfos.add((GoogleCloudStorageItemInfo)resultItemInfos.get(itemInfo.getStorageResourceId()));
        }
        Preconditions.checkState(sortedItemInfos.size() == itemInfoList.size(), "sortedItemInfos.size() (%s) != resourceIds.size() (%s). infos: %s, updateItemInfos: %s", (Object)sortedItemInfos.size(), (Object)itemInfoList.size(), sortedItemInfos, itemInfoList);
        return sortedItemInfos;
    }

    private static Map<String, String> encodeMetadata(Map<String, byte[]> metadata) {
        return Maps.transformValues(metadata, GoogleCloudStorageClientImpl::encodeMetadataValues);
    }

    @Override
    public void compose(String bucketName, List<String> sources, String destination, String contentType) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("compose(%s, %s, %s, %s)", bucketName, sources, destination, contentType);
        List<StorageResourceId> sourceIds = sources.stream().map(objectName -> new StorageResourceId(bucketName, (String)objectName)).collect(Collectors.toList());
        StorageResourceId destinationId = new StorageResourceId(bucketName, destination);
        CreateObjectOptions options = CreateObjectOptions.DEFAULT_OVERWRITE.toBuilder().setContentType(contentType).setEnsureEmptyObjectsMetadataMatch(false).build();
        this.composeObjects(sourceIds, destinationId, options);
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        Blob composedBlob;
        ((GoogleLogger.Api)logger.atFiner()).log("composeObjects(%s, %s, %s)", sources, destination, options);
        for (StorageResourceId inputId : sources) {
            if (destination.getBucketName().equals(inputId.getBucketName())) continue;
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(String.format("Bucket doesn't match for source '%s' and destination '%s'!", inputId, destination));
        }
        Storage.ComposeRequest request = Storage.ComposeRequest.newBuilder().addSource(sources.stream().map(StorageResourceId::getObjectName).collect(Collectors.toList())).setTarget(BlobInfo.newBuilder(destination.getBucketName(), destination.getObjectName()).setContentType(options.getContentType()).setContentEncoding(options.getContentEncoding()).setMetadata(GoogleCloudStorageClientImpl.encodeMetadata(options.getMetadata())).build()).setTargetOptions(Storage.BlobTargetOption.generationMatch(destination.hasGenerationId() ? destination.getGenerationId() : this.getWriteGeneration(destination, true))).build();
        try {
            composedBlob = this.storage.compose(request);
        }
        catch (StorageException e) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(e);
        }
        GoogleCloudStorageItemInfo compositeInfo = GoogleCloudStorageClientImpl.createItemInfoForBlob(destination, composedBlob);
        ((GoogleLogger.Api)logger.atFiner()).log("composeObjects() done, returning: %s", compositeInfo);
        return compositeInfo;
    }

    private long getWriteGeneration(StorageResourceId resourceId, boolean overwrite) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getWriteGeneration(%s, %s)", (Object)resourceId, overwrite);
        GoogleCloudStorageItemInfo info = this.getItemInfo(resourceId);
        if (!info.exists()) {
            return 0L;
        }
        if (info.exists() && overwrite) {
            long generation = info.getContentGeneration();
            Preconditions.checkState(generation != 0L, "Generation should not be 0 for an existing item");
            return generation;
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new FileAlreadyExistsException(String.format("Object %s already exists.", resourceId));
    }

    private static Storage createStorage(Credentials credentials, GoogleCloudStorageOptions storageOptions, List<ClientInterceptor> interceptors, ExecutorService pCUExecutorService, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        ImmutableMap<String, String> headers = GoogleCloudStorageClientImpl.getUpdatedHeadersWithUserAgent(storageOptions);
        return (Storage)StorageOptions.grpc().setAttemptDirectPath(storageOptions.isDirectPathPreferred()).setHeaderProvider(() -> headers).setGrpcInterceptorProvider(() -> {
            ArrayList<ClientInterceptor> list = new ArrayList<ClientInterceptor>();
            if (interceptors != null && !interceptors.isEmpty()) {
                list.addAll(interceptors.stream().filter(x -> x != null).collect(Collectors.toList()));
            }
            if (storageOptions.isTraceLogEnabled()) {
                list.add(new GoogleCloudStorageClientGrpcTracingInterceptor());
            }
            if (downscopedAccessTokenFn != null) {
                list.add(new GoogleCloudStorageClientGrpcDownscopingInterceptor(downscopedAccessTokenFn));
            }
            list.add(new GoogleCloudStorageClientGrpcStatisticsInterceptor());
            return ImmutableList.copyOf(list);
        }).setCredentials(credentials != null ? credentials : GoogleCloudStorageClientImpl.getNoCredentials(downscopedAccessTokenFn)).setBlobWriteSessionConfig(GoogleCloudStorageClientImpl.getSessionConfig(storageOptions.getWriteChannelOptions(), pCUExecutorService)).setProjectId(storageOptions.getProjectId()).build().getService();
    }

    private static ImmutableMap<String, String> getUpdatedHeadersWithUserAgent(GoogleCloudStorageOptions storageOptions) {
        ImmutableMap<String, String> httpRequestHeaders = MoreObjects.firstNonNull(storageOptions.getHttpRequestHeaders(), ImmutableMap.of());
        String appName = storageOptions.getAppName();
        if (!httpRequestHeaders.containsKey(USER_AGENT) && !Strings.isNullOrEmpty(appName)) {
            ((GoogleLogger.Api)logger.atFiner()).log("Setting useragent %s", appName);
            return ImmutableMap.builder().putAll(httpRequestHeaders).put(USER_AGENT, appName).build();
        }
        return httpRequestHeaders;
    }

    private static BlobWriteSessionConfig getSessionConfig(AsyncWriteChannelOptions writeOptions, ExecutorService pCUExecutorService) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("Upload strategy in use: %s", (Object)writeOptions.getUploadType());
        switch (writeOptions.getUploadType()) {
            case CHUNK_UPLOAD: {
                return BlobWriteSessionConfigs.getDefault().withChunkSize(writeOptions.getUploadChunkSize());
            }
            case WRITE_TO_DISK_THEN_UPLOAD: {
                if (writeOptions.getTemporaryPaths() == null || writeOptions.getTemporaryPaths().isEmpty()) {
                    return BlobWriteSessionConfigs.bufferToTempDirThenUpload();
                }
                return BlobWriteSessionConfigs.bufferToDiskThenUpload(writeOptions.getTemporaryPaths().stream().map(x -> Paths.get(x, new String[0])).collect(ImmutableSet.toImmutableSet()));
            }
            case JOURNALING: {
                if (writeOptions.getTemporaryPaths() == null || writeOptions.getTemporaryPaths().isEmpty()) {
                    GoogleCloudStorageEventBus.postOnException();
                    throw new IllegalArgumentException("Upload using `Journaling` requires the property:fs.gs.write.temporary.dirs to be set.");
                }
                return BlobWriteSessionConfigs.journaling(writeOptions.getTemporaryPaths().stream().map(x -> Paths.get(x, new String[0])).collect(ImmutableSet.toImmutableSet()));
            }
            case PARALLEL_COMPOSITE_UPLOAD: {
                return BlobWriteSessionConfigs.parallelCompositeUpload().withBufferAllocationStrategy(ParallelCompositeUploadBlobWriteSessionConfig.BufferAllocationStrategy.fixedPool(writeOptions.getPCUBufferCount(), writeOptions.getPCUBufferCapacity())).withPartCleanupStrategy(GoogleCloudStorageClientImpl.getPartCleanupStrategy(writeOptions.getPartFileCleanupType())).withExecutorSupplier(GoogleCloudStorageClientImpl.getPCUExecutorSupplier(pCUExecutorService)).withPartNamingStrategy(GoogleCloudStorageClientImpl.getPartNamingStrategy(writeOptions.getPartFileNamePrefix()));
            }
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new IllegalArgumentException(String.format("Upload type:%s is not supported.", new Object[]{writeOptions.getUploadType()}));
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy getPartCleanupStrategy(AsyncWriteChannelOptions.PartFileCleanupType cleanupType) {
        switch (cleanupType) {
            case NEVER: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.never();
            }
            case ON_SUCCESS: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.onlyOnSuccess();
            }
            case ALWAYS: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.always();
            }
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new IllegalArgumentException(String.format("Cleanup type:%s is not handled.", new Object[]{cleanupType}));
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy getPartNamingStrategy(String partFilePrefix) {
        if (Strings.isNullOrEmpty(partFilePrefix)) {
            return ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy.useObjectNameAsPrefix();
        }
        return ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy.prefix(partFilePrefix);
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier getPCUExecutorSupplier(ExecutorService pCUExecutorService) {
        return pCUExecutorService == null ? ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier.cachedPool() : ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier.useExecutor(pCUExecutorService);
    }

    private static GoogleCloudStorageItemInfo createItemInfoForBlob(StorageResourceId resourceId, Blob blob) {
        Preconditions.checkArgument(resourceId != null, "resourceId must not be null");
        Preconditions.checkArgument(blob != null, "object must not be null");
        Preconditions.checkArgument(resourceId.isStorageObject(), "resourceId must be a StorageObject. resourceId: %s", (Object)resourceId);
        Preconditions.checkArgument(resourceId.getBucketName().equals(blob.getBucket()), "resourceId.getBucketName() must equal object.getBucket(): '%s' vs '%s'", (Object)resourceId.getBucketName(), (Object)blob.getBucket());
        Preconditions.checkArgument(resourceId.getObjectName().equals(blob.getName()), "resourceId.getObjectName() must equal object.getName(): '%s' vs '%s'", (Object)resourceId.getObjectName(), (Object)blob.getName());
        Map<String, byte[]> decodedMetadata = blob.getMetadata() == null ? null : GoogleCloudStorageImpl.decodeMetadata(blob.getMetadata());
        byte[] md5Hash = null;
        byte[] crc32c = null;
        if (!Strings.isNullOrEmpty(blob.getCrc32c())) {
            crc32c = BaseEncoding.base64().decode(blob.getCrc32c());
        }
        if (!Strings.isNullOrEmpty(blob.getMd5())) {
            md5Hash = BaseEncoding.base64().decode(blob.getMd5());
        }
        return GoogleCloudStorageItemInfo.createObject(resourceId, blob.getCreateTimeOffsetDateTime() == null ? 0L : blob.getCreateTimeOffsetDateTime().toInstant().toEpochMilli(), blob.getUpdateTimeOffsetDateTime() == null ? 0L : blob.getUpdateTimeOffsetDateTime().toInstant().toEpochMilli(), blob.getSize() == null ? 0L : blob.getSize(), blob.getContentType(), blob.getContentEncoding(), decodedMetadata, blob.getGeneration() == null ? 0L : blob.getGeneration(), blob.getMetageneration() == null ? 0L : blob.getMetageneration(), new VerificationAttributes(md5Hash, crc32c));
    }

    private static Credentials getNoCredentials(Function<List<AccessBoundary>, String> downscopedAccessTokenFn) {
        if (downscopedAccessTokenFn == null) {
            return null;
        }
        return GoogleCredentials.create(new AccessToken("", null));
    }

    public static Builder builder() {
        return new AutoBuilder_GoogleCloudStorageClientImpl_Builder();
    }

    @AutoBuilder(ofClass=GoogleCloudStorageClientImpl.class)
    public static abstract class Builder {
        public abstract Builder setOptions(GoogleCloudStorageOptions var1);

        public abstract Builder setHttpTransport(@Nullable HttpTransport var1);

        public abstract Builder setCredentials(@Nullable Credentials var1);

        @VisibleForTesting
        public abstract Builder setHttpRequestInitializer(@Nullable HttpRequestInitializer var1);

        public abstract Builder setDownscopedAccessTokenFn(@Nullable Function<List<AccessBoundary>, String> var1);

        public abstract Builder setGRPCInterceptors(@Nullable ImmutableList<ClientInterceptor> var1);

        @VisibleForTesting
        public abstract Builder setClientLibraryStorage(@Nullable Storage var1);

        @VisibleForTesting
        public abstract Builder setPCUExecutorService(@Nullable ExecutorService var1);

        public abstract GoogleCloudStorageClientImpl build() throws IOException;
    }
}

