/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.SettableApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.GrpcCallContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ApiException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ApiStreamObserver;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Crc32cValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.GrpcUtils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ResumableSessionFailureScenario;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.WriteCtx;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.ByteString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ChecksummedData;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ObjectChecksums;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.nullness.qual.NonNull;

final class GapicUnbufferedDirectWritableByteChannel
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final SettableApiFuture<WriteObjectResponse> resultFuture;
    private final ChunkSegmenter chunkSegmenter;
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
    private final WriteCtx<WriteCtx.SimpleWriteObjectRequestBuilderFactory> writeCtx;
    private final Observer responseObserver;
    private volatile ApiStreamObserver<WriteObjectRequest> stream;
    private boolean open = true;
    private boolean first = true;
    private boolean finished = false;
    private volatile WriteObjectRequest lastWrittenRequest;

    GapicUnbufferedDirectWritableByteChannel(SettableApiFuture<WriteObjectResponse> resultFuture, ChunkSegmenter chunkSegmenter, ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, WriteCtx<WriteCtx.SimpleWriteObjectRequestBuilderFactory> writeCtx) {
        String bucketName = writeCtx.getRequestFactory().bucketName();
        this.resultFuture = resultFuture;
        this.chunkSegmenter = chunkSegmenter;
        GrpcCallContext internalContext = GrpcUtils.contextWithBucketName(bucketName, GrpcCallContext.createDefault());
        this.write = write.withDefaultCallContext(internalContext);
        this.writeCtx = writeCtx;
        this.responseObserver = new Observer(internalContext);
    }

    @Override
    public long write(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        ChunkSegmenter.ChunkSegment[] data = this.chunkSegmenter.segmentBuffers(srcs, srcsOffset, srcsLength);
        if (data.length == 0) {
            return 0L;
        }
        try {
            ApiStreamObserver<WriteObjectRequest> openedStream = this.openedStream();
            int bytesConsumed = 0;
            for (ChunkSegmenter.ChunkSegment datum : data) {
                Crc32cValue.Crc32cLengthKnown crc32c = datum.getCrc32c();
                ByteString b = datum.getB();
                int contentSize = b.size();
                long offset = this.writeCtx.getTotalSentBytes().getAndAdd(contentSize);
                Crc32cValue.Crc32cLengthKnown cumulative = this.writeCtx.getCumulativeCrc32c().accumulateAndGet(crc32c, this.chunkSegmenter.getHasher()::nullSafeConcat);
                ChecksummedData.Builder checksummedData = ChecksummedData.newBuilder().setContent(b);
                if (crc32c != null) {
                    checksummedData.setCrc32C(crc32c.getValue());
                }
                WriteObjectRequest.Builder builder = this.writeCtx.newRequestBuilder();
                if (!this.first) {
                    builder.clearWriteObjectSpec();
                    builder.clearObjectChecksums();
                }
                builder.setWriteOffset(offset).setChecksummedData(checksummedData.build());
                if (!datum.isOnlyFullBlocks()) {
                    builder.setFinishWrite(true);
                    if (cumulative != null) {
                        builder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(cumulative.getValue()).build());
                    }
                    this.finished = true;
                }
                WriteObjectRequest build = builder.build();
                this.first = false;
                bytesConsumed += contentSize;
                this.lastWrittenRequest = build;
                openedStream.onNext(build);
            }
            return bytesConsumed;
        }
        catch (RuntimeException e) {
            this.resultFuture.setException(e);
            throw e;
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        ApiStreamObserver<WriteObjectRequest> openedStream = this.openedStream();
        if (!this.finished) {
            WriteObjectRequest message;
            this.lastWrittenRequest = message = this.finishMessage();
            try {
                openedStream.onNext(message);
                openedStream.onCompleted();
                this.finished = true;
            }
            catch (RuntimeException e) {
                this.resultFuture.setException(e);
                throw e;
            }
        }
        try {
            openedStream.onCompleted();
        }
        catch (RuntimeException e) {
            this.resultFuture.setException(e);
            throw e;
        }
        this.open = false;
        this.responseObserver.await();
    }

    private @NonNull WriteObjectRequest finishMessage() {
        long offset = this.writeCtx.getTotalSentBytes().get();
        Crc32cValue.Crc32cLengthKnown crc32cValue = this.writeCtx.getCumulativeCrc32c().get();
        WriteObjectRequest.Builder b = this.writeCtx.newRequestBuilder();
        if (!this.first) {
            b.clearWriteObjectSpec();
            b.clearObjectChecksums();
            this.first = false;
        }
        b.setFinishWrite(true).setWriteOffset(offset);
        if (crc32cValue != null) {
            b.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(crc32cValue.getValue()).build());
        }
        return b.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiStreamObserver<WriteObjectRequest> openedStream() {
        if (this.stream == null) {
            GapicUnbufferedDirectWritableByteChannel gapicUnbufferedDirectWritableByteChannel = this;
            synchronized (gapicUnbufferedDirectWritableByteChannel) {
                if (this.stream == null) {
                    this.stream = this.write.clientStreamingCall(this.responseObserver);
                }
            }
        }
        return this.stream;
    }

    class Observer
    implements ApiStreamObserver<WriteObjectResponse> {
        private final GrpcCallContext context;
        private final SettableApiFuture<Void> invocationHandle;
        private volatile WriteObjectResponse last;

        Observer(GrpcCallContext context) {
            this.context = context;
            this.invocationHandle = SettableApiFuture.create();
        }

        @Override
        public void onNext(WriteObjectResponse value) {
            this.last = value;
        }

        @Override
        public void onError(Throwable t) {
            if (t instanceof ApiException) {
                StorageException tmp = StorageException.asStorageException((ApiException)t);
                StorageException storageException = ResumableSessionFailureScenario.toStorageException(tmp.getCode(), tmp.getMessage(), tmp.getReason(), this.getRequests(), null, this.context, t);
                this.invocationHandle.setException(storageException);
            } else {
                this.invocationHandle.setException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            block9: {
                try {
                    if (this.last == null) {
                        throw new StorageException(0, "onComplete without preceding onNext, unable to determine success.");
                    }
                    if (this.last.hasResource()) {
                        long finalSize;
                        long totalSentBytes = GapicUnbufferedDirectWritableByteChannel.this.writeCtx.getTotalSentBytes().get();
                        if (totalSentBytes == (finalSize = this.last.getResource().getSize())) {
                            GapicUnbufferedDirectWritableByteChannel.this.writeCtx.getConfirmedBytes().set(finalSize);
                            GapicUnbufferedDirectWritableByteChannel.this.resultFuture.set(this.last);
                            break block9;
                        }
                        if (finalSize < totalSentBytes) {
                            throw ResumableSessionFailureScenario.SCENARIO_4_1.toStorageException(this.getRequests(), this.last, this.context, null);
                        }
                        throw ResumableSessionFailureScenario.SCENARIO_4_2.toStorageException(this.getRequests(), this.last, this.context, null);
                    }
                    throw ResumableSessionFailureScenario.SCENARIO_0.toStorageException(this.getRequests(), this.last, this.context, null);
                }
                catch (Throwable se) {
                    GapicUnbufferedDirectWritableByteChannel.this.open = false;
                    this.invocationHandle.setException(se);
                }
                finally {
                    this.invocationHandle.set(null);
                }
            }
        }

        private @NonNull ImmutableList<@NonNull WriteObjectRequest> getRequests() {
            if (GapicUnbufferedDirectWritableByteChannel.this.lastWrittenRequest == null) {
                return ImmutableList.of();
            }
            return ImmutableList.of(GapicUnbufferedDirectWritableByteChannel.this.lastWrittenRequest);
        }

        void await() {
            try {
                this.invocationHandle.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
    }
}

