/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.GrpcUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.JsonUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.PickFirstLeafLoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.PickFirstLoadBalancer;
import java.util.Map;

public final class PickFirstLoadBalancerProvider
extends LoadBalancerProvider {
    public static final String GRPC_PF_USE_HAPPY_EYEBALLS = "GRPC_PF_USE_HAPPY_EYEBALLS";
    private static final String SHUFFLE_ADDRESS_LIST_KEY = "shuffleAddressList";
    private static boolean enableNewPickFirst = GrpcUtil.getFlag("GRPC_EXPERIMENTAL_ENABLE_NEW_PICK_FIRST", false);

    public static boolean isEnabledHappyEyeballs() {
        return GrpcUtil.getFlag(GRPC_PF_USE_HAPPY_EYEBALLS, false);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "pick_first";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        if (enableNewPickFirst) {
            return new PickFirstLeafLoadBalancer(helper);
        }
        return new PickFirstLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLbPolicyConfig) {
        try {
            Object config = PickFirstLoadBalancerProvider.getLbPolicyConfig(rawLbPolicyConfig);
            return NameResolver.ConfigOrError.fromConfig(config);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withCause(e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }

    private static Object getLbPolicyConfig(Map<String, ?> rawLbPolicyConfig) {
        Boolean shuffleAddressList = JsonUtil.getBoolean(rawLbPolicyConfig, SHUFFLE_ADDRESS_LIST_KEY);
        if (enableNewPickFirst) {
            return new PickFirstLeafLoadBalancer.PickFirstLeafLoadBalancerConfig(shuffleAddressList);
        }
        return new PickFirstLoadBalancer.PickFirstLoadBalancerConfig(shuffleAddressList);
    }

    @VisibleForTesting
    public static boolean isEnabledNewPickFirst() {
        return enableNewPickFirst;
    }
}

