/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.opentelemetry;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Stopwatch;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Supplier;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientStreamTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Deadline;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingClientCallListener;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.MethodDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerStreamTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.opentelemetry.OpenTelemetryMetricsResource;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.opentelemetry.OpenTelemetryPlugin;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.opentelemetry.internal.OpenTelemetryConstants;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class OpenTelemetryMetricsModule {
    private static final Logger logger = Logger.getLogger(OpenTelemetryMetricsModule.class.getName());
    private static final String LOCALITY_LABEL_NAME = "grpc.lb.locality";
    public static final ImmutableSet<String> DEFAULT_PER_CALL_METRICS_SET = ImmutableSet.of("grpc.client.attempt.started", "grpc.client.attempt.duration", "grpc.client.attempt.sent_total_compressed_message_size", "grpc.client.attempt.rcvd_total_compressed_message_size", "grpc.client.call.duration", "grpc.server.call.started", new String[]{"grpc.server.call.duration", "grpc.server.call.sent_total_compressed_message_size", "grpc.server.call.rcvd_total_compressed_message_size"});
    private static final double SECONDS_PER_NANO = 1.0E-9;
    private final OpenTelemetryMetricsResource resource;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final boolean localityEnabled;
    private final ImmutableList<OpenTelemetryPlugin> plugins;

    OpenTelemetryMetricsModule(Supplier<Stopwatch> stopwatchSupplier, OpenTelemetryMetricsResource resource, Collection<String> optionalLabels, List<OpenTelemetryPlugin> plugins) {
        this.resource = Preconditions.checkNotNull(resource, "resource");
        this.stopwatchSupplier = Preconditions.checkNotNull(stopwatchSupplier, "stopwatchSupplier");
        this.localityEnabled = optionalLabels.contains(LOCALITY_LABEL_NAME);
        this.plugins = ImmutableList.copyOf(plugins);
    }

    ServerStreamTracer.Factory getServerTracerFactory() {
        return new ServerTracerFactory();
    }

    ClientInterceptor getClientInterceptor(String target) {
        ImmutableList.Builder pluginBuilder = ImmutableList.builderWithExpectedSize(this.plugins.size());
        for (OpenTelemetryPlugin plugin : this.plugins) {
            if (!plugin.enablePluginForChannel(target)) continue;
            pluginBuilder.add(plugin);
        }
        return new MetricsClientInterceptor(target, (ImmutableList<OpenTelemetryPlugin>)pluginBuilder.build());
    }

    static String recordMethodName(String fullMethodName, boolean isGeneratedMethod) {
        return isGeneratedMethod ? fullMethodName : "other";
    }

    @VisibleForTesting
    final class MetricsClientInterceptor
    implements ClientInterceptor {
        private final String target;
        private final ImmutableList<OpenTelemetryPlugin> plugins;

        MetricsClientInterceptor(String target, ImmutableList<OpenTelemetryPlugin> plugins) {
            this.target = Preconditions.checkNotNull(target, "target");
            this.plugins = Preconditions.checkNotNull(plugins, "plugins");
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            List<OpenTelemetryPlugin.ClientCallPlugin> callPlugins;
            if (this.plugins.isEmpty()) {
                callPlugins = Collections.emptyList();
            } else {
                ArrayList<OpenTelemetryPlugin.ClientCallPlugin> callPluginsMutable = new ArrayList<OpenTelemetryPlugin.ClientCallPlugin>(this.plugins.size());
                for (OpenTelemetryPlugin openTelemetryPlugin : this.plugins) {
                    callPluginsMutable.add(openTelemetryPlugin.newClientCallPlugin());
                }
                callPlugins = Collections.unmodifiableList(callPluginsMutable);
                for (OpenTelemetryPlugin.ClientCallPlugin clientCallPlugin : callPlugins) {
                    callOptions = clientCallPlugin.filterCallOptions(callOptions);
                }
            }
            final CallAttemptsTracerFactory tracerFactory = new CallAttemptsTracerFactory(OpenTelemetryMetricsModule.this, this.target, OpenTelemetryMetricsModule.recordMethodName(method.getFullMethodName(), method.isSampledToLocalTracing()), callPlugins);
            ClientCall<ReqT, RespT> call = next.newCall(method, callOptions.withStreamTracerFactory(tracerFactory));
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    for (OpenTelemetryPlugin.ClientCallPlugin plugin : callPlugins) {
                        plugin.addMetadata(headers);
                    }
                    this.delegate().start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            tracerFactory.callEnded(status);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }

    @VisibleForTesting
    final class ServerTracerFactory
    extends ServerStreamTracer.Factory {
        ServerTracerFactory() {
        }

        @Override
        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            List<OpenTelemetryPlugin.ServerStreamPlugin> streamPlugins;
            if (OpenTelemetryMetricsModule.this.plugins.isEmpty()) {
                streamPlugins = Collections.emptyList();
            } else {
                ArrayList<OpenTelemetryPlugin.ServerStreamPlugin> streamPluginsMutable = new ArrayList<OpenTelemetryPlugin.ServerStreamPlugin>(OpenTelemetryMetricsModule.this.plugins.size());
                for (OpenTelemetryPlugin plugin : OpenTelemetryMetricsModule.this.plugins) {
                    streamPluginsMutable.add(plugin.newServerStreamPlugin(headers));
                }
                streamPlugins = Collections.unmodifiableList(streamPluginsMutable);
            }
            return new ServerTracer(OpenTelemetryMetricsModule.this, fullMethodName, streamPlugins);
        }
    }

    private static final class ServerTracer
    extends ServerStreamTracer {
        @Nullable
        private static final AtomicIntegerFieldUpdater<ServerTracer> streamClosedUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ServerTracer> outboundWireSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ServerTracer> inboundWireSizeUpdater;
        private final OpenTelemetryMetricsModule module;
        private final String fullMethodName;
        private final List<OpenTelemetryPlugin.ServerStreamPlugin> streamPlugins;
        private volatile boolean isGeneratedMethod;
        private volatile int streamClosed;
        private final Stopwatch stopwatch;
        private volatile long outboundWireSize;
        private volatile long inboundWireSize;

        ServerTracer(OpenTelemetryMetricsModule module, String fullMethodName, List<OpenTelemetryPlugin.ServerStreamPlugin> streamPlugins) {
            this.module = Preconditions.checkNotNull(module, "module");
            this.fullMethodName = fullMethodName;
            this.streamPlugins = Preconditions.checkNotNull(streamPlugins, "streamPlugins");
            this.stopwatch = ((Stopwatch)module.stopwatchSupplier.get()).start();
        }

        @Override
        public void serverCallStarted(ServerStreamTracer.ServerCallInfo<?, ?> callInfo) {
            boolean isSampledToLocalTracing;
            this.isGeneratedMethod = isSampledToLocalTracing = callInfo.getMethodDescriptor().isSampledToLocalTracing();
            Attributes attribute = Attributes.of(OpenTelemetryConstants.METHOD_KEY, (Object)OpenTelemetryMetricsModule.recordMethodName(this.fullMethodName, isSampledToLocalTracing));
            if (this.module.resource.serverCallCountCounter() != null) {
                this.module.resource.serverCallCountCounter().add(1L, attribute);
            }
        }

        @Override
        public void outboundWireSize(long bytes) {
            if (outboundWireSizeUpdater != null) {
                outboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.outboundWireSize += bytes;
            }
        }

        @Override
        public void inboundWireSize(long bytes) {
            if (inboundWireSizeUpdater != null) {
                inboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.inboundWireSize += bytes;
            }
        }

        @Override
        public void streamClosed(Status status) {
            if (streamClosedUpdater != null) {
                if (streamClosedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.streamClosed != 0) {
                    return;
                }
                this.streamClosed = 1;
            }
            this.stopwatch.stop();
            long elapsedTimeNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            AttributesBuilder builder = Attributes.builder().put(OpenTelemetryConstants.METHOD_KEY, (Object)OpenTelemetryMetricsModule.recordMethodName(this.fullMethodName, this.isGeneratedMethod)).put(OpenTelemetryConstants.STATUS_KEY, (Object)status.getCode().toString());
            for (OpenTelemetryPlugin.ServerStreamPlugin plugin : this.streamPlugins) {
                plugin.addLabels(builder);
            }
            Attributes attributes = builder.build();
            if (this.module.resource.serverCallDurationCounter() != null) {
                this.module.resource.serverCallDurationCounter().record((double)elapsedTimeNanos * 1.0E-9, attributes);
            }
            if (this.module.resource.serverTotalSentCompressedMessageSizeCounter() != null) {
                this.module.resource.serverTotalSentCompressedMessageSizeCounter().record(this.outboundWireSize, attributes);
            }
            if (this.module.resource.serverTotalReceivedCompressedMessageSizeCounter() != null) {
                this.module.resource.serverTotalReceivedCompressedMessageSizeCounter().record(this.inboundWireSize, attributes);
            }
        }

        static {
            AtomicLongFieldUpdater<ServerTracer> tmpInboundWireSizeUpdater;
            AtomicLongFieldUpdater<ServerTracer> tmpOutboundWireSizeUpdater;
            AtomicIntegerFieldUpdater<ServerTracer> tmpStreamClosedUpdater;
            try {
                tmpStreamClosedUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerTracer.class, "streamClosed");
                tmpOutboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "outboundWireSize");
                tmpInboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "inboundWireSize");
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
                tmpStreamClosedUpdater = null;
                tmpOutboundWireSizeUpdater = null;
                tmpInboundWireSizeUpdater = null;
            }
            streamClosedUpdater = tmpStreamClosedUpdater;
            outboundWireSizeUpdater = tmpOutboundWireSizeUpdater;
            inboundWireSizeUpdater = tmpInboundWireSizeUpdater;
        }
    }

    @VisibleForTesting
    static final class CallAttemptsTracerFactory
    extends ClientStreamTracer.Factory {
        private final OpenTelemetryMetricsModule module;
        private final String target;
        private final Stopwatch attemptStopwatch;
        private final Stopwatch callStopWatch;
        @GuardedBy(value="lock")
        private boolean callEnded;
        private final String fullMethodName;
        private final List<OpenTelemetryPlugin.ClientCallPlugin> callPlugins;
        private Status status;
        private long callLatencyNanos;
        private final Object lock = new Object();
        private final AtomicLong attemptsPerCall = new AtomicLong();
        @GuardedBy(value="lock")
        private int activeStreams;
        @GuardedBy(value="lock")
        private boolean finishedCallToBeRecorded;

        CallAttemptsTracerFactory(OpenTelemetryMetricsModule module, String target, String fullMethodName, List<OpenTelemetryPlugin.ClientCallPlugin> callPlugins) {
            this.module = Preconditions.checkNotNull(module, "module");
            this.target = Preconditions.checkNotNull(target, "target");
            this.fullMethodName = Preconditions.checkNotNull(fullMethodName, "fullMethodName");
            this.callPlugins = Preconditions.checkNotNull(callPlugins, "callPlugins");
            this.attemptStopwatch = (Stopwatch)module.stopwatchSupplier.get();
            this.callStopWatch = ((Stopwatch)module.stopwatchSupplier.get()).start();
            Attributes attribute = Attributes.of(OpenTelemetryConstants.METHOD_KEY, (Object)fullMethodName, OpenTelemetryConstants.TARGET_KEY, (Object)target);
            if (module.resource.clientAttemptCountCounter() != null) {
                module.resource.clientAttemptCountCounter().add(1L, attribute);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata metadata) {
            Object object = this.lock;
            synchronized (object) {
                if (this.finishedCallToBeRecorded) {
                    return new ClientStreamTracer(){};
                }
                if (++this.activeStreams == 1 && this.attemptStopwatch.isRunning()) {
                    this.attemptStopwatch.stop();
                }
            }
            if (this.attemptsPerCall.get() > 0L) {
                Attributes attribute = Attributes.of(OpenTelemetryConstants.METHOD_KEY, (Object)this.fullMethodName, OpenTelemetryConstants.TARGET_KEY, (Object)this.target);
                if (this.module.resource.clientAttemptCountCounter() != null) {
                    this.module.resource.clientAttemptCountCounter().add(1L, attribute);
                }
            }
            if (!info.isTransparentRetry()) {
                this.attemptsPerCall.incrementAndGet();
            }
            return this.newClientTracer(info);
        }

        private ClientTracer newClientTracer(ClientStreamTracer.StreamInfo info) {
            List<OpenTelemetryPlugin.ClientStreamPlugin> streamPlugins = Collections.emptyList();
            if (!this.callPlugins.isEmpty()) {
                streamPlugins = new ArrayList(this.callPlugins.size());
                for (OpenTelemetryPlugin.ClientCallPlugin plugin : this.callPlugins) {
                    streamPlugins.add(plugin.newClientStreamPlugin());
                }
                streamPlugins = Collections.unmodifiableList(streamPlugins);
            }
            return new ClientTracer(this, this.module, info, this.target, this.fullMethodName, streamPlugins);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attemptEnded() {
            boolean shouldRecordFinishedCall = false;
            Object object = this.lock;
            synchronized (object) {
                if (--this.activeStreams == 0) {
                    this.attemptStopwatch.start();
                    if (this.callEnded && !this.finishedCallToBeRecorded) {
                        shouldRecordFinishedCall = true;
                        this.finishedCallToBeRecorded = true;
                    }
                }
            }
            if (shouldRecordFinishedCall) {
                this.recordFinishedCall();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void callEnded(Status status) {
            this.callStopWatch.stop();
            this.status = status;
            boolean shouldRecordFinishedCall = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.callEnded) {
                    return;
                }
                this.callEnded = true;
                if (this.activeStreams == 0 && !this.finishedCallToBeRecorded) {
                    shouldRecordFinishedCall = true;
                    this.finishedCallToBeRecorded = true;
                }
            }
            if (shouldRecordFinishedCall) {
                this.recordFinishedCall();
            }
        }

        void recordFinishedCall() {
            if (this.attemptsPerCall.get() == 0L) {
                ClientTracer tracer = this.newClientTracer(null);
                tracer.attemptNanos = this.attemptStopwatch.elapsed(TimeUnit.NANOSECONDS);
                tracer.statusCode = this.status.getCode();
                tracer.recordFinishedAttempt();
            }
            this.callLatencyNanos = this.callStopWatch.elapsed(TimeUnit.NANOSECONDS);
            Attributes attribute = Attributes.of(OpenTelemetryConstants.METHOD_KEY, (Object)this.fullMethodName, OpenTelemetryConstants.TARGET_KEY, (Object)this.target, OpenTelemetryConstants.STATUS_KEY, (Object)this.status.getCode().toString());
            if (this.module.resource.clientCallDurationCounter() != null) {
                this.module.resource.clientCallDurationCounter().record((double)this.callLatencyNanos * 1.0E-9, attribute);
            }
        }
    }

    private static final class ClientTracer
    extends ClientStreamTracer {
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> outboundWireSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> inboundWireSizeUpdater;
        final Stopwatch stopwatch;
        final CallAttemptsTracerFactory attemptsState;
        final OpenTelemetryMetricsModule module;
        final ClientStreamTracer.StreamInfo info;
        final String target;
        final String fullMethodName;
        final List<OpenTelemetryPlugin.ClientStreamPlugin> streamPlugins;
        volatile long outboundWireSize;
        volatile long inboundWireSize;
        volatile String locality;
        long attemptNanos;
        Status.Code statusCode;

        ClientTracer(CallAttemptsTracerFactory attemptsState, OpenTelemetryMetricsModule module, ClientStreamTracer.StreamInfo info, String target, String fullMethodName, List<OpenTelemetryPlugin.ClientStreamPlugin> streamPlugins) {
            this.attemptsState = attemptsState;
            this.module = module;
            this.info = info;
            this.target = target;
            this.fullMethodName = fullMethodName;
            this.streamPlugins = streamPlugins;
            this.stopwatch = ((Stopwatch)module.stopwatchSupplier.get()).start();
        }

        @Override
        public void inboundHeaders(Metadata headers) {
            for (OpenTelemetryPlugin.ClientStreamPlugin plugin : this.streamPlugins) {
                plugin.inboundHeaders(headers);
            }
        }

        @Override
        public void outboundWireSize(long bytes) {
            if (outboundWireSizeUpdater != null) {
                outboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.outboundWireSize += bytes;
            }
        }

        @Override
        public void inboundWireSize(long bytes) {
            if (inboundWireSizeUpdater != null) {
                inboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.inboundWireSize += bytes;
            }
        }

        @Override
        public void addOptionalLabel(String key, String value) {
            if (OpenTelemetryMetricsModule.LOCALITY_LABEL_NAME.equals(key)) {
                this.locality = value;
            }
        }

        @Override
        public void inboundTrailers(Metadata trailers) {
            for (OpenTelemetryPlugin.ClientStreamPlugin plugin : this.streamPlugins) {
                plugin.inboundTrailers(trailers);
            }
        }

        @Override
        public void streamClosed(Status status) {
            this.stopwatch.stop();
            this.attemptNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            Deadline deadline = this.info.getCallOptions().getDeadline();
            this.statusCode = status.getCode();
            if (this.statusCode == Status.Code.CANCELLED && deadline != null && deadline.isExpired()) {
                this.statusCode = Status.Code.DEADLINE_EXCEEDED;
            }
            this.attemptsState.attemptEnded();
            this.recordFinishedAttempt();
        }

        void recordFinishedAttempt() {
            AttributesBuilder builder = Attributes.builder().put(OpenTelemetryConstants.METHOD_KEY, (Object)this.fullMethodName).put(OpenTelemetryConstants.TARGET_KEY, (Object)this.target).put(OpenTelemetryConstants.STATUS_KEY, (Object)this.statusCode.toString());
            if (this.module.localityEnabled) {
                Object savedLocality = this.locality;
                if (savedLocality == null) {
                    savedLocality = "";
                }
                builder.put(OpenTelemetryConstants.LOCALITY_KEY, savedLocality);
            }
            for (OpenTelemetryPlugin.ClientStreamPlugin plugin : this.streamPlugins) {
                plugin.addLabels(builder);
            }
            Attributes attribute = builder.build();
            if (this.module.resource.clientAttemptDurationCounter() != null) {
                this.module.resource.clientAttemptDurationCounter().record((double)this.attemptNanos * 1.0E-9, attribute);
            }
            if (this.module.resource.clientTotalSentCompressedMessageSizeCounter() != null) {
                this.module.resource.clientTotalSentCompressedMessageSizeCounter().record(this.outboundWireSize, attribute);
            }
            if (this.module.resource.clientTotalReceivedCompressedMessageSizeCounter() != null) {
                this.module.resource.clientTotalReceivedCompressedMessageSizeCounter().record(this.inboundWireSize, attribute);
            }
        }

        static {
            AtomicLongFieldUpdater<ClientTracer> tmpInboundWireSizeUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpOutboundWireSizeUpdater;
            try {
                tmpOutboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "outboundWireSize");
                tmpInboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "inboundWireSize");
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
                tmpOutboundWireSizeUpdater = null;
                tmpInboundWireSizeUpdater = null;
            }
            outboundWireSizeUpdater = tmpOutboundWireSizeUpdater;
            inboundWireSizeUpdater = tmpInboundWireSizeUpdater;
        }
    }
}

