/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import java.util.Map;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.StorageStatisticsFromIOStatistics;

public class GhfsStorageStatistics
extends StorageStatisticsFromIOStatistics {
    public static final String NAME = "GhfsFileSystemBasedStorageStatistics";
    private static final String MINIMUM = ".min";
    private static final String MAXIMUM = ".max";
    private static final String MEAN = ".mean";
    private final IOStatistics ioStatistics;

    public GhfsStorageStatistics(IOStatistics ioStatistics) {
        super(NAME, "Ghfs", ioStatistics);
        this.ioStatistics = ioStatistics;
    }

    public Long getMin(String symbol) {
        return this.minimums().get(symbol + MINIMUM);
    }

    public Long getMax(String symbol) {
        return this.maximums().get(symbol + MAXIMUM);
    }

    public double getMean(String symbol) {
        return this.meanStatistics().get(symbol + MEAN).mean();
    }

    private Map<String, Long> minimums() {
        return this.ioStatistics.minimums();
    }

    private Map<String, Long> maximums() {
        return this.ioStatistics.maximums();
    }

    private Map<String, MeanStatistic> meanStatistics() {
        return this.ioStatistics.meanStatistics();
    }
}

