/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.InputStreamContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AbstractGoogleAsyncWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.LoggingMediaHttpUploaderProgressListener;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class GoogleCloudStorageWriteChannel
extends AbstractGoogleAsyncWriteChannel<StorageObject>
implements GoogleCloudStorageItemInfo.Provider {
    private static final Duration MIN_LOGGING_INTERVAL = Duration.ofMinutes(1L);
    private final Storage gcs;
    private final StorageResourceId resourceId;
    private final CreateObjectOptions createOptions;
    private final ObjectWriteConditions writeConditions;
    private final ClientRequestHelper<StorageObject> clientRequestHelper;
    private GoogleCloudStorageItemInfo completedItemInfo = null;

    public GoogleCloudStorageWriteChannel(Storage gcs, ClientRequestHelper<StorageObject> requestHelper, ExecutorService uploadThreadPool, AsyncWriteChannelOptions channelOptions, StorageResourceId resourceId, CreateObjectOptions createOptions, ObjectWriteConditions writeConditions) {
        super(uploadThreadPool, channelOptions);
        this.clientRequestHelper = requestHelper;
        this.gcs = gcs;
        this.resourceId = resourceId;
        this.createOptions = createOptions;
        this.writeConditions = writeConditions;
    }

    @Override
    public void startUpload(InputStream pipeSource) throws IOException {
        InputStreamContent objectContentStream = new InputStreamContent(this.getContentType(), pipeSource).setLength(-1L).setCloseInputStream(false);
        Storage.Objects.Insert request = this.createRequest(objectContentStream);
        request.setDisableGZipContent(true);
        this.clientRequestHelper.setChunkSize(request, this.channelOptions.getUploadChunkSize());
        this.uploadOperation = this.threadPool.submit(new UploadOperation(request, pipeSource));
    }

    Storage.Objects.Insert createRequest(InputStreamContent inputStream) throws IOException {
        StorageObject object = new StorageObject().setContentEncoding(this.createOptions.getContentEncoding()).setMetadata(GoogleCloudStorageImpl.encodeMetadata(this.createOptions.getMetadata())).setName(this.resourceId.getObjectName());
        Storage.Objects.Insert insert = this.gcs.objects().insert(this.resourceId.getBucketName(), object, inputStream).setName(this.resourceId.getObjectName()).setKmsKeyName(this.createOptions.getKmsKeyName());
        this.writeConditions.apply(insert);
        insert.getMediaHttpUploader().setDirectUploadEnabled(this.isDirectUploadEnabled()).setProgressListener(new LoggingMediaHttpUploaderProgressListener(this.resourceId.getObjectName(), MIN_LOGGING_INTERVAL.toMillis()));
        return insert;
    }

    @Override
    public void handleResponse(StorageObject response) {
        this.completedItemInfo = GoogleCloudStorageImpl.createItemInfoForStorageObject(this.resourceId, response);
    }

    public StorageObject createResponseFromException(IOException e) {
        return null;
    }

    protected String getContentType() {
        return this.completedItemInfo == null ? this.createOptions.getContentType() : this.completedItemInfo.getContentType();
    }

    @Override
    protected String getResourceString() {
        return this.resourceId.toString();
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.completedItemInfo;
    }

    class UploadOperation
    implements Callable<StorageObject> {
        private final Storage.Objects.Insert uploadObject;
        private final InputStream pipeSource;

        public UploadOperation(Storage.Objects.Insert uploadObject, InputStream pipeSource) {
            this.uploadObject = uploadObject;
            this.pipeSource = pipeSource;
        }

        @Override
        public StorageObject call() throws Exception {
            StorageObject storageObject;
            block9: {
                InputStream ignore = this.pipeSource;
                try {
                    storageObject = (StorageObject)this.uploadObject.execute();
                    if (ignore == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        GoogleCloudStorageEventBus.postOnException();
                        StorageObject response = GoogleCloudStorageWriteChannel.this.createResponseFromException(e);
                        if (response == null) {
                            throw e;
                        }
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Received IOException during '%s' upload, but successfully converted to response: '%s'.", (Object)GoogleCloudStorageWriteChannel.this.resourceId, (Object)response);
                        return response;
                    }
                }
                ignore.close();
            }
            return storageObject;
        }
    }
}

