/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Ascii;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

class StatisticsTrackingHttpRequestInitializer
implements HttpRequestInitializer {
    private final ConcurrentMap<String, AtomicLong> statistics = new ConcurrentHashMap<String, AtomicLong>();

    StatisticsTrackingHttpRequestInitializer() {
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        request.setResponseInterceptor(httpResponse -> {
            String requestMethod = Ascii.toLowerCase(httpResponse.getRequest().getRequestMethod());
            String statKey = String.format("http_%s_%d", requestMethod, httpResponse.getStatusCode());
            this.statistics.computeIfAbsent(statKey, k -> new AtomicLong()).incrementAndGet();
        });
    }

    public ImmutableMap<String, Long> getStatistics() {
        return this.statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((AtomicLong)e.getValue()).get()));
    }
}

