/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.AbstractHttpContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpMediaType;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Buffers;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

abstract class RewindableContent
extends AbstractHttpContent {
    private RewindableContent() {
        super((HttpMediaType)null);
    }

    @Override
    public abstract long getLength();

    abstract void rewindTo(long var1);

    abstract long writeTo(WritableByteChannel var1) throws IOException;

    abstract long writeTo(GatheringByteChannel var1) throws IOException;

    @Override
    public final boolean retrySupported() {
        return false;
    }

    static RewindableContent empty() {
        return EmptyRewindableContent.INSTANCE;
    }

    static RewindableContent of(ByteBuffer ... buffers) {
        return new ByteBufferContent(buffers);
    }

    public static RewindableContent of(ByteBuffer[] srcs, int srcsOffset, int srcsLength) {
        Preconditions.checkNotNull(srcs, "srcs must be non null");
        if (0 > srcsOffset || srcsOffset > srcs.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("srcsOffset out of bounds (0 <= %d && %d <= %d)", srcsOffset, srcsOffset, srcs.length));
        }
        Preconditions.checkArgument(srcsLength >= 0, "srcsLength >= 0 (%d >= 0)", srcsLength);
        int end = srcsOffset + srcsLength;
        return new ByteBufferContent(Arrays.copyOfRange(srcs, srcsOffset, end));
    }

    static RewindableContent of(Path path) throws IOException {
        return new PathRewindableContent(path);
    }

    private static final class EmptyRewindableContent
    extends RewindableContent {
        private static final EmptyRewindableContent INSTANCE = new EmptyRewindableContent();

        private EmptyRewindableContent() {
        }

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.flush();
        }

        @Override
        long writeTo(WritableByteChannel gbc) {
            return 0L;
        }

        @Override
        long writeTo(GatheringByteChannel gbc) {
            return 0L;
        }

        @Override
        protected void rewindTo(long offset) {
        }
    }

    private static final class ByteBufferContent
    extends RewindableContent {
        private final ByteBuffer[] buffers;
        private final int[] positions;
        private final long totalLength;
        private boolean dirty;
        private long offset;

        private ByteBufferContent(ByteBuffer[] buffers) {
            this.buffers = buffers;
            this.positions = Arrays.stream(buffers).mapToInt(Buffers::position).toArray();
            this.totalLength = Buffers.totalRemaining(buffers, 0, buffers.length);
            this.dirty = false;
        }

        @Override
        public long getLength() {
            return this.totalLength - this.offset;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.dirty = true;
            WritableByteChannel c = Channels.newChannel(out);
            for (ByteBuffer buffer : this.buffers) {
                c.write(buffer);
            }
            out.flush();
        }

        @Override
        long writeTo(WritableByteChannel gbc) throws IOException {
            this.dirty = true;
            int retVal = 0;
            for (ByteBuffer buffer : this.buffers) {
                retVal += gbc.write(buffer);
            }
            return retVal;
        }

        @Override
        long writeTo(GatheringByteChannel gbc) throws IOException {
            this.dirty = true;
            return gbc.write(this.buffers);
        }

        @Override
        void rewindTo(long offset) {
            Preconditions.checkArgument(offset <= this.totalLength, "provided offset must be less than or equal to totalLength (%s <= %s)", offset, this.totalLength);
            if (this.dirty || offset != this.offset) {
                int idx = this.buffers.length - 1;
                long currentOffset = this.totalLength;
                while (currentOffset > 0L) {
                    int position = this.positions[idx];
                    ByteBuffer buf = this.buffers[idx];
                    int origRemaining = buf.limit() - position;
                    long begin = currentOffset - (long)origRemaining;
                    if (begin <= offset && offset < currentOffset) {
                        long diff = offset - begin;
                        Buffers.position(buf, position + Math.toIntExact(diff));
                    } else if (offset >= currentOffset) {
                        Buffers.position(buf, buf.limit());
                    } else {
                        Buffers.position(buf, position);
                    }
                    currentOffset = begin;
                    --idx;
                }
            }
            this.offset = offset;
        }
    }

    private static final class PathRewindableContent
    extends RewindableContent {
        private final Path path;
        private final long size;
        private long readOffset;

        private PathRewindableContent(Path path) throws IOException {
            this.path = path;
            this.size = Files.size(path);
            this.readOffset = 0L;
        }

        @Override
        public long getLength() {
            return this.size - this.readOffset;
        }

        @Override
        void rewindTo(long offset) {
            Preconditions.checkArgument(offset < this.size, "provided offset must be less than size (%d < %d)", offset, this.size);
            this.readOffset = offset;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            try (SeekableByteChannel in = Files.newByteChannel(this.path, StandardOpenOption.READ);){
                in.position(this.readOffset);
                ByteStreams.copy(in, Channels.newChannel(out));
                out.flush();
            }
        }

        @Override
        long writeTo(WritableByteChannel gbc) throws IOException {
            try (SeekableByteChannel in = Files.newByteChannel(this.path, StandardOpenOption.READ);){
                in.position(this.readOffset);
                long l = ByteStreams.copy(in, gbc);
                return l;
            }
        }

        @Override
        long writeTo(GatheringByteChannel gbc) throws IOException {
            try (SeekableByteChannel in = Files.newByteChannel(this.path, StandardOpenOption.READ);){
                in.position(this.readOffset);
                long l = ByteStreams.copy(in, gbc);
                return l;
            }
        }
    }
}

