/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFutures;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.core.BackgroundResource;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.paging.AbstractPage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.PageContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.hadoop.repackaged.gcs.com.google.iam.v1.GetIamPolicyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.iam.v1.Policy;
import com.google.cloud.hadoop.repackaged.gcs.com.google.iam.v1.SetIamPolicyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.iam.v1.TestIamPermissionsRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.iam.v1.TestIamPermissionsResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.Empty;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.FieldMask;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.BidiWriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.BidiWriteObjectResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Bucket;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.BucketName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.CancelResumableWriteRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.CancelResumableWriteResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ComposeObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.CreateBucketRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.CreateHmacKeyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.CreateHmacKeyResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.CreateNotificationConfigRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.DeleteBucketRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.DeleteHmacKeyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.DeleteNotificationConfigRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.DeleteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.GetBucketRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.GetHmacKeyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.GetNotificationConfigRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.GetObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.GetServiceAccountRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.HmacKeyMetadata;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ListBucketsRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ListBucketsResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ListHmacKeysRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ListHmacKeysResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ListNotificationConfigsRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ListNotificationConfigsResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ListObjectsRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ListObjectsResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.LockBucketRetentionPolicyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.NotificationConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.NotificationConfigName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ProjectName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.QueryWriteStatusRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.QueryWriteStatusResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ReadObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ReadObjectResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.RestoreObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.RewriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.RewriteResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ServiceAccount;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.StartResumableWriteRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.StartResumableWriteResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.StorageSettings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.UpdateBucketRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.UpdateHmacKeyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.UpdateObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.stub.StorageStub;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.stub.StorageStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class StorageClient
implements BackgroundResource {
    private final StorageSettings settings;
    private final StorageStub stub;

    public static final StorageClient create() throws IOException {
        return StorageClient.create(StorageSettings.newBuilder().build());
    }

    public static final StorageClient create(StorageSettings settings) throws IOException {
        return new StorageClient(settings);
    }

    public static final StorageClient create(StorageStub stub) {
        return new StorageClient(stub);
    }

    protected StorageClient(StorageSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StorageStubSettings)settings.getStubSettings()).createStub();
    }

    protected StorageClient(StorageStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final StorageSettings getSettings() {
        return this.settings;
    }

    public StorageStub getStub() {
        return this.stub;
    }

    public final void deleteBucket(BucketName name) {
        DeleteBucketRequest request = DeleteBucketRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteBucket(request);
    }

    public final void deleteBucket(String name) {
        DeleteBucketRequest request = DeleteBucketRequest.newBuilder().setName(name).build();
        this.deleteBucket(request);
    }

    public final void deleteBucket(DeleteBucketRequest request) {
        this.deleteBucketCallable().call(request);
    }

    public final UnaryCallable<DeleteBucketRequest, Empty> deleteBucketCallable() {
        return this.stub.deleteBucketCallable();
    }

    public final Bucket getBucket(BucketName name) {
        GetBucketRequest request = GetBucketRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBucket(request);
    }

    public final Bucket getBucket(String name) {
        GetBucketRequest request = GetBucketRequest.newBuilder().setName(name).build();
        return this.getBucket(request);
    }

    public final Bucket getBucket(GetBucketRequest request) {
        return this.getBucketCallable().call(request);
    }

    public final UnaryCallable<GetBucketRequest, Bucket> getBucketCallable() {
        return this.stub.getBucketCallable();
    }

    public final Bucket createBucket(ProjectName parent, Bucket bucket, String bucketId) {
        CreateBucketRequest request = CreateBucketRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBucket(bucket).setBucketId(bucketId).build();
        return this.createBucket(request);
    }

    public final Bucket createBucket(String parent, Bucket bucket, String bucketId) {
        CreateBucketRequest request = CreateBucketRequest.newBuilder().setParent(parent).setBucket(bucket).setBucketId(bucketId).build();
        return this.createBucket(request);
    }

    public final Bucket createBucket(CreateBucketRequest request) {
        return this.createBucketCallable().call(request);
    }

    public final UnaryCallable<CreateBucketRequest, Bucket> createBucketCallable() {
        return this.stub.createBucketCallable();
    }

    public final ListBucketsPagedResponse listBuckets(ProjectName parent) {
        ListBucketsRequest request = ListBucketsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBuckets(request);
    }

    public final ListBucketsPagedResponse listBuckets(String parent) {
        ListBucketsRequest request = ListBucketsRequest.newBuilder().setParent(parent).build();
        return this.listBuckets(request);
    }

    public final ListBucketsPagedResponse listBuckets(ListBucketsRequest request) {
        return this.listBucketsPagedCallable().call(request);
    }

    public final UnaryCallable<ListBucketsRequest, ListBucketsPagedResponse> listBucketsPagedCallable() {
        return this.stub.listBucketsPagedCallable();
    }

    public final UnaryCallable<ListBucketsRequest, ListBucketsResponse> listBucketsCallable() {
        return this.stub.listBucketsCallable();
    }

    public final Bucket lockBucketRetentionPolicy(BucketName bucket) {
        LockBucketRetentionPolicyRequest request = LockBucketRetentionPolicyRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).build();
        return this.lockBucketRetentionPolicy(request);
    }

    public final Bucket lockBucketRetentionPolicy(String bucket) {
        LockBucketRetentionPolicyRequest request = LockBucketRetentionPolicyRequest.newBuilder().setBucket(bucket).build();
        return this.lockBucketRetentionPolicy(request);
    }

    public final Bucket lockBucketRetentionPolicy(LockBucketRetentionPolicyRequest request) {
        return this.lockBucketRetentionPolicyCallable().call(request);
    }

    public final UnaryCallable<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicyCallable() {
        return this.stub.lockBucketRetentionPolicyCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return this.getIamPolicyCallable().call(request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return this.setIamPolicyCallable().call(request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return this.testIamPermissionsCallable().call(request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final Bucket updateBucket(Bucket bucket, FieldMask updateMask) {
        UpdateBucketRequest request = UpdateBucketRequest.newBuilder().setBucket(bucket).setUpdateMask(updateMask).build();
        return this.updateBucket(request);
    }

    public final Bucket updateBucket(UpdateBucketRequest request) {
        return this.updateBucketCallable().call(request);
    }

    public final UnaryCallable<UpdateBucketRequest, Bucket> updateBucketCallable() {
        return this.stub.updateBucketCallable();
    }

    public final Object composeObject(ComposeObjectRequest request) {
        return this.composeObjectCallable().call(request);
    }

    public final UnaryCallable<ComposeObjectRequest, Object> composeObjectCallable() {
        return this.stub.composeObjectCallable();
    }

    public final void deleteObject(BucketName bucket, String object) {
        DeleteObjectRequest request = DeleteObjectRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).setObject(object).build();
        this.deleteObject(request);
    }

    public final void deleteObject(String bucket, String object) {
        DeleteObjectRequest request = DeleteObjectRequest.newBuilder().setBucket(bucket).setObject(object).build();
        this.deleteObject(request);
    }

    public final void deleteObject(BucketName bucket, String object, long generation) {
        DeleteObjectRequest request = DeleteObjectRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).setObject(object).setGeneration(generation).build();
        this.deleteObject(request);
    }

    public final void deleteObject(String bucket, String object, long generation) {
        DeleteObjectRequest request = DeleteObjectRequest.newBuilder().setBucket(bucket).setObject(object).setGeneration(generation).build();
        this.deleteObject(request);
    }

    public final void deleteObject(DeleteObjectRequest request) {
        this.deleteObjectCallable().call(request);
    }

    public final UnaryCallable<DeleteObjectRequest, Empty> deleteObjectCallable() {
        return this.stub.deleteObjectCallable();
    }

    public final Object restoreObject(BucketName bucket, String object, long generation) {
        RestoreObjectRequest request = RestoreObjectRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).setObject(object).setGeneration(generation).build();
        return this.restoreObject(request);
    }

    public final Object restoreObject(String bucket, String object, long generation) {
        RestoreObjectRequest request = RestoreObjectRequest.newBuilder().setBucket(bucket).setObject(object).setGeneration(generation).build();
        return this.restoreObject(request);
    }

    public final Object restoreObject(RestoreObjectRequest request) {
        return this.restoreObjectCallable().call(request);
    }

    public final UnaryCallable<RestoreObjectRequest, Object> restoreObjectCallable() {
        return this.stub.restoreObjectCallable();
    }

    public final CancelResumableWriteResponse cancelResumableWrite(String uploadId) {
        CancelResumableWriteRequest request = CancelResumableWriteRequest.newBuilder().setUploadId(uploadId).build();
        return this.cancelResumableWrite(request);
    }

    public final CancelResumableWriteResponse cancelResumableWrite(CancelResumableWriteRequest request) {
        return this.cancelResumableWriteCallable().call(request);
    }

    public final UnaryCallable<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteCallable() {
        return this.stub.cancelResumableWriteCallable();
    }

    public final Object getObject(BucketName bucket, String object) {
        GetObjectRequest request = GetObjectRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).setObject(object).build();
        return this.getObject(request);
    }

    public final Object getObject(String bucket, String object) {
        GetObjectRequest request = GetObjectRequest.newBuilder().setBucket(bucket).setObject(object).build();
        return this.getObject(request);
    }

    public final Object getObject(BucketName bucket, String object, long generation) {
        GetObjectRequest request = GetObjectRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).setObject(object).setGeneration(generation).build();
        return this.getObject(request);
    }

    public final Object getObject(String bucket, String object, long generation) {
        GetObjectRequest request = GetObjectRequest.newBuilder().setBucket(bucket).setObject(object).setGeneration(generation).build();
        return this.getObject(request);
    }

    public final Object getObject(GetObjectRequest request) {
        return this.getObjectCallable().call(request);
    }

    public final UnaryCallable<GetObjectRequest, Object> getObjectCallable() {
        return this.stub.getObjectCallable();
    }

    public final ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> readObjectCallable() {
        return this.stub.readObjectCallable();
    }

    public final Object updateObject(Object object, FieldMask updateMask) {
        UpdateObjectRequest request = UpdateObjectRequest.newBuilder().setObject(object).setUpdateMask(updateMask).build();
        return this.updateObject(request);
    }

    public final Object updateObject(UpdateObjectRequest request) {
        return this.updateObjectCallable().call(request);
    }

    public final UnaryCallable<UpdateObjectRequest, Object> updateObjectCallable() {
        return this.stub.updateObjectCallable();
    }

    public final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> writeObjectCallable() {
        return this.stub.writeObjectCallable();
    }

    public final BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> bidiWriteObjectCallable() {
        return this.stub.bidiWriteObjectCallable();
    }

    public final ListObjectsPagedResponse listObjects(BucketName parent) {
        ListObjectsRequest request = ListObjectsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listObjects(request);
    }

    public final ListObjectsPagedResponse listObjects(String parent) {
        ListObjectsRequest request = ListObjectsRequest.newBuilder().setParent(parent).build();
        return this.listObjects(request);
    }

    public final ListObjectsPagedResponse listObjects(ListObjectsRequest request) {
        return this.listObjectsPagedCallable().call(request);
    }

    public final UnaryCallable<ListObjectsRequest, ListObjectsPagedResponse> listObjectsPagedCallable() {
        return this.stub.listObjectsPagedCallable();
    }

    public final UnaryCallable<ListObjectsRequest, ListObjectsResponse> listObjectsCallable() {
        return this.stub.listObjectsCallable();
    }

    public final RewriteResponse rewriteObject(RewriteObjectRequest request) {
        return this.rewriteObjectCallable().call(request);
    }

    public final UnaryCallable<RewriteObjectRequest, RewriteResponse> rewriteObjectCallable() {
        return this.stub.rewriteObjectCallable();
    }

    public final StartResumableWriteResponse startResumableWrite(StartResumableWriteRequest request) {
        return this.startResumableWriteCallable().call(request);
    }

    public final UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteCallable() {
        return this.stub.startResumableWriteCallable();
    }

    public final QueryWriteStatusResponse queryWriteStatus(String uploadId) {
        QueryWriteStatusRequest request = QueryWriteStatusRequest.newBuilder().setUploadId(uploadId).build();
        return this.queryWriteStatus(request);
    }

    public final QueryWriteStatusResponse queryWriteStatus(QueryWriteStatusRequest request) {
        return this.queryWriteStatusCallable().call(request);
    }

    public final UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusCallable() {
        return this.stub.queryWriteStatusCallable();
    }

    @Deprecated
    public final ServiceAccount getServiceAccount(ProjectName project) {
        GetServiceAccountRequest request = GetServiceAccountRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.getServiceAccount(request);
    }

    @Deprecated
    public final ServiceAccount getServiceAccount(String project) {
        GetServiceAccountRequest request = GetServiceAccountRequest.newBuilder().setProject(project).build();
        return this.getServiceAccount(request);
    }

    @Deprecated
    public final ServiceAccount getServiceAccount(GetServiceAccountRequest request) {
        return this.getServiceAccountCallable().call(request);
    }

    @Deprecated
    public final UnaryCallable<GetServiceAccountRequest, ServiceAccount> getServiceAccountCallable() {
        return this.stub.getServiceAccountCallable();
    }

    @Deprecated
    public final CreateHmacKeyResponse createHmacKey(ProjectName project, String serviceAccountEmail) {
        CreateHmacKeyRequest request = CreateHmacKeyRequest.newBuilder().setProject(project == null ? null : project.toString()).setServiceAccountEmail(serviceAccountEmail).build();
        return this.createHmacKey(request);
    }

    @Deprecated
    public final CreateHmacKeyResponse createHmacKey(String project, String serviceAccountEmail) {
        CreateHmacKeyRequest request = CreateHmacKeyRequest.newBuilder().setProject(project).setServiceAccountEmail(serviceAccountEmail).build();
        return this.createHmacKey(request);
    }

    @Deprecated
    public final CreateHmacKeyResponse createHmacKey(CreateHmacKeyRequest request) {
        return this.createHmacKeyCallable().call(request);
    }

    @Deprecated
    public final UnaryCallable<CreateHmacKeyRequest, CreateHmacKeyResponse> createHmacKeyCallable() {
        return this.stub.createHmacKeyCallable();
    }

    @Deprecated
    public final void deleteHmacKey(String accessId, ProjectName project) {
        DeleteHmacKeyRequest request = DeleteHmacKeyRequest.newBuilder().setAccessId(accessId).setProject(project == null ? null : project.toString()).build();
        this.deleteHmacKey(request);
    }

    @Deprecated
    public final void deleteHmacKey(String accessId, String project) {
        DeleteHmacKeyRequest request = DeleteHmacKeyRequest.newBuilder().setAccessId(accessId).setProject(project).build();
        this.deleteHmacKey(request);
    }

    @Deprecated
    public final void deleteHmacKey(DeleteHmacKeyRequest request) {
        this.deleteHmacKeyCallable().call(request);
    }

    @Deprecated
    public final UnaryCallable<DeleteHmacKeyRequest, Empty> deleteHmacKeyCallable() {
        return this.stub.deleteHmacKeyCallable();
    }

    @Deprecated
    public final HmacKeyMetadata getHmacKey(String accessId, ProjectName project) {
        GetHmacKeyRequest request = GetHmacKeyRequest.newBuilder().setAccessId(accessId).setProject(project == null ? null : project.toString()).build();
        return this.getHmacKey(request);
    }

    @Deprecated
    public final HmacKeyMetadata getHmacKey(String accessId, String project) {
        GetHmacKeyRequest request = GetHmacKeyRequest.newBuilder().setAccessId(accessId).setProject(project).build();
        return this.getHmacKey(request);
    }

    @Deprecated
    public final HmacKeyMetadata getHmacKey(GetHmacKeyRequest request) {
        return this.getHmacKeyCallable().call(request);
    }

    @Deprecated
    public final UnaryCallable<GetHmacKeyRequest, HmacKeyMetadata> getHmacKeyCallable() {
        return this.stub.getHmacKeyCallable();
    }

    @Deprecated
    public final ListHmacKeysPagedResponse listHmacKeys(ProjectName project) {
        ListHmacKeysRequest request = ListHmacKeysRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listHmacKeys(request);
    }

    @Deprecated
    public final ListHmacKeysPagedResponse listHmacKeys(String project) {
        ListHmacKeysRequest request = ListHmacKeysRequest.newBuilder().setProject(project).build();
        return this.listHmacKeys(request);
    }

    @Deprecated
    public final ListHmacKeysPagedResponse listHmacKeys(ListHmacKeysRequest request) {
        return this.listHmacKeysPagedCallable().call(request);
    }

    @Deprecated
    public final UnaryCallable<ListHmacKeysRequest, ListHmacKeysPagedResponse> listHmacKeysPagedCallable() {
        return this.stub.listHmacKeysPagedCallable();
    }

    @Deprecated
    public final UnaryCallable<ListHmacKeysRequest, ListHmacKeysResponse> listHmacKeysCallable() {
        return this.stub.listHmacKeysCallable();
    }

    @Deprecated
    public final HmacKeyMetadata updateHmacKey(HmacKeyMetadata hmacKey, FieldMask updateMask) {
        UpdateHmacKeyRequest request = UpdateHmacKeyRequest.newBuilder().setHmacKey(hmacKey).setUpdateMask(updateMask).build();
        return this.updateHmacKey(request);
    }

    @Deprecated
    public final HmacKeyMetadata updateHmacKey(UpdateHmacKeyRequest request) {
        return this.updateHmacKeyCallable().call(request);
    }

    @Deprecated
    public final UnaryCallable<UpdateHmacKeyRequest, HmacKeyMetadata> updateHmacKeyCallable() {
        return this.stub.updateHmacKeyCallable();
    }

    @Deprecated
    public final void deleteNotificationConfig(NotificationConfigName name) {
        DeleteNotificationConfigRequest request = DeleteNotificationConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteNotificationConfig(request);
    }

    @Deprecated
    public final void deleteNotificationConfig(String name) {
        DeleteNotificationConfigRequest request = DeleteNotificationConfigRequest.newBuilder().setName(name).build();
        this.deleteNotificationConfig(request);
    }

    @Deprecated
    public final void deleteNotificationConfig(DeleteNotificationConfigRequest request) {
        this.deleteNotificationConfigCallable().call(request);
    }

    @Deprecated
    public final UnaryCallable<DeleteNotificationConfigRequest, Empty> deleteNotificationConfigCallable() {
        return this.stub.deleteNotificationConfigCallable();
    }

    @Deprecated
    public final NotificationConfig getNotificationConfig(NotificationConfigName name) {
        GetNotificationConfigRequest request = GetNotificationConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNotificationConfig(request);
    }

    @Deprecated
    public final NotificationConfig getNotificationConfig(String name) {
        GetNotificationConfigRequest request = GetNotificationConfigRequest.newBuilder().setName(name).build();
        return this.getNotificationConfig(request);
    }

    @Deprecated
    public final NotificationConfig getNotificationConfig(GetNotificationConfigRequest request) {
        return this.getNotificationConfigCallable().call(request);
    }

    @Deprecated
    public final UnaryCallable<GetNotificationConfigRequest, NotificationConfig> getNotificationConfigCallable() {
        return this.stub.getNotificationConfigCallable();
    }

    @Deprecated
    public final NotificationConfig createNotificationConfig(BucketName parent, NotificationConfig notificationConfig) {
        CreateNotificationConfigRequest request = CreateNotificationConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNotificationConfig(notificationConfig).build();
        return this.createNotificationConfig(request);
    }

    @Deprecated
    public final NotificationConfig createNotificationConfig(String parent, NotificationConfig notificationConfig) {
        CreateNotificationConfigRequest request = CreateNotificationConfigRequest.newBuilder().setParent(parent).setNotificationConfig(notificationConfig).build();
        return this.createNotificationConfig(request);
    }

    @Deprecated
    public final NotificationConfig createNotificationConfig(CreateNotificationConfigRequest request) {
        return this.createNotificationConfigCallable().call(request);
    }

    @Deprecated
    public final UnaryCallable<CreateNotificationConfigRequest, NotificationConfig> createNotificationConfigCallable() {
        return this.stub.createNotificationConfigCallable();
    }

    @Deprecated
    public final ListNotificationConfigsPagedResponse listNotificationConfigs(BucketName parent) {
        ListNotificationConfigsRequest request = ListNotificationConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNotificationConfigs(request);
    }

    @Deprecated
    public final ListNotificationConfigsPagedResponse listNotificationConfigs(String parent) {
        ListNotificationConfigsRequest request = ListNotificationConfigsRequest.newBuilder().setParent(parent).build();
        return this.listNotificationConfigs(request);
    }

    @Deprecated
    public final ListNotificationConfigsPagedResponse listNotificationConfigs(ListNotificationConfigsRequest request) {
        return this.listNotificationConfigsPagedCallable().call(request);
    }

    @Deprecated
    public final UnaryCallable<ListNotificationConfigsRequest, ListNotificationConfigsPagedResponse> listNotificationConfigsPagedCallable() {
        return this.stub.listNotificationConfigsPagedCallable();
    }

    @Deprecated
    public final UnaryCallable<ListNotificationConfigsRequest, ListNotificationConfigsResponse> listNotificationConfigsCallable() {
        return this.stub.listNotificationConfigsCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBucketsPagedResponse
    extends AbstractPagedListResponse<ListBucketsRequest, ListBucketsResponse, Bucket, ListBucketsPage, ListBucketsFixedSizeCollection> {
        public static ApiFuture<ListBucketsPagedResponse> createAsync(PageContext<ListBucketsRequest, ListBucketsResponse, Bucket> context, ApiFuture<ListBucketsResponse> futureResponse) {
            ApiFuture<ListBucketsPage> futurePage = ListBucketsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBucketsPagedResponse((ListBucketsPage)input), MoreExecutors.directExecutor());
        }

        private ListBucketsPagedResponse(ListBucketsPage page) {
            super(page, ListBucketsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListObjectsPagedResponse
    extends AbstractPagedListResponse<ListObjectsRequest, ListObjectsResponse, Object, ListObjectsPage, ListObjectsFixedSizeCollection> {
        public static ApiFuture<ListObjectsPagedResponse> createAsync(PageContext<ListObjectsRequest, ListObjectsResponse, Object> context, ApiFuture<ListObjectsResponse> futureResponse) {
            ApiFuture<ListObjectsPage> futurePage = ListObjectsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListObjectsPagedResponse((ListObjectsPage)input), MoreExecutors.directExecutor());
        }

        private ListObjectsPagedResponse(ListObjectsPage page) {
            super(page, ListObjectsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHmacKeysPagedResponse
    extends AbstractPagedListResponse<ListHmacKeysRequest, ListHmacKeysResponse, HmacKeyMetadata, ListHmacKeysPage, ListHmacKeysFixedSizeCollection> {
        public static ApiFuture<ListHmacKeysPagedResponse> createAsync(PageContext<ListHmacKeysRequest, ListHmacKeysResponse, HmacKeyMetadata> context, ApiFuture<ListHmacKeysResponse> futureResponse) {
            ApiFuture<ListHmacKeysPage> futurePage = ListHmacKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHmacKeysPagedResponse((ListHmacKeysPage)input), MoreExecutors.directExecutor());
        }

        private ListHmacKeysPagedResponse(ListHmacKeysPage page) {
            super(page, ListHmacKeysFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNotificationConfigsPagedResponse
    extends AbstractPagedListResponse<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig, ListNotificationConfigsPage, ListNotificationConfigsFixedSizeCollection> {
        public static ApiFuture<ListNotificationConfigsPagedResponse> createAsync(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ApiFuture<ListNotificationConfigsResponse> futureResponse) {
            ApiFuture<ListNotificationConfigsPage> futurePage = ListNotificationConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNotificationConfigsPagedResponse((ListNotificationConfigsPage)input), MoreExecutors.directExecutor());
        }

        private ListNotificationConfigsPagedResponse(ListNotificationConfigsPage page) {
            super(page, ListNotificationConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNotificationConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig, ListNotificationConfigsPage, ListNotificationConfigsFixedSizeCollection> {
        private ListNotificationConfigsFixedSizeCollection(List<ListNotificationConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNotificationConfigsFixedSizeCollection createEmptyCollection() {
            return new ListNotificationConfigsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListNotificationConfigsFixedSizeCollection createCollection(List<ListNotificationConfigsPage> pages, int collectionSize) {
            return new ListNotificationConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNotificationConfigsPage
    extends AbstractPage<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig, ListNotificationConfigsPage> {
        private ListNotificationConfigsPage(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ListNotificationConfigsResponse response) {
            super(context, response);
        }

        private static ListNotificationConfigsPage createEmptyPage() {
            return new ListNotificationConfigsPage(null, null);
        }

        @Override
        protected ListNotificationConfigsPage createPage(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ListNotificationConfigsResponse response) {
            return new ListNotificationConfigsPage(context, response);
        }

        @Override
        public ApiFuture<ListNotificationConfigsPage> createPageAsync(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ApiFuture<ListNotificationConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHmacKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHmacKeysRequest, ListHmacKeysResponse, HmacKeyMetadata, ListHmacKeysPage, ListHmacKeysFixedSizeCollection> {
        private ListHmacKeysFixedSizeCollection(List<ListHmacKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHmacKeysFixedSizeCollection createEmptyCollection() {
            return new ListHmacKeysFixedSizeCollection(null, 0);
        }

        @Override
        protected ListHmacKeysFixedSizeCollection createCollection(List<ListHmacKeysPage> pages, int collectionSize) {
            return new ListHmacKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHmacKeysPage
    extends AbstractPage<ListHmacKeysRequest, ListHmacKeysResponse, HmacKeyMetadata, ListHmacKeysPage> {
        private ListHmacKeysPage(PageContext<ListHmacKeysRequest, ListHmacKeysResponse, HmacKeyMetadata> context, ListHmacKeysResponse response) {
            super(context, response);
        }

        private static ListHmacKeysPage createEmptyPage() {
            return new ListHmacKeysPage(null, null);
        }

        @Override
        protected ListHmacKeysPage createPage(PageContext<ListHmacKeysRequest, ListHmacKeysResponse, HmacKeyMetadata> context, ListHmacKeysResponse response) {
            return new ListHmacKeysPage(context, response);
        }

        @Override
        public ApiFuture<ListHmacKeysPage> createPageAsync(PageContext<ListHmacKeysRequest, ListHmacKeysResponse, HmacKeyMetadata> context, ApiFuture<ListHmacKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListObjectsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListObjectsRequest, ListObjectsResponse, Object, ListObjectsPage, ListObjectsFixedSizeCollection> {
        private ListObjectsFixedSizeCollection(List<ListObjectsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListObjectsFixedSizeCollection createEmptyCollection() {
            return new ListObjectsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListObjectsFixedSizeCollection createCollection(List<ListObjectsPage> pages, int collectionSize) {
            return new ListObjectsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListObjectsPage
    extends AbstractPage<ListObjectsRequest, ListObjectsResponse, Object, ListObjectsPage> {
        private ListObjectsPage(PageContext<ListObjectsRequest, ListObjectsResponse, Object> context, ListObjectsResponse response) {
            super(context, response);
        }

        private static ListObjectsPage createEmptyPage() {
            return new ListObjectsPage(null, null);
        }

        @Override
        protected ListObjectsPage createPage(PageContext<ListObjectsRequest, ListObjectsResponse, Object> context, ListObjectsResponse response) {
            return new ListObjectsPage(context, response);
        }

        @Override
        public ApiFuture<ListObjectsPage> createPageAsync(PageContext<ListObjectsRequest, ListObjectsResponse, Object> context, ApiFuture<ListObjectsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBucketsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBucketsRequest, ListBucketsResponse, Bucket, ListBucketsPage, ListBucketsFixedSizeCollection> {
        private ListBucketsFixedSizeCollection(List<ListBucketsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBucketsFixedSizeCollection createEmptyCollection() {
            return new ListBucketsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListBucketsFixedSizeCollection createCollection(List<ListBucketsPage> pages, int collectionSize) {
            return new ListBucketsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBucketsPage
    extends AbstractPage<ListBucketsRequest, ListBucketsResponse, Bucket, ListBucketsPage> {
        private ListBucketsPage(PageContext<ListBucketsRequest, ListBucketsResponse, Bucket> context, ListBucketsResponse response) {
            super(context, response);
        }

        private static ListBucketsPage createEmptyPage() {
            return new ListBucketsPage(null, null);
        }

        @Override
        protected ListBucketsPage createPage(PageContext<ListBucketsRequest, ListBucketsResponse, Bucket> context, ListBucketsResponse response) {
            return new ListBucketsPage(context, response);
        }

        @Override
        public ApiFuture<ListBucketsPage> createPageAsync(PageContext<ListBucketsRequest, ListBucketsResponse, Bucket> context, ApiFuture<ListBucketsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

