/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GhfsGlobalStorageStatistics;
import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageStatistics;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StatisticTypeEnum;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GCSChecksumFailureEvent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GcsJsonApiEvent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GcsRequestExecutionEvent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.IGcsJsonApiEvent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.eventbus.Subscribe;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class GoogleCloudStorageEventSubscriber {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final Map<GcsJsonApiEvent.RequestType, GhfsStatistic> requestToGhfsStatMap = GoogleCloudStorageEventSubscriber.getHadoopFileSystemMap();
    private static final Map<GcsJsonApiEvent.RequestType, GoogleCloudStorageStatistics> requestToGcsStatMap = GoogleCloudStorageEventSubscriber.getGcsStatMap();
    private static GhfsGlobalStorageStatistics storageStatistics;
    private static GoogleCloudStorageEventSubscriber INSTANCE;

    private GoogleCloudStorageEventSubscriber(GhfsGlobalStorageStatistics storageStatistics) {
        GoogleCloudStorageEventSubscriber.storageStatistics = storageStatistics;
    }

    public static synchronized GoogleCloudStorageEventSubscriber getInstance(@Nonnull GhfsGlobalStorageStatistics storageStatistics) {
        if (INSTANCE == null) {
            ((GoogleLogger.Api)logger.atFiner()).log("Subscriber class invoked for first time");
            INSTANCE = new GoogleCloudStorageEventSubscriber(storageStatistics);
        }
        return INSTANCE;
    }

    @VisibleForTesting
    protected static void reset() {
        INSTANCE = null;
    }

    @Subscribe
    private void subscriberOnGcsRequest(@Nonnull GcsRequestExecutionEvent event) {
        storageStatistics.incrementGcsTotalRequestCount();
    }

    @Subscribe
    private void subscriberOnGrpcStatus(@Nonnull Status status) {
        this.updateGcsIOSpecificStatistics(this.grpcToHttpStatusCodeMapping(status));
    }

    @Subscribe
    private void subscriberOnGcsRequestExecutionEvent(IGcsJsonApiEvent event) {
        GcsJsonApiEvent.EventType eventType = event.getEventType();
        Object eventContext = event.getContext();
        if (eventType == GcsJsonApiEvent.EventType.STARTED) {
            storageStatistics.incrementGcsTotalRequestCount();
        } else if (eventType == GcsJsonApiEvent.EventType.RESPONSE) {
            long duration = (Long)event.getProperty("DURATION");
            int statusCode = (Integer)event.getProperty("STATUS_CODE");
            this.incrementStatusCode(statusCode);
            this.updateGcsIOSpecificStatistics(statusCode);
            storageStatistics.incrementCounter(GoogleCloudStorageStatistics.GCS_API_TIME, duration);
            GcsJsonApiEvent.RequestType requestType = (GcsJsonApiEvent.RequestType)((Object)event.getProperty("REQUEST_TYPE"));
            if (requestToGcsStatMap.containsKey((Object)requestType)) {
                this.updateMetric(requestToGcsStatMap.get((Object)requestType), duration, eventContext);
            } else if (requestToGhfsStatMap.containsKey((Object)requestType)) {
                this.updateMetric(requestToGhfsStatMap.get((Object)requestType), duration, eventContext);
            } else {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).atMostEvery(1, TimeUnit.MINUTES)).log("Unexpected error type %s. context=%s", (Object)requestType, eventContext);
            }
        } else if (eventType == GcsJsonApiEvent.EventType.BACKOFF) {
            long backOffTime = (Long)event.getProperty("BACKOFF_TIME");
            storageStatistics.increment(GoogleCloudStorageStatistics.GCS_BACKOFF_COUNT);
            storageStatistics.incrementCounter(GoogleCloudStorageStatistics.GCS_BACKOFF_TIME, backOffTime);
        } else if (eventType == GcsJsonApiEvent.EventType.EXCEPTION) {
            storageStatistics.incrementGcsExceptionCount();
        }
    }

    private void updateMetric(GhfsStatistic stat, long duration, Object eventContext) {
        storageStatistics.incrementCounter(stat, 1L);
        if (stat.getType() == StatisticTypeEnum.TYPE_DURATION || stat.getType() == StatisticTypeEnum.TYPE_DURATION_TOTAL) {
            storageStatistics.updateStats(stat, duration, eventContext);
        }
    }

    private void updateMetric(GoogleCloudStorageStatistics stat, long duration, Object eventContext) {
        storageStatistics.incrementCounter(stat, 1L);
        if (stat.getType() == StatisticTypeEnum.TYPE_DURATION || stat.getType() == StatisticTypeEnum.TYPE_DURATION_TOTAL) {
            storageStatistics.updateStats(stat, duration, eventContext);
        }
    }

    @Subscribe
    private void subscriberOnException(IOException exception) {
        storageStatistics.incrementGcsExceptionCount();
    }

    @Subscribe
    private void onGcsChecksumFailure(GCSChecksumFailureEvent exception) {
        storageStatistics.incrementWriteChecksumFailureCount();
    }

    protected void updateGcsIOSpecificStatistics(int statusCode) {
        if (statusCode >= 400 && statusCode < 500) {
            storageStatistics.incrementGcsClientSideCounter();
            if (statusCode == 429) {
                storageStatistics.incrementRateLimitingCounter();
            }
        }
        if (statusCode >= 500 && statusCode < 600) {
            storageStatistics.incrementGcsServerSideCounter();
        }
    }

    private int grpcToHttpStatusCodeMapping(Status grpcStatusCode) {
        switch (grpcStatusCode.getCode()) {
            case OK: {
                return 200;
            }
            case CANCELLED: {
                return 499;
            }
            case INVALID_ARGUMENT: 
            case FAILED_PRECONDITION: 
            case OUT_OF_RANGE: {
                return 400;
            }
            case DEADLINE_EXCEEDED: {
                return 504;
            }
            case NOT_FOUND: {
                return 404;
            }
            case ALREADY_EXISTS: 
            case ABORTED: {
                return 409;
            }
            case PERMISSION_DENIED: {
                return 403;
            }
            case RESOURCE_EXHAUSTED: {
                return 429;
            }
            case UNIMPLEMENTED: {
                return 501;
            }
            case UNAVAILABLE: {
                return 503;
            }
            case UNAUTHENTICATED: {
                return 401;
            }
        }
        return 500;
    }

    private void incrementStatusCode(int statusCode) {
        switch (statusCode) {
            case 400: {
                storageStatistics.incrementGcsClientBadRequestCount();
                break;
            }
            case 401: {
                storageStatistics.incrementGcsClientUnauthorizedResponseCount();
                break;
            }
            case 404: {
                storageStatistics.incrementGcsClientNotFoundResponseCount();
                break;
            }
            case 408: {
                storageStatistics.incrementGcsClientRequestTimeoutCount();
                break;
            }
            case 410: {
                storageStatistics.incrementGcsClientGoneResponseCount();
                break;
            }
            case 412: {
                storageStatistics.incrementGcsClientPreconditionFailedResponseCount();
                break;
            }
            case 416: {
                storageStatistics.incrementGcsClientRequestedRangeNotSatisfiableCount();
                break;
            }
            case 500: {
                storageStatistics.incrementGcsServerInternalErrorCount();
                break;
            }
            case 502: {
                storageStatistics.incrementGcsServerBadGatewayCount();
                break;
            }
            case 503: {
                storageStatistics.incrementGcsServerServiceUnavailableCount();
                break;
            }
            case 504: {
                storageStatistics.incrementGcsServerTimeoutCount();
            }
        }
    }

    private static Map<GcsJsonApiEvent.RequestType, GhfsStatistic> getHadoopFileSystemMap() {
        EnumMap<GcsJsonApiEvent.RequestType, GhfsStatistic> result = new EnumMap<GcsJsonApiEvent.RequestType, GhfsStatistic>(GcsJsonApiEvent.RequestType.class);
        result.put(GcsJsonApiEvent.RequestType.DELETE, GhfsStatistic.ACTION_HTTP_DELETE_REQUEST);
        result.put(GcsJsonApiEvent.RequestType.PATCH, GhfsStatistic.ACTION_HTTP_PATCH_REQUEST);
        result.put(GcsJsonApiEvent.RequestType.POST, GhfsStatistic.ACTION_HTTP_POST_REQUEST);
        result.put(GcsJsonApiEvent.RequestType.PUT, GhfsStatistic.ACTION_HTTP_PUT_REQUEST);
        return result;
    }

    private static Map<GcsJsonApiEvent.RequestType, GoogleCloudStorageStatistics> getGcsStatMap() {
        EnumMap<GcsJsonApiEvent.RequestType, GoogleCloudStorageStatistics> result = new EnumMap<GcsJsonApiEvent.RequestType, GoogleCloudStorageStatistics>(GcsJsonApiEvent.RequestType.class);
        result.put(GcsJsonApiEvent.RequestType.GET_MEDIA, GoogleCloudStorageStatistics.GCS_GET_MEDIA_REQUEST);
        result.put(GcsJsonApiEvent.RequestType.GET_METADATA, GoogleCloudStorageStatistics.GCS_METADATA_REQUEST);
        result.put(GcsJsonApiEvent.RequestType.GET_OTHER, GoogleCloudStorageStatistics.GCS_GET_OTHER_REQUEST);
        result.put(GcsJsonApiEvent.RequestType.LIST_DIR, GoogleCloudStorageStatistics.GCS_LIST_DIR_REQUEST);
        result.put(GcsJsonApiEvent.RequestType.LIST_FILE, GoogleCloudStorageStatistics.GCS_LIST_FILE_REQUEST);
        return result;
    }

    static {
        INSTANCE = null;
    }
}

