/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.GenericUrl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpHeaders;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.GenericJson;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonObjectParser;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.gson.GsonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiClock;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.BetaApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.CurrentMillisClock;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.InternalApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.core.GaxProperties;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.NoHeaderProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.tracing.ApiTracerFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.QuotaProjectIdProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.MetadataConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.PlatformInformation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.Service;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.ServiceDefaults;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.ServiceFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.ServiceRpc;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.TransportOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.spi.ServiceRpcFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Iterables;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ServiceOptions<ServiceT extends Service<OptionsT>, OptionsT extends ServiceOptions<ServiceT, OptionsT>>
implements Serializable {
    public static final String CREDENTIAL_ENV_NAME = "GOOGLE_APPLICATION_CREDENTIALS";
    private static final String DEFAULT_HOST = "https://www.googleapis.com";
    private static final String LEGACY_PROJECT_ENV_NAME = "GCLOUD_PROJECT";
    private static final String PROJECT_ENV_NAME = "GOOGLE_CLOUD_PROJECT";
    private static final RetrySettings DEFAULT_RETRY_SETTINGS = ServiceOptions.getDefaultRetrySettingsBuilder().build();
    private static final RetrySettings NO_RETRY_SETTINGS = ServiceOptions.getDefaultRetrySettingsBuilder().setMaxAttempts(1).build();
    private static final long serialVersionUID = 9198896031667942014L;
    protected final String clientLibToken;
    private final String projectId;
    private final String universeDomain;
    private final String host;
    private final RetrySettings retrySettings;
    private final String serviceRpcFactoryClassName;
    private final String serviceFactoryClassName;
    private final ApiClock clock;
    protected Credentials credentials;
    private final TransportOptions transportOptions;
    private final HeaderProvider headerProvider;
    private final String quotaProjectId;
    private transient ServiceRpcFactory<OptionsT> serviceRpcFactory;
    private transient ServiceFactory<ServiceT, OptionsT> serviceFactory;
    private transient ServiceT service;
    private transient ServiceRpc rpc;
    private final ApiTracerFactory apiTracerFactory;

    @InternalApi(value="This class should only be extended within google-cloud-java")
    protected ServiceOptions(Class<? extends ServiceFactory<ServiceT, OptionsT>> serviceFactoryClass, Class<? extends ServiceRpcFactory<OptionsT>> rpcFactoryClass, Builder<ServiceT, OptionsT, ?> builder, ServiceDefaults<ServiceT, OptionsT> serviceDefaults) {
        String string = this.projectId = ((Builder)builder).projectId != null ? ((Builder)builder).projectId : this.getDefaultProject();
        if (this.projectIdRequired()) {
            Preconditions.checkArgument(this.projectId != null, "A project ID is required for this service but could not be determined from the builder or the environment.  Please set a project ID using the builder.");
        }
        this.universeDomain = ((Builder)builder).universeDomain;
        this.host = MoreObjects.firstNonNull(((Builder)builder).host, this.getDefaultHost());
        this.credentials = builder.credentials != null ? builder.credentials : ServiceOptions.defaultCredentials();
        this.retrySettings = MoreObjects.firstNonNull(((Builder)builder).retrySettings, ServiceOptions.getDefaultRetrySettings());
        this.serviceFactory = MoreObjects.firstNonNull(((Builder)builder).serviceFactory, ServiceOptions.getFromServiceLoader(serviceFactoryClass, serviceDefaults.getDefaultServiceFactory()));
        this.serviceFactoryClassName = this.serviceFactory.getClass().getName();
        this.serviceRpcFactory = MoreObjects.firstNonNull(((Builder)builder).serviceRpcFactory, ServiceOptions.getFromServiceLoader(rpcFactoryClass, serviceDefaults.getDefaultRpcFactory()));
        this.serviceRpcFactoryClassName = this.serviceRpcFactory.getClass().getName();
        this.clock = MoreObjects.firstNonNull(((Builder)builder).clock, CurrentMillisClock.getDefaultClock());
        this.transportOptions = MoreObjects.firstNonNull(((Builder)builder).transportOptions, serviceDefaults.getDefaultTransportOptions());
        this.headerProvider = MoreObjects.firstNonNull(((Builder)builder).headerProvider, new NoHeaderProvider());
        this.clientLibToken = ((Builder)builder).clientLibToken;
        this.quotaProjectId = ((Builder)builder).quotaProjectId != null ? ((Builder)builder).quotaProjectId : ServiceOptions.getValueFromCredentialsFile(ServiceOptions.getCredentialsPath(), "quota_project_id");
        this.apiTracerFactory = ((Builder)builder).apiTracerFactory;
    }

    private static String getCredentialsPath() {
        return System.getProperty(CREDENTIAL_ENV_NAME, System.getenv(CREDENTIAL_ENV_NAME));
    }

    protected boolean projectIdRequired() {
        return true;
    }

    private static GoogleCredentials defaultCredentials() {
        try {
            return GoogleCredentials.getApplicationDefault();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    protected String getDefaultProject() {
        return ServiceOptions.getDefaultProjectId();
    }

    public static String getDefaultProjectId() {
        String projectId = System.getProperty(PROJECT_ENV_NAME, System.getenv(PROJECT_ENV_NAME));
        if (projectId == null) {
            projectId = System.getProperty(LEGACY_PROJECT_ENV_NAME, System.getenv(LEGACY_PROJECT_ENV_NAME));
        }
        if (projectId == null) {
            projectId = ServiceOptions.getAppEngineProjectId();
        }
        if (projectId == null) {
            projectId = ServiceOptions.getServiceAccountProjectId();
        }
        return projectId != null ? projectId : ServiceOptions.getGoogleCloudProjectId();
    }

    public static String getAppEngineAppId() {
        return System.getProperty("com.google.appengine.application.id");
    }

    private static String getActiveGoogleCloudConfig(File configDir) {
        String activeGoogleCloudConfig = null;
        try {
            activeGoogleCloudConfig = Files.asCharSource(new File(configDir, "active_config"), Charset.defaultCharset()).readFirstLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return MoreObjects.firstNonNull(activeGoogleCloudConfig, "default");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getGoogleCloudProjectId() {
        File configDir = System.getenv().containsKey("CLOUDSDK_CONFIG") ? new File(System.getenv("CLOUDSDK_CONFIG")) : (ServiceOptions.isWindows() && System.getenv().containsKey("APPDATA") ? new File(System.getenv("APPDATA"), "gcloud") : new File(System.getProperty("user.home"), ".config/gcloud"));
        String activeConfig = ServiceOptions.getActiveGoogleCloudConfig(configDir);
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(new File(configDir, "configurations/config_" + activeConfig));
        }
        catch (FileNotFoundException newConfigFileNotFoundEx) {
            try {
                fileReader = new FileReader(new File(configDir, "properties"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (fileReader == null) return MetadataConfig.getProjectId();
        try (BufferedReader reader = new BufferedReader(fileReader);){
            Matcher matcher;
            block15: {
                String line;
                String section = null;
                Pattern projectPattern = Pattern.compile("^project\\s*=\\s*(.*)$");
                Pattern sectionPattern = Pattern.compile("^\\[(.*)\\]$");
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.startsWith(";")) continue;
                    matcher = sectionPattern.matcher(line = line.trim());
                    if (matcher.matches()) {
                        section = matcher.group(1);
                        continue;
                    }
                    if (section != null && !section.equals("core") || !(matcher = projectPattern.matcher(line)).matches()) {
                        continue;
                    }
                    break block15;
                }
                return MetadataConfig.getProjectId();
            }
            String string = matcher.group(1);
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return MetadataConfig.getProjectId();
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    }

    protected static String getAppEngineProjectId() {
        String projectId = null;
        if (PlatformInformation.isOnGAEStandard7()) {
            projectId = ServiceOptions.getAppEngineProjectIdFromAppId();
        } else {
            projectId = System.getenv(PROJECT_ENV_NAME);
            if (projectId == null) {
                projectId = System.getenv(LEGACY_PROJECT_ENV_NAME);
            }
            if (projectId == null) {
                projectId = ServiceOptions.getAppEngineProjectIdFromAppId();
            }
            if (projectId == null) {
                try {
                    projectId = ServiceOptions.getAppEngineProjectIdFromMetadataServer();
                }
                catch (IOException ignore) {
                    projectId = null;
                }
            }
        }
        return projectId;
    }

    protected static String getAppEngineProjectIdFromAppId() {
        String projectId = ServiceOptions.getAppEngineAppId();
        if (projectId != null && projectId.contains(":")) {
            int colonIndex = projectId.indexOf(":");
            projectId = projectId.substring(colonIndex + 1);
        }
        return projectId;
    }

    private static String getAppEngineProjectIdFromMetadataServer() throws IOException {
        String metadata = "http://metadata.google.internal";
        String projectIdURL = "/computeMetadata/v1/project/project-id";
        GenericUrl url = new GenericUrl(metadata + projectIdURL);
        NetHttpTransport netHttpTransport = new NetHttpTransport();
        HttpRequestFactory requestFactory = netHttpTransport.createRequestFactory();
        HttpRequest request = requestFactory.buildGetRequest(url).setConnectTimeout(500).setReadTimeout(500).setHeaders(new HttpHeaders().set("Metadata-Flavor", "Google"));
        HttpResponse response = request.execute();
        return ServiceOptions.headerContainsMetadataFlavor(response) ? response.parseAsString() : null;
    }

    @InternalApi(value="Visible for testing")
    static boolean headerContainsMetadataFlavor(HttpResponse response) {
        String metadataFlavorValue = response.getHeaders().getFirstHeaderStringValue("Metadata-Flavor");
        return "Google".equals(metadataFlavorValue);
    }

    protected static String getServiceAccountProjectId() {
        return ServiceOptions.getValueFromCredentialsFile(ServiceOptions.getCredentialsPath(), "project_id");
    }

    @InternalApi(value="Visible for testing")
    static String getValueFromCredentialsFile(String credentialsPath, String key) {
        if (credentialsPath != null) {
            String string;
            FileInputStream credentialsStream = new FileInputStream(credentialsPath);
            try {
                GsonFactory jsonFactory = GsonFactory.getDefaultInstance();
                JsonObjectParser parser = new JsonObjectParser(jsonFactory);
                GenericJson fileContents = parser.parseAndClose((InputStream)credentialsStream, StandardCharsets.UTF_8, GenericJson.class);
                string = (String)fileContents.get(key);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)credentialsStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | IllegalArgumentException ex) {
                    return null;
                }
            }
            ((InputStream)credentialsStream).close();
            return string;
        }
        return null;
    }

    public ServiceT getService() {
        if (this.shouldRefreshService(this.service)) {
            this.service = this.serviceFactory.create(this);
        }
        return this.service;
    }

    protected boolean shouldRefreshService(ServiceT cachedService) {
        return cachedService == null;
    }

    public ServiceRpc getRpc() {
        if (this.shouldRefreshRpc(this.rpc)) {
            this.rpc = this.serviceRpcFactory.create(this);
        }
        return this.rpc;
    }

    protected boolean shouldRefreshRpc(ServiceRpc cachedRpc) {
        return cachedRpc == null;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getUniverseDomain() {
        return this.universeDomain;
    }

    public String getHost() {
        return this.host;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Credentials getScopedCredentials() {
        Credentials credentialsToReturn = this.credentials;
        if (this.credentials instanceof GoogleCredentials && ((GoogleCredentials)this.credentials).createScopedRequired()) {
            credentialsToReturn = ((GoogleCredentials)this.credentials).createScoped(this.getScopes());
        }
        return credentialsToReturn;
    }

    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    public ApiClock getClock() {
        return this.clock;
    }

    public TransportOptions getTransportOptions() {
        return this.transportOptions;
    }

    public String getApplicationName() {
        String libraryVersion = this.getLibraryVersion();
        StringBuilder sb = new StringBuilder();
        String customUserAgentValue = this.getUserAgent();
        if (customUserAgentValue != null) {
            sb.append(customUserAgentValue).append(' ');
        }
        if (libraryVersion == null) {
            sb.append(ServiceOptions.getLibraryName());
        } else {
            sb.append(ServiceOptions.getLibraryName()).append('/').append(libraryVersion);
        }
        return sb.toString();
    }

    public static String getLibraryName() {
        return "gcloud-java";
    }

    public static String getGoogApiClientLibName() {
        return "gccl";
    }

    public String getLibraryVersion() {
        return GaxProperties.getLibraryVersion(this.getClass());
    }

    public ApiTracerFactory getApiTracerFactory() {
        return this.apiTracerFactory;
    }

    @InternalApi
    public final HeaderProvider getMergedHeaderProvider(HeaderProvider internalHeaderProvider) {
        ImmutableMap<String, String> mergedHeaders = ImmutableMap.builder().putAll(internalHeaderProvider.getHeaders()).putAll(this.headerProvider.getHeaders()).build();
        return FixedHeaderProvider.create(mergedHeaders);
    }

    @InternalApi
    public final String getUserAgent() {
        if (this.headerProvider != null) {
            for (Map.Entry<String, String> entry : this.headerProvider.getHeaders().entrySet()) {
                if (!"user-agent".equals(entry.getKey().toLowerCase())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    protected int baseHashCode() {
        return Objects.hash(this.projectId, this.host, this.credentials, this.retrySettings, this.serviceFactoryClassName, this.serviceRpcFactoryClassName, this.clock, this.quotaProjectId);
    }

    protected boolean baseEquals(ServiceOptions<?, ?> other) {
        return Objects.equals(this.projectId, other.projectId) && Objects.equals(this.host, other.host) && Objects.equals(this.credentials, other.credentials) && Objects.equals(this.retrySettings, other.retrySettings) && Objects.equals(this.serviceFactoryClassName, other.serviceFactoryClassName) && Objects.equals(this.serviceRpcFactoryClassName, other.serviceRpcFactoryClassName) && Objects.equals(this.clock, other.clock) && Objects.equals(this.quotaProjectId, other.quotaProjectId);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.serviceFactory = (ServiceFactory)ServiceOptions.newInstance(this.serviceFactoryClassName);
        this.serviceRpcFactory = (ServiceRpcFactory)ServiceOptions.newInstance(this.serviceRpcFactoryClassName);
    }

    @InternalApi
    public static <T> T newInstance(String className) throws IOException, ClassNotFoundException {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException(e);
        }
    }

    public static RetrySettings getDefaultRetrySettings() {
        return DEFAULT_RETRY_SETTINGS;
    }

    public static RetrySettings getNoRetrySettings() {
        return NO_RETRY_SETTINGS;
    }

    private static RetrySettings.Builder getDefaultRetrySettingsBuilder() {
        return RetrySettings.newBuilder().setMaxAttempts(6).setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setMaxRetryDelayDuration(Duration.ofMillis(32000L)).setRetryDelayMultiplier(2.0).setTotalTimeoutDuration(Duration.ofMillis(50000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(50000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(50000L));
    }

    protected abstract Set<String> getScopes();

    public abstract <B extends Builder<ServiceT, OptionsT, B>> B toBuilder();

    protected RetrySettings defaultRetrySettings() {
        return ServiceOptions.getDefaultRetrySettings();
    }

    @InternalApi
    public static <T> T getFromServiceLoader(Class<? extends T> clazz, T defaultInstance) {
        return Iterables.getFirst(ServiceLoader.load(clazz), defaultInstance);
    }

    public String getClientLibToken() {
        return this.clientLibToken;
    }

    public String getQuotaProjectId() {
        return this.quotaProjectId;
    }

    @InternalApi
    public String getResolvedHost(String serviceName) {
        String resolvedUniverseDomain;
        if (this.universeDomain != null && this.universeDomain.isEmpty()) {
            throw new IllegalArgumentException("The universe domain cannot be empty");
        }
        String string = resolvedUniverseDomain = this.universeDomain != null ? this.universeDomain : "googleapis.com";
        if (!DEFAULT_HOST.equals(this.host)) {
            return this.host;
        }
        return "https://" + serviceName + "." + resolvedUniverseDomain;
    }

    @InternalApi
    public String getResolvedApiaryHost(String serviceName) {
        if (!DEFAULT_HOST.equals(this.host)) {
            return this.host;
        }
        String resolvedUniverseDomain = this.universeDomain != null ? this.universeDomain : "googleapis.com";
        return "https://" + serviceName + "." + resolvedUniverseDomain + "/";
    }

    @InternalApi
    public boolean hasValidUniverseDomain() throws IOException {
        String resolvedUniverseDomain = this.universeDomain != null ? this.universeDomain : "googleapis.com";
        return resolvedUniverseDomain.equals(this.getCredentials().getUniverseDomain());
    }

    public static abstract class Builder<ServiceT extends Service<OptionsT>, OptionsT extends ServiceOptions<ServiceT, OptionsT>, B extends Builder<ServiceT, OptionsT, B>> {
        private final ImmutableSet<String> allowedClientLibTokens = ImmutableSet.of(ServiceOptions.getGoogApiClientLibName());
        private String projectId;
        private String universeDomain;
        private String host;
        protected Credentials credentials;
        private RetrySettings retrySettings;
        private ServiceFactory<ServiceT, OptionsT> serviceFactory;
        private ServiceRpcFactory<OptionsT> serviceRpcFactory;
        private ApiClock clock;
        private TransportOptions transportOptions;
        private HeaderProvider headerProvider;
        private String clientLibToken = ServiceOptions.getGoogApiClientLibName();
        private String quotaProjectId;
        private ApiTracerFactory apiTracerFactory;

        @InternalApi(value="This class should only be extended within google-cloud-java")
        protected Builder() {
        }

        @InternalApi(value="This class should only be extended within google-cloud-java")
        protected Builder(ServiceOptions<ServiceT, OptionsT> options) {
            this.projectId = ((ServiceOptions)options).projectId;
            this.universeDomain = ((ServiceOptions)options).universeDomain;
            this.host = ((ServiceOptions)options).host;
            this.credentials = options.credentials;
            this.retrySettings = ((ServiceOptions)options).retrySettings;
            this.serviceFactory = ((ServiceOptions)options).serviceFactory;
            this.serviceRpcFactory = ((ServiceOptions)options).serviceRpcFactory;
            this.clock = ((ServiceOptions)options).clock;
            this.transportOptions = ((ServiceOptions)options).transportOptions;
            this.clientLibToken = options.clientLibToken;
            this.quotaProjectId = ((ServiceOptions)options).quotaProjectId;
            this.apiTracerFactory = ((ServiceOptions)options).apiTracerFactory;
        }

        protected abstract ServiceOptions<ServiceT, OptionsT> build();

        protected B self() {
            return (B)this;
        }

        public B setServiceFactory(ServiceFactory<ServiceT, OptionsT> serviceFactory) {
            this.serviceFactory = serviceFactory;
            return this.self();
        }

        public B setClock(ApiClock clock) {
            this.clock = clock;
            return this.self();
        }

        public B setProjectId(String projectId) {
            this.projectId = projectId;
            return this.self();
        }

        public B setHost(String host) {
            this.host = host;
            return this.self();
        }

        public B setUniverseDomain(String universeDomain) {
            this.universeDomain = Preconditions.checkNotNull(universeDomain);
            return this.self();
        }

        public B setCredentials(Credentials credentials) {
            this.credentials = Preconditions.checkNotNull(credentials);
            if (this.projectId == null && credentials instanceof ServiceAccountCredentials) {
                this.projectId = ((ServiceAccountCredentials)credentials).getProjectId();
            }
            if (this.quotaProjectId == null && credentials instanceof QuotaProjectIdProvider) {
                this.quotaProjectId = ((QuotaProjectIdProvider)((Object)credentials)).getQuotaProjectId();
            }
            return this.self();
        }

        public B setRetrySettings(RetrySettings retrySettings) {
            this.retrySettings = retrySettings;
            return this.self();
        }

        public B setServiceRpcFactory(ServiceRpcFactory<OptionsT> serviceRpcFactory) {
            this.serviceRpcFactory = serviceRpcFactory;
            return this.self();
        }

        public B setTransportOptions(TransportOptions transportOptions) {
            this.transportOptions = transportOptions;
            return this.self();
        }

        @BetaApi
        public B setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this.self();
        }

        @InternalApi
        public B setClientLibToken(String clientLibToken) {
            Preconditions.checkArgument(this.getAllowedClientLibTokens().contains(clientLibToken), "Illegal client lib token");
            this.clientLibToken = clientLibToken;
            return this.self();
        }

        public B setQuotaProjectId(String quotaProjectId) {
            this.quotaProjectId = quotaProjectId;
            return this.self();
        }

        @BetaApi
        @InternalApi
        public B setApiTracerFactory(ApiTracerFactory apiTracerFactory) {
            this.apiTracerFactory = apiTracerFactory;
            return this.self();
        }

        protected Set<String> getAllowedClientLibTokens() {
            return this.allowedClientLibTokens;
        }
    }
}

