/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.util.Timestamps;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.Folder;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class GoogleCloudStorageItemInfo {
    public static final GoogleCloudStorageItemInfo ROOT_INFO = new GoogleCloudStorageItemInfo(StorageResourceId.ROOT, 0L, 0L, 0L, null, null, null, null, null, 0L, 0L, null);
    private final StorageResourceId resourceId;
    private final long creationTime;
    private final long modificationTime;
    private final long size;
    private final String location;
    private final String storageClass;
    private final String contentType;
    private final String contentEncoding;
    private final Map<String, byte[]> metadata;
    private final long contentGeneration;
    private final long metaGeneration;
    private final VerificationAttributes verificationAttributes;

    public static GoogleCloudStorageItemInfo createBucket(StorageResourceId resourceId, long creationTime, long modificationTime, String location, String storageClass) {
        Preconditions.checkNotNull(resourceId, "resourceId must not be null");
        Preconditions.checkArgument(resourceId.isBucket(), "expected bucket but got '%s'", (Object)resourceId);
        return new GoogleCloudStorageItemInfo(resourceId, creationTime, modificationTime, 0L, location, storageClass, null, null, null, 0L, 0L, null);
    }

    public static GoogleCloudStorageItemInfo createObject(StorageResourceId resourceId, long creationTime, long modificationTime, long size, String contentType, String contentEncoding, Map<String, byte[]> metadata, long contentGeneration, long metaGeneration, VerificationAttributes verificationAttributes) {
        Preconditions.checkNotNull(resourceId, "resourceId must not be null");
        Preconditions.checkArgument(!resourceId.isRoot(), "expected object or directory but got '%s'", (Object)resourceId);
        Preconditions.checkArgument(!resourceId.isBucket(), "expected object or directory but got '%s'", (Object)resourceId);
        return new GoogleCloudStorageItemInfo(resourceId, creationTime, modificationTime, size, null, null, contentType, contentEncoding, metadata, contentGeneration, metaGeneration, verificationAttributes);
    }

    public static GoogleCloudStorageItemInfo createFolder(StorageResourceId resourceId, Folder folder) {
        Preconditions.checkNotNull(resourceId, "resourceId must not be null");
        Preconditions.checkNotNull(folder, "folder must not be null");
        Preconditions.checkArgument(resourceId.isDirectory(), "resourceId for a folder must be a directory");
        long creationTime = folder.hasCreateTime() ? Timestamps.toMillis(folder.getCreateTime()) : 0L;
        long modificationTime = folder.hasUpdateTime() ? Timestamps.toMillis(folder.getUpdateTime()) : 0L;
        return new GoogleCloudStorageItemInfo(resourceId, creationTime, modificationTime, 0L, null, null, null, null, ImmutableMap.of(), 0L, folder.getMetageneration(), null);
    }

    public static GoogleCloudStorageItemInfo createInferredDirectory(StorageResourceId resourceId) {
        return new GoogleCloudStorageItemInfo(resourceId, 0L, 0L, 0L, null, null, null, null, null, 0L, 0L, null);
    }

    public static GoogleCloudStorageItemInfo createNotFound(StorageResourceId resourceId) {
        return new GoogleCloudStorageItemInfo(resourceId, 0L, 0L, -1L, null, null, null, null, null, 0L, 0L, null);
    }

    private GoogleCloudStorageItemInfo(StorageResourceId resourceId, long creationTime, long modificationTime, long size, String location, String storageClass, String contentType, String contentEncoding, Map<String, byte[]> metadata, long contentGeneration, long metaGeneration, VerificationAttributes verificationAttributes) {
        this.resourceId = Preconditions.checkNotNull(resourceId, "resourceId must not be null");
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.size = size;
        this.location = location;
        this.storageClass = storageClass;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.metadata = metadata == null ? ImmutableMap.of() : metadata;
        this.contentGeneration = contentGeneration;
        this.metaGeneration = metaGeneration;
        this.verificationAttributes = verificationAttributes;
    }

    public String getBucketName() {
        return this.resourceId.getBucketName();
    }

    public String getObjectName() {
        return this.resourceId.getObjectName();
    }

    public StorageResourceId getResourceId() {
        return this.resourceId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getSize() {
        return this.size;
    }

    public String getLocation() {
        return this.location;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public Map<String, byte[]> getMetadata() {
        return this.metadata;
    }

    public boolean isBucket() {
        return this.resourceId.isBucket();
    }

    public boolean isRoot() {
        return this.resourceId.isRoot();
    }

    public boolean isGlobalRoot() {
        return this.isRoot() && this.exists();
    }

    public boolean isNativeHNSFolder() {
        return this.isDirectory() && !this.isInferredDirectory() && this.contentGeneration == 0L;
    }

    public boolean isDirectory() {
        return this.isGlobalRoot() || this.isBucket() || this.resourceId.isDirectory();
    }

    public boolean isInferredDirectory() {
        return this.creationTime == 0L && this.modificationTime == 0L && this.size == 0L && this.contentGeneration == 0L && this.metaGeneration == 0L;
    }

    public long getContentGeneration() {
        return this.contentGeneration;
    }

    public long getMetaGeneration() {
        return this.metaGeneration;
    }

    public VerificationAttributes getVerificationAttributes() {
        return this.verificationAttributes;
    }

    public boolean exists() {
        return this.size >= 0L;
    }

    @VisibleForTesting
    public boolean metadataEquals(Map<String, byte[]> otherMetadata) {
        if (this.metadata == otherMetadata) {
            return true;
        }
        if (this.metadata == null || otherMetadata == null) {
            return false;
        }
        if (!this.metadata.keySet().equals(otherMetadata.keySet())) {
            return false;
        }
        for (Map.Entry<String, byte[]> metadataEntry : this.metadata.entrySet()) {
            if (Arrays.equals(metadataEntry.getValue(), otherMetadata.get(metadataEntry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.exists() ? String.format("%s: created on: %s", this.resourceId, Instant.ofEpochMilli(this.creationTime)) : String.format("%s: exists: no", this.resourceId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GoogleCloudStorageItemInfo) {
            GoogleCloudStorageItemInfo other = (GoogleCloudStorageItemInfo)obj;
            return this.resourceId.equals(other.resourceId) && this.creationTime == other.creationTime && this.modificationTime == other.modificationTime && this.size == other.size && Objects.equals(this.location, other.location) && Objects.equals(this.storageClass, other.storageClass) && Objects.equals(this.verificationAttributes, other.verificationAttributes) && this.metaGeneration == other.metaGeneration && this.contentGeneration == other.contentGeneration && this.metadataEquals(other.getMetadata());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.resourceId.hashCode();
        result = 31 * result + (int)this.creationTime;
        result = 31 * result + (int)this.modificationTime;
        result = 31 * result + (int)this.size;
        result = 31 * result + Objects.hashCode(this.location);
        result = 31 * result + Objects.hashCode(this.storageClass);
        result = 31 * result + Objects.hashCode(this.verificationAttributes);
        result = 31 * result + (int)this.metaGeneration;
        result = 31 * result + (int)this.contentGeneration;
        result = 31 * result + this.metadata.entrySet().stream().mapToInt(e -> Objects.hash(e.getKey()) + Arrays.hashCode((byte[])e.getValue())).sum();
        return result;
    }

    public static interface Provider {
        public GoogleCloudStorageItemInfo getItemInfo();
    }
}

