/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Ticker;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class PrefixMappedItemCache {
    private final TreeMap<PrefixKey, CacheValue<GoogleCloudStorageItemInfo>> itemMap = new TreeMap(PrefixKey.COMPARATOR);
    private final long maxEntryAgeNanos;
    private final Ticker ticker;

    public PrefixMappedItemCache(Duration maxEntryAge) {
        this(Ticker.systemTicker(), maxEntryAge);
    }

    @VisibleForTesting
    PrefixMappedItemCache(Ticker ticker, Duration maxEntryAge) {
        this.ticker = ticker;
        this.maxEntryAgeNanos = maxEntryAge.toNanos();
    }

    @Nullable
    public synchronized GoogleCloudStorageItemInfo getItem(StorageResourceId id) {
        PrefixKey key = new PrefixKey(id.getBucketName(), id.getObjectName());
        CacheValue<GoogleCloudStorageItemInfo> value = this.itemMap.get(key);
        if (value == null) {
            return null;
        }
        if (this.isExpired(value)) {
            this.itemMap.remove(key);
            return null;
        }
        return value.getValue();
    }

    @Nullable
    public synchronized GoogleCloudStorageItemInfo putItem(GoogleCloudStorageItemInfo item) {
        CacheValue<GoogleCloudStorageItemInfo> value;
        if (!item.exists()) {
            return null;
        }
        StorageResourceId id = item.getResourceId();
        PrefixKey key = new PrefixKey(id.getBucketName(), id.getObjectName());
        CacheValue<GoogleCloudStorageItemInfo> oldValue = this.itemMap.put(key, value = new CacheValue<GoogleCloudStorageItemInfo>(item, this.ticker.read()));
        return oldValue == null || this.isExpired(oldValue) ? null : oldValue.getValue();
    }

    @Nullable
    public synchronized GoogleCloudStorageItemInfo removeItem(StorageResourceId id) {
        PrefixKey key = new PrefixKey(id.getBucketName(), id.getObjectName());
        CacheValue<GoogleCloudStorageItemInfo> value = this.itemMap.remove(key);
        if (id.isDirectory()) {
            PrefixMappedItemCache.getPrefixSubMap(this.itemMap, key).clear();
        }
        return value == null || this.isExpired(value) ? null : value.getValue();
    }

    public synchronized void invalidateBucket(String bucket) {
        PrefixKey key = new PrefixKey(bucket, "");
        PrefixMappedItemCache.getPrefixSubMap(this.itemMap, key).clear();
    }

    public synchronized void invalidateAll() {
        this.itemMap.clear();
    }

    private <V> boolean isExpired(CacheValue<V> value) {
        long diff = this.ticker.read() - value.getCreationTimeNanos();
        return diff > this.maxEntryAgeNanos;
    }

    private static <K, V> List<V> aggregateCacheValues(Map<K, CacheValue<V>> map) {
        ArrayList<V> values = new ArrayList<V>(map.size());
        for (Map.Entry<K, CacheValue<V>> entry : map.entrySet()) {
            values.add(entry.getValue().getValue());
        }
        return values;
    }

    private static <E> SortedMap<PrefixKey, E> getPrefixSubMap(TreeMap<PrefixKey, E> map, PrefixKey lowerBound) {
        PrefixKey upperBound = new PrefixKey(lowerBound.getBucket(), lowerBound.getObjectName() + "\uffff");
        return map.subMap(lowerBound, upperBound);
    }

    @VisibleForTesting
    List<GoogleCloudStorageItemInfo> getAllItemsRaw() {
        return PrefixMappedItemCache.aggregateCacheValues(this.itemMap);
    }

    private static class PrefixKey
    implements Comparable<PrefixKey> {
        public static final Comparator<PrefixKey> COMPARATOR = Comparator.naturalOrder();
        private final String bucket;
        private final String objectName;

        public PrefixKey(String bucket, @Nullable String objectName) {
            Preconditions.checkArgument(bucket != null || objectName == null, "bucket must not be null if object is not null.");
            this.bucket = Strings.nullToEmpty(bucket);
            this.objectName = Strings.nullToEmpty(objectName);
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String toString() {
            return "PrefixKey [bucket=" + this.bucket + ", objectName=" + this.objectName + "]";
        }

        @Override
        public int compareTo(PrefixKey other) {
            int result = this.bucket.compareTo(other.bucket);
            return result == 0 ? this.objectName.compareTo(other.objectName) : result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.bucket.hashCode();
            result = 31 * result + this.objectName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PrefixKey)) {
                return false;
            }
            PrefixKey other = (PrefixKey)obj;
            return this.bucket.equals(other.bucket) && this.objectName.equals(other.objectName);
        }
    }

    private static class CacheValue<V> {
        private final V value;
        private final long creationTimeNanos;

        public CacheValue(V value, long creationTimeNanos) {
            this.value = value;
            this.creationTimeNanos = creationTimeNanos;
        }

        public V getValue() {
            return this.value;
        }

        public long getCreationTimeNanos() {
            return this.creationTimeNanos;
        }

        public String toString() {
            return "CacheValue [value=" + String.valueOf(this.value) + ", creationTimeNanos=" + this.creationTimeNanos + "]";
        }
    }
}

