/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.AccessToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcDownscopingInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcStatisticsInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcTracingInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageClientProviderCacheKey;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageClientWrapper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.cache.Cache;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.cache.CacheBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.util.AccessBoundary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StorageClientProvider {
    @VisibleForTesting
    final Cache<StorageClientProviderCacheKey, StorageClientWrapper> cache = CacheBuilder.newBuilder().recordStats().build();
    @VisibleForTesting
    final Map<StorageClientWrapper, Integer> storageClientToReferenceMap = new ConcurrentHashMap<StorageClientWrapper, Integer>();
    final Map<StorageClientWrapper, StorageClientProviderCacheKey> storageToCacheKeyMap = new ConcurrentHashMap<StorageClientWrapper, StorageClientProviderCacheKey>();
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    synchronized StorageClientWrapper getStorage(Credentials credentials, GoogleCloudStorageOptions storageOptions, List<ClientInterceptor> interceptors, ExecutorService pCUExecutorService, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        if (!StorageClientProvider.canCache(storageOptions, interceptors, pCUExecutorService)) {
            ((GoogleLogger.Api)logger.atInfo()).log("Ignoring storage object cache.");
            return new StorageClientWrapper(StorageClientProvider.createStorage(credentials, storageOptions, interceptors, pCUExecutorService, downscopedAccessTokenFn), this);
        }
        StorageClientProviderCacheKey key = this.computeCacheKey(credentials, storageOptions, downscopedAccessTokenFn);
        StorageClientWrapper storage = this.cache.getIfPresent(key);
        if (storage == null) {
            storage = new StorageClientWrapper(StorageClientProvider.createStorage(credentials, storageOptions, null, null, downscopedAccessTokenFn), this);
            this.cache.put(key, storage);
            this.storageToCacheKeyMap.put(storage, key);
            ((GoogleLogger.Api)logger.atInfo()).log("Cache miss for %d, created new storage client. Cache hit count : %d, Cache hit rate : %.2f", key.hashCode(), this.cache.stats().hitCount(), this.cache.stats().hitRate());
        } else {
            ((GoogleLogger.Api)logger.atFine()).log("Cache hit for %d, reusing the storage client. Cache hit count : %d, Cache hit rate : %.2f", key.hashCode(), this.cache.stats().hitCount(), this.cache.stats().hitRate());
        }
        ((GoogleLogger.Api)logger.atFine()).log("Cache stats. size: %d", this.cache.size());
        this.storageClientToReferenceMap.put(storage, this.storageClientToReferenceMap.getOrDefault(storage, 0) + 1);
        return storage;
    }

    synchronized void close(StorageClientWrapper storage) {
        if (!this.storageClientToReferenceMap.containsKey(storage)) {
            this.closeStorage(storage.getStorage());
            ((GoogleLogger.Api)logger.atInfo()).log("close() called on storage object outside cache.");
            return;
        }
        this.storageClientToReferenceMap.put(storage, this.storageClientToReferenceMap.get(storage) - 1);
        if (this.storageClientToReferenceMap.get(storage) == 0) {
            ((GoogleLogger.Api)logger.atInfo()).log("close() called on storage object inside cache.");
            StorageClientProviderCacheKey key = this.storageToCacheKeyMap.get(storage);
            this.cache.invalidate(key);
            this.storageToCacheKeyMap.remove(storage);
            this.storageClientToReferenceMap.remove(storage);
            this.closeStorage(storage.getStorage());
        }
    }

    @VisibleForTesting
    StorageClientProviderCacheKey computeCacheKey(Credentials credentials, GoogleCloudStorageOptions storageOptions, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) {
        return StorageClientProviderCacheKey.builder().setCredentials(credentials).setHttpHeaders(storageOptions.getHttpRequestHeaders()).setIsDirectPathPreferred(storageOptions.isDirectPathPreferred()).setIsDownScopingEnabled(downscopedAccessTokenFn != null).setIsTracingEnabled(storageOptions.isTraceLogEnabled()).setWriteChannelOptions(storageOptions.getWriteChannelOptions()).setProjectId(storageOptions.getProjectId()).build();
    }

    private static boolean canCache(GoogleCloudStorageOptions options, List<ClientInterceptor> interceptors, ExecutorService pCUExecutorService) {
        return options.isStorageClientCachingEnabled() && pCUExecutorService == null && (interceptors == null || interceptors.isEmpty());
    }

    private static Storage createStorage(Credentials credentials, GoogleCloudStorageOptions storageOptions, List<ClientInterceptor> interceptors, ExecutorService pCUExecutorService, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        ImmutableMap<String, String> headers = GoogleCloudStorageClientImpl.getUpdatedHeadersWithUserAgent(storageOptions);
        return (Storage)StorageOptions.grpc().setAttemptDirectPath(storageOptions.isDirectPathPreferred()).setHeaderProvider(() -> headers).setGrpcInterceptorProvider(() -> StorageClientProvider.getInterceptors(interceptors, storageOptions, downscopedAccessTokenFn)).setCredentials(credentials != null ? credentials : StorageClientProvider.getNoCredentials(downscopedAccessTokenFn)).setBlobWriteSessionConfig(GoogleCloudStorageClientImpl.getSessionConfig(storageOptions.getWriteChannelOptions(), pCUExecutorService)).setProjectId(storageOptions.getProjectId()).build().getService();
    }

    private static ImmutableList<ClientInterceptor> getInterceptors(List<ClientInterceptor> interceptors, GoogleCloudStorageOptions storageOptions, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) {
        ArrayList<ClientInterceptor> clientInterceptorList = new ArrayList<ClientInterceptor>();
        if (interceptors != null && !interceptors.isEmpty()) {
            clientInterceptorList.addAll(interceptors.stream().filter(x -> x != null).collect(Collectors.toList()));
        }
        if (storageOptions.isTraceLogEnabled()) {
            clientInterceptorList.add(new GoogleCloudStorageClientGrpcTracingInterceptor());
        }
        if (downscopedAccessTokenFn != null) {
            clientInterceptorList.add(new GoogleCloudStorageClientGrpcDownscopingInterceptor(downscopedAccessTokenFn));
        }
        clientInterceptorList.add(new GoogleCloudStorageClientGrpcStatisticsInterceptor());
        return ImmutableList.copyOf(clientInterceptorList);
    }

    private static Credentials getNoCredentials(Function<List<AccessBoundary>, String> downscopedAccessTokenFn) {
        if (downscopedAccessTokenFn == null) {
            return null;
        }
        return GoogleCredentials.create(new AccessToken("", null));
    }

    private void closeStorage(Storage storage) {
        try {
            storage.close();
        }
        catch (Exception e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Error occurred while closing the storage client");
        }
    }
}

