/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.BetaApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.paging.Page;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.Policy;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.ReadChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.WriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageClientProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Acl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Blob;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Bucket;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BucketInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.CopyWriter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.HmacKey;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Notification;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.NotificationInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.PostPolicyV4;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ServiceAccount;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageBatch;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class StorageClientWrapper
implements Storage {
    private final Storage storage;
    private final StorageClientProvider storageClientProvider;

    public StorageClientWrapper(Storage storage, StorageClientProvider storageClientProvider) {
        this.storage = storage;
        this.storageClientProvider = storageClientProvider;
    }

    Storage getStorage() {
        return this.storage;
    }

    @Override
    public void close() {
        this.storageClientProvider.close(this);
    }

    @Override
    public Bucket create(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        return this.storage.create(bucketInfo, options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        return this.storage.create(blobInfo, options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, Storage.BlobTargetOption ... options) {
        return this.storage.create(blobInfo, content, options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, int offset, int length, Storage.BlobTargetOption ... options) {
        return this.storage.create(blobInfo, content, offset, length, options);
    }

    @Override
    @Deprecated
    public Blob create(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) {
        return this.storage.create(blobInfo, content, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, Storage.BlobWriteOption ... options) throws IOException {
        return this.storage.createFrom(blobInfo, path, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        return this.storage.createFrom(blobInfo, path, bufferSize, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) throws IOException {
        return this.storage.createFrom(blobInfo, content, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        return this.storage.createFrom(blobInfo, content, bufferSize, options);
    }

    @Override
    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        return this.storage.get(bucket, options);
    }

    @Override
    public Bucket lockRetentionPolicy(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        return this.storage.lockRetentionPolicy(bucketInfo, options);
    }

    @Override
    public Blob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        return this.storage.get(bucket, blob, options);
    }

    @Override
    public Blob get(BlobId blobId, Storage.BlobGetOption ... options) {
        return this.storage.get(blobId, options);
    }

    @Override
    public Blob get(BlobId blobId) {
        return this.storage.get(blobId);
    }

    @Override
    public Blob restore(BlobId blobId, Storage.BlobRestoreOption ... options) {
        return this.storage.restore(blobId, options);
    }

    @Override
    public Page<Bucket> list(Storage.BucketListOption ... options) {
        return this.storage.list(options);
    }

    @Override
    public Page<Blob> list(String bucket, Storage.BlobListOption ... options) {
        return this.storage.list(bucket, options);
    }

    @Override
    public Bucket update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        return this.storage.update(bucketInfo, options);
    }

    @Override
    public Blob update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        return this.storage.update(blobInfo, options);
    }

    @Override
    public Blob update(BlobInfo blobInfo) {
        return this.storage.update(blobInfo);
    }

    @Override
    public boolean delete(String bucket, Storage.BucketSourceOption ... options) {
        return this.storage.delete(bucket, options);
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.storage.delete(bucket, blob, options);
    }

    @Override
    public boolean delete(BlobId blobId, Storage.BlobSourceOption ... options) {
        return this.storage.delete(blobId, options);
    }

    @Override
    public boolean delete(BlobId blobId) {
        return this.storage.delete(blobId);
    }

    @Override
    public Blob compose(Storage.ComposeRequest composeRequest) {
        return this.storage.compose(composeRequest);
    }

    @Override
    public CopyWriter copy(Storage.CopyRequest copyRequest) {
        return this.storage.copy(copyRequest);
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.storage.readAllBytes(bucket, blob, options);
    }

    @Override
    public byte[] readAllBytes(BlobId blob, Storage.BlobSourceOption ... options) {
        return this.storage.readAllBytes(blob, options);
    }

    @Override
    public StorageBatch batch() {
        return this.storage.batch();
    }

    @Override
    public ReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.storage.reader(bucket, blob, options);
    }

    @Override
    public ReadChannel reader(BlobId blob, Storage.BlobSourceOption ... options) {
        return this.storage.reader(blob, options);
    }

    @Override
    public void downloadTo(BlobId blob, Path path, Storage.BlobSourceOption ... options) {
        this.storage.downloadTo(blob, path, options);
    }

    @Override
    public void downloadTo(BlobId blob, OutputStream outputStream, Storage.BlobSourceOption ... options) {
        this.storage.downloadTo(blob, outputStream, options);
    }

    @Override
    public WriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        return this.storage.writer(blobInfo, options);
    }

    @Override
    public WriteChannel writer(URL signedUrl) {
        return this.storage.writer(signedUrl);
    }

    @Override
    public URL signUrl(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        return this.storage.signUrl(blobInfo, duration, unit, options);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        return this.storage.generateSignedPostPolicyV4(blobInfo, duration, unit, fields, conditions, options);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, Storage.PostPolicyV4Option ... options) {
        return this.storage.generateSignedPostPolicyV4(blobInfo, duration, unit, fields, options);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        return this.storage.generateSignedPostPolicyV4(blobInfo, duration, unit, conditions, options);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.PostPolicyV4Option ... options) {
        return this.storage.generateSignedPostPolicyV4(blobInfo, duration, unit, options);
    }

    @Override
    public List<Blob> get(BlobId ... blobIds) {
        return this.storage.get(blobIds);
    }

    @Override
    public List<Blob> get(Iterable<BlobId> blobIds) {
        return this.storage.get(blobIds);
    }

    @Override
    public List<Blob> update(BlobInfo ... blobInfos) {
        return this.storage.update(blobInfos);
    }

    @Override
    public List<Blob> update(Iterable<BlobInfo> blobInfos) {
        return this.storage.update(blobInfos);
    }

    @Override
    public List<Boolean> delete(BlobId ... blobIds) {
        return this.storage.delete(blobIds);
    }

    @Override
    public List<Boolean> delete(Iterable<BlobId> blobIds) {
        return this.storage.delete(blobIds);
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        return this.storage.getAcl(bucket, entity, options);
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity) {
        return this.storage.getAcl(bucket, entity);
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        return this.storage.deleteAcl(bucket, entity, options);
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity) {
        return this.storage.deleteAcl(bucket, entity);
    }

    @Override
    public Acl createAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        return this.storage.createAcl(bucket, acl, options);
    }

    @Override
    public Acl createAcl(String bucket, Acl acl) {
        return this.storage.createAcl(bucket, acl);
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        return this.storage.updateAcl(bucket, acl, options);
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl) {
        return this.storage.updateAcl(bucket, acl);
    }

    @Override
    public List<Acl> listAcls(String bucket, Storage.BucketSourceOption ... options) {
        return this.storage.listAcls(bucket, options);
    }

    @Override
    public List<Acl> listAcls(String bucket) {
        return this.storage.listAcls(bucket);
    }

    @Override
    public Acl getDefaultAcl(String bucket, Acl.Entity entity) {
        return this.storage.getDefaultAcl(bucket, entity);
    }

    @Override
    public boolean deleteDefaultAcl(String bucket, Acl.Entity entity) {
        return this.storage.deleteDefaultAcl(bucket, entity);
    }

    @Override
    public Acl createDefaultAcl(String bucket, Acl acl) {
        return this.storage.createDefaultAcl(bucket, acl);
    }

    @Override
    public Acl updateDefaultAcl(String bucket, Acl acl) {
        return this.storage.updateDefaultAcl(bucket, acl);
    }

    @Override
    public List<Acl> listDefaultAcls(String bucket) {
        return this.storage.listDefaultAcls(bucket);
    }

    @Override
    public Acl getAcl(BlobId blob, Acl.Entity entity) {
        return this.storage.getAcl(blob, entity);
    }

    @Override
    public boolean deleteAcl(BlobId blob, Acl.Entity entity) {
        return this.storage.deleteAcl(blob, entity);
    }

    @Override
    public Acl createAcl(BlobId blob, Acl acl) {
        return this.storage.createAcl(blob, acl);
    }

    @Override
    public Acl updateAcl(BlobId blob, Acl acl) {
        return this.storage.updateAcl(blob, acl);
    }

    @Override
    public List<Acl> listAcls(BlobId blob) {
        return this.storage.listAcls(blob);
    }

    @Override
    public HmacKey createHmacKey(ServiceAccount serviceAccount, Storage.CreateHmacKeyOption ... options) {
        return this.storage.createHmacKey(serviceAccount, options);
    }

    @Override
    public Page<HmacKey.HmacKeyMetadata> listHmacKeys(Storage.ListHmacKeysOption ... options) {
        return this.storage.listHmacKeys(options);
    }

    @Override
    public HmacKey.HmacKeyMetadata getHmacKey(String accessId, Storage.GetHmacKeyOption ... options) {
        return this.storage.getHmacKey(accessId, options);
    }

    @Override
    public void deleteHmacKey(HmacKey.HmacKeyMetadata metadata, Storage.DeleteHmacKeyOption ... options) {
        this.storage.deleteHmacKey(metadata, options);
    }

    @Override
    public HmacKey.HmacKeyMetadata updateHmacKeyState(HmacKey.HmacKeyMetadata metadata, HmacKey.HmacKeyState state, Storage.UpdateHmacKeyOption ... options) {
        return this.storage.updateHmacKeyState(metadata, state, options);
    }

    @Override
    public Policy getIamPolicy(String bucket, Storage.BucketSourceOption ... options) {
        return this.storage.getIamPolicy(bucket, options);
    }

    @Override
    public Policy setIamPolicy(String bucket, Policy policy, Storage.BucketSourceOption ... options) {
        return this.storage.setIamPolicy(bucket, policy, options);
    }

    @Override
    public List<Boolean> testIamPermissions(String bucket, List<String> permissions, Storage.BucketSourceOption ... options) {
        return this.storage.testIamPermissions(bucket, permissions, options);
    }

    @Override
    public ServiceAccount getServiceAccount(String projectId) {
        return this.storage.getServiceAccount(projectId);
    }

    @Override
    public Notification createNotification(String bucket, NotificationInfo notificationInfo) {
        return this.storage.createNotification(bucket, notificationInfo);
    }

    @Override
    public Notification getNotification(String bucket, String notificationId) {
        return this.storage.getNotification(bucket, notificationId);
    }

    @Override
    public List<Notification> listNotifications(String bucket) {
        return this.storage.listNotifications(bucket);
    }

    @Override
    public boolean deleteNotification(String bucket, String notificationId) {
        return this.storage.deleteNotification(bucket, notificationId);
    }

    @Override
    @BetaApi
    public BlobWriteSession blobWriteSession(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        return this.storage.blobWriteSession(blobInfo, options);
    }

    @Override
    public Blob moveBlob(Storage.MoveBlobRequest request) {
        return this.storage.moveBlob(request);
    }

    @Override
    public StorageOptions getOptions() {
        return (StorageOptions)this.storage.getOptions();
    }
}

